import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [backup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackup.html).
 *
 * @experimental
 */
export declare class Backup extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Allows to copy from a backup vault.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCopyTargets()
     * - .ifCopyTargetOrgPaths()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartCopyJob.html
     *
     * @experimental
     */
    toCopyFromBackupVault(): this;
    /**
     * (experimental) Allows to copy into a backup vault.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartCopyJob.html
     *
     * @experimental
     */
    toCopyIntoBackupVault(): this;
    /**
     * (experimental) Creates a new backup plan.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupPlan.html
     *
     * @experimental
     */
    toCreateBackupPlan(): this;
    /**
     * (experimental) Creates a new resource assignment in a backup plan.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupSelection.html
     *
     * @experimental
     */
    toCreateBackupSelection(): this;
    /**
     * (experimental) Creates a new backup vault.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupVault.html
     *
     * @experimental
     */
    toCreateBackupVault(): this;
    /**
     * (experimental) Deletes a backup plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupPlan.html
     *
     * @experimental
     */
    toDeleteBackupPlan(): this;
    /**
     * (experimental) Deletes a resource assignment from a backup plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupSelection.html
     *
     * @experimental
     */
    toDeleteBackupSelection(): this;
    /**
     * (experimental) Deletes a backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVault.html
     *
     * @experimental
     */
    toDeleteBackupVault(): this;
    /**
     * (experimental) Deletes backup vault access policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVaultAccessPolicy.html
     *
     * @experimental
     */
    toDeleteBackupVaultAccessPolicy(): this;
    /**
     * (experimental) Removes notifications from backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVaultNotifications.html
     *
     * @experimental
     */
    toDeleteBackupVaultNotifications(): this;
    /**
     * (experimental) Deletes a recovery point from a backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteRecoveryPoint.html
     *
     * @experimental
     */
    toDeleteRecoveryPoint(): this;
    /**
     * (experimental) Describes a backup job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeBackupJob.html
     *
     * @experimental
     */
    toDescribeBackupJob(): this;
    /**
     * (experimental) Describes a new backup vault with the specified name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeBackupVault.html
     *
     * @experimental
     */
    toDescribeBackupVault(): this;
    /**
     * (experimental) Describes a copy job.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeCopyJob.html
     *
     * @experimental
     */
    toDescribeCopyJob(): this;
    /**
     * (experimental) Describes global settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeGlobalSettings.html
     *
     * @experimental
     */
    toDescribeGlobalSettings(): this;
    /**
     * (experimental) Describes a protected resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeProtectedResource.html
     *
     * @experimental
     */
    toDescribeProtectedResource(): this;
    /**
     * (experimental) Describes a recovery point.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeRecoveryPoint.html
     *
     * @experimental
     */
    toDescribeRecoveryPoint(): this;
    /**
     * (experimental) Describes region settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeRegionSettings.html
     *
     * @experimental
     */
    toDescribeRegionSettings(): this;
    /**
     * (experimental) Describes a restore job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeRestoreJob.html
     *
     * @experimental
     */
    toDescribeRestoreJob(): this;
    /**
     * (experimental) Exports a backup plan as a JSON.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ExportBackupPlanTemplate.html
     *
     * @experimental
     */
    toExportBackupPlanTemplate(): this;
    /**
     * (experimental) Gets a backup plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupPlan.html
     *
     * @experimental
     */
    toGetBackupPlan(): this;
    /**
     * (experimental) Transforms a JSON to a backup plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupPlanFromJSON.html
     *
     * @experimental
     */
    toGetBackupPlanFromJSON(): this;
    /**
     * (experimental) Transforms a template to a backup plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupPlanFromTemplate.html
     *
     * @experimental
     */
    toGetBackupPlanFromTemplate(): this;
    /**
     * (experimental) Gets a backup plan resource assignment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupSelection.html
     *
     * @experimental
     */
    toGetBackupSelection(): this;
    /**
     * (experimental) Gets backup vault access policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupVaultAccessPolicy.html
     *
     * @experimental
     */
    toGetBackupVaultAccessPolicy(): this;
    /**
     * (experimental) Gets backup vault notifications.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupVaultNotifications.html
     *
     * @experimental
     */
    toGetBackupVaultNotifications(): this;
    /**
     * (experimental) Gets recovery point restore metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetRecoveryPointRestoreMetadata.html
     *
     * @experimental
     */
    toGetRecoveryPointRestoreMetadata(): this;
    /**
     * (experimental) Gets supported resource types.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetSupportedResourceTypes.html
     *
     * @experimental
     */
    toGetSupportedResourceTypes(): this;
    /**
     * (experimental) Lists backup jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupJobs.html
     *
     * @experimental
     */
    toListBackupJobs(): this;
    /**
     * (experimental) Lists backup plan templates provided by AWS Backup.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupPlanTemplates.html
     *
     * @experimental
     */
    toListBackupPlanTemplates(): this;
    /**
     * (experimental) Lists backup plan versions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupPlanVersions.html
     *
     * @experimental
     */
    toListBackupPlanVersions(): this;
    /**
     * (experimental) Lists backup plans.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupPlans.html
     *
     * @experimental
     */
    toListBackupPlans(): this;
    /**
     * (experimental) Lists resource assignments for a specific backup plan.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupSelections.html
     *
     * @experimental
     */
    toListBackupSelections(): this;
    /**
     * (experimental) Lists backup vaults.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupVaults.html
     *
     * @experimental
     */
    toListBackupVaults(): this;
    /**
     * (experimental) Lists copy jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListCopyJobs.html
     *
     * @experimental
     */
    toListCopyJobs(): this;
    /**
     * (experimental) Lists protected resources by AWS Backup.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListProtectedResources.html
     *
     * @experimental
     */
    toListProtectedResources(): this;
    /**
     * (experimental) Lists recovery points inside a backup vault.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRecoveryPointsByBackupVault.html
     *
     * @experimental
     */
    toListRecoveryPointsByBackupVault(): this;
    /**
     * (experimental) Lists recovery points for a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRecoveryPointsByResource.html
     *
     * @experimental
     */
    toListRecoveryPointsByResource(): this;
    /**
     * (experimental) Lists restore jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRestoreJobs.html
     *
     * @experimental
     */
    toListRestoreJobs(): this;
    /**
     * (experimental) Lists tags for a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListTags.html
     *
     * @experimental
     */
    toListTags(): this;
    /**
     * (experimental) Adds an access policy to the backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultAccessPolicy.html
     *
     * @experimental
     */
    toPutBackupVaultAccessPolicy(): this;
    /**
     * (experimental) Adds an SNS topic to the backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html
     *
     * @experimental
     */
    toPutBackupVaultNotifications(): this;
    /**
     * (experimental) Starts a new backup job.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartBackupJob.html
     *
     * @experimental
     */
    toStartBackupJob(): this;
    /**
     * (experimental) Copy a backup from a source backup vault to a destination backup vault.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartCopyJob.html
     *
     * @experimental
     */
    toStartCopyJob(): this;
    /**
     * (experimental) Starts a new restore job.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartRestoreJob.html
     *
     * @experimental
     */
    toStartRestoreJob(): this;
    /**
     * (experimental) Stops a backup job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StopBackupJob.html
     *
     * @experimental
     */
    toStopBackupJob(): this;
    /**
     * (experimental) Tags a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Untags a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Updates a backup plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html
     *
     * @experimental
     */
    toUpdateBackupPlan(): this;
    /**
     * (experimental) Updates global settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateGlobalSettings.html
     *
     * @experimental
     */
    toUpdateGlobalSettings(): this;
    /**
     * (experimental) Updates the lifecycle of the recovery point.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRecoveryPointLifecycle.html
     *
     * @experimental
     */
    toUpdateRecoveryPointLifecycle(): this;
    /**
     * (experimental) Describes region settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html
     *
     * @experimental
     */
    toUpdateRegionSettings(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type backupVault to the statement.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/vaults.html
     *
     * @param backupVaultName - Identifier for the backupVaultName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBackupVault(backupVaultName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type backupPlan to the statement.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/about-backup-plans.html
     *
     * @param backupPlanId - Identifier for the backupPlanId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBackupPlan(backupPlanId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type recoveryPoint to the statement.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/recovery-points.html
     *
     * @param recoveryPointId - Identifier for the recoveryPointId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRecoveryPoint(recoveryPointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters actions based on the organization unit.
     *
     * Applies to actions:
     * - .toCopyFromBackupVault()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifCopyTargetOrgPaths(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters actions based on the ARN of an backup vault.
     *
     * Applies to actions:
     * - .toCopyFromBackupVault()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifCopyTargets(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [backup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackup.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
