"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2messages = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [ec2messages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html).
 *
 * @experimental
 */
class Ec2messages extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [ec2messages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'ec2messages';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AcknowledgeMessage",
                "DeleteMessage",
                "FailMessage",
                "SendReply"
            ],
            "Read": [
                "GetEndpoint",
                "GetMessages"
            ]
        };
    }
    /**
     * (experimental) Acknowledges a message, ensuring it will not be delivered again.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toAcknowledgeMessage() {
        this.to('ec2messages:AcknowledgeMessage');
        return this;
    }
    /**
     * (experimental) Deletes a message.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeleteMessage() {
        this.to('ec2messages:DeleteMessage');
        return this;
    }
    /**
     * (experimental) Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toFailMessage() {
        this.to('ec2messages:FailMessage');
        return this;
    }
    /**
     * (experimental) Routes traffic to the correct endpoint based on the given destination for the messages.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetEndpoint() {
        this.to('ec2messages:GetEndpoint');
        return this;
    }
    /**
     * (experimental) Delivers messages to clients/instances using long polling.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetMessages() {
        this.to('ec2messages:GetMessages');
        return this;
    }
    /**
     * (experimental) Sends replies from clients/instances to upstream service.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toSendReply() {
        this.to('ec2messages:SendReply');
        return this;
    }
}
exports.Ec2messages = Ec2messages;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWVzc2FnZWRlbGl2ZXJ5c2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1lc3NhZ2VkZWxpdmVyeXNlcnZpY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0Esc0NBQTRDOzs7Ozs7QUFRNUMsTUFBYSxXQUFZLFNBQVEsd0JBQWU7Ozs7OztJQWdGOUMsWUFBYSxLQUE0QjtRQUN2QyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7Ozs7OztRQWhGUixrQkFBYSxHQUFHLGFBQWEsQ0FBQzs7OztRQThEM0Isb0JBQWUsR0FBb0I7WUFDM0MsT0FBTyxFQUFFO2dCQUNQLG9CQUFvQjtnQkFDcEIsZUFBZTtnQkFDZixhQUFhO2dCQUNiLFdBQVc7YUFDWjtZQUNELE1BQU0sRUFBRTtnQkFDTixhQUFhO2dCQUNiLGFBQWE7YUFDZDtTQUNGLENBQUM7SUFRRixDQUFDOzs7Ozs7OztJQTFFTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQzFDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7SUFPTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztRQUNyQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7O0lBT00sYUFBYTtRQUNsQixJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7UUFDbkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7OztJQU9NLGFBQWE7UUFDbEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO1FBQ25DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7SUFPTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7O0lBT00sV0FBVztRQUNoQixJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFDakMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0NBc0JGO0FBbkZELGtDQW1GQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gXCIuLi9zaGFyZWQvYWNjZXNzLWxldmVsXCI7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tIFwiLi4vc2hhcmVkXCI7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnRQcm9wcyB9IGZyb20gXCJAYXdzLWNkay9hd3MtaWFtXCI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgRWMybWVzc2FnZXMgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdlYzJtZXNzYWdlcyc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Fja25vd2xlZGdlTWVzc2FnZSgpIHtcbiAgICB0aGlzLnRvKCdlYzJtZXNzYWdlczpBY2tub3dsZWRnZU1lc3NhZ2UnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZU1lc3NhZ2UoKSB7XG4gICAgdGhpcy50bygnZWMybWVzc2FnZXM6RGVsZXRlTWVzc2FnZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRmFpbE1lc3NhZ2UoKSB7XG4gICAgdGhpcy50bygnZWMybWVzc2FnZXM6RmFpbE1lc3NhZ2UnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvR2V0RW5kcG9pbnQoKSB7XG4gICAgdGhpcy50bygnZWMybWVzc2FnZXM6R2V0RW5kcG9pbnQnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldE1lc3NhZ2VzKCkge1xuICAgIHRoaXMudG8oJ2VjMm1lc3NhZ2VzOkdldE1lc3NhZ2VzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9TZW5kUmVwbHkoKSB7XG4gICAgdGhpcy50bygnZWMybWVzc2FnZXM6U2VuZFJlcGx5Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgXCJXcml0ZVwiOiBbXG4gICAgICBcIkFja25vd2xlZGdlTWVzc2FnZVwiLFxuICAgICAgXCJEZWxldGVNZXNzYWdlXCIsXG4gICAgICBcIkZhaWxNZXNzYWdlXCIsXG4gICAgICBcIlNlbmRSZXBseVwiXG4gICAgXSxcbiAgICBcIlJlYWRcIjogW1xuICAgICAgXCJHZXRFbmRwb2ludFwiLFxuICAgICAgXCJHZXRNZXNzYWdlc1wiXG4gICAgXVxuICB9O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3IgKHByb3BzPzogUG9saWN5U3RhdGVtZW50UHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gIH1cbn1cbiJdfQ==