"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Translate = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
 *
 * @experimental
 */
class Translate extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'translate';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CreateParallelData",
                "DeleteParallelData",
                "DeleteTerminology",
                "ImportTerminology",
                "StartTextTranslationJob",
                "StopTextTranslationJob",
                "UpdateParallelData"
            ],
            "Read": [
                "DescribeTextTranslationJob",
                "GetParallelData",
                "GetTerminology",
                "TranslateText"
            ],
            "List": [
                "ListParallelData",
                "ListTerminologies",
                "ListTextTranslationJobs"
            ]
        };
    }
    /**
     * (experimental) Grants permission to create a Parallel Data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_CreateParallelData.html
     *
     * @experimental
     */
    toCreateParallelData() {
        this.to('translate:CreateParallelData');
        return this;
    }
    /**
     * (experimental) Grants permission to delete a Parallel Data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteParallelData.html
     *
     * @experimental
     */
    toDeleteParallelData() {
        this.to('translate:DeleteParallelData');
        return this;
    }
    /**
     * (experimental) Grants permission to delete a terminology.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html
     *
     * @experimental
     */
    toDeleteTerminology() {
        this.to('translate:DeleteTerminology');
        return this;
    }
    /**
     * (experimental) Grants permission to get the properties associated with an asynchronous batch translation job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html
     *
     * @experimental
     */
    toDescribeTextTranslationJob() {
        this.to('translate:DescribeTextTranslationJob');
        return this;
    }
    /**
     * (experimental) Grants permission to get a Parallel Data.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetParallelData.html
     *
     * @experimental
     */
    toGetParallelData() {
        this.to('translate:GetParallelData');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve a terminology.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html
     *
     * @experimental
     */
    toGetTerminology() {
        this.to('translate:GetTerminology');
        return this;
    }
    /**
     * (experimental) Grants permission to create or update a terminology, depending on whether or not one already exists for the given terminology name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html
     *
     * @experimental
     */
    toImportTerminology() {
        this.to('translate:ImportTerminology');
        return this;
    }
    /**
     * (experimental) Grants permission to list Parallel Data associated with your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListParallelData.html
     *
     * @experimental
     */
    toListParallelData() {
        this.to('translate:ListParallelData');
        return this;
    }
    /**
     * (experimental) Grants permission to list terminologies associated with your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html
     *
     * @experimental
     */
    toListTerminologies() {
        this.to('translate:ListTerminologies');
        return this;
    }
    /**
     * (experimental) Grants permission to list batch translation jobs that you have submitted.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html
     *
     * @experimental
     */
    toListTextTranslationJobs() {
        this.to('translate:ListTextTranslationJobs');
        return this;
    }
    /**
     * (experimental) Grants permission to start an asynchronous batch translation job.
     *
     * Batch translation jobs can be used to translate large volumes of text across multiple documents at once
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html
     *
     * @experimental
     */
    toStartTextTranslationJob() {
        this.to('translate:StartTextTranslationJob');
        return this;
    }
    /**
     * (experimental) Grants permission to stop an asynchronous batch translation job that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html
     *
     * @experimental
     */
    toStopTextTranslationJob() {
        this.to('translate:StopTextTranslationJob');
        return this;
    }
    /**
     * (experimental) Grants permission to translate text from a source language to a target language.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html
     *
     * @experimental
     */
    toTranslateText() {
        this.to('translate:TranslateText');
        return this;
    }
    /**
     * (experimental) Grants permission to update an existing Parallel Data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_UpdateParallelData.html
     *
     * @experimental
     */
    toUpdateParallelData() {
        this.to('translate:UpdateParallelData');
        return this;
    }
}
exports.Translate = Translate;
//# sourceMappingURL=data:application/json;base64,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