import { PolicyStatementWithEffect } from './5-effect';
/**
 * (experimental) A collection of Principal's.
 *
 * @experimental
 */
export interface Principals {
    [key: string]: string[];
}
export declare enum PrincipalType {
    AWS = "AWS",
    FEDERATED = "Federated",
    CANONICAL_USER = "CanonicalUser",
    SERVICE = "Service"
}
/**
 * (experimental) Adds "principal" functionality to the Policy Statement.
 *
 * @experimental
 */
export declare class PolicyStatementWithPrincipal extends PolicyStatementWithEffect {
    /**
     * @experimental
     */
    protected useNotPrincipals: boolean;
    /**
     * @experimental
     */
    protected principals: Principals;
    /**
     * (experimental) Injects principals into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     *
     * @experimental
     */
    toJSON(): any;
    /**
     * (experimental) JSON-ify the policy statement.
     *
     * Used when JSON.stringify() is called
     *
     * @experimental
     */
    toStatementJson(): any;
    /**
     * @experimental
     */
    protected cdkApplyPrincipals(): void;
    /**
     * (experimental) Switches the statement to use [`notPrincipal`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notprincipal.html).
     *
     * @experimental
     */
    notPrincipals(): this;
    /**
     * (experimental) Checks weather a principal was applied to the policy.
     *
     * @experimental
     */
    hasPrincipals(): boolean;
    /**
     * (experimental) Adds a principal to the statement.
     *
     * @param prefix One of **AWS**, **Federated**, **CanonicalUser** or **Service**.
     * @param principal The principal string.
     * @experimental
     */
    protected addPrincipal(prefix: string, principal: string): this;
    /**
     * (experimental) Adds any principal to the statement.
     *
     * @param arn The ARN of the principal.
     * @param prefix One of **AWS**, **Federated**, **CanonicalUser** or **Service** - Default: **AWS**.
     * @experimental
     */
    for(arn: string, prefix?: string): this;
    /**
     * (experimental) Adds an account principal to the statement.
     *
     * @param account ID of the AWS account.
     * @experimental
     */
    forAccount(account: string): this;
    /**
     * (experimental) Adds a [federated](https://aws.amazon.com/identity/federation/) (web identity) principal to the statement.
     *
     * @param provider ID of the AWS account.
     * @experimental
     */
    forFederated(provider: string): this;
    /**
     * (experimental) Adds a federated [AWS Cognito](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc_cognito.html) principal to the statement.
     *
     * @experimental
     */
    forFederatedCognito(): this;
    /**
     * (experimental) Adds a federated [Amazon](https://login.amazon.com/) principal to the statement.
     *
     * @experimental
     */
    forFederatedAmazon(): this;
    /**
     * (experimental) Adds a federated [Facebook](https://developers.facebook.com/docs/facebook-login) principal to the statement.
     *
     * @experimental
     */
    forFederatedFacebook(): this;
    /**
     * (experimental) Adds a federated [Google](https://developers.google.com/identity/protocols/oauth2/openid-connect) principal to the statement.
     *
     * @experimental
     */
    forFederatedGoogle(): this;
    /**
     * (experimental) Adds a canonical user principal to the statement.
     *
     * @param userID The user ID.
     * @experimental
     */
    forCanonicalUser(userID: string): this;
    /**
     * (experimental) Adds federated SAML principal to the statement.
     *
     * @param account ID of the AWS account.
     * @param providerName Name of the SAML provider.
     * @experimental
     */
    forSaml(account: string, providerName: string): this;
    /**
     * (experimental) Adds an IAM user principal to the statement.
     *
     * @param account ID of the AWS account.
     * @param user Name of the IAM user.
     * @experimental
     */
    forUser(account: string, user: string): this;
    /**
     * (experimental) Adds an IAM role principal to the statement.
     *
     * @param account ID of the AWS account.
     * @param role Name of the IAM role.
     * @experimental
     */
    forRole(account: string, role: string): this;
    /**
     * (experimental) Adds a specific assumed role session principal to the statement.
     *
     * @param account ID of the AWS account.
     * @param roleName Name of the IAM role.
     * @param sessionName Name of the session.
     * @experimental
     */
    forAssumedRoleSession(account: string, roleName: string, sessionName: string): this;
    /**
     * (experimental) Adds a service principal to the statement.
     *
     * @param service Long version of the service name. Usually in the format: `long_service-name.amazonaws.com`.
     * @experimental
     */
    forService(service: string): this;
    /**
     * (experimental) Grants public asses.
     *
     * **EVERYONE IN THE WORLD HAS ACCESS**
     *
     * We strongly recommend that you do not use a wildcard in the Principal element in a role's trust policy unless you otherwise restrict access through a Condition element in the policy. Otherwise, any IAM user in any account in your partition can access the role.
     *
     * @experimental
     */
    forPublic(): this;
}
