# Yandex Resource Provider

The Yandex Resource Provider lets you manage [Yandex](http://example.com) resources.

## Installing

This package is available for several languages/platforms:

### Node.js (JavaScript/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

```bash
npm install @pulumi/yandex
```

or `yarn`:

```bash
yarn add @pulumi/yandex
```

### Python

To use from Python, install using `pip`:

```bash
pip install pulumi_yandex
```

### Go

To use from Go, use `go get` to grab the latest version of the library:

```bash
go get github.com/pulumi/pulumi-yandex/sdk/go/...
```

### .NET

To use from .NET, install using `dotnet add package`:

```bash
dotnet add package Pulumi.Yandex
```

## Configuration

The following configuration points are available for the `yandex` provider:

- `yandex:region` (environment: `YANDEX_REGION`) - the region in which to deploy resources

## Reference

For detailed reference documentation, please visit [the Pulumi registry](https://www.pulumi.com/registry/packages/yandex/api-docs/).
