# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuditTrailsTrailArgs', 'AuditTrailsTrail']

@pulumi.input_type
class AuditTrailsTrailArgs:
    def __init__(__self__, *,
                 folder_id: pulumi.Input[_builtins.str],
                 service_account_id: pulumi.Input[_builtins.str],
                 data_stream_destination: Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input['AuditTrailsTrailFilterArgs']] = None,
                 filtering_policy: Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging_destination: Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_destination: Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']] = None):
        """
        The set of arguments for constructing a AuditTrailsTrail resource.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs'] data_stream_destination: Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input['AuditTrailsTrailFilterArgs'] filter: Structure is deprecated. Use `filtering_policy` instead.
        :param pulumi.Input['AuditTrailsTrailFilteringPolicyArgs'] filtering_policy: Structure describing event filtering process for the trail. Mutually exclusive with `filter`. At least one of the `management_events_filter` or `data_events_filter` fields will be filled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['AuditTrailsTrailLoggingDestinationArgs'] logging_destination: Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['AuditTrailsTrailStorageDestinationArgs'] storage_destination: Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        pulumi.set(__self__, "folder_id", folder_id)
        pulumi.set(__self__, "service_account_id", service_account_id)
        if data_stream_destination is not None:
            pulumi.set(__self__, "data_stream_destination", data_stream_destination)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            warnings.warn("""Configure filtering_policy instead. This attribute will be removed""", DeprecationWarning)
            pulumi.log.warn("""filter is deprecated: Configure filtering_policy instead. This attribute will be removed""")
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if filtering_policy is not None:
            pulumi.set(__self__, "filtering_policy", filtering_policy)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if logging_destination is not None:
            pulumi.set(__self__, "logging_destination", logging_destination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_destination is not None:
            pulumi.set(__self__, "storage_destination", storage_destination)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Input[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="dataStreamDestination")
    def data_stream_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']]:
        """
        Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        """
        return pulumi.get(self, "data_stream_destination")

    @data_stream_destination.setter
    def data_stream_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']]):
        pulumi.set(self, "data_stream_destination", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Configure filtering_policy instead. This attribute will be removed""")
    def filter(self) -> Optional[pulumi.Input['AuditTrailsTrailFilterArgs']]:
        """
        Structure is deprecated. Use `filtering_policy` instead.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['AuditTrailsTrailFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="filteringPolicy")
    def filtering_policy(self) -> Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']]:
        """
        Structure describing event filtering process for the trail. Mutually exclusive with `filter`. At least one of the `management_events_filter` or `data_events_filter` fields will be filled.
        """
        return pulumi.get(self, "filtering_policy")

    @filtering_policy.setter
    def filtering_policy(self, value: Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']]):
        pulumi.set(self, "filtering_policy", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loggingDestination")
    def logging_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']]:
        """
        Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "logging_destination")

    @logging_destination.setter
    def logging_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']]):
        pulumi.set(self, "logging_destination", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="storageDestination")
    def storage_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']]:
        """
        Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "storage_destination")

    @storage_destination.setter
    def storage_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']]):
        pulumi.set(self, "storage_destination", value)


@pulumi.input_type
class _AuditTrailsTrailState:
    def __init__(__self__, *,
                 data_stream_destination: Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input['AuditTrailsTrailFilterArgs']] = None,
                 filtering_policy: Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging_destination: Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_destination: Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']] = None,
                 trail_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuditTrailsTrail resources.
        :param pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs'] data_stream_destination: Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input['AuditTrailsTrailFilterArgs'] filter: Structure is deprecated. Use `filtering_policy` instead.
        :param pulumi.Input['AuditTrailsTrailFilteringPolicyArgs'] filtering_policy: Structure describing event filtering process for the trail. Mutually exclusive with `filter`. At least one of the `management_events_filter` or `data_events_filter` fields will be filled.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['AuditTrailsTrailLoggingDestinationArgs'] logging_destination: Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[_builtins.str] status: Status of this trail.
        :param pulumi.Input['AuditTrailsTrailStorageDestinationArgs'] storage_destination: Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        :param pulumi.Input[_builtins.str] trail_id: ID of the trail resource.
        """
        if data_stream_destination is not None:
            pulumi.set(__self__, "data_stream_destination", data_stream_destination)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            warnings.warn("""Configure filtering_policy instead. This attribute will be removed""", DeprecationWarning)
            pulumi.log.warn("""filter is deprecated: Configure filtering_policy instead. This attribute will be removed""")
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if filtering_policy is not None:
            pulumi.set(__self__, "filtering_policy", filtering_policy)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if logging_destination is not None:
            pulumi.set(__self__, "logging_destination", logging_destination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_destination is not None:
            pulumi.set(__self__, "storage_destination", storage_destination)
        if trail_id is not None:
            pulumi.set(__self__, "trail_id", trail_id)

    @_builtins.property
    @pulumi.getter(name="dataStreamDestination")
    def data_stream_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']]:
        """
        Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        """
        return pulumi.get(self, "data_stream_destination")

    @data_stream_destination.setter
    def data_stream_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']]):
        pulumi.set(self, "data_stream_destination", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Configure filtering_policy instead. This attribute will be removed""")
    def filter(self) -> Optional[pulumi.Input['AuditTrailsTrailFilterArgs']]:
        """
        Structure is deprecated. Use `filtering_policy` instead.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['AuditTrailsTrailFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="filteringPolicy")
    def filtering_policy(self) -> Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']]:
        """
        Structure describing event filtering process for the trail. Mutually exclusive with `filter`. At least one of the `management_events_filter` or `data_events_filter` fields will be filled.
        """
        return pulumi.get(self, "filtering_policy")

    @filtering_policy.setter
    def filtering_policy(self, value: Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']]):
        pulumi.set(self, "filtering_policy", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loggingDestination")
    def logging_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']]:
        """
        Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "logging_destination")

    @logging_destination.setter
    def logging_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']]):
        pulumi.set(self, "logging_destination", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of this trail.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageDestination")
    def storage_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']]:
        """
        Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "storage_destination")

    @storage_destination.setter
    def storage_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']]):
        pulumi.set(self, "storage_destination", value)

    @_builtins.property
    @pulumi.getter(name="trailId")
    def trail_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the trail resource.
        """
        return pulumi.get(self, "trail_id")

    @trail_id.setter
    def trail_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trail_id", value)


@pulumi.type_token("yandex:index/auditTrailsTrail:AuditTrailsTrail")
class AuditTrailsTrail(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_stream_destination: Optional[pulumi.Input[Union['AuditTrailsTrailDataStreamDestinationArgs', 'AuditTrailsTrailDataStreamDestinationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[Union['AuditTrailsTrailFilterArgs', 'AuditTrailsTrailFilterArgsDict']]] = None,
                 filtering_policy: Optional[pulumi.Input[Union['AuditTrailsTrailFilteringPolicyArgs', 'AuditTrailsTrailFilteringPolicyArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging_destination: Optional[pulumi.Input[Union['AuditTrailsTrailLoggingDestinationArgs', 'AuditTrailsTrailLoggingDestinationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_destination: Optional[pulumi.Input[Union['AuditTrailsTrailStorageDestinationArgs', 'AuditTrailsTrailStorageDestinationArgsDict']]] = None,
                 __props__=None):
        """
        Allows management of [trail](https://yandex.cloud/docs/audit-trails/concepts/trail).

        ## Migration from deprecated filter field

        In order to migrate from using `filter` to the `filtering_policy`, you will have to:
        * Remove the `filter.event_filters.categories` blocks. With the introduction of `included_events`/`excluded_events` you can configure filtering per each event type.
        * Replace the `filter.event_filters.path_filter` with the appropriate `resource_scope` blocks. You have to account that `resource_scope` does not support specifying relations between resources, so your configuration will simplify to only the actual resources, that will be monitored.

        * Replace the `filter.path_filter` block with the `filtering_policy.management_events_filter`. New API states management events filtration in a more clear way. The resources, that were specified, must migrate into the `filtering_policy.management_events_filter.resource_scope`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new basic Audit Trails Trail
        #
        basic_trail = yandex.AuditTrailsTrail("basic-trail",
            name="basic-trail",
            folder_id="home-folder",
            description="Some trail description",
            labels={
                "key": "value",
            },
            service_account_id="trail-service-account",
            logging_destination={
                "log_group_id": "some-log-group",
            },
            filtering_policy={
                "management_events_filter": {
                    "resource_scopes": [{
                        "resource_id": "home-folder",
                        "resource_type": "resource-manager.folder",
                    }],
                },
                "data_events_filters": [
                    {
                        "service": "storage",
                        "resource_scopes": [{
                            "resource_id": "home-folder",
                            "resource_type": "resource-manager.folder",
                        }],
                    },
                    {
                        "service": "dns",
                        "resource_scopes": [
                            {
                                "resource_id": "vpc-net-id-1",
                                "resource_type": "vpc.network",
                            },
                            {
                                "resource_id": "vpc-net-id-2",
                                "resource_type": "vpc.network",
                            },
                        ],
                        "dns_filter": {
                            "include_nonrecursive_queries": True,
                        },
                    },
                ],
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create Trail for delivering events to YDS and gathering such events:
        # * Management events from the 'some-organization' organization.
        # * DNS data events with only recursive queries from the 'some-organization' organization.
        # * Object Storage data events from the 'some-organization' organization.
        #
        basic_trail = yandex.AuditTrailsTrail("basic_trail",
            name="a-trail",
            folder_id="home-folder",
            description="Some trail description",
            labels={
                "key": "value",
            },
            service_account_id="trail-service-account",
            data_stream_destination={
                "database_id": "some-database",
                "stream_name": "some-stream",
            },
            filtering_policy={
                "management_events_filter": {
                    "resource_scopes": [{
                        "resource_id": "some-organization",
                        "resource_type": "organization-manager.organization",
                    }],
                },
                "data_events_filters": [
                    {
                        "service": "storage",
                        "resource_scopes": [{
                            "resource_id": "some-organization",
                            "resource_type": "organization-manager.organization",
                        }],
                    },
                    {
                        "service": "dns",
                        "resource_scopes": [{
                            "resource_id": "some-organization",
                            "resource_type": "organization-manager.organization",
                        }],
                        "dns_filter": {
                            "include_nonrecursive_queries": True,
                        },
                    },
                ],
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/auditTrailsTrail:AuditTrailsTrail <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/auditTrailsTrail:AuditTrailsTrail basic-trail cnpqe**********sh835
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AuditTrailsTrailDataStreamDestinationArgs', 'AuditTrailsTrailDataStreamDestinationArgsDict']] data_stream_destination: Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Union['AuditTrailsTrailFilterArgs', 'AuditTrailsTrailFilterArgsDict']] filter: Structure is deprecated. Use `filtering_policy` instead.
        :param pulumi.Input[Union['AuditTrailsTrailFilteringPolicyArgs', 'AuditTrailsTrailFilteringPolicyArgsDict']] filtering_policy: Structure describing event filtering process for the trail. Mutually exclusive with `filter`. At least one of the `management_events_filter` or `data_events_filter` fields will be filled.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['AuditTrailsTrailLoggingDestinationArgs', 'AuditTrailsTrailLoggingDestinationArgsDict']] logging_destination: Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Union['AuditTrailsTrailStorageDestinationArgs', 'AuditTrailsTrailStorageDestinationArgsDict']] storage_destination: Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuditTrailsTrailArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [trail](https://yandex.cloud/docs/audit-trails/concepts/trail).

        ## Migration from deprecated filter field

        In order to migrate from using `filter` to the `filtering_policy`, you will have to:
        * Remove the `filter.event_filters.categories` blocks. With the introduction of `included_events`/`excluded_events` you can configure filtering per each event type.
        * Replace the `filter.event_filters.path_filter` with the appropriate `resource_scope` blocks. You have to account that `resource_scope` does not support specifying relations between resources, so your configuration will simplify to only the actual resources, that will be monitored.

        * Replace the `filter.path_filter` block with the `filtering_policy.management_events_filter`. New API states management events filtration in a more clear way. The resources, that were specified, must migrate into the `filtering_policy.management_events_filter.resource_scope`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new basic Audit Trails Trail
        #
        basic_trail = yandex.AuditTrailsTrail("basic-trail",
            name="basic-trail",
            folder_id="home-folder",
            description="Some trail description",
            labels={
                "key": "value",
            },
            service_account_id="trail-service-account",
            logging_destination={
                "log_group_id": "some-log-group",
            },
            filtering_policy={
                "management_events_filter": {
                    "resource_scopes": [{
                        "resource_id": "home-folder",
                        "resource_type": "resource-manager.folder",
                    }],
                },
                "data_events_filters": [
                    {
                        "service": "storage",
                        "resource_scopes": [{
                            "resource_id": "home-folder",
                            "resource_type": "resource-manager.folder",
                        }],
                    },
                    {
                        "service": "dns",
                        "resource_scopes": [
                            {
                                "resource_id": "vpc-net-id-1",
                                "resource_type": "vpc.network",
                            },
                            {
                                "resource_id": "vpc-net-id-2",
                                "resource_type": "vpc.network",
                            },
                        ],
                        "dns_filter": {
                            "include_nonrecursive_queries": True,
                        },
                    },
                ],
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create Trail for delivering events to YDS and gathering such events:
        # * Management events from the 'some-organization' organization.
        # * DNS data events with only recursive queries from the 'some-organization' organization.
        # * Object Storage data events from the 'some-organization' organization.
        #
        basic_trail = yandex.AuditTrailsTrail("basic_trail",
            name="a-trail",
            folder_id="home-folder",
            description="Some trail description",
            labels={
                "key": "value",
            },
            service_account_id="trail-service-account",
            data_stream_destination={
                "database_id": "some-database",
                "stream_name": "some-stream",
            },
            filtering_policy={
                "management_events_filter": {
                    "resource_scopes": [{
                        "resource_id": "some-organization",
                        "resource_type": "organization-manager.organization",
                    }],
                },
                "data_events_filters": [
                    {
                        "service": "storage",
                        "resource_scopes": [{
                            "resource_id": "some-organization",
                            "resource_type": "organization-manager.organization",
                        }],
                    },
                    {
                        "service": "dns",
                        "resource_scopes": [{
                            "resource_id": "some-organization",
                            "resource_type": "organization-manager.organization",
                        }],
                        "dns_filter": {
                            "include_nonrecursive_queries": True,
                        },
                    },
                ],
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/auditTrailsTrail:AuditTrailsTrail <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/auditTrailsTrail:AuditTrailsTrail basic-trail cnpqe**********sh835
        ```

        :param str resource_name: The name of the resource.
        :param AuditTrailsTrailArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuditTrailsTrailArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_stream_destination: Optional[pulumi.Input[Union['AuditTrailsTrailDataStreamDestinationArgs', 'AuditTrailsTrailDataStreamDestinationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[Union['AuditTrailsTrailFilterArgs', 'AuditTrailsTrailFilterArgsDict']]] = None,
                 filtering_policy: Optional[pulumi.Input[Union['AuditTrailsTrailFilteringPolicyArgs', 'AuditTrailsTrailFilteringPolicyArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging_destination: Optional[pulumi.Input[Union['AuditTrailsTrailLoggingDestinationArgs', 'AuditTrailsTrailLoggingDestinationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_destination: Optional[pulumi.Input[Union['AuditTrailsTrailStorageDestinationArgs', 'AuditTrailsTrailStorageDestinationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuditTrailsTrailArgs.__new__(AuditTrailsTrailArgs)

            __props__.__dict__["data_stream_destination"] = data_stream_destination
            __props__.__dict__["description"] = description
            __props__.__dict__["filter"] = filter
            __props__.__dict__["filtering_policy"] = filtering_policy
            if folder_id is None and not opts.urn:
                raise TypeError("Missing required property 'folder_id'")
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["logging_destination"] = logging_destination
            __props__.__dict__["name"] = name
            if service_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_id'")
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["storage_destination"] = storage_destination
            __props__.__dict__["status"] = None
            __props__.__dict__["trail_id"] = None
        super(AuditTrailsTrail, __self__).__init__(
            'yandex:index/auditTrailsTrail:AuditTrailsTrail',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_stream_destination: Optional[pulumi.Input[Union['AuditTrailsTrailDataStreamDestinationArgs', 'AuditTrailsTrailDataStreamDestinationArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            filter: Optional[pulumi.Input[Union['AuditTrailsTrailFilterArgs', 'AuditTrailsTrailFilterArgsDict']]] = None,
            filtering_policy: Optional[pulumi.Input[Union['AuditTrailsTrailFilteringPolicyArgs', 'AuditTrailsTrailFilteringPolicyArgsDict']]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            logging_destination: Optional[pulumi.Input[Union['AuditTrailsTrailLoggingDestinationArgs', 'AuditTrailsTrailLoggingDestinationArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_destination: Optional[pulumi.Input[Union['AuditTrailsTrailStorageDestinationArgs', 'AuditTrailsTrailStorageDestinationArgsDict']]] = None,
            trail_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuditTrailsTrail':
        """
        Get an existing AuditTrailsTrail resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AuditTrailsTrailDataStreamDestinationArgs', 'AuditTrailsTrailDataStreamDestinationArgsDict']] data_stream_destination: Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Union['AuditTrailsTrailFilterArgs', 'AuditTrailsTrailFilterArgsDict']] filter: Structure is deprecated. Use `filtering_policy` instead.
        :param pulumi.Input[Union['AuditTrailsTrailFilteringPolicyArgs', 'AuditTrailsTrailFilteringPolicyArgsDict']] filtering_policy: Structure describing event filtering process for the trail. Mutually exclusive with `filter`. At least one of the `management_events_filter` or `data_events_filter` fields will be filled.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['AuditTrailsTrailLoggingDestinationArgs', 'AuditTrailsTrailLoggingDestinationArgsDict']] logging_destination: Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[_builtins.str] status: Status of this trail.
        :param pulumi.Input[Union['AuditTrailsTrailStorageDestinationArgs', 'AuditTrailsTrailStorageDestinationArgsDict']] storage_destination: Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        :param pulumi.Input[_builtins.str] trail_id: ID of the trail resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuditTrailsTrailState.__new__(_AuditTrailsTrailState)

        __props__.__dict__["data_stream_destination"] = data_stream_destination
        __props__.__dict__["description"] = description
        __props__.__dict__["filter"] = filter
        __props__.__dict__["filtering_policy"] = filtering_policy
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["logging_destination"] = logging_destination
        __props__.__dict__["name"] = name
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_destination"] = storage_destination
        __props__.__dict__["trail_id"] = trail_id
        return AuditTrailsTrail(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataStreamDestination")
    def data_stream_destination(self) -> pulumi.Output[Optional['outputs.AuditTrailsTrailDataStreamDestination']]:
        """
        Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        """
        return pulumi.get(self, "data_stream_destination")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Configure filtering_policy instead. This attribute will be removed""")
    def filter(self) -> pulumi.Output[Optional['outputs.AuditTrailsTrailFilter']]:
        """
        Structure is deprecated. Use `filtering_policy` instead.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="filteringPolicy")
    def filtering_policy(self) -> pulumi.Output[Optional['outputs.AuditTrailsTrailFilteringPolicy']]:
        """
        Structure describing event filtering process for the trail. Mutually exclusive with `filter`. At least one of the `management_events_filter` or `data_events_filter` fields will be filled.
        """
        return pulumi.get(self, "filtering_policy")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="loggingDestination")
    def logging_destination(self) -> pulumi.Output[Optional['outputs.AuditTrailsTrailLoggingDestination']]:
        """
        Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "logging_destination")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of this trail.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageDestination")
    def storage_destination(self) -> pulumi.Output[Optional['outputs.AuditTrailsTrailStorageDestination']]:
        """
        Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "storage_destination")

    @_builtins.property
    @pulumi.getter(name="trailId")
    def trail_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the trail resource.
        """
        return pulumi.get(self, "trail_id")

