# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['BackupPolicyBindingsArgs', 'BackupPolicyBindings']

@pulumi.input_type
class BackupPolicyBindingsArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 policy_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a BackupPolicyBindings resource.
        :param pulumi.Input[_builtins.str] instance_id: Compute Cloud instance ID.
        :param pulumi.Input[_builtins.str] policy_id: Backup Policy ID.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "policy_id", policy_id)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Compute Cloud instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Backup Policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)


@pulumi.input_type
class _BackupPolicyBindingsState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 processing: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering BackupPolicyBindings resources.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] enabled: Flag is specifies whether the policy application is enabled. May be `false` if Processing flag is `true`.
        :param pulumi.Input[_builtins.str] instance_id: Compute Cloud instance ID.
        :param pulumi.Input[_builtins.str] policy_id: Backup Policy ID.
        :param pulumi.Input[_builtins.bool] processing: Flag that specifies whether the policy is in the process of binding to an instance.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if processing is not None:
            pulumi.set(__self__, "processing", processing)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag is specifies whether the policy application is enabled. May be `false` if Processing flag is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compute Cloud instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup Policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def processing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that specifies whether the policy is in the process of binding to an instance.
        """
        return pulumi.get(self, "processing")

    @processing.setter
    def processing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "processing", value)


@pulumi.type_token("yandex:index/backupPolicyBindings:BackupPolicyBindings")
class BackupPolicyBindings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Attach and Detach VM](https://yandex.cloud/docs/backup/operations/policy-vm/attach-and-detach-vm).

         > Cloud Backup Provider must be activated in order to manipulate with policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Cloud Backup Policy Binding
        #
        test_sa = yandex.IamServiceAccount("test_sa", name="sa-backup-editor")
        test_binding = yandex.index.ResourcemanagerFolderIamMember("test_binding",
            folder_id=test_sa.folder_id,
            role=backup.editor,
            member=fserviceAccount:{test_sa.id})
        test_backup_network = yandex.VpcNetwork("test_backup_network")
        test_backup_subnet = yandex.VpcSubnet("test_backup_subnet",
            zone="ru-central1-a",
            network_id=test_backup_network.id,
            v4_cidr_blocks=["192.168.0.0/24"])
        # https://yandex.cloud/ru/docs/backup/concepts/vm-connection#vm-network-access
        test_backup_security_group = yandex.VpcSecurityGroup("test_backup_security_group",
            name="cloud-backup",
            network_id=test_backup_network.id,
            egresses=[
                {
                    "protocol": "TCP",
                    "from_port": 7770,
                    "to_port": 7800,
                    "v4_cidr_blocks": ["84.47.172.0/24"],
                },
                {
                    "protocol": "TCP",
                    "port": 443,
                    "v4_cidr_blocks": [
                        "213.180.204.0/24",
                        "213.180.193.0/24",
                        "178.176.128.0/24",
                        "84.201.181.0/24",
                        "84.47.172.0/24",
                    ],
                },
                {
                    "protocol": "TCP",
                    "port": 80,
                    "v4_cidr_blocks": [
                        "213.180.204.0/24",
                        "213.180.193.0/24",
                    ],
                },
                {
                    "protocol": "TCP",
                    "port": 8443,
                    "v4_cidr_blocks": ["84.47.172.0/24"],
                },
                {
                    "protocol": "TCP",
                    "port": 44445,
                    "v4_cidr_blocks": ["51.250.1.0/24"],
                },
            ])
        ubuntu = yandex.get_compute_image(family="ubuntu-2004-lts")
        test_backup_compute = yandex.ComputeInstance("test_backup_compute",
            name="test-backup-compute",
            platform_id="standard-v1",
            zone="ru-central1-a",
            service_account_id=test_sa.id,
            network_interfaces=[{
                "subnet_id": test_backup_subnet.id,
                "security_group_ids": [test_backup_security_group.id],
                "nat": True,
            }],
            boot_disk={
                "initialize_params": {
                    "image_id": ubuntu.id,
                },
            },
            resources={
                "cores": 2,
                "memory": 4,
            },
            metadata={
                "user-data": \"\"\"#cloud-config
        packages:
          - curl
          - perl
          - jq
        runcmd:
          - curl https://storage.yandexcloud.net/backup-distributions/agent_installer.sh | sudo bash
        \"\"\",
            })
        test_backup_policy = yandex.get_backup_policy(name="Default daily")
        test_backup_binding = yandex.BackupPolicyBindings("test_backup_binding",
            instance_id=test_backup_compute.id,
            policy_id=test_backup_policy.id)
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/backupPolicyBindings:BackupPolicyBindings <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/backupPolicyBindings:BackupPolicyBindings test_backup_binding ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: Compute Cloud instance ID.
        :param pulumi.Input[_builtins.str] policy_id: Backup Policy ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPolicyBindingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Attach and Detach VM](https://yandex.cloud/docs/backup/operations/policy-vm/attach-and-detach-vm).

         > Cloud Backup Provider must be activated in order to manipulate with policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Cloud Backup Policy Binding
        #
        test_sa = yandex.IamServiceAccount("test_sa", name="sa-backup-editor")
        test_binding = yandex.index.ResourcemanagerFolderIamMember("test_binding",
            folder_id=test_sa.folder_id,
            role=backup.editor,
            member=fserviceAccount:{test_sa.id})
        test_backup_network = yandex.VpcNetwork("test_backup_network")
        test_backup_subnet = yandex.VpcSubnet("test_backup_subnet",
            zone="ru-central1-a",
            network_id=test_backup_network.id,
            v4_cidr_blocks=["192.168.0.0/24"])
        # https://yandex.cloud/ru/docs/backup/concepts/vm-connection#vm-network-access
        test_backup_security_group = yandex.VpcSecurityGroup("test_backup_security_group",
            name="cloud-backup",
            network_id=test_backup_network.id,
            egresses=[
                {
                    "protocol": "TCP",
                    "from_port": 7770,
                    "to_port": 7800,
                    "v4_cidr_blocks": ["84.47.172.0/24"],
                },
                {
                    "protocol": "TCP",
                    "port": 443,
                    "v4_cidr_blocks": [
                        "213.180.204.0/24",
                        "213.180.193.0/24",
                        "178.176.128.0/24",
                        "84.201.181.0/24",
                        "84.47.172.0/24",
                    ],
                },
                {
                    "protocol": "TCP",
                    "port": 80,
                    "v4_cidr_blocks": [
                        "213.180.204.0/24",
                        "213.180.193.0/24",
                    ],
                },
                {
                    "protocol": "TCP",
                    "port": 8443,
                    "v4_cidr_blocks": ["84.47.172.0/24"],
                },
                {
                    "protocol": "TCP",
                    "port": 44445,
                    "v4_cidr_blocks": ["51.250.1.0/24"],
                },
            ])
        ubuntu = yandex.get_compute_image(family="ubuntu-2004-lts")
        test_backup_compute = yandex.ComputeInstance("test_backup_compute",
            name="test-backup-compute",
            platform_id="standard-v1",
            zone="ru-central1-a",
            service_account_id=test_sa.id,
            network_interfaces=[{
                "subnet_id": test_backup_subnet.id,
                "security_group_ids": [test_backup_security_group.id],
                "nat": True,
            }],
            boot_disk={
                "initialize_params": {
                    "image_id": ubuntu.id,
                },
            },
            resources={
                "cores": 2,
                "memory": 4,
            },
            metadata={
                "user-data": \"\"\"#cloud-config
        packages:
          - curl
          - perl
          - jq
        runcmd:
          - curl https://storage.yandexcloud.net/backup-distributions/agent_installer.sh | sudo bash
        \"\"\",
            })
        test_backup_policy = yandex.get_backup_policy(name="Default daily")
        test_backup_binding = yandex.BackupPolicyBindings("test_backup_binding",
            instance_id=test_backup_compute.id,
            policy_id=test_backup_policy.id)
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/backupPolicyBindings:BackupPolicyBindings <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/backupPolicyBindings:BackupPolicyBindings test_backup_binding ...
        ```

        :param str resource_name: The name of the resource.
        :param BackupPolicyBindingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPolicyBindingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPolicyBindingsArgs.__new__(BackupPolicyBindingsArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enabled"] = None
            __props__.__dict__["processing"] = None
        super(BackupPolicyBindings, __self__).__init__(
            'yandex:index/backupPolicyBindings:BackupPolicyBindings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            processing: Optional[pulumi.Input[_builtins.bool]] = None) -> 'BackupPolicyBindings':
        """
        Get an existing BackupPolicyBindings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] enabled: Flag is specifies whether the policy application is enabled. May be `false` if Processing flag is `true`.
        :param pulumi.Input[_builtins.str] instance_id: Compute Cloud instance ID.
        :param pulumi.Input[_builtins.str] policy_id: Backup Policy ID.
        :param pulumi.Input[_builtins.bool] processing: Flag that specifies whether the policy is in the process of binding to an instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPolicyBindingsState.__new__(_BackupPolicyBindingsState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["processing"] = processing
        return BackupPolicyBindings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag is specifies whether the policy application is enabled. May be `false` if Processing flag is `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Compute Cloud instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Backup Policy ID.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter
    def processing(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag that specifies whether the policy is in the process of binding to an instance.
        """
        return pulumi.get(self, "processing")

