# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CdnResourceArgs', 'CdnResource']

@pulumi.input_type
class CdnResourceArgs:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 cname: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 options: Optional[pulumi.Input['CdnResourceOptionsArgs']] = None,
                 origin_group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 origin_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ssl_certificate: Optional[pulumi.Input['CdnResourceSslCertificateArgs']] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CdnResource resource.
        :param pulumi.Input[_builtins.bool] active: Flag to create Resource either in active or disabled state. `True` - the content from CDN is available to clients.
        :param pulumi.Input[_builtins.str] cname: CDN endpoint CNAME, must be unique among resources.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['CdnResourceOptionsArgs'] options: CDN Resource settings and options to tune CDN edge behavior.
        :param pulumi.Input[_builtins.int] origin_group_id: The ID of a specific origin group.
        :param pulumi.Input[_builtins.str] origin_group_name: The name of a specific origin group.
        :param pulumi.Input[_builtins.str] origin_protocol: Protocol of origin resource. `http` or `https`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_hostnames: List of secondary hostname strings.
        :param pulumi.Input['CdnResourceSslCertificateArgs'] ssl_certificate: SSL certificate of CDN resource.
        :param pulumi.Input[_builtins.str] updated_at: Last update timestamp. Computed value for read and update operations.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if origin_group_id is not None:
            pulumi.set(__self__, "origin_group_id", origin_group_id)
        if origin_group_name is not None:
            pulumi.set(__self__, "origin_group_name", origin_group_name)
        if origin_protocol is not None:
            pulumi.set(__self__, "origin_protocol", origin_protocol)
        if secondary_hostnames is not None:
            pulumi.set(__self__, "secondary_hostnames", secondary_hostnames)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to create Resource either in active or disabled state. `True` - the content from CDN is available to clients.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CDN endpoint CNAME, must be unique among resources.
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cname", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['CdnResourceOptionsArgs']]:
        """
        CDN Resource settings and options to tune CDN edge behavior.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['CdnResourceOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="originGroupId")
    def origin_group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of a specific origin group.
        """
        return pulumi.get(self, "origin_group_id")

    @origin_group_id.setter
    def origin_group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "origin_group_id", value)

    @_builtins.property
    @pulumi.getter(name="originGroupName")
    def origin_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a specific origin group.
        """
        return pulumi.get(self, "origin_group_name")

    @origin_group_name.setter
    def origin_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_group_name", value)

    @_builtins.property
    @pulumi.getter(name="originProtocol")
    def origin_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol of origin resource. `http` or `https`.
        """
        return pulumi.get(self, "origin_protocol")

    @origin_protocol.setter
    def origin_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_protocol", value)

    @_builtins.property
    @pulumi.getter(name="secondaryHostnames")
    def secondary_hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of secondary hostname strings.
        """
        return pulumi.get(self, "secondary_hostnames")

    @secondary_hostnames.setter
    def secondary_hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_hostnames", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['CdnResourceSslCertificateArgs']]:
        """
        SSL certificate of CDN resource.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['CdnResourceSslCertificateArgs']]):
        pulumi.set(self, "ssl_certificate", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last update timestamp. Computed value for read and update operations.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class _CdnResourceState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 cname: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 options: Optional[pulumi.Input['CdnResourceOptionsArgs']] = None,
                 origin_group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 origin_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_cname: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_type: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ssl_certificate: Optional[pulumi.Input['CdnResourceSslCertificateArgs']] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CdnResource resources.
        :param pulumi.Input[_builtins.bool] active: Flag to create Resource either in active or disabled state. `True` - the content from CDN is available to clients.
        :param pulumi.Input[_builtins.str] cname: CDN endpoint CNAME, must be unique among resources.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['CdnResourceOptionsArgs'] options: CDN Resource settings and options to tune CDN edge behavior.
        :param pulumi.Input[_builtins.int] origin_group_id: The ID of a specific origin group.
        :param pulumi.Input[_builtins.str] origin_group_name: The name of a specific origin group.
        :param pulumi.Input[_builtins.str] origin_protocol: Protocol of origin resource. `http` or `https`.
        :param pulumi.Input[_builtins.str] provider_cname: Provider CNAME of CDN resource, computed value for read and update operations.
        :param pulumi.Input[_builtins.str] provider_type: Type of the CDN provider for this resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_hostnames: List of secondary hostname strings.
        :param pulumi.Input['CdnResourceSslCertificateArgs'] ssl_certificate: SSL certificate of CDN resource.
        :param pulumi.Input[_builtins.str] updated_at: Last update timestamp. Computed value for read and update operations.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if origin_group_id is not None:
            pulumi.set(__self__, "origin_group_id", origin_group_id)
        if origin_group_name is not None:
            pulumi.set(__self__, "origin_group_name", origin_group_name)
        if origin_protocol is not None:
            pulumi.set(__self__, "origin_protocol", origin_protocol)
        if provider_cname is not None:
            pulumi.set(__self__, "provider_cname", provider_cname)
        if provider_type is not None:
            pulumi.set(__self__, "provider_type", provider_type)
        if secondary_hostnames is not None:
            pulumi.set(__self__, "secondary_hostnames", secondary_hostnames)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to create Resource either in active or disabled state. `True` - the content from CDN is available to clients.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CDN endpoint CNAME, must be unique among resources.
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cname", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['CdnResourceOptionsArgs']]:
        """
        CDN Resource settings and options to tune CDN edge behavior.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['CdnResourceOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="originGroupId")
    def origin_group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of a specific origin group.
        """
        return pulumi.get(self, "origin_group_id")

    @origin_group_id.setter
    def origin_group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "origin_group_id", value)

    @_builtins.property
    @pulumi.getter(name="originGroupName")
    def origin_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a specific origin group.
        """
        return pulumi.get(self, "origin_group_name")

    @origin_group_name.setter
    def origin_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_group_name", value)

    @_builtins.property
    @pulumi.getter(name="originProtocol")
    def origin_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol of origin resource. `http` or `https`.
        """
        return pulumi.get(self, "origin_protocol")

    @origin_protocol.setter
    def origin_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_protocol", value)

    @_builtins.property
    @pulumi.getter(name="providerCname")
    def provider_cname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider CNAME of CDN resource, computed value for read and update operations.
        """
        return pulumi.get(self, "provider_cname")

    @provider_cname.setter
    def provider_cname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_cname", value)

    @_builtins.property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the CDN provider for this resource.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_type", value)

    @_builtins.property
    @pulumi.getter(name="secondaryHostnames")
    def secondary_hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of secondary hostname strings.
        """
        return pulumi.get(self, "secondary_hostnames")

    @secondary_hostnames.setter
    def secondary_hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_hostnames", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['CdnResourceSslCertificateArgs']]:
        """
        SSL certificate of CDN resource.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['CdnResourceSslCertificateArgs']]):
        pulumi.set(self, "ssl_certificate", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last update timestamp. Computed value for read and update operations.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("yandex:index/cdnResource:CdnResource")
class CdnResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 cname: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 options: Optional[pulumi.Input[Union['CdnResourceOptionsArgs', 'CdnResourceOptionsArgsDict']]] = None,
                 origin_group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 origin_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ssl_certificate: Optional[pulumi.Input[Union['CdnResourceSslCertificateArgs', 'CdnResourceSslCertificateArgsDict']]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud CDN Resource](https://yandex.cloud/docs/cdn/concepts/resource).

        > CDN provider must be activated prior usage of CDN resources, either via UI console or via yc cli command: `yc cdn provider activate --folder-id <folder-id> --type gcore`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new CDN Resource
        #
        my_resource = yandex.CdnResource("my_resource",
            cname="cdn1.yandex-example.ru",
            active=False,
            origin_protocol="https",
            secondary_hostnames=[
                "cdn-example-1.yandex.ru",
                "cdn-example-2.yandex.ru",
            ],
            origin_group_id=foo_cdn_group_by_id["id"],
            options={
                "edge_cache_settings": 345600,
                "ignore_cookie": True,
                "static_request_headers": {
                    "is-from-cdn": "yes",
                },
                "static_response_headers": {
                    "is-cdn": "yes",
                },
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/cdnResource:CdnResource <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/cdnResource:CdnResource my_cdn_resource ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Flag to create Resource either in active or disabled state. `True` - the content from CDN is available to clients.
        :param pulumi.Input[_builtins.str] cname: CDN endpoint CNAME, must be unique among resources.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['CdnResourceOptionsArgs', 'CdnResourceOptionsArgsDict']] options: CDN Resource settings and options to tune CDN edge behavior.
        :param pulumi.Input[_builtins.int] origin_group_id: The ID of a specific origin group.
        :param pulumi.Input[_builtins.str] origin_group_name: The name of a specific origin group.
        :param pulumi.Input[_builtins.str] origin_protocol: Protocol of origin resource. `http` or `https`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_hostnames: List of secondary hostname strings.
        :param pulumi.Input[Union['CdnResourceSslCertificateArgs', 'CdnResourceSslCertificateArgsDict']] ssl_certificate: SSL certificate of CDN resource.
        :param pulumi.Input[_builtins.str] updated_at: Last update timestamp. Computed value for read and update operations.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CdnResourceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud CDN Resource](https://yandex.cloud/docs/cdn/concepts/resource).

        > CDN provider must be activated prior usage of CDN resources, either via UI console or via yc cli command: `yc cdn provider activate --folder-id <folder-id> --type gcore`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new CDN Resource
        #
        my_resource = yandex.CdnResource("my_resource",
            cname="cdn1.yandex-example.ru",
            active=False,
            origin_protocol="https",
            secondary_hostnames=[
                "cdn-example-1.yandex.ru",
                "cdn-example-2.yandex.ru",
            ],
            origin_group_id=foo_cdn_group_by_id["id"],
            options={
                "edge_cache_settings": 345600,
                "ignore_cookie": True,
                "static_request_headers": {
                    "is-from-cdn": "yes",
                },
                "static_response_headers": {
                    "is-cdn": "yes",
                },
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/cdnResource:CdnResource <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/cdnResource:CdnResource my_cdn_resource ...
        ```

        :param str resource_name: The name of the resource.
        :param CdnResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CdnResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 cname: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 options: Optional[pulumi.Input[Union['CdnResourceOptionsArgs', 'CdnResourceOptionsArgsDict']]] = None,
                 origin_group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 origin_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ssl_certificate: Optional[pulumi.Input[Union['CdnResourceSslCertificateArgs', 'CdnResourceSslCertificateArgsDict']]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CdnResourceArgs.__new__(CdnResourceArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["cname"] = cname
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["options"] = options
            __props__.__dict__["origin_group_id"] = origin_group_id
            __props__.__dict__["origin_group_name"] = origin_group_name
            __props__.__dict__["origin_protocol"] = origin_protocol
            __props__.__dict__["secondary_hostnames"] = secondary_hostnames
            __props__.__dict__["ssl_certificate"] = ssl_certificate
            __props__.__dict__["updated_at"] = updated_at
            __props__.__dict__["created_at"] = None
            __props__.__dict__["provider_cname"] = None
            __props__.__dict__["provider_type"] = None
        super(CdnResource, __self__).__init__(
            'yandex:index/cdnResource:CdnResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            cname: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            options: Optional[pulumi.Input[Union['CdnResourceOptionsArgs', 'CdnResourceOptionsArgsDict']]] = None,
            origin_group_id: Optional[pulumi.Input[_builtins.int]] = None,
            origin_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            origin_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            provider_cname: Optional[pulumi.Input[_builtins.str]] = None,
            provider_type: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ssl_certificate: Optional[pulumi.Input[Union['CdnResourceSslCertificateArgs', 'CdnResourceSslCertificateArgsDict']]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'CdnResource':
        """
        Get an existing CdnResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Flag to create Resource either in active or disabled state. `True` - the content from CDN is available to clients.
        :param pulumi.Input[_builtins.str] cname: CDN endpoint CNAME, must be unique among resources.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['CdnResourceOptionsArgs', 'CdnResourceOptionsArgsDict']] options: CDN Resource settings and options to tune CDN edge behavior.
        :param pulumi.Input[_builtins.int] origin_group_id: The ID of a specific origin group.
        :param pulumi.Input[_builtins.str] origin_group_name: The name of a specific origin group.
        :param pulumi.Input[_builtins.str] origin_protocol: Protocol of origin resource. `http` or `https`.
        :param pulumi.Input[_builtins.str] provider_cname: Provider CNAME of CDN resource, computed value for read and update operations.
        :param pulumi.Input[_builtins.str] provider_type: Type of the CDN provider for this resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_hostnames: List of secondary hostname strings.
        :param pulumi.Input[Union['CdnResourceSslCertificateArgs', 'CdnResourceSslCertificateArgsDict']] ssl_certificate: SSL certificate of CDN resource.
        :param pulumi.Input[_builtins.str] updated_at: Last update timestamp. Computed value for read and update operations.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CdnResourceState.__new__(_CdnResourceState)

        __props__.__dict__["active"] = active
        __props__.__dict__["cname"] = cname
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["options"] = options
        __props__.__dict__["origin_group_id"] = origin_group_id
        __props__.__dict__["origin_group_name"] = origin_group_name
        __props__.__dict__["origin_protocol"] = origin_protocol
        __props__.__dict__["provider_cname"] = provider_cname
        __props__.__dict__["provider_type"] = provider_type
        __props__.__dict__["secondary_hostnames"] = secondary_hostnames
        __props__.__dict__["ssl_certificate"] = ssl_certificate
        __props__.__dict__["updated_at"] = updated_at
        return CdnResource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to create Resource either in active or disabled state. `True` - the content from CDN is available to clients.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter
    def cname(self) -> pulumi.Output[_builtins.str]:
        """
        CDN endpoint CNAME, must be unique among resources.
        """
        return pulumi.get(self, "cname")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.CdnResourceOptions']:
        """
        CDN Resource settings and options to tune CDN edge behavior.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="originGroupId")
    def origin_group_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of a specific origin group.
        """
        return pulumi.get(self, "origin_group_id")

    @_builtins.property
    @pulumi.getter(name="originGroupName")
    def origin_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of a specific origin group.
        """
        return pulumi.get(self, "origin_group_name")

    @_builtins.property
    @pulumi.getter(name="originProtocol")
    def origin_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Protocol of origin resource. `http` or `https`.
        """
        return pulumi.get(self, "origin_protocol")

    @_builtins.property
    @pulumi.getter(name="providerCname")
    def provider_cname(self) -> pulumi.Output[_builtins.str]:
        """
        Provider CNAME of CDN resource, computed value for read and update operations.
        """
        return pulumi.get(self, "provider_cname")

    @_builtins.property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the CDN provider for this resource.
        """
        return pulumi.get(self, "provider_type")

    @_builtins.property
    @pulumi.getter(name="secondaryHostnames")
    def secondary_hostnames(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of secondary hostname strings.
        """
        return pulumi.get(self, "secondary_hostnames")

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> pulumi.Output['outputs.CdnResourceSslCertificate']:
        """
        SSL certificate of CDN resource.
        """
        return pulumi.get(self, "ssl_certificate")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Last update timestamp. Computed value for read and update operations.
        """
        return pulumi.get(self, "updated_at")

