# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeImageArgs', 'ComputeImage']

@pulumi.input_type
class ComputeImageArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_generation: Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 min_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pooled: Optional[pulumi.Input[_builtins.bool]] = None,
                 product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_disk: Optional[pulumi.Input[_builtins.str]] = None,
                 source_family: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 source_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 source_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ComputeImage resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] family: The name of the image family to which this image belongs.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input['ComputeImageHardwareGenerationArgs'] hardware_generation: Hardware generation and its features, which will be applied to the instance when this image is used for creating a boot disk. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.int] min_disk_size: Minimum size in GB of the disk that will be created from this image.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] os_type: Operating system type that is contained in the image. Possible values: `LINUX`, `WINDOWS`.
        :param pulumi.Input[_builtins.bool] pooled: Optimize the image to create a disk.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_ids: License IDs that indicate which licenses are attached to this image.
        :param pulumi.Input[_builtins.str] source_disk: The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_family: The name of the family to use as the source of the new image. The ID of the latest image is taken from the `standard-images` folder. Changing the family forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_image: The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_snapshot: The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_url: The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generation is not None:
            pulumi.set(__self__, "hardware_generation", hardware_generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if min_disk_size is not None:
            pulumi.set(__self__, "min_disk_size", min_disk_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pooled is not None:
            pulumi.set(__self__, "pooled", pooled)
        if product_ids is not None:
            pulumi.set(__self__, "product_ids", product_ids)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)
        if source_family is not None:
            pulumi.set(__self__, "source_family", source_family)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)
        if source_url is not None:
            pulumi.set(__self__, "source_url", source_url)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image family to which this image belongs.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']]:
        """
        Hardware generation and its features, which will be applied to the instance when this image is used for creating a boot disk. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        """
        return pulumi.get(self, "hardware_generation")

    @hardware_generation.setter
    def hardware_generation(self, value: Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']]):
        pulumi.set(self, "hardware_generation", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum size in GB of the disk that will be created from this image.
        """
        return pulumi.get(self, "min_disk_size")

    @min_disk_size.setter
    def min_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_disk_size", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system type that is contained in the image. Possible values: `LINUX`, `WINDOWS`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter
    def pooled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optimize the image to create a disk.
        """
        return pulumi.get(self, "pooled")

    @pooled.setter
    def pooled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pooled", value)

    @_builtins.property
    @pulumi.getter(name="productIds")
    def product_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        License IDs that indicate which licenses are attached to this image.
        """
        return pulumi.get(self, "product_ids")

    @product_ids.setter
    def product_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "product_ids", value)

    @_builtins.property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_disk", value)

    @_builtins.property
    @pulumi.getter(name="sourceFamily")
    def source_family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the family to use as the source of the new image. The ID of the latest image is taken from the `standard-images` folder. Changing the family forces a new resource to be created.
        """
        return pulumi.get(self, "source_family")

    @source_family.setter
    def source_family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_family", value)

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image", value)

    @_builtins.property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        """
        return pulumi.get(self, "source_url")

    @source_url.setter
    def source_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_url", value)


@pulumi.input_type
class _ComputeImageState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_generation: Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 min_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pooled: Optional[pulumi.Input[_builtins.bool]] = None,
                 product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 source_disk: Optional[pulumi.Input[_builtins.str]] = None,
                 source_family: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 source_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 source_url: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeImage resources.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] family: The name of the image family to which this image belongs.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input['ComputeImageHardwareGenerationArgs'] hardware_generation: Hardware generation and its features, which will be applied to the instance when this image is used for creating a boot disk. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.int] min_disk_size: Minimum size in GB of the disk that will be created from this image.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] os_type: Operating system type that is contained in the image. Possible values: `LINUX`, `WINDOWS`.
        :param pulumi.Input[_builtins.bool] pooled: Optimize the image to create a disk.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_ids: License IDs that indicate which licenses are attached to this image.
        :param pulumi.Input[_builtins.int] size: The size of the image, specified in GB.
        :param pulumi.Input[_builtins.str] source_disk: The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_family: The name of the family to use as the source of the new image. The ID of the latest image is taken from the `standard-images` folder. Changing the family forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_image: The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_snapshot: The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_url: The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of the image.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generation is not None:
            pulumi.set(__self__, "hardware_generation", hardware_generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if min_disk_size is not None:
            pulumi.set(__self__, "min_disk_size", min_disk_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pooled is not None:
            pulumi.set(__self__, "pooled", pooled)
        if product_ids is not None:
            pulumi.set(__self__, "product_ids", product_ids)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)
        if source_family is not None:
            pulumi.set(__self__, "source_family", source_family)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)
        if source_url is not None:
            pulumi.set(__self__, "source_url", source_url)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image family to which this image belongs.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']]:
        """
        Hardware generation and its features, which will be applied to the instance when this image is used for creating a boot disk. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        """
        return pulumi.get(self, "hardware_generation")

    @hardware_generation.setter
    def hardware_generation(self, value: Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']]):
        pulumi.set(self, "hardware_generation", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum size in GB of the disk that will be created from this image.
        """
        return pulumi.get(self, "min_disk_size")

    @min_disk_size.setter
    def min_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_disk_size", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system type that is contained in the image. Possible values: `LINUX`, `WINDOWS`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter
    def pooled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optimize the image to create a disk.
        """
        return pulumi.get(self, "pooled")

    @pooled.setter
    def pooled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pooled", value)

    @_builtins.property
    @pulumi.getter(name="productIds")
    def product_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        License IDs that indicate which licenses are attached to this image.
        """
        return pulumi.get(self, "product_ids")

    @product_ids.setter
    def product_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "product_ids", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the image, specified in GB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_disk", value)

    @_builtins.property
    @pulumi.getter(name="sourceFamily")
    def source_family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the family to use as the source of the new image. The ID of the latest image is taken from the `standard-images` folder. Changing the family forces a new resource to be created.
        """
        return pulumi.get(self, "source_family")

    @source_family.setter
    def source_family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_family", value)

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image", value)

    @_builtins.property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        """
        return pulumi.get(self, "source_url")

    @source_url.setter
    def source_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_url", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the image.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("yandex:index/computeImage:ComputeImage")
class ComputeImage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_generation: Optional[pulumi.Input[Union['ComputeImageHardwareGenerationArgs', 'ComputeImageHardwareGenerationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 min_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pooled: Optional[pulumi.Input[_builtins.bool]] = None,
                 product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_disk: Optional[pulumi.Input[_builtins.str]] = None,
                 source_family: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 source_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 source_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a virtual machine image resource for the Yandex Compute Cloud service from an existing tarball. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/image).

        > One of `source_family`, `source_image`, `source_snapshot`, `source_disk` or `source_url` must be specified.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Compute Image.
        #
        foo_image = yandex.ComputeImage("foo-image",
            name="my-custom-image",
            source_url="https://storage.yandexcloud.net/lucky-images/kube-it.img")
        # You can use "data.yandex_compute_image.my_image.id" identifier 
        # as reference to existing resource.
        vm = yandex.ComputeInstance("vm",
            name="vm-from-custom-image",
            boot_disk={
                "initialize_params": {
                    "image_id": foo_image.id,
                },
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/computeImage:ComputeImage <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/computeImage:ComputeImage my_image fd8go**********trjsd
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] family: The name of the image family to which this image belongs.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Union['ComputeImageHardwareGenerationArgs', 'ComputeImageHardwareGenerationArgsDict']] hardware_generation: Hardware generation and its features, which will be applied to the instance when this image is used for creating a boot disk. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.int] min_disk_size: Minimum size in GB of the disk that will be created from this image.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] os_type: Operating system type that is contained in the image. Possible values: `LINUX`, `WINDOWS`.
        :param pulumi.Input[_builtins.bool] pooled: Optimize the image to create a disk.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_ids: License IDs that indicate which licenses are attached to this image.
        :param pulumi.Input[_builtins.str] source_disk: The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_family: The name of the family to use as the source of the new image. The ID of the latest image is taken from the `standard-images` folder. Changing the family forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_image: The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_snapshot: The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_url: The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ComputeImageArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a virtual machine image resource for the Yandex Compute Cloud service from an existing tarball. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/image).

        > One of `source_family`, `source_image`, `source_snapshot`, `source_disk` or `source_url` must be specified.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Compute Image.
        #
        foo_image = yandex.ComputeImage("foo-image",
            name="my-custom-image",
            source_url="https://storage.yandexcloud.net/lucky-images/kube-it.img")
        # You can use "data.yandex_compute_image.my_image.id" identifier 
        # as reference to existing resource.
        vm = yandex.ComputeInstance("vm",
            name="vm-from-custom-image",
            boot_disk={
                "initialize_params": {
                    "image_id": foo_image.id,
                },
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/computeImage:ComputeImage <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/computeImage:ComputeImage my_image fd8go**********trjsd
        ```

        :param str resource_name: The name of the resource.
        :param ComputeImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_generation: Optional[pulumi.Input[Union['ComputeImageHardwareGenerationArgs', 'ComputeImageHardwareGenerationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 min_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pooled: Optional[pulumi.Input[_builtins.bool]] = None,
                 product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_disk: Optional[pulumi.Input[_builtins.str]] = None,
                 source_family: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 source_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 source_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeImageArgs.__new__(ComputeImageArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["family"] = family
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["hardware_generation"] = hardware_generation
            __props__.__dict__["labels"] = labels
            __props__.__dict__["min_disk_size"] = min_disk_size
            __props__.__dict__["name"] = name
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["pooled"] = pooled
            __props__.__dict__["product_ids"] = product_ids
            __props__.__dict__["source_disk"] = source_disk
            __props__.__dict__["source_family"] = source_family
            __props__.__dict__["source_image"] = source_image
            __props__.__dict__["source_snapshot"] = source_snapshot
            __props__.__dict__["source_url"] = source_url
            __props__.__dict__["created_at"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
        super(ComputeImage, __self__).__init__(
            'yandex:index/computeImage:ComputeImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            family: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            hardware_generation: Optional[pulumi.Input[Union['ComputeImageHardwareGenerationArgs', 'ComputeImageHardwareGenerationArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            min_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            os_type: Optional[pulumi.Input[_builtins.str]] = None,
            pooled: Optional[pulumi.Input[_builtins.bool]] = None,
            product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            source_disk: Optional[pulumi.Input[_builtins.str]] = None,
            source_family: Optional[pulumi.Input[_builtins.str]] = None,
            source_image: Optional[pulumi.Input[_builtins.str]] = None,
            source_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
            source_url: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComputeImage':
        """
        Get an existing ComputeImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] family: The name of the image family to which this image belongs.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Union['ComputeImageHardwareGenerationArgs', 'ComputeImageHardwareGenerationArgsDict']] hardware_generation: Hardware generation and its features, which will be applied to the instance when this image is used for creating a boot disk. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.int] min_disk_size: Minimum size in GB of the disk that will be created from this image.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] os_type: Operating system type that is contained in the image. Possible values: `LINUX`, `WINDOWS`.
        :param pulumi.Input[_builtins.bool] pooled: Optimize the image to create a disk.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_ids: License IDs that indicate which licenses are attached to this image.
        :param pulumi.Input[_builtins.int] size: The size of the image, specified in GB.
        :param pulumi.Input[_builtins.str] source_disk: The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_family: The name of the family to use as the source of the new image. The ID of the latest image is taken from the `standard-images` folder. Changing the family forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_image: The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_snapshot: The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_url: The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of the image.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeImageState.__new__(_ComputeImageState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["family"] = family
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["hardware_generation"] = hardware_generation
        __props__.__dict__["labels"] = labels
        __props__.__dict__["min_disk_size"] = min_disk_size
        __props__.__dict__["name"] = name
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["pooled"] = pooled
        __props__.__dict__["product_ids"] = product_ids
        __props__.__dict__["size"] = size
        __props__.__dict__["source_disk"] = source_disk
        __props__.__dict__["source_family"] = source_family
        __props__.__dict__["source_image"] = source_image
        __props__.__dict__["source_snapshot"] = source_snapshot
        __props__.__dict__["source_url"] = source_url
        __props__.__dict__["status"] = status
        return ComputeImage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def family(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the image family to which this image belongs.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> pulumi.Output['outputs.ComputeImageHardwareGeneration']:
        """
        Hardware generation and its features, which will be applied to the instance when this image is used for creating a boot disk. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        """
        return pulumi.get(self, "hardware_generation")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum size in GB of the disk that will be created from this image.
        """
        return pulumi.get(self, "min_disk_size")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[_builtins.str]:
        """
        Operating system type that is contained in the image. Possible values: `LINUX`, `WINDOWS`.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter
    def pooled(self) -> pulumi.Output[_builtins.bool]:
        """
        Optimize the image to create a disk.
        """
        return pulumi.get(self, "pooled")

    @_builtins.property
    @pulumi.getter(name="productIds")
    def product_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        License IDs that indicate which licenses are attached to this image.
        """
        return pulumi.get(self, "product_ids")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the image, specified in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_disk")

    @_builtins.property
    @pulumi.getter(name="sourceFamily")
    def source_family(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the family to use as the source of the new image. The ID of the latest image is taken from the `standard-images` folder. Changing the family forces a new resource to be created.
        """
        return pulumi.get(self, "source_family")

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_image")

    @_builtins.property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_snapshot")

    @_builtins.property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        """
        return pulumi.get(self, "source_url")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the image.
        """
        return pulumi.get(self, "status")

