# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

import types

__config__ = pulumi.Config('yandex')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def cloud_id(self) -> Optional[str]:
        """
        The ID of the [Cloud](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#cloud) to apply any resources to.
        This can also be specified using environment variable `YC_CLOUD_ID`.
        """
        return __config__.get('cloudId')

    @_builtins.property
    def endpoint(self) -> Optional[str]:
        """
        The endpoint for API calls, default value is **api.cloud.yandex.net:443**.
        This can also be defined by environment variable `YC_ENDPOINT`.
        """
        return __config__.get('endpoint')

    @_builtins.property
    def folder_id(self) -> Optional[str]:
        """
        The ID of the [Folder](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#folder) to operate under, if not specified by a given resource.
        This can also be specified using environment variable `YC_FOLDER_ID`.
        """
        return __config__.get('folderId')

    @_builtins.property
    def insecure(self) -> Optional[bool]:
        """
        Explicitly allow the provider to perform "insecure" SSL requests. If omitted, default value is `false`.
        """
        return __config__.get_bool('insecure')

    @_builtins.property
    def max_retries(self) -> Optional[int]:
        """
        This is the maximum number of times an API call is retried, in the case where requests are being throttled or experiencing transient failures. The delay between the subsequent API calls increases exponentially.
        """
        return __config__.get_int('maxRetries')

    @_builtins.property
    def organization_id(self) -> Optional[str]:
        """
        The ID of the [Cloud Organization](https://yandex.cloud/docs/organization/quickstart) to operate under.
        """
        return __config__.get('organizationId')

    @_builtins.property
    def plaintext(self) -> Optional[bool]:
        """
        Disable use of TLS. Default value is `false`.
        """
        return __config__.get_bool('plaintext')

    @_builtins.property
    def profile(self) -> Optional[str]:
        """
        Profile name to use in the shared credentials file. Default value is `default`.
        """
        return __config__.get('profile')

    @_builtins.property
    def region_id(self) -> Optional[str]:
        """
        [The region](https://yandex.cloud/docs/overview/concepts/region) where operations will take place. For example `ru-central1`.
        """
        return __config__.get('regionId')

    @_builtins.property
    def service_account_key_file(self) -> Optional[str]:
        """
        Contains either a path to or the contents of the [Service Account file](https://yandex.cloud/docs/iam/concepts/authorization/key) in JSON format.
        This can also be specified using environment variable `YC_SERVICE_ACCOUNT_KEY_FILE`. You can read how to create service account key file [here](https://yandex.cloud/docs/iam/operations/iam-token/create-for-sa#keys-create).

        > Only one of `token` or `service_account_key_file` must be specified.

        > One can authenticate via instance service account from inside a compute instance. In order to use this method, omit both `token`/`service_account_key_file` and attach service account to the instance. [Working with Yandex Cloud from inside an instance](https://yandex.cloud/docs/compute/operations/vm-connect/auth-inside-vm).
        """
        return __config__.get('serviceAccountKeyFile')

    @_builtins.property
    def shared_credentials_file(self) -> Optional[str]:
        """
        Shared credentials file path.
        Supported keys: `storage_access_key` and `storage_secret_key`.

        > The `storage_access_key` and `storage_secret_key` attributes from the shared credentials file are used only when the provider and a storage data/resource do not have an access/secret keys explicitly specified.
        """
        return __config__.get('sharedCredentialsFile')

    @_builtins.property
    def storage_access_key(self) -> Optional[str]:
        """
        Yandex Cloud Object Storage access key, which is used when a storage data/resource doesn't have an access key explicitly specified. 
        This can also be specified using environment variable `YC_STORAGE_ACCESS_KEY`.
        """
        return __config__.get('storageAccessKey')

    @_builtins.property
    def storage_endpoint(self) -> Optional[str]:
        """
        Yandex Cloud [Object Storage Endpoint](https://yandex.cloud/docs/storage/s3/#request-url), which is used to connect to `S3 API`. Default value is **storage.yandexcloud.net**.
        """
        return __config__.get('storageEndpoint')

    @_builtins.property
    def storage_secret_key(self) -> Optional[str]:
        """
        Yandex Cloud Object Storage secret key, which is used when a storage data/resource doesn't have a secret key explicitly specified.
        This can also be specified using environment variable `YC_STORAGE_SECRET_KEY`.
        """
        return __config__.get('storageSecretKey')

    @_builtins.property
    def token(self) -> Optional[str]:
        """
        Security token or IAM token used for authentication in Yandex Cloud.
        Check [documentation](https://yandex.cloud/docs/iam/operations/iam-token/create) about how to create IAM token. This can also be specified using environment variable `YC_TOKEN`.
        """
        return __config__.get('token')

    @_builtins.property
    def ymq_access_key(self) -> Optional[str]:
        """
        Yandex Cloud Message Queue service access key, which is used when a YMQ queue resource doesn't have an access key explicitly specified.
          This can also be specified using environment variable `YC_MESSAGE_QUEUE_ACCESS_KEY`.
        """
        return __config__.get('ymqAccessKey')

    @_builtins.property
    def ymq_endpoint(self) -> Optional[str]:
        """
        Yandex Cloud Message Queue service endpoint. Default value is **message-queue.api.cloud.yandex.net**.
        """
        return __config__.get('ymqEndpoint')

    @_builtins.property
    def ymq_secret_key(self) -> Optional[str]:
        """
        Yandex Cloud Message Queue service secret key, which is used when a YMQ queue resource doesn't have a secret key explicitly specified.
        This can also be specified using environment variable `YC_MESSAGE_QUEUE_SECRET_KEY`.
        """
        return __config__.get('ymqSecretKey')

    @_builtins.property
    def yq_endpoint(self) -> Optional[str]:
        """
        The Yandex Query API endpoint, default value is **grpc.yandex-query.cloud.yandex.net:2135**.
        This can also be defined by environment variable `YC_YQ_ENDPOINT`.
        """
        return __config__.get('yqEndpoint')

    @_builtins.property
    def zone(self) -> Optional[str]:
        """
        The default [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) to operate under, if not specified by a given resource.
        This can also be specified using environment variable `YC_ZONE`.
        """
        return __config__.get('zone')

