# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionTriggerArgs', 'FunctionTrigger']

@pulumi.input_type
class FunctionTriggerArgs:
    def __init__(__self__, *,
                 container: Optional[pulumi.Input['FunctionTriggerContainerArgs']] = None,
                 container_registry: Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']] = None,
                 data_streams: Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dlq: Optional[pulumi.Input['FunctionTriggerDlqArgs']] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 function: Optional[pulumi.Input['FunctionTriggerFunctionArgs']] = None,
                 iot: Optional[pulumi.Input['FunctionTriggerIotArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_group: Optional[pulumi.Input['FunctionTriggerLogGroupArgs']] = None,
                 logging: Optional[pulumi.Input['FunctionTriggerLoggingArgs']] = None,
                 mail: Optional[pulumi.Input['FunctionTriggerMailArgs']] = None,
                 message_queue: Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage: Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']] = None,
                 timer: Optional[pulumi.Input['FunctionTriggerTimerArgs']] = None):
        """
        The set of arguments for constructing a FunctionTrigger resource.
        :param pulumi.Input['FunctionTriggerContainerArgs'] container: [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input['FunctionTriggerContainerRegistryArgs'] container_registry: [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input['FunctionTriggerDataStreamsArgs'] data_streams: [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input['FunctionTriggerDlqArgs'] dlq: Dead Letter Queue (DLQ) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input['FunctionTriggerFunctionArgs'] function: [Yandex Cloud Function](https://yandex.cloud/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input['FunctionTriggerIotArgs'] iot: [IoT](https://yandex.cloud/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['FunctionTriggerLoggingArgs'] logging: [Logging](https://yandex.cloud/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input['FunctionTriggerMailArgs'] mail: [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input['FunctionTriggerMessageQueueArgs'] message_queue: [Message Queue](https://yandex.cloud/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['FunctionTriggerObjectStorageArgs'] object_storage: [Object Storage](https://yandex.cloud/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input['FunctionTriggerTimerArgs'] timer: [Timer](https://yandex.cloud/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if container_registry is not None:
            pulumi.set(__self__, "container_registry", container_registry)
        if data_streams is not None:
            pulumi.set(__self__, "data_streams", data_streams)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dlq is not None:
            pulumi.set(__self__, "dlq", dlq)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if iot is not None:
            pulumi.set(__self__, "iot", iot)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if mail is not None:
            pulumi.set(__self__, "mail", mail)
        if message_queue is not None:
            pulumi.set(__self__, "message_queue", message_queue)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_storage is not None:
            pulumi.set(__self__, "object_storage", object_storage)
        if timer is not None:
            pulumi.set(__self__, "timer", timer)

    @_builtins.property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['FunctionTriggerContainerArgs']]:
        """
        [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['FunctionTriggerContainerArgs']]):
        pulumi.set(self, "container", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistry")
    def container_registry(self) -> Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']]:
        """
        [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "container_registry")

    @container_registry.setter
    def container_registry(self, value: Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']]):
        pulumi.set(self, "container_registry", value)

    @_builtins.property
    @pulumi.getter(name="dataStreams")
    def data_streams(self) -> Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']]:
        """
        [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "data_streams")

    @data_streams.setter
    def data_streams(self, value: Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']]):
        pulumi.set(self, "data_streams", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def dlq(self) -> Optional[pulumi.Input['FunctionTriggerDlqArgs']]:
        """
        Dead Letter Queue (DLQ) settings definition for Yandex Cloud Functions Trigger.
        """
        return pulumi.get(self, "dlq")

    @dlq.setter
    def dlq(self, value: Optional[pulumi.Input['FunctionTriggerDlqArgs']]):
        pulumi.set(self, "dlq", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input['FunctionTriggerFunctionArgs']]:
        """
        [Yandex Cloud Function](https://yandex.cloud/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input['FunctionTriggerFunctionArgs']]):
        pulumi.set(self, "function", value)

    @_builtins.property
    @pulumi.getter
    def iot(self) -> Optional[pulumi.Input['FunctionTriggerIotArgs']]:
        """
        [IoT](https://yandex.cloud/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue`.
        """
        return pulumi.get(self, "iot")

    @iot.setter
    def iot(self, value: Optional[pulumi.Input['FunctionTriggerIotArgs']]):
        pulumi.set(self, "iot", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[pulumi.Input['FunctionTriggerLogGroupArgs']]:
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional[pulumi.Input['FunctionTriggerLogGroupArgs']]):
        pulumi.set(self, "log_group", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['FunctionTriggerLoggingArgs']]:
        """
        [Logging](https://yandex.cloud/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['FunctionTriggerLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter
    def mail(self) -> Optional[pulumi.Input['FunctionTriggerMailArgs']]:
        """
        [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "mail")

    @mail.setter
    def mail(self, value: Optional[pulumi.Input['FunctionTriggerMailArgs']]):
        pulumi.set(self, "mail", value)

    @_builtins.property
    @pulumi.getter(name="messageQueue")
    def message_queue(self) -> Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']]:
        """
        [Message Queue](https://yandex.cloud/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "message_queue")

    @message_queue.setter
    def message_queue(self, value: Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']]):
        pulumi.set(self, "message_queue", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectStorage")
    def object_storage(self) -> Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']]:
        """
        [Object Storage](https://yandex.cloud/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "object_storage")

    @object_storage.setter
    def object_storage(self, value: Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']]):
        pulumi.set(self, "object_storage", value)

    @_builtins.property
    @pulumi.getter
    def timer(self) -> Optional[pulumi.Input['FunctionTriggerTimerArgs']]:
        """
        [Timer](https://yandex.cloud/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "timer")

    @timer.setter
    def timer(self, value: Optional[pulumi.Input['FunctionTriggerTimerArgs']]):
        pulumi.set(self, "timer", value)


@pulumi.input_type
class _FunctionTriggerState:
    def __init__(__self__, *,
                 container: Optional[pulumi.Input['FunctionTriggerContainerArgs']] = None,
                 container_registry: Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 data_streams: Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dlq: Optional[pulumi.Input['FunctionTriggerDlqArgs']] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 function: Optional[pulumi.Input['FunctionTriggerFunctionArgs']] = None,
                 iot: Optional[pulumi.Input['FunctionTriggerIotArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_group: Optional[pulumi.Input['FunctionTriggerLogGroupArgs']] = None,
                 logging: Optional[pulumi.Input['FunctionTriggerLoggingArgs']] = None,
                 mail: Optional[pulumi.Input['FunctionTriggerMailArgs']] = None,
                 message_queue: Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage: Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']] = None,
                 timer: Optional[pulumi.Input['FunctionTriggerTimerArgs']] = None):
        """
        Input properties used for looking up and filtering FunctionTrigger resources.
        :param pulumi.Input['FunctionTriggerContainerArgs'] container: [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input['FunctionTriggerContainerRegistryArgs'] container_registry: [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input['FunctionTriggerDataStreamsArgs'] data_streams: [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input['FunctionTriggerDlqArgs'] dlq: Dead Letter Queue (DLQ) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input['FunctionTriggerFunctionArgs'] function: [Yandex Cloud Function](https://yandex.cloud/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input['FunctionTriggerIotArgs'] iot: [IoT](https://yandex.cloud/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['FunctionTriggerLoggingArgs'] logging: [Logging](https://yandex.cloud/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input['FunctionTriggerMailArgs'] mail: [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input['FunctionTriggerMessageQueueArgs'] message_queue: [Message Queue](https://yandex.cloud/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['FunctionTriggerObjectStorageArgs'] object_storage: [Object Storage](https://yandex.cloud/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input['FunctionTriggerTimerArgs'] timer: [Timer](https://yandex.cloud/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if container_registry is not None:
            pulumi.set(__self__, "container_registry", container_registry)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if data_streams is not None:
            pulumi.set(__self__, "data_streams", data_streams)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dlq is not None:
            pulumi.set(__self__, "dlq", dlq)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if iot is not None:
            pulumi.set(__self__, "iot", iot)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if mail is not None:
            pulumi.set(__self__, "mail", mail)
        if message_queue is not None:
            pulumi.set(__self__, "message_queue", message_queue)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_storage is not None:
            pulumi.set(__self__, "object_storage", object_storage)
        if timer is not None:
            pulumi.set(__self__, "timer", timer)

    @_builtins.property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['FunctionTriggerContainerArgs']]:
        """
        [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['FunctionTriggerContainerArgs']]):
        pulumi.set(self, "container", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistry")
    def container_registry(self) -> Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']]:
        """
        [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "container_registry")

    @container_registry.setter
    def container_registry(self, value: Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']]):
        pulumi.set(self, "container_registry", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="dataStreams")
    def data_streams(self) -> Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']]:
        """
        [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "data_streams")

    @data_streams.setter
    def data_streams(self, value: Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']]):
        pulumi.set(self, "data_streams", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def dlq(self) -> Optional[pulumi.Input['FunctionTriggerDlqArgs']]:
        """
        Dead Letter Queue (DLQ) settings definition for Yandex Cloud Functions Trigger.
        """
        return pulumi.get(self, "dlq")

    @dlq.setter
    def dlq(self, value: Optional[pulumi.Input['FunctionTriggerDlqArgs']]):
        pulumi.set(self, "dlq", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input['FunctionTriggerFunctionArgs']]:
        """
        [Yandex Cloud Function](https://yandex.cloud/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input['FunctionTriggerFunctionArgs']]):
        pulumi.set(self, "function", value)

    @_builtins.property
    @pulumi.getter
    def iot(self) -> Optional[pulumi.Input['FunctionTriggerIotArgs']]:
        """
        [IoT](https://yandex.cloud/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue`.
        """
        return pulumi.get(self, "iot")

    @iot.setter
    def iot(self, value: Optional[pulumi.Input['FunctionTriggerIotArgs']]):
        pulumi.set(self, "iot", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[pulumi.Input['FunctionTriggerLogGroupArgs']]:
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional[pulumi.Input['FunctionTriggerLogGroupArgs']]):
        pulumi.set(self, "log_group", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['FunctionTriggerLoggingArgs']]:
        """
        [Logging](https://yandex.cloud/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['FunctionTriggerLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter
    def mail(self) -> Optional[pulumi.Input['FunctionTriggerMailArgs']]:
        """
        [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "mail")

    @mail.setter
    def mail(self, value: Optional[pulumi.Input['FunctionTriggerMailArgs']]):
        pulumi.set(self, "mail", value)

    @_builtins.property
    @pulumi.getter(name="messageQueue")
    def message_queue(self) -> Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']]:
        """
        [Message Queue](https://yandex.cloud/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "message_queue")

    @message_queue.setter
    def message_queue(self, value: Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']]):
        pulumi.set(self, "message_queue", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectStorage")
    def object_storage(self) -> Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']]:
        """
        [Object Storage](https://yandex.cloud/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "object_storage")

    @object_storage.setter
    def object_storage(self, value: Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']]):
        pulumi.set(self, "object_storage", value)

    @_builtins.property
    @pulumi.getter
    def timer(self) -> Optional[pulumi.Input['FunctionTriggerTimerArgs']]:
        """
        [Timer](https://yandex.cloud/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "timer")

    @timer.setter
    def timer(self, value: Optional[pulumi.Input['FunctionTriggerTimerArgs']]):
        pulumi.set(self, "timer", value)


@pulumi.type_token("yandex:index/functionTrigger:FunctionTrigger")
class FunctionTrigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container: Optional[pulumi.Input[Union['FunctionTriggerContainerArgs', 'FunctionTriggerContainerArgsDict']]] = None,
                 container_registry: Optional[pulumi.Input[Union['FunctionTriggerContainerRegistryArgs', 'FunctionTriggerContainerRegistryArgsDict']]] = None,
                 data_streams: Optional[pulumi.Input[Union['FunctionTriggerDataStreamsArgs', 'FunctionTriggerDataStreamsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dlq: Optional[pulumi.Input[Union['FunctionTriggerDlqArgs', 'FunctionTriggerDlqArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 function: Optional[pulumi.Input[Union['FunctionTriggerFunctionArgs', 'FunctionTriggerFunctionArgsDict']]] = None,
                 iot: Optional[pulumi.Input[Union['FunctionTriggerIotArgs', 'FunctionTriggerIotArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_group: Optional[pulumi.Input[Union['FunctionTriggerLogGroupArgs', 'FunctionTriggerLogGroupArgsDict']]] = None,
                 logging: Optional[pulumi.Input[Union['FunctionTriggerLoggingArgs', 'FunctionTriggerLoggingArgsDict']]] = None,
                 mail: Optional[pulumi.Input[Union['FunctionTriggerMailArgs', 'FunctionTriggerMailArgsDict']]] = None,
                 message_queue: Optional[pulumi.Input[Union['FunctionTriggerMessageQueueArgs', 'FunctionTriggerMessageQueueArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage: Optional[pulumi.Input[Union['FunctionTriggerObjectStorageArgs', 'FunctionTriggerObjectStorageArgsDict']]] = None,
                 timer: Optional[pulumi.Input[Union['FunctionTriggerTimerArgs', 'FunctionTriggerTimerArgsDict']]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Functions Trigger](https://yandex.cloud/docs/functions/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Cloud Function Trigger.
        #
        my_trigger = yandex.FunctionTrigger("my_trigger",
            name="some_name",
            description="any description",
            timer={
                "cron_expression": "* * * * ? *",
            },
            function={
                "id": "tf-test",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/functionTrigger:FunctionTrigger <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/functionTrigger:FunctionTrigger my_trigger a1scn**********3ur32
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FunctionTriggerContainerArgs', 'FunctionTriggerContainerArgsDict']] container: [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input[Union['FunctionTriggerContainerRegistryArgs', 'FunctionTriggerContainerRegistryArgsDict']] container_registry: [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[Union['FunctionTriggerDataStreamsArgs', 'FunctionTriggerDataStreamsArgsDict']] data_streams: [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Union['FunctionTriggerDlqArgs', 'FunctionTriggerDlqArgsDict']] dlq: Dead Letter Queue (DLQ) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Union['FunctionTriggerFunctionArgs', 'FunctionTriggerFunctionArgsDict']] function: [Yandex Cloud Function](https://yandex.cloud/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input[Union['FunctionTriggerIotArgs', 'FunctionTriggerIotArgsDict']] iot: [IoT](https://yandex.cloud/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['FunctionTriggerLoggingArgs', 'FunctionTriggerLoggingArgsDict']] logging: [Logging](https://yandex.cloud/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[Union['FunctionTriggerMailArgs', 'FunctionTriggerMailArgsDict']] mail: [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[Union['FunctionTriggerMessageQueueArgs', 'FunctionTriggerMessageQueueArgsDict']] message_queue: [Message Queue](https://yandex.cloud/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Union['FunctionTriggerObjectStorageArgs', 'FunctionTriggerObjectStorageArgsDict']] object_storage: [Object Storage](https://yandex.cloud/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[Union['FunctionTriggerTimerArgs', 'FunctionTriggerTimerArgsDict']] timer: [Timer](https://yandex.cloud/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FunctionTriggerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Functions Trigger](https://yandex.cloud/docs/functions/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Cloud Function Trigger.
        #
        my_trigger = yandex.FunctionTrigger("my_trigger",
            name="some_name",
            description="any description",
            timer={
                "cron_expression": "* * * * ? *",
            },
            function={
                "id": "tf-test",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/functionTrigger:FunctionTrigger <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/functionTrigger:FunctionTrigger my_trigger a1scn**********3ur32
        ```

        :param str resource_name: The name of the resource.
        :param FunctionTriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionTriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container: Optional[pulumi.Input[Union['FunctionTriggerContainerArgs', 'FunctionTriggerContainerArgsDict']]] = None,
                 container_registry: Optional[pulumi.Input[Union['FunctionTriggerContainerRegistryArgs', 'FunctionTriggerContainerRegistryArgsDict']]] = None,
                 data_streams: Optional[pulumi.Input[Union['FunctionTriggerDataStreamsArgs', 'FunctionTriggerDataStreamsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dlq: Optional[pulumi.Input[Union['FunctionTriggerDlqArgs', 'FunctionTriggerDlqArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 function: Optional[pulumi.Input[Union['FunctionTriggerFunctionArgs', 'FunctionTriggerFunctionArgsDict']]] = None,
                 iot: Optional[pulumi.Input[Union['FunctionTriggerIotArgs', 'FunctionTriggerIotArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_group: Optional[pulumi.Input[Union['FunctionTriggerLogGroupArgs', 'FunctionTriggerLogGroupArgsDict']]] = None,
                 logging: Optional[pulumi.Input[Union['FunctionTriggerLoggingArgs', 'FunctionTriggerLoggingArgsDict']]] = None,
                 mail: Optional[pulumi.Input[Union['FunctionTriggerMailArgs', 'FunctionTriggerMailArgsDict']]] = None,
                 message_queue: Optional[pulumi.Input[Union['FunctionTriggerMessageQueueArgs', 'FunctionTriggerMessageQueueArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage: Optional[pulumi.Input[Union['FunctionTriggerObjectStorageArgs', 'FunctionTriggerObjectStorageArgsDict']]] = None,
                 timer: Optional[pulumi.Input[Union['FunctionTriggerTimerArgs', 'FunctionTriggerTimerArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionTriggerArgs.__new__(FunctionTriggerArgs)

            __props__.__dict__["container"] = container
            __props__.__dict__["container_registry"] = container_registry
            __props__.__dict__["data_streams"] = data_streams
            __props__.__dict__["description"] = description
            __props__.__dict__["dlq"] = dlq
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["function"] = function
            __props__.__dict__["iot"] = iot
            __props__.__dict__["labels"] = labels
            __props__.__dict__["log_group"] = log_group
            __props__.__dict__["logging"] = logging
            __props__.__dict__["mail"] = mail
            __props__.__dict__["message_queue"] = message_queue
            __props__.__dict__["name"] = name
            __props__.__dict__["object_storage"] = object_storage
            __props__.__dict__["timer"] = timer
            __props__.__dict__["created_at"] = None
        super(FunctionTrigger, __self__).__init__(
            'yandex:index/functionTrigger:FunctionTrigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container: Optional[pulumi.Input[Union['FunctionTriggerContainerArgs', 'FunctionTriggerContainerArgsDict']]] = None,
            container_registry: Optional[pulumi.Input[Union['FunctionTriggerContainerRegistryArgs', 'FunctionTriggerContainerRegistryArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            data_streams: Optional[pulumi.Input[Union['FunctionTriggerDataStreamsArgs', 'FunctionTriggerDataStreamsArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dlq: Optional[pulumi.Input[Union['FunctionTriggerDlqArgs', 'FunctionTriggerDlqArgsDict']]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            function: Optional[pulumi.Input[Union['FunctionTriggerFunctionArgs', 'FunctionTriggerFunctionArgsDict']]] = None,
            iot: Optional[pulumi.Input[Union['FunctionTriggerIotArgs', 'FunctionTriggerIotArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            log_group: Optional[pulumi.Input[Union['FunctionTriggerLogGroupArgs', 'FunctionTriggerLogGroupArgsDict']]] = None,
            logging: Optional[pulumi.Input[Union['FunctionTriggerLoggingArgs', 'FunctionTriggerLoggingArgsDict']]] = None,
            mail: Optional[pulumi.Input[Union['FunctionTriggerMailArgs', 'FunctionTriggerMailArgsDict']]] = None,
            message_queue: Optional[pulumi.Input[Union['FunctionTriggerMessageQueueArgs', 'FunctionTriggerMessageQueueArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            object_storage: Optional[pulumi.Input[Union['FunctionTriggerObjectStorageArgs', 'FunctionTriggerObjectStorageArgsDict']]] = None,
            timer: Optional[pulumi.Input[Union['FunctionTriggerTimerArgs', 'FunctionTriggerTimerArgsDict']]] = None) -> 'FunctionTrigger':
        """
        Get an existing FunctionTrigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FunctionTriggerContainerArgs', 'FunctionTriggerContainerArgsDict']] container: [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input[Union['FunctionTriggerContainerRegistryArgs', 'FunctionTriggerContainerRegistryArgsDict']] container_registry: [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Union['FunctionTriggerDataStreamsArgs', 'FunctionTriggerDataStreamsArgsDict']] data_streams: [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Union['FunctionTriggerDlqArgs', 'FunctionTriggerDlqArgsDict']] dlq: Dead Letter Queue (DLQ) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Union['FunctionTriggerFunctionArgs', 'FunctionTriggerFunctionArgsDict']] function: [Yandex Cloud Function](https://yandex.cloud/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger.
        :param pulumi.Input[Union['FunctionTriggerIotArgs', 'FunctionTriggerIotArgsDict']] iot: [IoT](https://yandex.cloud/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['FunctionTriggerLoggingArgs', 'FunctionTriggerLoggingArgsDict']] logging: [Logging](https://yandex.cloud/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[Union['FunctionTriggerMailArgs', 'FunctionTriggerMailArgsDict']] mail: [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[Union['FunctionTriggerMessageQueueArgs', 'FunctionTriggerMessageQueueArgsDict']] message_queue: [Message Queue](https://yandex.cloud/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Union['FunctionTriggerObjectStorageArgs', 'FunctionTriggerObjectStorageArgsDict']] object_storage: [Object Storage](https://yandex.cloud/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        :param pulumi.Input[Union['FunctionTriggerTimerArgs', 'FunctionTriggerTimerArgsDict']] timer: [Timer](https://yandex.cloud/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionTriggerState.__new__(_FunctionTriggerState)

        __props__.__dict__["container"] = container
        __props__.__dict__["container_registry"] = container_registry
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["data_streams"] = data_streams
        __props__.__dict__["description"] = description
        __props__.__dict__["dlq"] = dlq
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["function"] = function
        __props__.__dict__["iot"] = iot
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_group"] = log_group
        __props__.__dict__["logging"] = logging
        __props__.__dict__["mail"] = mail
        __props__.__dict__["message_queue"] = message_queue
        __props__.__dict__["name"] = name
        __props__.__dict__["object_storage"] = object_storage
        __props__.__dict__["timer"] = timer
        return FunctionTrigger(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def container(self) -> pulumi.Output[Optional['outputs.FunctionTriggerContainer']]:
        """
        [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger.
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter(name="containerRegistry")
    def container_registry(self) -> pulumi.Output[Optional['outputs.FunctionTriggerContainerRegistry']]:
        """
        [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "container_registry")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dataStreams")
    def data_streams(self) -> pulumi.Output[Optional['outputs.FunctionTriggerDataStreams']]:
        """
        [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "data_streams")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def dlq(self) -> pulumi.Output[Optional['outputs.FunctionTriggerDlq']]:
        """
        Dead Letter Queue (DLQ) settings definition for Yandex Cloud Functions Trigger.
        """
        return pulumi.get(self, "dlq")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def function(self) -> pulumi.Output[Optional['outputs.FunctionTriggerFunction']]:
        """
        [Yandex Cloud Function](https://yandex.cloud/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger.
        """
        return pulumi.get(self, "function")

    @_builtins.property
    @pulumi.getter
    def iot(self) -> pulumi.Output[Optional['outputs.FunctionTriggerIot']]:
        """
        [IoT](https://yandex.cloud/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue`.
        """
        return pulumi.get(self, "iot")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> pulumi.Output[Optional['outputs.FunctionTriggerLogGroup']]:
        return pulumi.get(self, "log_group")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.FunctionTriggerLogging']]:
        """
        [Logging](https://yandex.cloud/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter
    def mail(self) -> pulumi.Output[Optional['outputs.FunctionTriggerMail']]:
        """
        [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "mail")

    @_builtins.property
    @pulumi.getter(name="messageQueue")
    def message_queue(self) -> pulumi.Output[Optional['outputs.FunctionTriggerMessageQueue']]:
        """
        [Message Queue](https://yandex.cloud/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "message_queue")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectStorage")
    def object_storage(self) -> pulumi.Output[Optional['outputs.FunctionTriggerObjectStorage']]:
        """
        [Object Storage](https://yandex.cloud/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "object_storage")

    @_builtins.property
    @pulumi.getter
    def timer(self) -> pulumi.Output[Optional['outputs.FunctionTriggerTimer']]:
        """
        [Timer](https://yandex.cloud/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present.
        """
        return pulumi.get(self, "timer")

