# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAlbTargetGroupResult',
    'AwaitableGetAlbTargetGroupResult',
    'get_alb_target_group',
    'get_alb_target_group_output',
]

@pulumi.output_type
class GetAlbTargetGroupResult:
    """
    A collection of values returned by getAlbTargetGroup.
    """
    def __init__(__self__, created_at=None, description=None, folder_id=None, id=None, labels=None, name=None, target_group_id=None, targets=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if target_group_id and not isinstance(target_group_id, str):
            raise TypeError("Expected argument 'target_group_id' to be a str")
        pulumi.set(__self__, "target_group_id", target_group_id)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="targetGroupId")
    def target_group_id(self) -> _builtins.str:
        """
        Target Group ID.
        """
        return pulumi.get(self, "target_group_id")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetAlbTargetGroupTargetResult']:
        return pulumi.get(self, "targets")


class AwaitableGetAlbTargetGroupResult(GetAlbTargetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlbTargetGroupResult(
            created_at=self.created_at,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            target_group_id=self.target_group_id,
            targets=self.targets)


def get_alb_target_group(description: Optional[_builtins.str] = None,
                         folder_id: Optional[_builtins.str] = None,
                         name: Optional[_builtins.str] = None,
                         target_group_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlbTargetGroupResult:
    """
    Get information about a Yandex Application Load Balancer target group. For more information, see [Yandex Cloud Application Load Balancer](https://yandex.cloud/docs/application-load-balancer/quickstart).

    This data source is used to define [Application Load Balancer Target Groups](https://yandex.cloud/docs/application-load-balancer/concepts/target-group) that can be used by other resources.

    > One of `target_group_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing ALB Target Group
    #
    foo = yandex.get_alb_target_group(target_group_id="my-target-group-id")
    ```


    :param _builtins.str description: The resource description.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.str target_group_id: Target Group ID.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['targetGroupId'] = target_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getAlbTargetGroup:getAlbTargetGroup', __args__, opts=opts, typ=GetAlbTargetGroupResult).value

    return AwaitableGetAlbTargetGroupResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        target_group_id=pulumi.get(__ret__, 'target_group_id'),
        targets=pulumi.get(__ret__, 'targets'))
def get_alb_target_group_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                target_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlbTargetGroupResult]:
    """
    Get information about a Yandex Application Load Balancer target group. For more information, see [Yandex Cloud Application Load Balancer](https://yandex.cloud/docs/application-load-balancer/quickstart).

    This data source is used to define [Application Load Balancer Target Groups](https://yandex.cloud/docs/application-load-balancer/concepts/target-group) that can be used by other resources.

    > One of `target_group_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing ALB Target Group
    #
    foo = yandex.get_alb_target_group(target_group_id="my-target-group-id")
    ```


    :param _builtins.str description: The resource description.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.str target_group_id: Target Group ID.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['targetGroupId'] = target_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getAlbTargetGroup:getAlbTargetGroup', __args__, opts=opts, typ=GetAlbTargetGroupResult)
    return __ret__.apply(lambda __response__: GetAlbTargetGroupResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        target_group_id=pulumi.get(__response__, 'target_group_id'),
        targets=pulumi.get(__response__, 'targets')))
