# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCmCertificateContentResult',
    'AwaitableGetCmCertificateContentResult',
    'get_cm_certificate_content',
    'get_cm_certificate_content_output',
]

@pulumi.output_type
class GetCmCertificateContentResult:
    """
    A collection of values returned by getCmCertificateContent.
    """
    def __init__(__self__, certificate_id=None, certificates=None, folder_id=None, id=None, name=None, private_key=None, private_key_format=None, wait_validation=None):
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_key and not isinstance(private_key, str):
            raise TypeError("Expected argument 'private_key' to be a str")
        pulumi.set(__self__, "private_key", private_key)
        if private_key_format and not isinstance(private_key_format, str):
            raise TypeError("Expected argument 'private_key_format' to be a str")
        pulumi.set(__self__, "private_key_format", private_key_format)
        if wait_validation and not isinstance(wait_validation, bool):
            raise TypeError("Expected argument 'wait_validation' to be a bool")
        pulumi.set(__self__, "wait_validation", wait_validation)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[_builtins.str]:
        """
        Certificate Id.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence[_builtins.str]:
        """
        List of certificates in chain.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Certificate name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> _builtins.str:
        """
        Private key in specified format.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> Optional[_builtins.str]:
        """
        Format in which you want to export the private_key: `"PKCS1"` or `"PKCS8"`.
        """
        return pulumi.get(self, "private_key_format")

    @_builtins.property
    @pulumi.getter(name="waitValidation")
    def wait_validation(self) -> Optional[_builtins.bool]:
        """
        If `true`, the operation won't be completed while the certificate is in `VALIDATING`. Default is `false`.
        """
        return pulumi.get(self, "wait_validation")


class AwaitableGetCmCertificateContentResult(GetCmCertificateContentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCmCertificateContentResult(
            certificate_id=self.certificate_id,
            certificates=self.certificates,
            folder_id=self.folder_id,
            id=self.id,
            name=self.name,
            private_key=self.private_key,
            private_key_format=self.private_key_format,
            wait_validation=self.wait_validation)


def get_cm_certificate_content(certificate_id: Optional[_builtins.str] = None,
                               folder_id: Optional[_builtins.str] = None,
                               name: Optional[_builtins.str] = None,
                               private_key_format: Optional[_builtins.str] = None,
                               wait_validation: Optional[_builtins.bool] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCmCertificateContentResult:
    """
    Get content (certificate, private key) from a Yandex Certificate Manager Certificate. For more information, see [the official documentation](https://yandex.cloud/docs/certificate-manager/concepts/).

    > One of `certificate_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    # 
    # Get CM Certificate payload. Can be used for Certificate Validation.
    #
    example_by_id = yandex.get_cm_certificate_content(certificate_id="certificate-id")
    example_by_name = yandex.get_cm_certificate_content(folder_id="folder-id",
        name="example")
    ```


    :param _builtins.str certificate_id: Certificate Id.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: Certificate name.
    :param _builtins.str private_key_format: Format in which you want to export the private_key: `"PKCS1"` or `"PKCS8"`.
    :param _builtins.bool wait_validation: If `true`, the operation won't be completed while the certificate is in `VALIDATING`. Default is `false`.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['privateKeyFormat'] = private_key_format
    __args__['waitValidation'] = wait_validation
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getCmCertificateContent:getCmCertificateContent', __args__, opts=opts, typ=GetCmCertificateContentResult).value

    return AwaitableGetCmCertificateContentResult(
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        certificates=pulumi.get(__ret__, 'certificates'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        private_key=pulumi.get(__ret__, 'private_key'),
        private_key_format=pulumi.get(__ret__, 'private_key_format'),
        wait_validation=pulumi.get(__ret__, 'wait_validation'))
def get_cm_certificate_content_output(certificate_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      private_key_format: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      wait_validation: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCmCertificateContentResult]:
    """
    Get content (certificate, private key) from a Yandex Certificate Manager Certificate. For more information, see [the official documentation](https://yandex.cloud/docs/certificate-manager/concepts/).

    > One of `certificate_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    # 
    # Get CM Certificate payload. Can be used for Certificate Validation.
    #
    example_by_id = yandex.get_cm_certificate_content(certificate_id="certificate-id")
    example_by_name = yandex.get_cm_certificate_content(folder_id="folder-id",
        name="example")
    ```


    :param _builtins.str certificate_id: Certificate Id.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: Certificate name.
    :param _builtins.str private_key_format: Format in which you want to export the private_key: `"PKCS1"` or `"PKCS8"`.
    :param _builtins.bool wait_validation: If `true`, the operation won't be completed while the certificate is in `VALIDATING`. Default is `false`.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['privateKeyFormat'] = private_key_format
    __args__['waitValidation'] = wait_validation
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getCmCertificateContent:getCmCertificateContent', __args__, opts=opts, typ=GetCmCertificateContentResult)
    return __ret__.apply(lambda __response__: GetCmCertificateContentResult(
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        certificates=pulumi.get(__response__, 'certificates'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        private_key=pulumi.get(__response__, 'private_key'),
        private_key_format=pulumi.get(__response__, 'private_key_format'),
        wait_validation=pulumi.get(__response__, 'wait_validation')))
