# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetComputeInstanceGroupResult',
    'AwaitableGetComputeInstanceGroupResult',
    'get_compute_instance_group',
    'get_compute_instance_group_output',
]

@pulumi.output_type
class GetComputeInstanceGroupResult:
    """
    A collection of values returned by getComputeInstanceGroup.
    """
    def __init__(__self__, allocation_policies=None, application_balancer_states=None, application_load_balancers=None, created_at=None, deletion_protection=None, deploy_policies=None, description=None, folder_id=None, health_checks=None, id=None, instance_group_id=None, instance_templates=None, instances=None, labels=None, load_balancer_states=None, load_balancers=None, max_checking_health_duration=None, name=None, scale_policies=None, service_account_id=None, status=None, variables=None):
        if allocation_policies and not isinstance(allocation_policies, list):
            raise TypeError("Expected argument 'allocation_policies' to be a list")
        pulumi.set(__self__, "allocation_policies", allocation_policies)
        if application_balancer_states and not isinstance(application_balancer_states, list):
            raise TypeError("Expected argument 'application_balancer_states' to be a list")
        pulumi.set(__self__, "application_balancer_states", application_balancer_states)
        if application_load_balancers and not isinstance(application_load_balancers, list):
            raise TypeError("Expected argument 'application_load_balancers' to be a list")
        pulumi.set(__self__, "application_load_balancers", application_load_balancers)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if deploy_policies and not isinstance(deploy_policies, list):
            raise TypeError("Expected argument 'deploy_policies' to be a list")
        pulumi.set(__self__, "deploy_policies", deploy_policies)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if health_checks and not isinstance(health_checks, list):
            raise TypeError("Expected argument 'health_checks' to be a list")
        pulumi.set(__self__, "health_checks", health_checks)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_group_id and not isinstance(instance_group_id, str):
            raise TypeError("Expected argument 'instance_group_id' to be a str")
        pulumi.set(__self__, "instance_group_id", instance_group_id)
        if instance_templates and not isinstance(instance_templates, list):
            raise TypeError("Expected argument 'instance_templates' to be a list")
        pulumi.set(__self__, "instance_templates", instance_templates)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if load_balancer_states and not isinstance(load_balancer_states, list):
            raise TypeError("Expected argument 'load_balancer_states' to be a list")
        pulumi.set(__self__, "load_balancer_states", load_balancer_states)
        if load_balancers and not isinstance(load_balancers, list):
            raise TypeError("Expected argument 'load_balancers' to be a list")
        pulumi.set(__self__, "load_balancers", load_balancers)
        if max_checking_health_duration and not isinstance(max_checking_health_duration, int):
            raise TypeError("Expected argument 'max_checking_health_duration' to be a int")
        pulumi.set(__self__, "max_checking_health_duration", max_checking_health_duration)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if scale_policies and not isinstance(scale_policies, list):
            raise TypeError("Expected argument 'scale_policies' to be a list")
        pulumi.set(__self__, "scale_policies", scale_policies)
        if service_account_id and not isinstance(service_account_id, str):
            raise TypeError("Expected argument 'service_account_id' to be a str")
        pulumi.set(__self__, "service_account_id", service_account_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if variables and not isinstance(variables, dict):
            raise TypeError("Expected argument 'variables' to be a dict")
        pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="allocationPolicies")
    def allocation_policies(self) -> Sequence['outputs.GetComputeInstanceGroupAllocationPolicyResult']:
        return pulumi.get(self, "allocation_policies")

    @_builtins.property
    @pulumi.getter(name="applicationBalancerStates")
    def application_balancer_states(self) -> Sequence['outputs.GetComputeInstanceGroupApplicationBalancerStateResult']:
        return pulumi.get(self, "application_balancer_states")

    @_builtins.property
    @pulumi.getter(name="applicationLoadBalancers")
    def application_load_balancers(self) -> Sequence['outputs.GetComputeInstanceGroupApplicationLoadBalancerResult']:
        return pulumi.get(self, "application_load_balancers")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="deployPolicies")
    def deploy_policies(self) -> Sequence['outputs.GetComputeInstanceGroupDeployPolicyResult']:
        return pulumi.get(self, "deploy_policies")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Sequence['outputs.GetComputeInstanceGroupHealthCheckResult']:
        return pulumi.get(self, "health_checks")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceGroupId")
    def instance_group_id(self) -> _builtins.str:
        """
        The ID of a specific instance group.
        """
        return pulumi.get(self, "instance_group_id")

    @_builtins.property
    @pulumi.getter(name="instanceTemplates")
    def instance_templates(self) -> Sequence['outputs.GetComputeInstanceGroupInstanceTemplateResult']:
        return pulumi.get(self, "instance_templates")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetComputeInstanceGroupInstanceResult']:
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="loadBalancerStates")
    def load_balancer_states(self) -> Sequence['outputs.GetComputeInstanceGroupLoadBalancerStateResult']:
        return pulumi.get(self, "load_balancer_states")

    @_builtins.property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Sequence['outputs.GetComputeInstanceGroupLoadBalancerResult']:
        return pulumi.get(self, "load_balancers")

    @_builtins.property
    @pulumi.getter(name="maxCheckingHealthDuration")
    def max_checking_health_duration(self) -> _builtins.int:
        """
        Timeout for waiting for the VM to become healthy. If the timeout is exceeded, the VM will be turned off based on the deployment policy. Specified in seconds.
        """
        return pulumi.get(self, "max_checking_health_duration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scalePolicies")
    def scale_policies(self) -> Sequence['outputs.GetComputeInstanceGroupScalePolicyResult']:
        return pulumi.get(self, "scale_policies")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> _builtins.str:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value variables pairs to assign to the instance group.
        """
        return pulumi.get(self, "variables")


class AwaitableGetComputeInstanceGroupResult(GetComputeInstanceGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeInstanceGroupResult(
            allocation_policies=self.allocation_policies,
            application_balancer_states=self.application_balancer_states,
            application_load_balancers=self.application_load_balancers,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            deploy_policies=self.deploy_policies,
            description=self.description,
            folder_id=self.folder_id,
            health_checks=self.health_checks,
            id=self.id,
            instance_group_id=self.instance_group_id,
            instance_templates=self.instance_templates,
            instances=self.instances,
            labels=self.labels,
            load_balancer_states=self.load_balancer_states,
            load_balancers=self.load_balancers,
            max_checking_health_duration=self.max_checking_health_duration,
            name=self.name,
            scale_policies=self.scale_policies,
            service_account_id=self.service_account_id,
            status=self.status,
            variables=self.variables)


def get_compute_instance_group(instance_group_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeInstanceGroupResult:
    """
    Get information about a Yandex Compute instance group.


    :param _builtins.str instance_group_id: The ID of a specific instance group.
    """
    __args__ = dict()
    __args__['instanceGroupId'] = instance_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getComputeInstanceGroup:getComputeInstanceGroup', __args__, opts=opts, typ=GetComputeInstanceGroupResult).value

    return AwaitableGetComputeInstanceGroupResult(
        allocation_policies=pulumi.get(__ret__, 'allocation_policies'),
        application_balancer_states=pulumi.get(__ret__, 'application_balancer_states'),
        application_load_balancers=pulumi.get(__ret__, 'application_load_balancers'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        deploy_policies=pulumi.get(__ret__, 'deploy_policies'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        health_checks=pulumi.get(__ret__, 'health_checks'),
        id=pulumi.get(__ret__, 'id'),
        instance_group_id=pulumi.get(__ret__, 'instance_group_id'),
        instance_templates=pulumi.get(__ret__, 'instance_templates'),
        instances=pulumi.get(__ret__, 'instances'),
        labels=pulumi.get(__ret__, 'labels'),
        load_balancer_states=pulumi.get(__ret__, 'load_balancer_states'),
        load_balancers=pulumi.get(__ret__, 'load_balancers'),
        max_checking_health_duration=pulumi.get(__ret__, 'max_checking_health_duration'),
        name=pulumi.get(__ret__, 'name'),
        scale_policies=pulumi.get(__ret__, 'scale_policies'),
        service_account_id=pulumi.get(__ret__, 'service_account_id'),
        status=pulumi.get(__ret__, 'status'),
        variables=pulumi.get(__ret__, 'variables'))
def get_compute_instance_group_output(instance_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeInstanceGroupResult]:
    """
    Get information about a Yandex Compute instance group.


    :param _builtins.str instance_group_id: The ID of a specific instance group.
    """
    __args__ = dict()
    __args__['instanceGroupId'] = instance_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getComputeInstanceGroup:getComputeInstanceGroup', __args__, opts=opts, typ=GetComputeInstanceGroupResult)
    return __ret__.apply(lambda __response__: GetComputeInstanceGroupResult(
        allocation_policies=pulumi.get(__response__, 'allocation_policies'),
        application_balancer_states=pulumi.get(__response__, 'application_balancer_states'),
        application_load_balancers=pulumi.get(__response__, 'application_load_balancers'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        deploy_policies=pulumi.get(__response__, 'deploy_policies'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        health_checks=pulumi.get(__response__, 'health_checks'),
        id=pulumi.get(__response__, 'id'),
        instance_group_id=pulumi.get(__response__, 'instance_group_id'),
        instance_templates=pulumi.get(__response__, 'instance_templates'),
        instances=pulumi.get(__response__, 'instances'),
        labels=pulumi.get(__response__, 'labels'),
        load_balancer_states=pulumi.get(__response__, 'load_balancer_states'),
        load_balancers=pulumi.get(__response__, 'load_balancers'),
        max_checking_health_duration=pulumi.get(__response__, 'max_checking_health_duration'),
        name=pulumi.get(__response__, 'name'),
        scale_policies=pulumi.get(__response__, 'scale_policies'),
        service_account_id=pulumi.get(__response__, 'service_account_id'),
        status=pulumi.get(__response__, 'status'),
        variables=pulumi.get(__response__, 'variables')))
