# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetComputePlacementGroupResult',
    'AwaitableGetComputePlacementGroupResult',
    'get_compute_placement_group',
    'get_compute_placement_group_output',
]

@pulumi.output_type
class GetComputePlacementGroupResult:
    """
    A collection of values returned by getComputePlacementGroup.
    """
    def __init__(__self__, created_at=None, description=None, folder_id=None, group_id=None, id=None, labels=None, name=None, placement_strategy=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if placement_strategy and not isinstance(placement_strategy, dict):
            raise TypeError("Expected argument 'placement_strategy' to be a dict")
        pulumi.set(__self__, "placement_strategy", placement_strategy)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        The ID of a specific group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="placementStrategy")
    def placement_strategy(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Placement strategy set for group.
        """
        return pulumi.get(self, "placement_strategy")


class AwaitableGetComputePlacementGroupResult(GetComputePlacementGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputePlacementGroupResult(
            created_at=self.created_at,
            description=self.description,
            folder_id=self.folder_id,
            group_id=self.group_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            placement_strategy=self.placement_strategy)


def get_compute_placement_group(description: Optional[_builtins.str] = None,
                                folder_id: Optional[_builtins.str] = None,
                                group_id: Optional[_builtins.str] = None,
                                labels: Optional[Mapping[str, _builtins.str]] = None,
                                name: Optional[_builtins.str] = None,
                                placement_strategy: Optional[Mapping[str, _builtins.str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputePlacementGroupResult:
    """
    Get information about a Yandex Compute Placement group. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/placement-groups).

    > One of `group_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Compute Placement Group
    #
    my_group = yandex.get_compute_placement_group(group_id="some_group_id")
    pulumi.export("placementGroupName", my_group.name)
    ```


    :param _builtins.str description: The resource description.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str group_id: The ID of a specific group.
    :param Mapping[str, _builtins.str] labels: A set of key/value label pairs which assigned to resource.
    :param _builtins.str name: The resource name.
    :param Mapping[str, _builtins.str] placement_strategy: Placement strategy set for group.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['groupId'] = group_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['placementStrategy'] = placement_strategy
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getComputePlacementGroup:getComputePlacementGroup', __args__, opts=opts, typ=GetComputePlacementGroupResult).value

    return AwaitableGetComputePlacementGroupResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        placement_strategy=pulumi.get(__ret__, 'placement_strategy'))
def get_compute_placement_group_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       labels: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       placement_strategy: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputePlacementGroupResult]:
    """
    Get information about a Yandex Compute Placement group. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/placement-groups).

    > One of `group_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Compute Placement Group
    #
    my_group = yandex.get_compute_placement_group(group_id="some_group_id")
    pulumi.export("placementGroupName", my_group.name)
    ```


    :param _builtins.str description: The resource description.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str group_id: The ID of a specific group.
    :param Mapping[str, _builtins.str] labels: A set of key/value label pairs which assigned to resource.
    :param _builtins.str name: The resource name.
    :param Mapping[str, _builtins.str] placement_strategy: Placement strategy set for group.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['groupId'] = group_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['placementStrategy'] = placement_strategy
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getComputePlacementGroup:getComputePlacementGroup', __args__, opts=opts, typ=GetComputePlacementGroupResult)
    return __ret__.apply(lambda __response__: GetComputePlacementGroupResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        placement_strategy=pulumi.get(__response__, 'placement_strategy')))
