# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetComputeSnapshotScheduleResult',
    'AwaitableGetComputeSnapshotScheduleResult',
    'get_compute_snapshot_schedule',
    'get_compute_snapshot_schedule_output',
]

@pulumi.output_type
class GetComputeSnapshotScheduleResult:
    """
    A collection of values returned by getComputeSnapshotSchedule.
    """
    def __init__(__self__, created_at=None, description=None, disk_ids=None, folder_id=None, id=None, labels=None, name=None, retention_period=None, schedule_policies=None, snapshot_count=None, snapshot_schedule_id=None, snapshot_specs=None, status=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disk_ids and not isinstance(disk_ids, list):
            raise TypeError("Expected argument 'disk_ids' to be a list")
        pulumi.set(__self__, "disk_ids", disk_ids)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if retention_period and not isinstance(retention_period, str):
            raise TypeError("Expected argument 'retention_period' to be a str")
        pulumi.set(__self__, "retention_period", retention_period)
        if schedule_policies and not isinstance(schedule_policies, list):
            raise TypeError("Expected argument 'schedule_policies' to be a list")
        pulumi.set(__self__, "schedule_policies", schedule_policies)
        if snapshot_count and not isinstance(snapshot_count, int):
            raise TypeError("Expected argument 'snapshot_count' to be a int")
        pulumi.set(__self__, "snapshot_count", snapshot_count)
        if snapshot_schedule_id and not isinstance(snapshot_schedule_id, str):
            raise TypeError("Expected argument 'snapshot_schedule_id' to be a str")
        pulumi.set(__self__, "snapshot_schedule_id", snapshot_schedule_id)
        if snapshot_specs and not isinstance(snapshot_specs, list):
            raise TypeError("Expected argument 'snapshot_specs' to be a list")
        pulumi.set(__self__, "snapshot_specs", snapshot_specs)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskIds")
    def disk_ids(self) -> Sequence[_builtins.str]:
        """
        IDs of the disk for snapshot schedule.
        """
        return pulumi.get(self, "disk_ids")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> _builtins.str:
        """
        Time duration applied to snapshots created by this snapshot schedule. This is a signed sequence of decimal numbers, each with optional fraction and a unit suffix. Valid time units are `ns`, `us` (or `µs`), `ms`, `s`, `m`, `h`. Examples: `300ms`, `1.5h` or `2h45m`.
        """
        return pulumi.get(self, "retention_period")

    @_builtins.property
    @pulumi.getter(name="schedulePolicies")
    def schedule_policies(self) -> Sequence['outputs.GetComputeSnapshotScheduleSchedulePolicyResult']:
        return pulumi.get(self, "schedule_policies")

    @_builtins.property
    @pulumi.getter(name="snapshotCount")
    def snapshot_count(self) -> _builtins.int:
        """
        Maximum number of snapshots for every disk of the snapshot schedule.
        """
        return pulumi.get(self, "snapshot_count")

    @_builtins.property
    @pulumi.getter(name="snapshotScheduleId")
    def snapshot_schedule_id(self) -> _builtins.str:
        """
        The ID of a specific snapshot schedule.
        """
        return pulumi.get(self, "snapshot_schedule_id")

    @_builtins.property
    @pulumi.getter(name="snapshotSpecs")
    def snapshot_specs(self) -> Sequence['outputs.GetComputeSnapshotScheduleSnapshotSpecResult']:
        """
        Additional attributes for snapshots created by this snapshot schedule.
        """
        return pulumi.get(self, "snapshot_specs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the snapshot schedule.
        """
        return pulumi.get(self, "status")


class AwaitableGetComputeSnapshotScheduleResult(GetComputeSnapshotScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeSnapshotScheduleResult(
            created_at=self.created_at,
            description=self.description,
            disk_ids=self.disk_ids,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            retention_period=self.retention_period,
            schedule_policies=self.schedule_policies,
            snapshot_count=self.snapshot_count,
            snapshot_schedule_id=self.snapshot_schedule_id,
            snapshot_specs=self.snapshot_specs,
            status=self.status)


def get_compute_snapshot_schedule(description: Optional[_builtins.str] = None,
                                  disk_ids: Optional[Sequence[_builtins.str]] = None,
                                  folder_id: Optional[_builtins.str] = None,
                                  labels: Optional[Mapping[str, _builtins.str]] = None,
                                  name: Optional[_builtins.str] = None,
                                  retention_period: Optional[_builtins.str] = None,
                                  schedule_policies: Optional[Sequence[Union['GetComputeSnapshotScheduleSchedulePolicyArgs', 'GetComputeSnapshotScheduleSchedulePolicyArgsDict']]] = None,
                                  snapshot_count: Optional[_builtins.int] = None,
                                  snapshot_schedule_id: Optional[_builtins.str] = None,
                                  snapshot_specs: Optional[Sequence[Union['GetComputeSnapshotScheduleSnapshotSpecArgs', 'GetComputeSnapshotScheduleSnapshotSpecArgsDict']]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeSnapshotScheduleResult:
    """
    Get information about a Yandex Compute snapshot schedule. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/snapshot-schedule).

    > One of `snapshot_schedule_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Compute Snapshot Schedule
    #
    my_snapshot_schedule = yandex.get_compute_snapshot_schedule(snapshot_schedule_id="some_snapshot_schedule_id")
    ```


    :param _builtins.str description: The resource description.
    :param Sequence[_builtins.str] disk_ids: IDs of the disk for snapshot schedule.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param Mapping[str, _builtins.str] labels: A set of key/value label pairs which assigned to resource.
    :param _builtins.str name: The resource name.
    :param _builtins.str retention_period: Time duration applied to snapshots created by this snapshot schedule. This is a signed sequence of decimal numbers, each with optional fraction and a unit suffix. Valid time units are `ns`, `us` (or `µs`), `ms`, `s`, `m`, `h`. Examples: `300ms`, `1.5h` or `2h45m`.
    :param _builtins.int snapshot_count: Maximum number of snapshots for every disk of the snapshot schedule.
    :param _builtins.str snapshot_schedule_id: The ID of a specific snapshot schedule.
    :param Sequence[Union['GetComputeSnapshotScheduleSnapshotSpecArgs', 'GetComputeSnapshotScheduleSnapshotSpecArgsDict']] snapshot_specs: Additional attributes for snapshots created by this snapshot schedule.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['diskIds'] = disk_ids
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['retentionPeriod'] = retention_period
    __args__['schedulePolicies'] = schedule_policies
    __args__['snapshotCount'] = snapshot_count
    __args__['snapshotScheduleId'] = snapshot_schedule_id
    __args__['snapshotSpecs'] = snapshot_specs
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getComputeSnapshotSchedule:getComputeSnapshotSchedule', __args__, opts=opts, typ=GetComputeSnapshotScheduleResult).value

    return AwaitableGetComputeSnapshotScheduleResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        disk_ids=pulumi.get(__ret__, 'disk_ids'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        retention_period=pulumi.get(__ret__, 'retention_period'),
        schedule_policies=pulumi.get(__ret__, 'schedule_policies'),
        snapshot_count=pulumi.get(__ret__, 'snapshot_count'),
        snapshot_schedule_id=pulumi.get(__ret__, 'snapshot_schedule_id'),
        snapshot_specs=pulumi.get(__ret__, 'snapshot_specs'),
        status=pulumi.get(__ret__, 'status'))
def get_compute_snapshot_schedule_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         disk_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                         folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         labels: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         retention_period: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         schedule_policies: Optional[pulumi.Input[Optional[Sequence[Union['GetComputeSnapshotScheduleSchedulePolicyArgs', 'GetComputeSnapshotScheduleSchedulePolicyArgsDict']]]]] = None,
                                         snapshot_count: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                         snapshot_schedule_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         snapshot_specs: Optional[pulumi.Input[Optional[Sequence[Union['GetComputeSnapshotScheduleSnapshotSpecArgs', 'GetComputeSnapshotScheduleSnapshotSpecArgsDict']]]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeSnapshotScheduleResult]:
    """
    Get information about a Yandex Compute snapshot schedule. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/snapshot-schedule).

    > One of `snapshot_schedule_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Compute Snapshot Schedule
    #
    my_snapshot_schedule = yandex.get_compute_snapshot_schedule(snapshot_schedule_id="some_snapshot_schedule_id")
    ```


    :param _builtins.str description: The resource description.
    :param Sequence[_builtins.str] disk_ids: IDs of the disk for snapshot schedule.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param Mapping[str, _builtins.str] labels: A set of key/value label pairs which assigned to resource.
    :param _builtins.str name: The resource name.
    :param _builtins.str retention_period: Time duration applied to snapshots created by this snapshot schedule. This is a signed sequence of decimal numbers, each with optional fraction and a unit suffix. Valid time units are `ns`, `us` (or `µs`), `ms`, `s`, `m`, `h`. Examples: `300ms`, `1.5h` or `2h45m`.
    :param _builtins.int snapshot_count: Maximum number of snapshots for every disk of the snapshot schedule.
    :param _builtins.str snapshot_schedule_id: The ID of a specific snapshot schedule.
    :param Sequence[Union['GetComputeSnapshotScheduleSnapshotSpecArgs', 'GetComputeSnapshotScheduleSnapshotSpecArgsDict']] snapshot_specs: Additional attributes for snapshots created by this snapshot schedule.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['diskIds'] = disk_ids
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['retentionPeriod'] = retention_period
    __args__['schedulePolicies'] = schedule_policies
    __args__['snapshotCount'] = snapshot_count
    __args__['snapshotScheduleId'] = snapshot_schedule_id
    __args__['snapshotSpecs'] = snapshot_specs
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getComputeSnapshotSchedule:getComputeSnapshotSchedule', __args__, opts=opts, typ=GetComputeSnapshotScheduleResult)
    return __ret__.apply(lambda __response__: GetComputeSnapshotScheduleResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        disk_ids=pulumi.get(__response__, 'disk_ids'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        retention_period=pulumi.get(__response__, 'retention_period'),
        schedule_policies=pulumi.get(__response__, 'schedule_policies'),
        snapshot_count=pulumi.get(__response__, 'snapshot_count'),
        snapshot_schedule_id=pulumi.get(__response__, 'snapshot_schedule_id'),
        snapshot_specs=pulumi.get(__response__, 'snapshot_specs'),
        status=pulumi.get(__response__, 'status')))
