# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetContainerRegistryIpPermissionResult',
    'AwaitableGetContainerRegistryIpPermissionResult',
    'get_container_registry_ip_permission',
    'get_container_registry_ip_permission_output',
]

@pulumi.output_type
class GetContainerRegistryIpPermissionResult:
    """
    A collection of values returned by getContainerRegistryIpPermission.
    """
    def __init__(__self__, id=None, pulls=None, pushes=None, registry_id=None, registry_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pulls and not isinstance(pulls, list):
            raise TypeError("Expected argument 'pulls' to be a list")
        pulumi.set(__self__, "pulls", pulls)
        if pushes and not isinstance(pushes, list):
            raise TypeError("Expected argument 'pushes' to be a list")
        pulumi.set(__self__, "pushes", pushes)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if registry_name and not isinstance(registry_name, str):
            raise TypeError("Expected argument 'registry_name' to be a str")
        pulumi.set(__self__, "registry_name", registry_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def pulls(self) -> Sequence[_builtins.str]:
        """
        List of configured CIDRs, from which `pull` is allowed.
        """
        return pulumi.get(self, "pulls")

    @_builtins.property
    @pulumi.getter
    def pushes(self) -> Sequence[_builtins.str]:
        """
        List of configured CIDRs, from which `push` is allowed.
        """
        return pulumi.get(self, "pushes")

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> _builtins.str:
        """
        The ID of the registry that ip restrictions applied to.
        """
        return pulumi.get(self, "registry_id")

    @_builtins.property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> _builtins.str:
        """
        The Name of specific Container Registry.
        """
        return pulumi.get(self, "registry_name")


class AwaitableGetContainerRegistryIpPermissionResult(GetContainerRegistryIpPermissionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerRegistryIpPermissionResult(
            id=self.id,
            pulls=self.pulls,
            pushes=self.pushes,
            registry_id=self.registry_id,
            registry_name=self.registry_name)


def get_container_registry_ip_permission(registry_id: Optional[_builtins.str] = None,
                                         registry_name: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerRegistryIpPermissionResult:
    """
    Get information about a Yandex Container Registry IP Permission. For more information, see [the official documentation](https://yandex.cloud/docs/container-registry/operations/registry/registry-access).

    > Either `registry_id` or `registry_name` must be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing IP Permission of specific Container Registry.
    #
    my_ip_permission_by_id = yandex.get_container_registry_ip_permission(registry_id=my_registry["id"])
    ```


    :param _builtins.str registry_id: The ID of the registry that ip restrictions applied to.
    :param _builtins.str registry_name: The Name of specific Container Registry.
    """
    __args__ = dict()
    __args__['registryId'] = registry_id
    __args__['registryName'] = registry_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getContainerRegistryIpPermission:getContainerRegistryIpPermission', __args__, opts=opts, typ=GetContainerRegistryIpPermissionResult).value

    return AwaitableGetContainerRegistryIpPermissionResult(
        id=pulumi.get(__ret__, 'id'),
        pulls=pulumi.get(__ret__, 'pulls'),
        pushes=pulumi.get(__ret__, 'pushes'),
        registry_id=pulumi.get(__ret__, 'registry_id'),
        registry_name=pulumi.get(__ret__, 'registry_name'))
def get_container_registry_ip_permission_output(registry_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                registry_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerRegistryIpPermissionResult]:
    """
    Get information about a Yandex Container Registry IP Permission. For more information, see [the official documentation](https://yandex.cloud/docs/container-registry/operations/registry/registry-access).

    > Either `registry_id` or `registry_name` must be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing IP Permission of specific Container Registry.
    #
    my_ip_permission_by_id = yandex.get_container_registry_ip_permission(registry_id=my_registry["id"])
    ```


    :param _builtins.str registry_id: The ID of the registry that ip restrictions applied to.
    :param _builtins.str registry_name: The Name of specific Container Registry.
    """
    __args__ = dict()
    __args__['registryId'] = registry_id
    __args__['registryName'] = registry_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getContainerRegistryIpPermission:getContainerRegistryIpPermission', __args__, opts=opts, typ=GetContainerRegistryIpPermissionResult)
    return __ret__.apply(lambda __response__: GetContainerRegistryIpPermissionResult(
        id=pulumi.get(__response__, 'id'),
        pulls=pulumi.get(__response__, 'pulls'),
        pushes=pulumi.get(__response__, 'pushes'),
        registry_id=pulumi.get(__response__, 'registry_id'),
        registry_name=pulumi.get(__response__, 'registry_name')))
