# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFunctionScalingPolicyResult',
    'AwaitableGetFunctionScalingPolicyResult',
    'get_function_scaling_policy',
    'get_function_scaling_policy_output',
]

@pulumi.output_type
class GetFunctionScalingPolicyResult:
    """
    A collection of values returned by getFunctionScalingPolicy.
    """
    def __init__(__self__, function_id=None, id=None, policies=None):
        if function_id and not isinstance(function_id, str):
            raise TypeError("Expected argument 'function_id' to be a str")
        pulumi.set(__self__, "function_id", function_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> _builtins.str:
        """
        Yandex Cloud Function id used to define function.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetFunctionScalingPolicyPolicyResult']:
        return pulumi.get(self, "policies")


class AwaitableGetFunctionScalingPolicyResult(GetFunctionScalingPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionScalingPolicyResult(
            function_id=self.function_id,
            id=self.id,
            policies=self.policies)


def get_function_scaling_policy(function_id: Optional[_builtins.str] = None,
                                policies: Optional[Sequence[Union['GetFunctionScalingPolicyPolicyArgs', 'GetFunctionScalingPolicyPolicyArgsDict']]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionScalingPolicyResult:
    """
    Get information about a Yandex Cloud Function Scaling Policy. For more information about Yandex Cloud Functions, see [Yandex Cloud Functions](https://yandex.cloud/docs/functions/).

    This data source is used to define [Yandex Cloud Function Scaling Policy](https://yandex.cloud/docs/functions/) that can be used by other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Cloud Function Scaling Policy.
    #
    my_scaling_policy = yandex.get_function_scaling_policy(function_id="d4e45**********pqvd3")
    ```


    :param _builtins.str function_id: Yandex Cloud Function id used to define function.
    """
    __args__ = dict()
    __args__['functionId'] = function_id
    __args__['policies'] = policies
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getFunctionScalingPolicy:getFunctionScalingPolicy', __args__, opts=opts, typ=GetFunctionScalingPolicyResult).value

    return AwaitableGetFunctionScalingPolicyResult(
        function_id=pulumi.get(__ret__, 'function_id'),
        id=pulumi.get(__ret__, 'id'),
        policies=pulumi.get(__ret__, 'policies'))
def get_function_scaling_policy_output(function_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       policies: Optional[pulumi.Input[Optional[Sequence[Union['GetFunctionScalingPolicyPolicyArgs', 'GetFunctionScalingPolicyPolicyArgsDict']]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFunctionScalingPolicyResult]:
    """
    Get information about a Yandex Cloud Function Scaling Policy. For more information about Yandex Cloud Functions, see [Yandex Cloud Functions](https://yandex.cloud/docs/functions/).

    This data source is used to define [Yandex Cloud Function Scaling Policy](https://yandex.cloud/docs/functions/) that can be used by other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Cloud Function Scaling Policy.
    #
    my_scaling_policy = yandex.get_function_scaling_policy(function_id="d4e45**********pqvd3")
    ```


    :param _builtins.str function_id: Yandex Cloud Function id used to define function.
    """
    __args__ = dict()
    __args__['functionId'] = function_id
    __args__['policies'] = policies
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getFunctionScalingPolicy:getFunctionScalingPolicy', __args__, opts=opts, typ=GetFunctionScalingPolicyResult)
    return __ret__.apply(lambda __response__: GetFunctionScalingPolicyResult(
        function_id=pulumi.get(__response__, 'function_id'),
        id=pulumi.get(__response__, 'id'),
        policies=pulumi.get(__response__, 'policies')))
