# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetIamUserResult',
    'AwaitableGetIamUserResult',
    'get_iam_user',
    'get_iam_user_output',
]

@pulumi.output_type
class GetIamUserResult:
    """
    A collection of values returned by getIamUser.
    """
    def __init__(__self__, default_email=None, id=None, login=None, user_id=None):
        if default_email and not isinstance(default_email, str):
            raise TypeError("Expected argument 'default_email' to be a str")
        pulumi.set(__self__, "default_email", default_email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if login and not isinstance(login, str):
            raise TypeError("Expected argument 'login' to be a str")
        pulumi.set(__self__, "login", login)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="defaultEmail")
    def default_email(self) -> _builtins.str:
        """
        Email address of user account.
        """
        return pulumi.get(self, "default_email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def login(self) -> _builtins.str:
        """
        Login name used to sign in to Yandex Passport.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        User ID used to manage IAM access bindings.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetIamUserResult(GetIamUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamUserResult(
            default_email=self.default_email,
            id=self.id,
            login=self.login,
            user_id=self.user_id)


def get_iam_user(login: Optional[_builtins.str] = None,
                 user_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamUserResult:
    """
    Get information about a Yandex IAM user account. For more information about accounts, see [Yandex Cloud IAM accounts](https://yandex.cloud/docs/iam/concepts/#accounts).

    This data source is used to define [IAM User](https://yandex.cloud/docs/iam/concepts/#passport) that can be used by other resources.

    > Either `login` or `user_id` must be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing IAM User.
    #
    admin = yandex.get_iam_user(login="my-yandex-login")
    ```


    :param _builtins.str login: Login name used to sign in to Yandex Passport.
    :param _builtins.str user_id: User ID used to manage IAM access bindings.
    """
    __args__ = dict()
    __args__['login'] = login
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getIamUser:getIamUser', __args__, opts=opts, typ=GetIamUserResult).value

    return AwaitableGetIamUserResult(
        default_email=pulumi.get(__ret__, 'default_email'),
        id=pulumi.get(__ret__, 'id'),
        login=pulumi.get(__ret__, 'login'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_iam_user_output(login: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        user_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIamUserResult]:
    """
    Get information about a Yandex IAM user account. For more information about accounts, see [Yandex Cloud IAM accounts](https://yandex.cloud/docs/iam/concepts/#accounts).

    This data source is used to define [IAM User](https://yandex.cloud/docs/iam/concepts/#passport) that can be used by other resources.

    > Either `login` or `user_id` must be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing IAM User.
    #
    admin = yandex.get_iam_user(login="my-yandex-login")
    ```


    :param _builtins.str login: Login name used to sign in to Yandex Passport.
    :param _builtins.str user_id: User ID used to manage IAM access bindings.
    """
    __args__ = dict()
    __args__['login'] = login
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getIamUser:getIamUser', __args__, opts=opts, typ=GetIamUserResult)
    return __ret__.apply(lambda __response__: GetIamUserResult(
        default_email=pulumi.get(__response__, 'default_email'),
        id=pulumi.get(__response__, 'id'),
        login=pulumi.get(__response__, 'login'),
        user_id=pulumi.get(__response__, 'user_id')))
