# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetIotCoreDeviceResult',
    'AwaitableGetIotCoreDeviceResult',
    'get_iot_core_device',
    'get_iot_core_device_output',
]

@pulumi.output_type
class GetIotCoreDeviceResult:
    """
    A collection of values returned by getIotCoreDevice.
    """
    def __init__(__self__, aliases=None, certificates=None, created_at=None, description=None, device_id=None, id=None, labels=None, name=None, passwords=None, registry_id=None):
        if aliases and not isinstance(aliases, dict):
            raise TypeError("Expected argument 'aliases' to be a dict")
        pulumi.set(__self__, "aliases", aliases)
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_id and not isinstance(device_id, str):
            raise TypeError("Expected argument 'device_id' to be a str")
        pulumi.set(__self__, "device_id", device_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if passwords and not isinstance(passwords, list):
            raise TypeError("Expected argument 'passwords' to be a list")
        pulumi.set(__self__, "passwords", passwords)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value aliases pairs to assign to the IoT Core Device.
        """
        return pulumi.get(self, "aliases")

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence[_builtins.str]:
        """
        A set of certificate's fingerprints for the IoT Core Device.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[_builtins.str]:
        """
        IoT Core Device id used to define device.
        """
        return pulumi.get(self, "device_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def passwords(self) -> Sequence[_builtins.str]:
        """
        A set of passwords's id for the IoT Core Device.
        """
        return pulumi.get(self, "passwords")

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> _builtins.str:
        """
        IoT Core Registry ID for the IoT Core Device.
        """
        return pulumi.get(self, "registry_id")


class AwaitableGetIotCoreDeviceResult(GetIotCoreDeviceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIotCoreDeviceResult(
            aliases=self.aliases,
            certificates=self.certificates,
            created_at=self.created_at,
            description=self.description,
            device_id=self.device_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            passwords=self.passwords,
            registry_id=self.registry_id)


def get_iot_core_device(device_id: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIotCoreDeviceResult:
    """
    Get information about a Yandex IoT Core device. For more information about IoT Core, see [Yandex Cloud IoT Device](https://yandex.cloud/docs/iot-core/quickstart).
    This data source is used to define [Yandex Cloud IoT Device](https://yandex.cloud/docs/iot-core/quickstart) that can be used by other resources.

    > Either `device_id` or `name` must be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing IoT Core Device.
    #
    my_device = yandex.get_iot_core_device(device_id="are1sampleregistry11")
    ```


    :param _builtins.str device_id: IoT Core Device id used to define device.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['deviceId'] = device_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getIotCoreDevice:getIotCoreDevice', __args__, opts=opts, typ=GetIotCoreDeviceResult).value

    return AwaitableGetIotCoreDeviceResult(
        aliases=pulumi.get(__ret__, 'aliases'),
        certificates=pulumi.get(__ret__, 'certificates'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        device_id=pulumi.get(__ret__, 'device_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        passwords=pulumi.get(__ret__, 'passwords'),
        registry_id=pulumi.get(__ret__, 'registry_id'))
def get_iot_core_device_output(device_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIotCoreDeviceResult]:
    """
    Get information about a Yandex IoT Core device. For more information about IoT Core, see [Yandex Cloud IoT Device](https://yandex.cloud/docs/iot-core/quickstart).
    This data source is used to define [Yandex Cloud IoT Device](https://yandex.cloud/docs/iot-core/quickstart) that can be used by other resources.

    > Either `device_id` or `name` must be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing IoT Core Device.
    #
    my_device = yandex.get_iot_core_device(device_id="are1sampleregistry11")
    ```


    :param _builtins.str device_id: IoT Core Device id used to define device.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['deviceId'] = device_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getIotCoreDevice:getIotCoreDevice', __args__, opts=opts, typ=GetIotCoreDeviceResult)
    return __ret__.apply(lambda __response__: GetIotCoreDeviceResult(
        aliases=pulumi.get(__response__, 'aliases'),
        certificates=pulumi.get(__response__, 'certificates'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        device_id=pulumi.get(__response__, 'device_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        passwords=pulumi.get(__response__, 'passwords'),
        registry_id=pulumi.get(__response__, 'registry_id')))
