# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLoadtestingAgentResult',
    'AwaitableGetLoadtestingAgentResult',
    'get_loadtesting_agent',
    'get_loadtesting_agent_output',
]

@pulumi.output_type
class GetLoadtestingAgentResult:
    """
    A collection of values returned by getLoadtestingAgent.
    """
    def __init__(__self__, agent_id=None, compute_instance_id=None, compute_instances=None, description=None, folder_id=None, id=None, labels=None, log_settings=None, name=None):
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if compute_instance_id and not isinstance(compute_instance_id, str):
            raise TypeError("Expected argument 'compute_instance_id' to be a str")
        pulumi.set(__self__, "compute_instance_id", compute_instance_id)
        if compute_instances and not isinstance(compute_instances, list):
            raise TypeError("Expected argument 'compute_instances' to be a list")
        pulumi.set(__self__, "compute_instances", compute_instances)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if log_settings and not isinstance(log_settings, dict):
            raise TypeError("Expected argument 'log_settings' to be a dict")
        pulumi.set(__self__, "log_settings", log_settings)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> _builtins.str:
        """
        The ID of a specific load testing agent.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="computeInstanceId")
    def compute_instance_id(self) -> _builtins.str:
        """
        Compute Instance ID.
        """
        return pulumi.get(self, "compute_instance_id")

    @_builtins.property
    @pulumi.getter(name="computeInstances")
    def compute_instances(self) -> Sequence['outputs.GetLoadtestingAgentComputeInstanceResult']:
        return pulumi.get(self, "compute_instances")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="logSettings")
    def log_settings(self) -> Optional['outputs.GetLoadtestingAgentLogSettingsResult']:
        return pulumi.get(self, "log_settings")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")


class AwaitableGetLoadtestingAgentResult(GetLoadtestingAgentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadtestingAgentResult(
            agent_id=self.agent_id,
            compute_instance_id=self.compute_instance_id,
            compute_instances=self.compute_instances,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            log_settings=self.log_settings,
            name=self.name)


def get_loadtesting_agent(agent_id: Optional[_builtins.str] = None,
                          log_settings: Optional[Union['GetLoadtestingAgentLogSettingsArgs', 'GetLoadtestingAgentLogSettingsArgsDict']] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadtestingAgentResult:
    """
    Get information about a Yandex Load Testing Agent.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing LoadTesting Agent.
    #
    my_agent = yandex.get_loadtesting_agent(agent_id="some_agent_id")
    pulumi.export("instanceExternalIp", my_agent.compute_instances[0].network_interfaces[0].nat_ip_address)
    ```


    :param _builtins.str agent_id: The ID of a specific load testing agent.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['logSettings'] = log_settings
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getLoadtestingAgent:getLoadtestingAgent', __args__, opts=opts, typ=GetLoadtestingAgentResult).value

    return AwaitableGetLoadtestingAgentResult(
        agent_id=pulumi.get(__ret__, 'agent_id'),
        compute_instance_id=pulumi.get(__ret__, 'compute_instance_id'),
        compute_instances=pulumi.get(__ret__, 'compute_instances'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        log_settings=pulumi.get(__ret__, 'log_settings'),
        name=pulumi.get(__ret__, 'name'))
def get_loadtesting_agent_output(agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 log_settings: Optional[pulumi.Input[Optional[Union['GetLoadtestingAgentLogSettingsArgs', 'GetLoadtestingAgentLogSettingsArgsDict']]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadtestingAgentResult]:
    """
    Get information about a Yandex Load Testing Agent.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing LoadTesting Agent.
    #
    my_agent = yandex.get_loadtesting_agent(agent_id="some_agent_id")
    pulumi.export("instanceExternalIp", my_agent.compute_instances[0].network_interfaces[0].nat_ip_address)
    ```


    :param _builtins.str agent_id: The ID of a specific load testing agent.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['logSettings'] = log_settings
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getLoadtestingAgent:getLoadtestingAgent', __args__, opts=opts, typ=GetLoadtestingAgentResult)
    return __ret__.apply(lambda __response__: GetLoadtestingAgentResult(
        agent_id=pulumi.get(__response__, 'agent_id'),
        compute_instance_id=pulumi.get(__response__, 'compute_instance_id'),
        compute_instances=pulumi.get(__response__, 'compute_instances'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        log_settings=pulumi.get(__response__, 'log_settings'),
        name=pulumi.get(__response__, 'name')))
