# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLockboxSecretVersionResult',
    'AwaitableGetLockboxSecretVersionResult',
    'get_lockbox_secret_version',
    'get_lockbox_secret_version_output',
]

@pulumi.output_type
class GetLockboxSecretVersionResult:
    """
    A collection of values returned by getLockboxSecretVersion.
    """
    def __init__(__self__, entries=None, id=None, secret_id=None, version_id=None):
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetLockboxSecretVersionEntryResult']:
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The Yandex Cloud Lockbox secret ID where to add the version.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        The Yandex Cloud Lockbox secret version ID.
        """
        return pulumi.get(self, "version_id")


class AwaitableGetLockboxSecretVersionResult(GetLockboxSecretVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLockboxSecretVersionResult(
            entries=self.entries,
            id=self.id,
            secret_id=self.secret_id,
            version_id=self.version_id)


def get_lockbox_secret_version(secret_id: Optional[_builtins.str] = None,
                               version_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLockboxSecretVersionResult:
    """
    Get information about Yandex Cloud Lockbox secret version. For more information, see [the official documentation](https://yandex.cloud/docs/lockbox/).
    If you're creating the secret in the same project, then you should indicate `version_id`, since otherwise you may refer to a wrong version of the secret (e.g. the first version, when it is still empty).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Lockbox Secret Version.
    #
    my_secret_version = yandex.get_lockbox_secret_version(secret_id="some-secret-id",
        version_id="some-version-id")
    pulumi.export("mySecretEntries", my_secret_version.entries)
    ```

    ```python
    import pulumi
    import pulumi_yandex as yandex
    import pulumi_yandex_marketmaker as yandex

    #
    # Get information about existing Lockbox Secret Version.
    #
    my_secret = yandex.LockboxSecret("my_secret")
    my_version_lockbox_secret_version = yandex.LockboxSecretVersion("my_version", secret_id=my_secret.id)
    my_version = yandex.get_lockbox_secret_version_output(secret_id=my_secret.id,
        version_id=my_version_lockbox_secret_version.id)
    pulumi.export("mySecretEntries", my_version.entries)
    ```


    :param _builtins.str secret_id: The Yandex Cloud Lockbox secret ID where to add the version.
    :param _builtins.str version_id: The Yandex Cloud Lockbox secret version ID.
    """
    __args__ = dict()
    __args__['secretId'] = secret_id
    __args__['versionId'] = version_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getLockboxSecretVersion:getLockboxSecretVersion', __args__, opts=opts, typ=GetLockboxSecretVersionResult).value

    return AwaitableGetLockboxSecretVersionResult(
        entries=pulumi.get(__ret__, 'entries'),
        id=pulumi.get(__ret__, 'id'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        version_id=pulumi.get(__ret__, 'version_id'))
def get_lockbox_secret_version_output(secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      version_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLockboxSecretVersionResult]:
    """
    Get information about Yandex Cloud Lockbox secret version. For more information, see [the official documentation](https://yandex.cloud/docs/lockbox/).
    If you're creating the secret in the same project, then you should indicate `version_id`, since otherwise you may refer to a wrong version of the secret (e.g. the first version, when it is still empty).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Lockbox Secret Version.
    #
    my_secret_version = yandex.get_lockbox_secret_version(secret_id="some-secret-id",
        version_id="some-version-id")
    pulumi.export("mySecretEntries", my_secret_version.entries)
    ```

    ```python
    import pulumi
    import pulumi_yandex as yandex
    import pulumi_yandex_marketmaker as yandex

    #
    # Get information about existing Lockbox Secret Version.
    #
    my_secret = yandex.LockboxSecret("my_secret")
    my_version_lockbox_secret_version = yandex.LockboxSecretVersion("my_version", secret_id=my_secret.id)
    my_version = yandex.get_lockbox_secret_version_output(secret_id=my_secret.id,
        version_id=my_version_lockbox_secret_version.id)
    pulumi.export("mySecretEntries", my_version.entries)
    ```


    :param _builtins.str secret_id: The Yandex Cloud Lockbox secret ID where to add the version.
    :param _builtins.str version_id: The Yandex Cloud Lockbox secret version ID.
    """
    __args__ = dict()
    __args__['secretId'] = secret_id
    __args__['versionId'] = version_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getLockboxSecretVersion:getLockboxSecretVersion', __args__, opts=opts, typ=GetLockboxSecretVersionResult)
    return __ret__.apply(lambda __response__: GetLockboxSecretVersionResult(
        entries=pulumi.get(__response__, 'entries'),
        id=pulumi.get(__response__, 'id'),
        secret_id=pulumi.get(__response__, 'secret_id'),
        version_id=pulumi.get(__response__, 'version_id')))
