# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMdbGreenplumClusterResult',
    'AwaitableGetMdbGreenplumClusterResult',
    'get_mdb_greenplum_cluster',
    'get_mdb_greenplum_cluster_output',
]

@pulumi.output_type
class GetMdbGreenplumClusterResult:
    """
    A collection of values returned by getMdbGreenplumCluster.
    """
    def __init__(__self__, accesses=None, assign_public_ip=None, background_activities=None, backup_window_starts=None, cloud_storages=None, cluster_id=None, created_at=None, deletion_protection=None, description=None, environment=None, folder_id=None, greenplum_config=None, health=None, id=None, labels=None, loggings=None, maintenance_windows=None, master_host_count=None, master_host_group_ids=None, master_hosts=None, master_subclusters=None, name=None, network_id=None, pooler_config=None, pxf_configs=None, security_group_ids=None, segment_host_count=None, segment_host_group_ids=None, segment_hosts=None, segment_in_host=None, segment_subclusters=None, service_account_id=None, status=None, subnet_id=None, user_name=None, version=None, zone=None):
        if accesses and not isinstance(accesses, list):
            raise TypeError("Expected argument 'accesses' to be a list")
        pulumi.set(__self__, "accesses", accesses)
        if assign_public_ip and not isinstance(assign_public_ip, bool):
            raise TypeError("Expected argument 'assign_public_ip' to be a bool")
        pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if background_activities and not isinstance(background_activities, list):
            raise TypeError("Expected argument 'background_activities' to be a list")
        pulumi.set(__self__, "background_activities", background_activities)
        if backup_window_starts and not isinstance(backup_window_starts, list):
            raise TypeError("Expected argument 'backup_window_starts' to be a list")
        pulumi.set(__self__, "backup_window_starts", backup_window_starts)
        if cloud_storages and not isinstance(cloud_storages, list):
            raise TypeError("Expected argument 'cloud_storages' to be a list")
        pulumi.set(__self__, "cloud_storages", cloud_storages)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if greenplum_config and not isinstance(greenplum_config, dict):
            raise TypeError("Expected argument 'greenplum_config' to be a dict")
        pulumi.set(__self__, "greenplum_config", greenplum_config)
        if health and not isinstance(health, str):
            raise TypeError("Expected argument 'health' to be a str")
        pulumi.set(__self__, "health", health)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if loggings and not isinstance(loggings, list):
            raise TypeError("Expected argument 'loggings' to be a list")
        pulumi.set(__self__, "loggings", loggings)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if master_host_count and not isinstance(master_host_count, int):
            raise TypeError("Expected argument 'master_host_count' to be a int")
        pulumi.set(__self__, "master_host_count", master_host_count)
        if master_host_group_ids and not isinstance(master_host_group_ids, list):
            raise TypeError("Expected argument 'master_host_group_ids' to be a list")
        pulumi.set(__self__, "master_host_group_ids", master_host_group_ids)
        if master_hosts and not isinstance(master_hosts, list):
            raise TypeError("Expected argument 'master_hosts' to be a list")
        pulumi.set(__self__, "master_hosts", master_hosts)
        if master_subclusters and not isinstance(master_subclusters, list):
            raise TypeError("Expected argument 'master_subclusters' to be a list")
        pulumi.set(__self__, "master_subclusters", master_subclusters)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if pooler_config and not isinstance(pooler_config, dict):
            raise TypeError("Expected argument 'pooler_config' to be a dict")
        pulumi.set(__self__, "pooler_config", pooler_config)
        if pxf_configs and not isinstance(pxf_configs, list):
            raise TypeError("Expected argument 'pxf_configs' to be a list")
        pulumi.set(__self__, "pxf_configs", pxf_configs)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if segment_host_count and not isinstance(segment_host_count, int):
            raise TypeError("Expected argument 'segment_host_count' to be a int")
        pulumi.set(__self__, "segment_host_count", segment_host_count)
        if segment_host_group_ids and not isinstance(segment_host_group_ids, list):
            raise TypeError("Expected argument 'segment_host_group_ids' to be a list")
        pulumi.set(__self__, "segment_host_group_ids", segment_host_group_ids)
        if segment_hosts and not isinstance(segment_hosts, list):
            raise TypeError("Expected argument 'segment_hosts' to be a list")
        pulumi.set(__self__, "segment_hosts", segment_hosts)
        if segment_in_host and not isinstance(segment_in_host, int):
            raise TypeError("Expected argument 'segment_in_host' to be a int")
        pulumi.set(__self__, "segment_in_host", segment_in_host)
        if segment_subclusters and not isinstance(segment_subclusters, list):
            raise TypeError("Expected argument 'segment_subclusters' to be a list")
        pulumi.set(__self__, "segment_subclusters", segment_subclusters)
        if service_account_id and not isinstance(service_account_id, str):
            raise TypeError("Expected argument 'service_account_id' to be a str")
        pulumi.set(__self__, "service_account_id", service_account_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def accesses(self) -> Sequence['outputs.GetMdbGreenplumClusterAccessResult']:
        return pulumi.get(self, "accesses")

    @_builtins.property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> _builtins.bool:
        """
        Sets whether the master hosts should get a public IP address on creation. Changing this parameter for an existing host is not supported at the moment.
        """
        return pulumi.get(self, "assign_public_ip")

    @_builtins.property
    @pulumi.getter(name="backgroundActivities")
    def background_activities(self) -> Sequence['outputs.GetMdbGreenplumClusterBackgroundActivityResult']:
        return pulumi.get(self, "background_activities")

    @_builtins.property
    @pulumi.getter(name="backupWindowStarts")
    def backup_window_starts(self) -> Sequence['outputs.GetMdbGreenplumClusterBackupWindowStartResult']:
        return pulumi.get(self, "backup_window_starts")

    @_builtins.property
    @pulumi.getter(name="cloudStorages")
    def cloud_storages(self) -> Sequence['outputs.GetMdbGreenplumClusterCloudStorageResult']:
        return pulumi.get(self, "cloud_storages")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the Greenplum cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> _builtins.str:
        """
        Deployment environment of the Greenplum cluster. (PRODUCTION, PRESTABLE)
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="greenplumConfig")
    def greenplum_config(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "greenplum_config")

    @_builtins.property
    @pulumi.getter
    def health(self) -> _builtins.str:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def loggings(self) -> Sequence['outputs.GetMdbGreenplumClusterLoggingResult']:
        return pulumi.get(self, "loggings")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetMdbGreenplumClusterMaintenanceWindowResult']:
        return pulumi.get(self, "maintenance_windows")

    @_builtins.property
    @pulumi.getter(name="masterHostCount")
    def master_host_count(self) -> _builtins.int:
        """
        Number of hosts in master subcluster (1 or 2).
        """
        return pulumi.get(self, "master_host_count")

    @_builtins.property
    @pulumi.getter(name="masterHostGroupIds")
    def master_host_group_ids(self) -> Sequence[_builtins.str]:
        """
        A list of IDs of the host groups to place master subclusters' VMs of the cluster on.
        """
        return pulumi.get(self, "master_host_group_ids")

    @_builtins.property
    @pulumi.getter(name="masterHosts")
    def master_hosts(self) -> Sequence['outputs.GetMdbGreenplumClusterMasterHostResult']:
        return pulumi.get(self, "master_hosts")

    @_builtins.property
    @pulumi.getter(name="masterSubclusters")
    def master_subclusters(self) -> Sequence['outputs.GetMdbGreenplumClusterMasterSubclusterResult']:
        return pulumi.get(self, "master_subclusters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="poolerConfig")
    def pooler_config(self) -> Optional['outputs.GetMdbGreenplumClusterPoolerConfigResult']:
        return pulumi.get(self, "pooler_config")

    @_builtins.property
    @pulumi.getter(name="pxfConfigs")
    def pxf_configs(self) -> Sequence['outputs.GetMdbGreenplumClusterPxfConfigResult']:
        return pulumi.get(self, "pxf_configs")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="segmentHostCount")
    def segment_host_count(self) -> _builtins.int:
        """
        Number of hosts in segment subcluster (from 1 to 32).
        """
        return pulumi.get(self, "segment_host_count")

    @_builtins.property
    @pulumi.getter(name="segmentHostGroupIds")
    def segment_host_group_ids(self) -> Sequence[_builtins.str]:
        """
        A list of IDs of the host groups to place segment subclusters' VMs of the cluster on.
        """
        return pulumi.get(self, "segment_host_group_ids")

    @_builtins.property
    @pulumi.getter(name="segmentHosts")
    def segment_hosts(self) -> Sequence['outputs.GetMdbGreenplumClusterSegmentHostResult']:
        return pulumi.get(self, "segment_hosts")

    @_builtins.property
    @pulumi.getter(name="segmentInHost")
    def segment_in_host(self) -> _builtins.int:
        """
        Number of segments on segment host (not more then 1 + RAM/8).
        """
        return pulumi.get(self, "segment_in_host")

    @_builtins.property
    @pulumi.getter(name="segmentSubclusters")
    def segment_subclusters(self) -> Sequence['outputs.GetMdbGreenplumClusterSegmentSubclusterResult']:
        return pulumi.get(self, "segment_subclusters")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> _builtins.str:
        """
        ID of service account to use with Yandex Cloud resources (e.g. S3, Cloud Logging).
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The ID of the subnet, to which the hosts belongs. The subnet must be a part of the network to which the cluster belongs.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        Greenplum cluster admin user name.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of the Greenplum cluster. (`6.25`)
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone")


class AwaitableGetMdbGreenplumClusterResult(GetMdbGreenplumClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbGreenplumClusterResult(
            accesses=self.accesses,
            assign_public_ip=self.assign_public_ip,
            background_activities=self.background_activities,
            backup_window_starts=self.backup_window_starts,
            cloud_storages=self.cloud_storages,
            cluster_id=self.cluster_id,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            description=self.description,
            environment=self.environment,
            folder_id=self.folder_id,
            greenplum_config=self.greenplum_config,
            health=self.health,
            id=self.id,
            labels=self.labels,
            loggings=self.loggings,
            maintenance_windows=self.maintenance_windows,
            master_host_count=self.master_host_count,
            master_host_group_ids=self.master_host_group_ids,
            master_hosts=self.master_hosts,
            master_subclusters=self.master_subclusters,
            name=self.name,
            network_id=self.network_id,
            pooler_config=self.pooler_config,
            pxf_configs=self.pxf_configs,
            security_group_ids=self.security_group_ids,
            segment_host_count=self.segment_host_count,
            segment_host_group_ids=self.segment_host_group_ids,
            segment_hosts=self.segment_hosts,
            segment_in_host=self.segment_in_host,
            segment_subclusters=self.segment_subclusters,
            service_account_id=self.service_account_id,
            status=self.status,
            subnet_id=self.subnet_id,
            user_name=self.user_name,
            version=self.version,
            zone=self.zone)


def get_mdb_greenplum_cluster(background_activities: Optional[Sequence[Union['GetMdbGreenplumClusterBackgroundActivityArgs', 'GetMdbGreenplumClusterBackgroundActivityArgsDict']]] = None,
                              cluster_id: Optional[_builtins.str] = None,
                              folder_id: Optional[_builtins.str] = None,
                              greenplum_config: Optional[Mapping[str, _builtins.str]] = None,
                              master_host_group_ids: Optional[Sequence[_builtins.str]] = None,
                              name: Optional[_builtins.str] = None,
                              pooler_config: Optional[Union['GetMdbGreenplumClusterPoolerConfigArgs', 'GetMdbGreenplumClusterPoolerConfigArgsDict']] = None,
                              pxf_configs: Optional[Sequence[Union['GetMdbGreenplumClusterPxfConfigArgs', 'GetMdbGreenplumClusterPxfConfigArgsDict']]] = None,
                              segment_host_group_ids: Optional[Sequence[_builtins.str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbGreenplumClusterResult:
    """
    Get information about a Yandex Managed Greenplum cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-greenplum/).

    > Either `cluster_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB Greenplum Cluster.
    #
    foo = yandex.get_mdb_greenplum_cluster(name="test")
    pulumi.export("networkId", foo.network_id)
    ```


    :param _builtins.str cluster_id: The ID of the Greenplum cluster.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param Sequence[_builtins.str] master_host_group_ids: A list of IDs of the host groups to place master subclusters' VMs of the cluster on.
    :param _builtins.str name: The resource name.
    :param Sequence[_builtins.str] segment_host_group_ids: A list of IDs of the host groups to place segment subclusters' VMs of the cluster on.
    """
    __args__ = dict()
    __args__['backgroundActivities'] = background_activities
    __args__['clusterId'] = cluster_id
    __args__['folderId'] = folder_id
    __args__['greenplumConfig'] = greenplum_config
    __args__['masterHostGroupIds'] = master_host_group_ids
    __args__['name'] = name
    __args__['poolerConfig'] = pooler_config
    __args__['pxfConfigs'] = pxf_configs
    __args__['segmentHostGroupIds'] = segment_host_group_ids
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbGreenplumCluster:getMdbGreenplumCluster', __args__, opts=opts, typ=GetMdbGreenplumClusterResult).value

    return AwaitableGetMdbGreenplumClusterResult(
        accesses=pulumi.get(__ret__, 'accesses'),
        assign_public_ip=pulumi.get(__ret__, 'assign_public_ip'),
        background_activities=pulumi.get(__ret__, 'background_activities'),
        backup_window_starts=pulumi.get(__ret__, 'backup_window_starts'),
        cloud_storages=pulumi.get(__ret__, 'cloud_storages'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        environment=pulumi.get(__ret__, 'environment'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        greenplum_config=pulumi.get(__ret__, 'greenplum_config'),
        health=pulumi.get(__ret__, 'health'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        loggings=pulumi.get(__ret__, 'loggings'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        master_host_count=pulumi.get(__ret__, 'master_host_count'),
        master_host_group_ids=pulumi.get(__ret__, 'master_host_group_ids'),
        master_hosts=pulumi.get(__ret__, 'master_hosts'),
        master_subclusters=pulumi.get(__ret__, 'master_subclusters'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        pooler_config=pulumi.get(__ret__, 'pooler_config'),
        pxf_configs=pulumi.get(__ret__, 'pxf_configs'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        segment_host_count=pulumi.get(__ret__, 'segment_host_count'),
        segment_host_group_ids=pulumi.get(__ret__, 'segment_host_group_ids'),
        segment_hosts=pulumi.get(__ret__, 'segment_hosts'),
        segment_in_host=pulumi.get(__ret__, 'segment_in_host'),
        segment_subclusters=pulumi.get(__ret__, 'segment_subclusters'),
        service_account_id=pulumi.get(__ret__, 'service_account_id'),
        status=pulumi.get(__ret__, 'status'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        user_name=pulumi.get(__ret__, 'user_name'),
        version=pulumi.get(__ret__, 'version'),
        zone=pulumi.get(__ret__, 'zone'))
def get_mdb_greenplum_cluster_output(background_activities: Optional[pulumi.Input[Optional[Sequence[Union['GetMdbGreenplumClusterBackgroundActivityArgs', 'GetMdbGreenplumClusterBackgroundActivityArgsDict']]]]] = None,
                                     cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     greenplum_config: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                     master_host_group_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     pooler_config: Optional[pulumi.Input[Optional[Union['GetMdbGreenplumClusterPoolerConfigArgs', 'GetMdbGreenplumClusterPoolerConfigArgsDict']]]] = None,
                                     pxf_configs: Optional[pulumi.Input[Optional[Sequence[Union['GetMdbGreenplumClusterPxfConfigArgs', 'GetMdbGreenplumClusterPxfConfigArgsDict']]]]] = None,
                                     segment_host_group_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbGreenplumClusterResult]:
    """
    Get information about a Yandex Managed Greenplum cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-greenplum/).

    > Either `cluster_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB Greenplum Cluster.
    #
    foo = yandex.get_mdb_greenplum_cluster(name="test")
    pulumi.export("networkId", foo.network_id)
    ```


    :param _builtins.str cluster_id: The ID of the Greenplum cluster.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param Sequence[_builtins.str] master_host_group_ids: A list of IDs of the host groups to place master subclusters' VMs of the cluster on.
    :param _builtins.str name: The resource name.
    :param Sequence[_builtins.str] segment_host_group_ids: A list of IDs of the host groups to place segment subclusters' VMs of the cluster on.
    """
    __args__ = dict()
    __args__['backgroundActivities'] = background_activities
    __args__['clusterId'] = cluster_id
    __args__['folderId'] = folder_id
    __args__['greenplumConfig'] = greenplum_config
    __args__['masterHostGroupIds'] = master_host_group_ids
    __args__['name'] = name
    __args__['poolerConfig'] = pooler_config
    __args__['pxfConfigs'] = pxf_configs
    __args__['segmentHostGroupIds'] = segment_host_group_ids
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbGreenplumCluster:getMdbGreenplumCluster', __args__, opts=opts, typ=GetMdbGreenplumClusterResult)
    return __ret__.apply(lambda __response__: GetMdbGreenplumClusterResult(
        accesses=pulumi.get(__response__, 'accesses'),
        assign_public_ip=pulumi.get(__response__, 'assign_public_ip'),
        background_activities=pulumi.get(__response__, 'background_activities'),
        backup_window_starts=pulumi.get(__response__, 'backup_window_starts'),
        cloud_storages=pulumi.get(__response__, 'cloud_storages'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        environment=pulumi.get(__response__, 'environment'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        greenplum_config=pulumi.get(__response__, 'greenplum_config'),
        health=pulumi.get(__response__, 'health'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        loggings=pulumi.get(__response__, 'loggings'),
        maintenance_windows=pulumi.get(__response__, 'maintenance_windows'),
        master_host_count=pulumi.get(__response__, 'master_host_count'),
        master_host_group_ids=pulumi.get(__response__, 'master_host_group_ids'),
        master_hosts=pulumi.get(__response__, 'master_hosts'),
        master_subclusters=pulumi.get(__response__, 'master_subclusters'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        pooler_config=pulumi.get(__response__, 'pooler_config'),
        pxf_configs=pulumi.get(__response__, 'pxf_configs'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        segment_host_count=pulumi.get(__response__, 'segment_host_count'),
        segment_host_group_ids=pulumi.get(__response__, 'segment_host_group_ids'),
        segment_hosts=pulumi.get(__response__, 'segment_hosts'),
        segment_in_host=pulumi.get(__response__, 'segment_in_host'),
        segment_subclusters=pulumi.get(__response__, 'segment_subclusters'),
        service_account_id=pulumi.get(__response__, 'service_account_id'),
        status=pulumi.get(__response__, 'status'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        user_name=pulumi.get(__response__, 'user_name'),
        version=pulumi.get(__response__, 'version'),
        zone=pulumi.get(__response__, 'zone')))
