# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMdbKafkaTopicResult',
    'AwaitableGetMdbKafkaTopicResult',
    'get_mdb_kafka_topic',
    'get_mdb_kafka_topic_output',
]

@pulumi.output_type
class GetMdbKafkaTopicResult:
    """
    A collection of values returned by getMdbKafkaTopic.
    """
    def __init__(__self__, cluster_id=None, id=None, name=None, partitions=None, replication_factor=None, topic_configs=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partitions and not isinstance(partitions, int):
            raise TypeError("Expected argument 'partitions' to be a int")
        pulumi.set(__self__, "partitions", partitions)
        if replication_factor and not isinstance(replication_factor, int):
            raise TypeError("Expected argument 'replication_factor' to be a int")
        pulumi.set(__self__, "replication_factor", replication_factor)
        if topic_configs and not isinstance(topic_configs, list):
            raise TypeError("Expected argument 'topic_configs' to be a list")
        pulumi.set(__self__, "topic_configs", topic_configs)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> _builtins.int:
        """
        The number of the topic's partitions.
        """
        return pulumi.get(self, "partitions")

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> _builtins.int:
        """
        Amount of data copies (replicas) for the topic in the cluster.
        """
        return pulumi.get(self, "replication_factor")

    @_builtins.property
    @pulumi.getter(name="topicConfigs")
    def topic_configs(self) -> Sequence['outputs.GetMdbKafkaTopicTopicConfigResult']:
        """
        User-defined settings for the topic. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts/settings-list#topic-settings) and [the Kafka documentation](https://kafka.apache.org/documentation/#topicconfigs).
        """
        return pulumi.get(self, "topic_configs")


class AwaitableGetMdbKafkaTopicResult(GetMdbKafkaTopicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbKafkaTopicResult(
            cluster_id=self.cluster_id,
            id=self.id,
            name=self.name,
            partitions=self.partitions,
            replication_factor=self.replication_factor,
            topic_configs=self.topic_configs)


def get_mdb_kafka_topic(cluster_id: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbKafkaTopicResult:
    """
    Get information about a topic of the Yandex Managed Kafka cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB Kafka Topic.
    #
    foo = yandex.get_mdb_kafka_topic(cluster_id="some_cluster_id",
        name="test")
    pulumi.export("replicationFactor", foo.replication_factor)
    ```


    :param _builtins.str cluster_id: The ID of the Kafka cluster.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbKafkaTopic:getMdbKafkaTopic', __args__, opts=opts, typ=GetMdbKafkaTopicResult).value

    return AwaitableGetMdbKafkaTopicResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        partitions=pulumi.get(__ret__, 'partitions'),
        replication_factor=pulumi.get(__ret__, 'replication_factor'),
        topic_configs=pulumi.get(__ret__, 'topic_configs'))
def get_mdb_kafka_topic_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                               name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbKafkaTopicResult]:
    """
    Get information about a topic of the Yandex Managed Kafka cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB Kafka Topic.
    #
    foo = yandex.get_mdb_kafka_topic(cluster_id="some_cluster_id",
        name="test")
    pulumi.export("replicationFactor", foo.replication_factor)
    ```


    :param _builtins.str cluster_id: The ID of the Kafka cluster.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbKafkaTopic:getMdbKafkaTopic', __args__, opts=opts, typ=GetMdbKafkaTopicResult)
    return __ret__.apply(lambda __response__: GetMdbKafkaTopicResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        partitions=pulumi.get(__response__, 'partitions'),
        replication_factor=pulumi.get(__response__, 'replication_factor'),
        topic_configs=pulumi.get(__response__, 'topic_configs')))
