# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMdbKafkaUserResult',
    'AwaitableGetMdbKafkaUserResult',
    'get_mdb_kafka_user',
    'get_mdb_kafka_user_output',
]

@pulumi.output_type
class GetMdbKafkaUserResult:
    """
    A collection of values returned by getMdbKafkaUser.
    """
    def __init__(__self__, cluster_id=None, id=None, name=None, password=None, permissions=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.GetMdbKafkaUserPermissionResult']:
        """
        Set of permissions granted to the user.
        """
        return pulumi.get(self, "permissions")


class AwaitableGetMdbKafkaUserResult(GetMdbKafkaUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbKafkaUserResult(
            cluster_id=self.cluster_id,
            id=self.id,
            name=self.name,
            password=self.password,
            permissions=self.permissions)


def get_mdb_kafka_user(cluster_id: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbKafkaUserResult:
    """
    Get information about a user of the Yandex Managed Kafka cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB Kafka User.
    #
    my_user = yandex.get_mdb_kafka_user(cluster_id="some_cluster_id",
        name="test")
    pulumi.export("username", my_user.name)
    ```


    :param _builtins.str cluster_id: The ID of the Kafka cluster.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbKafkaUser:getMdbKafkaUser', __args__, opts=opts, typ=GetMdbKafkaUserResult).value

    return AwaitableGetMdbKafkaUserResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        password=pulumi.get(__ret__, 'password'),
        permissions=pulumi.get(__ret__, 'permissions'))
def get_mdb_kafka_user_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                              name: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbKafkaUserResult]:
    """
    Get information about a user of the Yandex Managed Kafka cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB Kafka User.
    #
    my_user = yandex.get_mdb_kafka_user(cluster_id="some_cluster_id",
        name="test")
    pulumi.export("username", my_user.name)
    ```


    :param _builtins.str cluster_id: The ID of the Kafka cluster.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbKafkaUser:getMdbKafkaUser', __args__, opts=opts, typ=GetMdbKafkaUserResult)
    return __ret__.apply(lambda __response__: GetMdbKafkaUserResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        password=pulumi.get(__response__, 'password'),
        permissions=pulumi.get(__response__, 'permissions')))
