# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMdbMysqlUserResult',
    'AwaitableGetMdbMysqlUserResult',
    'get_mdb_mysql_user',
    'get_mdb_mysql_user_output',
]

@pulumi.output_type
class GetMdbMysqlUserResult:
    """
    A collection of values returned by getMdbMysqlUser.
    """
    def __init__(__self__, authentication_plugin=None, cluster_id=None, connection_limits=None, connection_manager=None, global_permissions=None, id=None, name=None, permissions=None):
        if authentication_plugin and not isinstance(authentication_plugin, str):
            raise TypeError("Expected argument 'authentication_plugin' to be a str")
        pulumi.set(__self__, "authentication_plugin", authentication_plugin)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if connection_limits and not isinstance(connection_limits, list):
            raise TypeError("Expected argument 'connection_limits' to be a list")
        pulumi.set(__self__, "connection_limits", connection_limits)
        if connection_manager and not isinstance(connection_manager, dict):
            raise TypeError("Expected argument 'connection_manager' to be a dict")
        pulumi.set(__self__, "connection_manager", connection_manager)
        if global_permissions and not isinstance(global_permissions, list):
            raise TypeError("Expected argument 'global_permissions' to be a list")
        pulumi.set(__self__, "global_permissions", global_permissions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="authenticationPlugin")
    def authentication_plugin(self) -> _builtins.str:
        """
        Authentication plugin. Allowed values: `MYSQL_NATIVE_PASSWORD`, `CACHING_SHA2_PASSWORD`, `SHA256_PASSWORD` (for version 5.7 `MYSQL_NATIVE_PASSWORD`, `SHA256_PASSWORD`)
        """
        return pulumi.get(self, "authentication_plugin")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the MySQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="connectionLimits")
    def connection_limits(self) -> Sequence['outputs.GetMdbMysqlUserConnectionLimitResult']:
        return pulumi.get(self, "connection_limits")

    @_builtins.property
    @pulumi.getter(name="connectionManager")
    def connection_manager(self) -> Mapping[str, _builtins.str]:
        """
        Connection Manager connection configuration. Filled in by the server automatically.
        """
        return pulumi.get(self, "connection_manager")

    @_builtins.property
    @pulumi.getter(name="globalPermissions")
    def global_permissions(self) -> Sequence[_builtins.str]:
        """
        List user's global permissions. Allowed permissions: `REPLICATION_CLIENT`, `REPLICATION_SLAVE`, `PROCESS`, `FLUSH_OPTIMIZER_COSTS`, `SHOW_ROUTINE`, `MDB_ADMIN` for clear list use empty list. If the attribute is not specified there will be no changes.
        """
        return pulumi.get(self, "global_permissions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the MySQL user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.GetMdbMysqlUserPermissionResult']:
        return pulumi.get(self, "permissions")


class AwaitableGetMdbMysqlUserResult(GetMdbMysqlUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbMysqlUserResult(
            authentication_plugin=self.authentication_plugin,
            cluster_id=self.cluster_id,
            connection_limits=self.connection_limits,
            connection_manager=self.connection_manager,
            global_permissions=self.global_permissions,
            id=self.id,
            name=self.name,
            permissions=self.permissions)


def get_mdb_mysql_user(cluster_id: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       permissions: Optional[Sequence[Union['GetMdbMysqlUserPermissionArgs', 'GetMdbMysqlUserPermissionArgsDict']]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbMysqlUserResult:
    """
    Get information about a Yandex Managed MySQL user. For more information, see [the official documentation](https://yandex.cloud/docs/managed-mysql/).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB MySQL Database User.
    #
    my_user = yandex.get_mdb_mysql_user(cluster_id="some_cluster_id",
        name="test")
    pulumi.export("permission", foo["permission"])
    ```


    :param _builtins.str cluster_id: The ID of the MySQL cluster.
    :param _builtins.str name: The name of the MySQL user.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['permissions'] = permissions
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbMysqlUser:getMdbMysqlUser', __args__, opts=opts, typ=GetMdbMysqlUserResult).value

    return AwaitableGetMdbMysqlUserResult(
        authentication_plugin=pulumi.get(__ret__, 'authentication_plugin'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        connection_limits=pulumi.get(__ret__, 'connection_limits'),
        connection_manager=pulumi.get(__ret__, 'connection_manager'),
        global_permissions=pulumi.get(__ret__, 'global_permissions'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        permissions=pulumi.get(__ret__, 'permissions'))
def get_mdb_mysql_user_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                              name: Optional[pulumi.Input[_builtins.str]] = None,
                              permissions: Optional[pulumi.Input[Optional[Sequence[Union['GetMdbMysqlUserPermissionArgs', 'GetMdbMysqlUserPermissionArgsDict']]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbMysqlUserResult]:
    """
    Get information about a Yandex Managed MySQL user. For more information, see [the official documentation](https://yandex.cloud/docs/managed-mysql/).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB MySQL Database User.
    #
    my_user = yandex.get_mdb_mysql_user(cluster_id="some_cluster_id",
        name="test")
    pulumi.export("permission", foo["permission"])
    ```


    :param _builtins.str cluster_id: The ID of the MySQL cluster.
    :param _builtins.str name: The name of the MySQL user.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['permissions'] = permissions
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbMysqlUser:getMdbMysqlUser', __args__, opts=opts, typ=GetMdbMysqlUserResult)
    return __ret__.apply(lambda __response__: GetMdbMysqlUserResult(
        authentication_plugin=pulumi.get(__response__, 'authentication_plugin'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        connection_limits=pulumi.get(__response__, 'connection_limits'),
        connection_manager=pulumi.get(__response__, 'connection_manager'),
        global_permissions=pulumi.get(__response__, 'global_permissions'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        permissions=pulumi.get(__response__, 'permissions')))
