# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMdbPostgresqlClusterResult',
    'AwaitableGetMdbPostgresqlClusterResult',
    'get_mdb_postgresql_cluster',
    'get_mdb_postgresql_cluster_output',
]

@pulumi.output_type
class GetMdbPostgresqlClusterResult:
    """
    A collection of values returned by getMdbPostgresqlCluster.
    """
    def __init__(__self__, cluster_id=None, configs=None, created_at=None, databases=None, deletion_protection=None, description=None, disk_encryption_key_id=None, environment=None, folder_id=None, health=None, host_group_ids=None, hosts=None, id=None, labels=None, maintenance_windows=None, name=None, network_id=None, security_group_ids=None, status=None, users=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disk_encryption_key_id and not isinstance(disk_encryption_key_id, str):
            raise TypeError("Expected argument 'disk_encryption_key_id' to be a str")
        pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if health and not isinstance(health, str):
            raise TypeError("Expected argument 'health' to be a str")
        pulumi.set(__self__, "health", health)
        if host_group_ids and not isinstance(host_group_ids, list):
            raise TypeError("Expected argument 'host_group_ids' to be a list")
        pulumi.set(__self__, "host_group_ids", host_group_ids)
        if hosts and not isinstance(hosts, list):
            raise TypeError("Expected argument 'hosts' to be a list")
        pulumi.set(__self__, "hosts", hosts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the PostgreSQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetMdbPostgresqlClusterConfigResult']:
        """
        Configuration of the PostgreSQL cluster.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetMdbPostgresqlClusterDatabaseResult']:
        """
        > Deprecated! To manage databases, please switch to using a separate resource type `MdbPostgresqlDatabase`.
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> _builtins.str:
        """
        ID of the KMS key for cluster disk encryption.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> _builtins.str:
        """
        Deployment environment of the PostgreSQL cluster.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> _builtins.str:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Sequence[_builtins.str]:
        """
        Host Group IDs.
        """
        return pulumi.get(self, "host_group_ids")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Sequence['outputs.GetMdbPostgresqlClusterHostResult']:
        """
        A host of the PostgreSQL cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetMdbPostgresqlClusterMaintenanceWindowResult']:
        """
        Maintenance policy of the PostgreSQL cluster.
        """
        return pulumi.get(self, "maintenance_windows")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the PostgreSQL cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetMdbPostgresqlClusterUserResult']:
        """
        > Deprecated! To manage users, please switch to using a separate resource type `MdbPostgresqlUser`.
        """
        return pulumi.get(self, "users")


class AwaitableGetMdbPostgresqlClusterResult(GetMdbPostgresqlClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbPostgresqlClusterResult(
            cluster_id=self.cluster_id,
            configs=self.configs,
            created_at=self.created_at,
            databases=self.databases,
            deletion_protection=self.deletion_protection,
            description=self.description,
            disk_encryption_key_id=self.disk_encryption_key_id,
            environment=self.environment,
            folder_id=self.folder_id,
            health=self.health,
            host_group_ids=self.host_group_ids,
            hosts=self.hosts,
            id=self.id,
            labels=self.labels,
            maintenance_windows=self.maintenance_windows,
            name=self.name,
            network_id=self.network_id,
            security_group_ids=self.security_group_ids,
            status=self.status,
            users=self.users)


def get_mdb_postgresql_cluster(cluster_id: Optional[_builtins.str] = None,
                               deletion_protection: Optional[_builtins.bool] = None,
                               description: Optional[_builtins.str] = None,
                               disk_encryption_key_id: Optional[_builtins.str] = None,
                               folder_id: Optional[_builtins.str] = None,
                               name: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbPostgresqlClusterResult:
    """
    Get information about a Yandex Managed PostgreSQL cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-postgresql/). [How to connect to the DB](https://yandex.cloud/docs/managed-postgresql/quickstart#connect). To connect, use port 6432. The port number is not configurable.

    > Either `cluster_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB PostgreSQL Cluster.
    #
    my_cluster = yandex.get_mdb_postgresql_cluster(name="test")
    pulumi.export("fqdn", my_cluster.hosts[0].fqdn)
    ```


    :param _builtins.str cluster_id: The ID of the PostgreSQL cluster.
    :param _builtins.bool deletion_protection: The `true` value means that resource is protected from accidental deletion.
    :param _builtins.str description: The resource description.
    :param _builtins.str disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The name of the PostgreSQL cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['deletionProtection'] = deletion_protection
    __args__['description'] = description
    __args__['diskEncryptionKeyId'] = disk_encryption_key_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbPostgresqlCluster:getMdbPostgresqlCluster', __args__, opts=opts, typ=GetMdbPostgresqlClusterResult).value

    return AwaitableGetMdbPostgresqlClusterResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        configs=pulumi.get(__ret__, 'configs'),
        created_at=pulumi.get(__ret__, 'created_at'),
        databases=pulumi.get(__ret__, 'databases'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        disk_encryption_key_id=pulumi.get(__ret__, 'disk_encryption_key_id'),
        environment=pulumi.get(__ret__, 'environment'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        health=pulumi.get(__ret__, 'health'),
        host_group_ids=pulumi.get(__ret__, 'host_group_ids'),
        hosts=pulumi.get(__ret__, 'hosts'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        status=pulumi.get(__ret__, 'status'),
        users=pulumi.get(__ret__, 'users'))
def get_mdb_postgresql_cluster_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      deletion_protection: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                      description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      disk_encryption_key_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbPostgresqlClusterResult]:
    """
    Get information about a Yandex Managed PostgreSQL cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-postgresql/). [How to connect to the DB](https://yandex.cloud/docs/managed-postgresql/quickstart#connect). To connect, use port 6432. The port number is not configurable.

    > Either `cluster_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB PostgreSQL Cluster.
    #
    my_cluster = yandex.get_mdb_postgresql_cluster(name="test")
    pulumi.export("fqdn", my_cluster.hosts[0].fqdn)
    ```


    :param _builtins.str cluster_id: The ID of the PostgreSQL cluster.
    :param _builtins.bool deletion_protection: The `true` value means that resource is protected from accidental deletion.
    :param _builtins.str description: The resource description.
    :param _builtins.str disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The name of the PostgreSQL cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['deletionProtection'] = deletion_protection
    __args__['description'] = description
    __args__['diskEncryptionKeyId'] = disk_encryption_key_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbPostgresqlCluster:getMdbPostgresqlCluster', __args__, opts=opts, typ=GetMdbPostgresqlClusterResult)
    return __ret__.apply(lambda __response__: GetMdbPostgresqlClusterResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        configs=pulumi.get(__response__, 'configs'),
        created_at=pulumi.get(__response__, 'created_at'),
        databases=pulumi.get(__response__, 'databases'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        disk_encryption_key_id=pulumi.get(__response__, 'disk_encryption_key_id'),
        environment=pulumi.get(__response__, 'environment'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        health=pulumi.get(__response__, 'health'),
        host_group_ids=pulumi.get(__response__, 'host_group_ids'),
        hosts=pulumi.get(__response__, 'hosts'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        maintenance_windows=pulumi.get(__response__, 'maintenance_windows'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        status=pulumi.get(__response__, 'status'),
        users=pulumi.get(__response__, 'users')))
