# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMdbPostgresqlDatabaseResult',
    'AwaitableGetMdbPostgresqlDatabaseResult',
    'get_mdb_postgresql_database',
    'get_mdb_postgresql_database_output',
]

@pulumi.output_type
class GetMdbPostgresqlDatabaseResult:
    """
    A collection of values returned by getMdbPostgresqlDatabase.
    """
    def __init__(__self__, cluster_id=None, deletion_protection=None, extensions=None, id=None, lc_collate=None, lc_type=None, name=None, owner=None, template_db=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if deletion_protection and not isinstance(deletion_protection, str):
            raise TypeError("Expected argument 'deletion_protection' to be a str")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if extensions and not isinstance(extensions, list):
            raise TypeError("Expected argument 'extensions' to be a list")
        pulumi.set(__self__, "extensions", extensions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lc_collate and not isinstance(lc_collate, str):
            raise TypeError("Expected argument 'lc_collate' to be a str")
        pulumi.set(__self__, "lc_collate", lc_collate)
        if lc_type and not isinstance(lc_type, str):
            raise TypeError("Expected argument 'lc_type' to be a str")
        pulumi.set(__self__, "lc_type", lc_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if template_db and not isinstance(template_db, str):
            raise TypeError("Expected argument 'template_db' to be a str")
        pulumi.set(__self__, "template_db", template_db)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the PostgreSQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[_builtins.str]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.GetMdbPostgresqlDatabaseExtensionResult']]:
        """
        Set of database extensions.
        """
        return pulumi.get(self, "extensions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lcCollate")
    def lc_collate(self) -> _builtins.str:
        """
        POSIX locale for string sorting order. Forbidden to change in an existing database.
        """
        return pulumi.get(self, "lc_collate")

    @_builtins.property
    @pulumi.getter(name="lcType")
    def lc_type(self) -> _builtins.str:
        """
        POSIX locale for character classification. Forbidden to change in an existing database.
        """
        return pulumi.get(self, "lc_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        Name of the user assigned as the owner of the database. Forbidden to change in an existing database.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="templateDb")
    def template_db(self) -> _builtins.str:
        """
        Name of the template database.
        """
        return pulumi.get(self, "template_db")


class AwaitableGetMdbPostgresqlDatabaseResult(GetMdbPostgresqlDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbPostgresqlDatabaseResult(
            cluster_id=self.cluster_id,
            deletion_protection=self.deletion_protection,
            extensions=self.extensions,
            id=self.id,
            lc_collate=self.lc_collate,
            lc_type=self.lc_type,
            name=self.name,
            owner=self.owner,
            template_db=self.template_db)


def get_mdb_postgresql_database(cluster_id: Optional[_builtins.str] = None,
                                deletion_protection: Optional[_builtins.str] = None,
                                extensions: Optional[Sequence[Union['GetMdbPostgresqlDatabaseExtensionArgs', 'GetMdbPostgresqlDatabaseExtensionArgsDict']]] = None,
                                lc_collate: Optional[_builtins.str] = None,
                                lc_type: Optional[_builtins.str] = None,
                                name: Optional[_builtins.str] = None,
                                owner: Optional[_builtins.str] = None,
                                template_db: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbPostgresqlDatabaseResult:
    """
    Get information about a Yandex Managed PostgreSQL database. For more information, see [the official documentation](https://yandex.cloud/docs/managed-postgresql/).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB PostgreSQL Database.
    #
    foo = yandex.get_mdb_postgresql_database(cluster_id="some_cluster_id",
        name="test")
    pulumi.export("owner", foo.owner)
    ```


    :param _builtins.str cluster_id: The ID of the PostgreSQL cluster.
    :param _builtins.str deletion_protection: The `true` value means that resource is protected from accidental deletion.
    :param Sequence[Union['GetMdbPostgresqlDatabaseExtensionArgs', 'GetMdbPostgresqlDatabaseExtensionArgsDict']] extensions: Set of database extensions.
    :param _builtins.str lc_collate: POSIX locale for string sorting order. Forbidden to change in an existing database.
    :param _builtins.str lc_type: POSIX locale for character classification. Forbidden to change in an existing database.
    :param _builtins.str name: The resource name.
    :param _builtins.str owner: Name of the user assigned as the owner of the database. Forbidden to change in an existing database.
    :param _builtins.str template_db: Name of the template database.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['deletionProtection'] = deletion_protection
    __args__['extensions'] = extensions
    __args__['lcCollate'] = lc_collate
    __args__['lcType'] = lc_type
    __args__['name'] = name
    __args__['owner'] = owner
    __args__['templateDb'] = template_db
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbPostgresqlDatabase:getMdbPostgresqlDatabase', __args__, opts=opts, typ=GetMdbPostgresqlDatabaseResult).value

    return AwaitableGetMdbPostgresqlDatabaseResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        extensions=pulumi.get(__ret__, 'extensions'),
        id=pulumi.get(__ret__, 'id'),
        lc_collate=pulumi.get(__ret__, 'lc_collate'),
        lc_type=pulumi.get(__ret__, 'lc_type'),
        name=pulumi.get(__ret__, 'name'),
        owner=pulumi.get(__ret__, 'owner'),
        template_db=pulumi.get(__ret__, 'template_db'))
def get_mdb_postgresql_database_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       deletion_protection: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       extensions: Optional[pulumi.Input[Optional[Sequence[Union['GetMdbPostgresqlDatabaseExtensionArgs', 'GetMdbPostgresqlDatabaseExtensionArgsDict']]]]] = None,
                                       lc_collate: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       lc_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       name: Optional[pulumi.Input[_builtins.str]] = None,
                                       owner: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       template_db: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbPostgresqlDatabaseResult]:
    """
    Get information about a Yandex Managed PostgreSQL database. For more information, see [the official documentation](https://yandex.cloud/docs/managed-postgresql/).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB PostgreSQL Database.
    #
    foo = yandex.get_mdb_postgresql_database(cluster_id="some_cluster_id",
        name="test")
    pulumi.export("owner", foo.owner)
    ```


    :param _builtins.str cluster_id: The ID of the PostgreSQL cluster.
    :param _builtins.str deletion_protection: The `true` value means that resource is protected from accidental deletion.
    :param Sequence[Union['GetMdbPostgresqlDatabaseExtensionArgs', 'GetMdbPostgresqlDatabaseExtensionArgsDict']] extensions: Set of database extensions.
    :param _builtins.str lc_collate: POSIX locale for string sorting order. Forbidden to change in an existing database.
    :param _builtins.str lc_type: POSIX locale for character classification. Forbidden to change in an existing database.
    :param _builtins.str name: The resource name.
    :param _builtins.str owner: Name of the user assigned as the owner of the database. Forbidden to change in an existing database.
    :param _builtins.str template_db: Name of the template database.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['deletionProtection'] = deletion_protection
    __args__['extensions'] = extensions
    __args__['lcCollate'] = lc_collate
    __args__['lcType'] = lc_type
    __args__['name'] = name
    __args__['owner'] = owner
    __args__['templateDb'] = template_db
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbPostgresqlDatabase:getMdbPostgresqlDatabase', __args__, opts=opts, typ=GetMdbPostgresqlDatabaseResult)
    return __ret__.apply(lambda __response__: GetMdbPostgresqlDatabaseResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        extensions=pulumi.get(__response__, 'extensions'),
        id=pulumi.get(__response__, 'id'),
        lc_collate=pulumi.get(__response__, 'lc_collate'),
        lc_type=pulumi.get(__response__, 'lc_type'),
        name=pulumi.get(__response__, 'name'),
        owner=pulumi.get(__response__, 'owner'),
        template_db=pulumi.get(__response__, 'template_db')))
