# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetResourcemanagerFolderResult',
    'AwaitableGetResourcemanagerFolderResult',
    'get_resourcemanager_folder',
    'get_resourcemanager_folder_output',
]

@pulumi.output_type
class GetResourcemanagerFolderResult:
    """
    A collection of values returned by getResourcemanagerFolder.
    """
    def __init__(__self__, cloud_id=None, created_at=None, description=None, folder_id=None, id=None, labels=None, name=None, status=None):
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> _builtins.str:
        """
        Cloud that the resource belongs to. If value is omitted, the default provider cloud is used.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        ID of the folder.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Current status of the folder.
        """
        return pulumi.get(self, "status")


class AwaitableGetResourcemanagerFolderResult(GetResourcemanagerFolderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourcemanagerFolderResult(
            cloud_id=self.cloud_id,
            created_at=self.created_at,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            status=self.status)


def get_resourcemanager_folder(cloud_id: Optional[_builtins.str] = None,
                               folder_id: Optional[_builtins.str] = None,
                               labels: Optional[Mapping[str, _builtins.str]] = None,
                               name: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourcemanagerFolderResult:
    """
    Use this data source to get information about a Yandex Resource Manager Folder. For more information, see [the official documentation](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#folder).

    > Either `folder_id` or `name` must be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Folder.
    #
    my_folder1 = yandex.get_resourcemanager_folder(folder_id="folder_id_number_1")
    # Get folder by name in specific cloud
    my_folder2 = yandex.get_resourcemanager_folder(name="folder_name",
        cloud_id="some_cloud_id")
    pulumi.export("myFolder1Name", my_folder1.name)
    pulumi.export("myFolder2CloudId", my_folder2.cloud_id)
    ```


    :param _builtins.str cloud_id: Cloud that the resource belongs to. If value is omitted, the default provider cloud is used.
    :param _builtins.str folder_id: ID of the folder.
    :param Mapping[str, _builtins.str] labels: A set of key/value label pairs which assigned to resource.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getResourcemanagerFolder:getResourcemanagerFolder', __args__, opts=opts, typ=GetResourcemanagerFolderResult).value

    return AwaitableGetResourcemanagerFolderResult(
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'))
def get_resourcemanager_folder_output(cloud_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      labels: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourcemanagerFolderResult]:
    """
    Use this data source to get information about a Yandex Resource Manager Folder. For more information, see [the official documentation](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#folder).

    > Either `folder_id` or `name` must be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Folder.
    #
    my_folder1 = yandex.get_resourcemanager_folder(folder_id="folder_id_number_1")
    # Get folder by name in specific cloud
    my_folder2 = yandex.get_resourcemanager_folder(name="folder_name",
        cloud_id="some_cloud_id")
    pulumi.export("myFolder1Name", my_folder1.name)
    pulumi.export("myFolder2CloudId", my_folder2.cloud_id)
    ```


    :param _builtins.str cloud_id: Cloud that the resource belongs to. If value is omitted, the default provider cloud is used.
    :param _builtins.str folder_id: ID of the folder.
    :param Mapping[str, _builtins.str] labels: A set of key/value label pairs which assigned to resource.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getResourcemanagerFolder:getResourcemanagerFolder', __args__, opts=opts, typ=GetResourcemanagerFolderResult)
    return __ret__.apply(lambda __response__: GetResourcemanagerFolderResult(
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status')))
