# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServerlessEventrouterConnectorResult',
    'AwaitableGetServerlessEventrouterConnectorResult',
    'get_serverless_eventrouter_connector',
    'get_serverless_eventrouter_connector_output',
]

@pulumi.output_type
class GetServerlessEventrouterConnectorResult:
    """
    A collection of values returned by getServerlessEventrouterConnector.
    """
    def __init__(__self__, bus_id=None, cloud_id=None, connector_id=None, created_at=None, deletion_protection=None, description=None, folder_id=None, id=None, labels=None, name=None, timers=None, yds=None, ymqs=None):
        if bus_id and not isinstance(bus_id, str):
            raise TypeError("Expected argument 'bus_id' to be a str")
        pulumi.set(__self__, "bus_id", bus_id)
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if connector_id and not isinstance(connector_id, str):
            raise TypeError("Expected argument 'connector_id' to be a str")
        pulumi.set(__self__, "connector_id", connector_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if timers and not isinstance(timers, list):
            raise TypeError("Expected argument 'timers' to be a list")
        pulumi.set(__self__, "timers", timers)
        if yds and not isinstance(yds, list):
            raise TypeError("Expected argument 'yds' to be a list")
        pulumi.set(__self__, "yds", yds)
        if ymqs and not isinstance(ymqs, list):
            raise TypeError("Expected argument 'ymqs' to be a list")
        pulumi.set(__self__, "ymqs", ymqs)

    @_builtins.property
    @pulumi.getter(name="busId")
    def bus_id(self) -> _builtins.str:
        """
        ID of the bus that the connector belongs to
        """
        return pulumi.get(self, "bus_id")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> _builtins.str:
        """
        ID of the cloud that the connector resides in
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[_builtins.str]:
        """
        ID of the connector
        """
        return pulumi.get(self, "connector_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        Deletion protection
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the connector
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        ID of the folder that the connector resides in
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Connector labels
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the connector
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def timers(self) -> Sequence['outputs.GetServerlessEventrouterConnectorTimerResult']:
        """
        Timer source of the connector.
        """
        return pulumi.get(self, "timers")

    @_builtins.property
    @pulumi.getter
    def yds(self) -> Sequence['outputs.GetServerlessEventrouterConnectorYdResult']:
        """
        Data Stream source of the connector.
        """
        return pulumi.get(self, "yds")

    @_builtins.property
    @pulumi.getter
    def ymqs(self) -> Sequence['outputs.GetServerlessEventrouterConnectorYmqResult']:
        """
        Message Queue source of the connector.
        """
        return pulumi.get(self, "ymqs")


class AwaitableGetServerlessEventrouterConnectorResult(GetServerlessEventrouterConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerlessEventrouterConnectorResult(
            bus_id=self.bus_id,
            cloud_id=self.cloud_id,
            connector_id=self.connector_id,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            timers=self.timers,
            yds=self.yds,
            ymqs=self.ymqs)


def get_serverless_eventrouter_connector(connector_id: Optional[_builtins.str] = None,
                                         name: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerlessEventrouterConnectorResult:
    """
    Get information about Serverless Event Router Connector.

    ## Example Usage

    ```python
    import pulumi
    ```


    :param _builtins.str connector_id: ID of the connector
    :param _builtins.str name: Name of the connector
    """
    __args__ = dict()
    __args__['connectorId'] = connector_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getServerlessEventrouterConnector:getServerlessEventrouterConnector', __args__, opts=opts, typ=GetServerlessEventrouterConnectorResult).value

    return AwaitableGetServerlessEventrouterConnectorResult(
        bus_id=pulumi.get(__ret__, 'bus_id'),
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        connector_id=pulumi.get(__ret__, 'connector_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        timers=pulumi.get(__ret__, 'timers'),
        yds=pulumi.get(__ret__, 'yds'),
        ymqs=pulumi.get(__ret__, 'ymqs'))
def get_serverless_eventrouter_connector_output(connector_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerlessEventrouterConnectorResult]:
    """
    Get information about Serverless Event Router Connector.

    ## Example Usage

    ```python
    import pulumi
    ```


    :param _builtins.str connector_id: ID of the connector
    :param _builtins.str name: Name of the connector
    """
    __args__ = dict()
    __args__['connectorId'] = connector_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getServerlessEventrouterConnector:getServerlessEventrouterConnector', __args__, opts=opts, typ=GetServerlessEventrouterConnectorResult)
    return __ret__.apply(lambda __response__: GetServerlessEventrouterConnectorResult(
        bus_id=pulumi.get(__response__, 'bus_id'),
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        connector_id=pulumi.get(__response__, 'connector_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        timers=pulumi.get(__response__, 'timers'),
        yds=pulumi.get(__response__, 'yds'),
        ymqs=pulumi.get(__response__, 'ymqs')))
