# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServerlessEventrouterRuleResult',
    'AwaitableGetServerlessEventrouterRuleResult',
    'get_serverless_eventrouter_rule',
    'get_serverless_eventrouter_rule_output',
]

@pulumi.output_type
class GetServerlessEventrouterRuleResult:
    """
    A collection of values returned by getServerlessEventrouterRule.
    """
    def __init__(__self__, bus_id=None, cloud_id=None, containers=None, created_at=None, deletion_protection=None, description=None, folder_id=None, functions=None, gateway_websocket_broadcasts=None, id=None, jq_filter=None, labels=None, loggings=None, name=None, rule_id=None, workflows=None, yds=None, ymqs=None):
        if bus_id and not isinstance(bus_id, str):
            raise TypeError("Expected argument 'bus_id' to be a str")
        pulumi.set(__self__, "bus_id", bus_id)
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if containers and not isinstance(containers, list):
            raise TypeError("Expected argument 'containers' to be a list")
        pulumi.set(__self__, "containers", containers)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if functions and not isinstance(functions, list):
            raise TypeError("Expected argument 'functions' to be a list")
        pulumi.set(__self__, "functions", functions)
        if gateway_websocket_broadcasts and not isinstance(gateway_websocket_broadcasts, list):
            raise TypeError("Expected argument 'gateway_websocket_broadcasts' to be a list")
        pulumi.set(__self__, "gateway_websocket_broadcasts", gateway_websocket_broadcasts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jq_filter and not isinstance(jq_filter, str):
            raise TypeError("Expected argument 'jq_filter' to be a str")
        pulumi.set(__self__, "jq_filter", jq_filter)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if loggings and not isinstance(loggings, list):
            raise TypeError("Expected argument 'loggings' to be a list")
        pulumi.set(__self__, "loggings", loggings)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rule_id and not isinstance(rule_id, str):
            raise TypeError("Expected argument 'rule_id' to be a str")
        pulumi.set(__self__, "rule_id", rule_id)
        if workflows and not isinstance(workflows, list):
            raise TypeError("Expected argument 'workflows' to be a list")
        pulumi.set(__self__, "workflows", workflows)
        if yds and not isinstance(yds, list):
            raise TypeError("Expected argument 'yds' to be a list")
        pulumi.set(__self__, "yds", yds)
        if ymqs and not isinstance(ymqs, list):
            raise TypeError("Expected argument 'ymqs' to be a list")
        pulumi.set(__self__, "ymqs", ymqs)

    @_builtins.property
    @pulumi.getter(name="busId")
    def bus_id(self) -> _builtins.str:
        """
        ID of the bus that the rule belongs to
        """
        return pulumi.get(self, "bus_id")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> _builtins.str:
        """
        ID of the cloud that the rule resides in
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetServerlessEventrouterRuleContainerResult']:
        """
        ContainerTarget
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        Deletion protection
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        ID of the folder that the rule resides in
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def functions(self) -> Sequence['outputs.GetServerlessEventrouterRuleFunctionResult']:
        """
        FunctionTarget
        """
        return pulumi.get(self, "functions")

    @_builtins.property
    @pulumi.getter(name="gatewayWebsocketBroadcasts")
    def gateway_websocket_broadcasts(self) -> Sequence['outputs.GetServerlessEventrouterRuleGatewayWebsocketBroadcastResult']:
        """
        GatewayWebsocketBroadcastTarget
        """
        return pulumi.get(self, "gateway_websocket_broadcasts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jqFilter")
    def jq_filter(self) -> _builtins.str:
        """
        JQ filter for matching events
        """
        return pulumi.get(self, "jq_filter")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Rule labels
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def loggings(self) -> Sequence['outputs.GetServerlessEventrouterRuleLoggingResult']:
        """
        LoggingTarget. Includes either log*group*id or folder_id
        """
        return pulumi.get(self, "loggings")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[_builtins.str]:
        """
        ID of the bus that the rule belongs to
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter
    def workflows(self) -> Sequence['outputs.GetServerlessEventrouterRuleWorkflowResult']:
        """
        WorkflowTarget
        """
        return pulumi.get(self, "workflows")

    @_builtins.property
    @pulumi.getter
    def yds(self) -> Sequence['outputs.GetServerlessEventrouterRuleYdResult']:
        """
        YdsTarget
        """
        return pulumi.get(self, "yds")

    @_builtins.property
    @pulumi.getter
    def ymqs(self) -> Sequence['outputs.GetServerlessEventrouterRuleYmqResult']:
        """
        YmqTarget
        """
        return pulumi.get(self, "ymqs")


class AwaitableGetServerlessEventrouterRuleResult(GetServerlessEventrouterRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerlessEventrouterRuleResult(
            bus_id=self.bus_id,
            cloud_id=self.cloud_id,
            containers=self.containers,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            description=self.description,
            folder_id=self.folder_id,
            functions=self.functions,
            gateway_websocket_broadcasts=self.gateway_websocket_broadcasts,
            id=self.id,
            jq_filter=self.jq_filter,
            labels=self.labels,
            loggings=self.loggings,
            name=self.name,
            rule_id=self.rule_id,
            workflows=self.workflows,
            yds=self.yds,
            ymqs=self.ymqs)


def get_serverless_eventrouter_rule(name: Optional[_builtins.str] = None,
                                    rule_id: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerlessEventrouterRuleResult:
    """
    Get information about Serverless Event Router Rule.

    ## Example Usage

    ```python
    import pulumi
    ```


    :param _builtins.str name: Name of the rule
    :param _builtins.str rule_id: ID of the bus that the rule belongs to
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['ruleId'] = rule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getServerlessEventrouterRule:getServerlessEventrouterRule', __args__, opts=opts, typ=GetServerlessEventrouterRuleResult).value

    return AwaitableGetServerlessEventrouterRuleResult(
        bus_id=pulumi.get(__ret__, 'bus_id'),
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        containers=pulumi.get(__ret__, 'containers'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        functions=pulumi.get(__ret__, 'functions'),
        gateway_websocket_broadcasts=pulumi.get(__ret__, 'gateway_websocket_broadcasts'),
        id=pulumi.get(__ret__, 'id'),
        jq_filter=pulumi.get(__ret__, 'jq_filter'),
        labels=pulumi.get(__ret__, 'labels'),
        loggings=pulumi.get(__ret__, 'loggings'),
        name=pulumi.get(__ret__, 'name'),
        rule_id=pulumi.get(__ret__, 'rule_id'),
        workflows=pulumi.get(__ret__, 'workflows'),
        yds=pulumi.get(__ret__, 'yds'),
        ymqs=pulumi.get(__ret__, 'ymqs'))
def get_serverless_eventrouter_rule_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           rule_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerlessEventrouterRuleResult]:
    """
    Get information about Serverless Event Router Rule.

    ## Example Usage

    ```python
    import pulumi
    ```


    :param _builtins.str name: Name of the rule
    :param _builtins.str rule_id: ID of the bus that the rule belongs to
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['ruleId'] = rule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getServerlessEventrouterRule:getServerlessEventrouterRule', __args__, opts=opts, typ=GetServerlessEventrouterRuleResult)
    return __ret__.apply(lambda __response__: GetServerlessEventrouterRuleResult(
        bus_id=pulumi.get(__response__, 'bus_id'),
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        containers=pulumi.get(__response__, 'containers'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        functions=pulumi.get(__response__, 'functions'),
        gateway_websocket_broadcasts=pulumi.get(__response__, 'gateway_websocket_broadcasts'),
        id=pulumi.get(__response__, 'id'),
        jq_filter=pulumi.get(__response__, 'jq_filter'),
        labels=pulumi.get(__response__, 'labels'),
        loggings=pulumi.get(__response__, 'loggings'),
        name=pulumi.get(__response__, 'name'),
        rule_id=pulumi.get(__response__, 'rule_id'),
        workflows=pulumi.get(__response__, 'workflows'),
        yds=pulumi.get(__response__, 'yds'),
        ymqs=pulumi.get(__response__, 'ymqs')))
