# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSwsSecurityProfileResult',
    'AwaitableGetSwsSecurityProfileResult',
    'get_sws_security_profile',
    'get_sws_security_profile_output',
]

@pulumi.output_type
class GetSwsSecurityProfileResult:
    """
    A collection of values returned by getSwsSecurityProfile.
    """
    def __init__(__self__, advanced_rate_limiter_profile_id=None, analyze_request_bodies=None, captcha_id=None, cloud_id=None, created_at=None, default_action=None, description=None, folder_id=None, id=None, labels=None, name=None, security_profile_id=None, security_rules=None):
        if advanced_rate_limiter_profile_id and not isinstance(advanced_rate_limiter_profile_id, str):
            raise TypeError("Expected argument 'advanced_rate_limiter_profile_id' to be a str")
        pulumi.set(__self__, "advanced_rate_limiter_profile_id", advanced_rate_limiter_profile_id)
        if analyze_request_bodies and not isinstance(analyze_request_bodies, list):
            raise TypeError("Expected argument 'analyze_request_bodies' to be a list")
        pulumi.set(__self__, "analyze_request_bodies", analyze_request_bodies)
        if captcha_id and not isinstance(captcha_id, str):
            raise TypeError("Expected argument 'captcha_id' to be a str")
        pulumi.set(__self__, "captcha_id", captcha_id)
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if default_action and not isinstance(default_action, str):
            raise TypeError("Expected argument 'default_action' to be a str")
        pulumi.set(__self__, "default_action", default_action)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if security_profile_id and not isinstance(security_profile_id, str):
            raise TypeError("Expected argument 'security_profile_id' to be a str")
        pulumi.set(__self__, "security_profile_id", security_profile_id)
        if security_rules and not isinstance(security_rules, list):
            raise TypeError("Expected argument 'security_rules' to be a list")
        pulumi.set(__self__, "security_rules", security_rules)

    @_builtins.property
    @pulumi.getter(name="advancedRateLimiterProfileId")
    def advanced_rate_limiter_profile_id(self) -> _builtins.str:
        """
        Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "advanced_rate_limiter_profile_id")

    @_builtins.property
    @pulumi.getter(name="analyzeRequestBodies")
    def analyze_request_bodies(self) -> Sequence['outputs.GetSwsSecurityProfileAnalyzeRequestBodyResult']:
        return pulumi.get(self, "analyze_request_bodies")

    @_builtins.property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> _builtins.str:
        """
        Captcha ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "captcha_id")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> _builtins.str:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> _builtins.str:
        """
        Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="securityProfileId")
    def security_profile_id(self) -> Optional[_builtins.str]:
        """
        ID of the security profile.
        """
        return pulumi.get(self, "security_profile_id")

    @_builtins.property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Sequence['outputs.GetSwsSecurityProfileSecurityRuleResult']:
        """
        List of security rules.
        """
        return pulumi.get(self, "security_rules")


class AwaitableGetSwsSecurityProfileResult(GetSwsSecurityProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSwsSecurityProfileResult(
            advanced_rate_limiter_profile_id=self.advanced_rate_limiter_profile_id,
            analyze_request_bodies=self.analyze_request_bodies,
            captcha_id=self.captcha_id,
            cloud_id=self.cloud_id,
            created_at=self.created_at,
            default_action=self.default_action,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            security_profile_id=self.security_profile_id,
            security_rules=self.security_rules)


def get_sws_security_profile(cloud_id: Optional[_builtins.str] = None,
                             folder_id: Optional[_builtins.str] = None,
                             name: Optional[_builtins.str] = None,
                             security_profile_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSwsSecurityProfileResult:
    """
    Get information about SecurityProfile. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/concepts/profiles).

    This data source is used to define SecurityProfile that can be used by other resources.

    > One of `security_profile_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing SWS Security Profile.
    #
    by_id = yandex.get_sws_security_profile(security_profile_id=my_profile["id"])
    by_name = yandex.get_sws_security_profile(name=my_profile["name"])
    ```


    :param _builtins.str cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.str security_profile_id: ID of the security profile.
    """
    __args__ = dict()
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['securityProfileId'] = security_profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getSwsSecurityProfile:getSwsSecurityProfile', __args__, opts=opts, typ=GetSwsSecurityProfileResult).value

    return AwaitableGetSwsSecurityProfileResult(
        advanced_rate_limiter_profile_id=pulumi.get(__ret__, 'advanced_rate_limiter_profile_id'),
        analyze_request_bodies=pulumi.get(__ret__, 'analyze_request_bodies'),
        captcha_id=pulumi.get(__ret__, 'captcha_id'),
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        default_action=pulumi.get(__ret__, 'default_action'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        security_profile_id=pulumi.get(__ret__, 'security_profile_id'),
        security_rules=pulumi.get(__ret__, 'security_rules'))
def get_sws_security_profile_output(cloud_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    security_profile_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSwsSecurityProfileResult]:
    """
    Get information about SecurityProfile. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/concepts/profiles).

    This data source is used to define SecurityProfile that can be used by other resources.

    > One of `security_profile_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing SWS Security Profile.
    #
    by_id = yandex.get_sws_security_profile(security_profile_id=my_profile["id"])
    by_name = yandex.get_sws_security_profile(name=my_profile["name"])
    ```


    :param _builtins.str cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.str security_profile_id: ID of the security profile.
    """
    __args__ = dict()
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['securityProfileId'] = security_profile_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getSwsSecurityProfile:getSwsSecurityProfile', __args__, opts=opts, typ=GetSwsSecurityProfileResult)
    return __ret__.apply(lambda __response__: GetSwsSecurityProfileResult(
        advanced_rate_limiter_profile_id=pulumi.get(__response__, 'advanced_rate_limiter_profile_id'),
        analyze_request_bodies=pulumi.get(__response__, 'analyze_request_bodies'),
        captcha_id=pulumi.get(__response__, 'captcha_id'),
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        default_action=pulumi.get(__response__, 'default_action'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        security_profile_id=pulumi.get(__response__, 'security_profile_id'),
        security_rules=pulumi.get(__response__, 'security_rules')))
