# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LbNetworkLoadBalancerArgs', 'LbNetworkLoadBalancer']

@pulumi.input_type
class LbNetworkLoadBalancerArgs:
    def __init__(__self__, *,
                 allow_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 attached_target_groups: Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerAttachedTargetGroupArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerListenerArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LbNetworkLoadBalancer resource.
        :param pulumi.Input[_builtins.bool] allow_zonal_shift: Flag that marks the network load balancer as available to zonal shift.
        :param pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerAttachedTargetGroupArgs']]] attached_target_groups: An AttachedTargetGroup resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerListenerArgs']]] listeners: Listener specification that will be used by a network load balancer.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] region_id: ID of the availability zone where the network load balancer resides. If omitted, default region is being used.
        :param pulumi.Input[_builtins.str] type: Type of the network load balancer. Must be one of 'external' or 'internal'. The default is 'external'.
        """
        if allow_zonal_shift is not None:
            pulumi.set(__self__, "allow_zonal_shift", allow_zonal_shift)
        if attached_target_groups is not None:
            pulumi.set(__self__, "attached_target_groups", attached_target_groups)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="allowZonalShift")
    def allow_zonal_shift(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that marks the network load balancer as available to zonal shift.
        """
        return pulumi.get(self, "allow_zonal_shift")

    @allow_zonal_shift.setter
    def allow_zonal_shift(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_zonal_shift", value)

    @_builtins.property
    @pulumi.getter(name="attachedTargetGroups")
    def attached_target_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerAttachedTargetGroupArgs']]]]:
        """
        An AttachedTargetGroup resource.
        """
        return pulumi.get(self, "attached_target_groups")

    @attached_target_groups.setter
    def attached_target_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerAttachedTargetGroupArgs']]]]):
        pulumi.set(self, "attached_target_groups", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerListenerArgs']]]]:
        """
        Listener specification that will be used by a network load balancer.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerListenerArgs']]]]):
        pulumi.set(self, "listeners", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the availability zone where the network load balancer resides. If omitted, default region is being used.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the network load balancer. Must be one of 'external' or 'internal'. The default is 'external'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _LbNetworkLoadBalancerState:
    def __init__(__self__, *,
                 allow_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 attached_target_groups: Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerAttachedTargetGroupArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerListenerArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LbNetworkLoadBalancer resources.
        :param pulumi.Input[_builtins.bool] allow_zonal_shift: Flag that marks the network load balancer as available to zonal shift.
        :param pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerAttachedTargetGroupArgs']]] attached_target_groups: An AttachedTargetGroup resource.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerListenerArgs']]] listeners: Listener specification that will be used by a network load balancer.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] region_id: ID of the availability zone where the network load balancer resides. If omitted, default region is being used.
        :param pulumi.Input[_builtins.str] type: Type of the network load balancer. Must be one of 'external' or 'internal'. The default is 'external'.
        """
        if allow_zonal_shift is not None:
            pulumi.set(__self__, "allow_zonal_shift", allow_zonal_shift)
        if attached_target_groups is not None:
            pulumi.set(__self__, "attached_target_groups", attached_target_groups)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="allowZonalShift")
    def allow_zonal_shift(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that marks the network load balancer as available to zonal shift.
        """
        return pulumi.get(self, "allow_zonal_shift")

    @allow_zonal_shift.setter
    def allow_zonal_shift(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_zonal_shift", value)

    @_builtins.property
    @pulumi.getter(name="attachedTargetGroups")
    def attached_target_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerAttachedTargetGroupArgs']]]]:
        """
        An AttachedTargetGroup resource.
        """
        return pulumi.get(self, "attached_target_groups")

    @attached_target_groups.setter
    def attached_target_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerAttachedTargetGroupArgs']]]]):
        pulumi.set(self, "attached_target_groups", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerListenerArgs']]]]:
        """
        Listener specification that will be used by a network load balancer.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LbNetworkLoadBalancerListenerArgs']]]]):
        pulumi.set(self, "listeners", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the availability zone where the network load balancer resides. If omitted, default region is being used.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the network load balancer. Must be one of 'external' or 'internal'. The default is 'external'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("yandex:index/lbNetworkLoadBalancer:LbNetworkLoadBalancer")
class LbNetworkLoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 attached_target_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LbNetworkLoadBalancerAttachedTargetGroupArgs', 'LbNetworkLoadBalancerAttachedTargetGroupArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LbNetworkLoadBalancerListenerArgs', 'LbNetworkLoadBalancerListenerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a network load balancer in the specified folder using the data specified in the config. For more information, see [the official documentation](https://yandex.cloud/docs/load-balancer/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Network Load Balancer (NLB).
        #
        my_nlb = yandex.LbNetworkLoadBalancer("my_nlb",
            name="my-network-load-balancer",
            listeners=[{
                "name": "my-listener",
                "port": 8080,
                "external_address_spec": {
                    "ip_version": "ipv4",
                },
            }],
            attached_target_groups=[{
                "target_group_id": my_target_group["id"],
                "healthchecks": [{
                    "name": "http",
                    "http_options": {
                        "port": 8080,
                        "path": "/ping",
                    },
                }],
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/lbNetworkLoadBalancer:LbNetworkLoadBalancer <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/lbNetworkLoadBalancer:LbNetworkLoadBalancer my_nlb ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_zonal_shift: Flag that marks the network load balancer as available to zonal shift.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LbNetworkLoadBalancerAttachedTargetGroupArgs', 'LbNetworkLoadBalancerAttachedTargetGroupArgsDict']]]] attached_target_groups: An AttachedTargetGroup resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LbNetworkLoadBalancerListenerArgs', 'LbNetworkLoadBalancerListenerArgsDict']]]] listeners: Listener specification that will be used by a network load balancer.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] region_id: ID of the availability zone where the network load balancer resides. If omitted, default region is being used.
        :param pulumi.Input[_builtins.str] type: Type of the network load balancer. Must be one of 'external' or 'internal'. The default is 'external'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LbNetworkLoadBalancerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a network load balancer in the specified folder using the data specified in the config. For more information, see [the official documentation](https://yandex.cloud/docs/load-balancer/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Network Load Balancer (NLB).
        #
        my_nlb = yandex.LbNetworkLoadBalancer("my_nlb",
            name="my-network-load-balancer",
            listeners=[{
                "name": "my-listener",
                "port": 8080,
                "external_address_spec": {
                    "ip_version": "ipv4",
                },
            }],
            attached_target_groups=[{
                "target_group_id": my_target_group["id"],
                "healthchecks": [{
                    "name": "http",
                    "http_options": {
                        "port": 8080,
                        "path": "/ping",
                    },
                }],
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/lbNetworkLoadBalancer:LbNetworkLoadBalancer <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/lbNetworkLoadBalancer:LbNetworkLoadBalancer my_nlb ...
        ```

        :param str resource_name: The name of the resource.
        :param LbNetworkLoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LbNetworkLoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 attached_target_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LbNetworkLoadBalancerAttachedTargetGroupArgs', 'LbNetworkLoadBalancerAttachedTargetGroupArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LbNetworkLoadBalancerListenerArgs', 'LbNetworkLoadBalancerListenerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LbNetworkLoadBalancerArgs.__new__(LbNetworkLoadBalancerArgs)

            __props__.__dict__["allow_zonal_shift"] = allow_zonal_shift
            __props__.__dict__["attached_target_groups"] = attached_target_groups
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["listeners"] = listeners
            __props__.__dict__["name"] = name
            __props__.__dict__["region_id"] = region_id
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
        super(LbNetworkLoadBalancer, __self__).__init__(
            'yandex:index/lbNetworkLoadBalancer:LbNetworkLoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
            attached_target_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LbNetworkLoadBalancerAttachedTargetGroupArgs', 'LbNetworkLoadBalancerAttachedTargetGroupArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LbNetworkLoadBalancerListenerArgs', 'LbNetworkLoadBalancerListenerArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'LbNetworkLoadBalancer':
        """
        Get an existing LbNetworkLoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_zonal_shift: Flag that marks the network load balancer as available to zonal shift.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LbNetworkLoadBalancerAttachedTargetGroupArgs', 'LbNetworkLoadBalancerAttachedTargetGroupArgsDict']]]] attached_target_groups: An AttachedTargetGroup resource.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LbNetworkLoadBalancerListenerArgs', 'LbNetworkLoadBalancerListenerArgsDict']]]] listeners: Listener specification that will be used by a network load balancer.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] region_id: ID of the availability zone where the network load balancer resides. If omitted, default region is being used.
        :param pulumi.Input[_builtins.str] type: Type of the network load balancer. Must be one of 'external' or 'internal'. The default is 'external'.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LbNetworkLoadBalancerState.__new__(_LbNetworkLoadBalancerState)

        __props__.__dict__["allow_zonal_shift"] = allow_zonal_shift
        __props__.__dict__["attached_target_groups"] = attached_target_groups
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["listeners"] = listeners
        __props__.__dict__["name"] = name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["type"] = type
        return LbNetworkLoadBalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowZonalShift")
    def allow_zonal_shift(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag that marks the network load balancer as available to zonal shift.
        """
        return pulumi.get(self, "allow_zonal_shift")

    @_builtins.property
    @pulumi.getter(name="attachedTargetGroups")
    def attached_target_groups(self) -> pulumi.Output[Optional[Sequence['outputs.LbNetworkLoadBalancerAttachedTargetGroup']]]:
        """
        An AttachedTargetGroup resource.
        """
        return pulumi.get(self, "attached_target_groups")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> pulumi.Output[Optional[Sequence['outputs.LbNetworkLoadBalancerListener']]]:
        """
        Listener specification that will be used by a network load balancer.
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the availability zone where the network load balancer resides. If omitted, default region is being used.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of the network load balancer. Must be one of 'external' or 'internal'. The default is 'external'.
        """
        return pulumi.get(self, "type")

