# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbGreenplumClusterArgs', 'MdbGreenplumCluster']

@pulumi.input_type
class MdbGreenplumClusterArgs:
    def __init__(__self__, *,
                 assign_public_ip: pulumi.Input[_builtins.bool],
                 environment: pulumi.Input[_builtins.str],
                 master_host_count: pulumi.Input[_builtins.int],
                 master_subcluster: pulumi.Input['MdbGreenplumClusterMasterSubclusterArgs'],
                 network_id: pulumi.Input[_builtins.str],
                 segment_host_count: pulumi.Input[_builtins.int],
                 segment_in_host: pulumi.Input[_builtins.int],
                 segment_subcluster: pulumi.Input['MdbGreenplumClusterSegmentSubclusterArgs'],
                 subnet_id: pulumi.Input[_builtins.str],
                 user_name: pulumi.Input[_builtins.str],
                 user_password: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 zone: pulumi.Input[_builtins.str],
                 access: Optional[pulumi.Input['MdbGreenplumClusterAccessArgs']] = None,
                 background_activities: Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterBackgroundActivityArgs']]]] = None,
                 backup_window_start: Optional[pulumi.Input['MdbGreenplumClusterBackupWindowStartArgs']] = None,
                 cloud_storage: Optional[pulumi.Input['MdbGreenplumClusterCloudStorageArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 greenplum_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging: Optional[pulumi.Input['MdbGreenplumClusterLoggingArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['MdbGreenplumClusterMaintenanceWindowArgs']] = None,
                 master_host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pooler_config: Optional[pulumi.Input['MdbGreenplumClusterPoolerConfigArgs']] = None,
                 pxf_config: Optional[pulumi.Input['MdbGreenplumClusterPxfConfigArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 segment_host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MdbGreenplumCluster resource.
        :param pulumi.Input[_builtins.bool] assign_public_ip: Sets whether the master hosts should get a public IP address on creation. Changing this parameter for an existing host is not supported at the moment.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the Greenplum cluster. (PRODUCTION, PRESTABLE)
        :param pulumi.Input[_builtins.int] master_host_count: Number of hosts in master subcluster (1 or 2).
        :param pulumi.Input['MdbGreenplumClusterMasterSubclusterArgs'] master_subcluster: Settings for master subcluster.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.int] segment_host_count: Number of hosts in segment subcluster (from 1 to 32).
        :param pulumi.Input[_builtins.int] segment_in_host: Number of segments on segment host (not more then 1 + RAM/8).
        :param pulumi.Input['MdbGreenplumClusterSegmentSubclusterArgs'] segment_subcluster: Settings for segment subcluster.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet, to which the hosts belongs. The subnet must be a part of the network to which the cluster belongs.
        :param pulumi.Input[_builtins.str] user_name: Greenplum cluster admin user name.
        :param pulumi.Input[_builtins.str] user_password: Greenplum cluster admin password name.
        :param pulumi.Input[_builtins.str] version: Version of the Greenplum cluster. (`6.25`)
        :param pulumi.Input[_builtins.str] zone: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        :param pulumi.Input['MdbGreenplumClusterAccessArgs'] access: Access policy to the Greenplum cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterBackgroundActivityArgs']]] background_activities: Background activities settings.
        :param pulumi.Input['MdbGreenplumClusterBackupWindowStartArgs'] backup_window_start: Time to start the daily backup, in the UTC timezone.
        :param pulumi.Input['MdbGreenplumClusterCloudStorageArgs'] cloud_storage: Cloud Storage settings of the Greenplum cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] greenplum_config: Greenplum cluster config. Detail info in `Greenplum cluster settings` block.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['MdbGreenplumClusterLoggingArgs'] logging: Cloud Logging settings.
        :param pulumi.Input['MdbGreenplumClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the Greenplum cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] master_host_group_ids: A list of IDs of the host groups to place master subclusters' VMs of the cluster on.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['MdbGreenplumClusterPoolerConfigArgs'] pooler_config: Configuration of the connection pooler.
        :param pulumi.Input['MdbGreenplumClusterPxfConfigArgs'] pxf_config: Configuration of the PXF daemon.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] segment_host_group_ids: A list of IDs of the host groups to place segment subclusters' VMs of the cluster on.
        :param pulumi.Input[_builtins.str] service_account_id: ID of service account to use with Yandex Cloud resources (e.g. S3, Cloud Logging).
        """
        pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "master_host_count", master_host_count)
        pulumi.set(__self__, "master_subcluster", master_subcluster)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "segment_host_count", segment_host_count)
        pulumi.set(__self__, "segment_in_host", segment_in_host)
        pulumi.set(__self__, "segment_subcluster", segment_subcluster)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_password", user_password)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "zone", zone)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if background_activities is not None:
            pulumi.set(__self__, "background_activities", background_activities)
        if backup_window_start is not None:
            pulumi.set(__self__, "backup_window_start", backup_window_start)
        if cloud_storage is not None:
            pulumi.set(__self__, "cloud_storage", cloud_storage)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if greenplum_config is not None:
            pulumi.set(__self__, "greenplum_config", greenplum_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if master_host_group_ids is not None:
            pulumi.set(__self__, "master_host_group_ids", master_host_group_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pooler_config is not None:
            pulumi.set(__self__, "pooler_config", pooler_config)
        if pxf_config is not None:
            pulumi.set(__self__, "pxf_config", pxf_config)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if segment_host_group_ids is not None:
            pulumi.set(__self__, "segment_host_group_ids", segment_host_group_ids)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> pulumi.Input[_builtins.bool]:
        """
        Sets whether the master hosts should get a public IP address on creation. Changing this parameter for an existing host is not supported at the moment.
        """
        return pulumi.get(self, "assign_public_ip")

    @assign_public_ip.setter
    def assign_public_ip(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "assign_public_ip", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        Deployment environment of the Greenplum cluster. (PRODUCTION, PRESTABLE)
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="masterHostCount")
    def master_host_count(self) -> pulumi.Input[_builtins.int]:
        """
        Number of hosts in master subcluster (1 or 2).
        """
        return pulumi.get(self, "master_host_count")

    @master_host_count.setter
    def master_host_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "master_host_count", value)

    @_builtins.property
    @pulumi.getter(name="masterSubcluster")
    def master_subcluster(self) -> pulumi.Input['MdbGreenplumClusterMasterSubclusterArgs']:
        """
        Settings for master subcluster.
        """
        return pulumi.get(self, "master_subcluster")

    @master_subcluster.setter
    def master_subcluster(self, value: pulumi.Input['MdbGreenplumClusterMasterSubclusterArgs']):
        pulumi.set(self, "master_subcluster", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="segmentHostCount")
    def segment_host_count(self) -> pulumi.Input[_builtins.int]:
        """
        Number of hosts in segment subcluster (from 1 to 32).
        """
        return pulumi.get(self, "segment_host_count")

    @segment_host_count.setter
    def segment_host_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "segment_host_count", value)

    @_builtins.property
    @pulumi.getter(name="segmentInHost")
    def segment_in_host(self) -> pulumi.Input[_builtins.int]:
        """
        Number of segments on segment host (not more then 1 + RAM/8).
        """
        return pulumi.get(self, "segment_in_host")

    @segment_in_host.setter
    def segment_in_host(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "segment_in_host", value)

    @_builtins.property
    @pulumi.getter(name="segmentSubcluster")
    def segment_subcluster(self) -> pulumi.Input['MdbGreenplumClusterSegmentSubclusterArgs']:
        """
        Settings for segment subcluster.
        """
        return pulumi.get(self, "segment_subcluster")

    @segment_subcluster.setter
    def segment_subcluster(self, value: pulumi.Input['MdbGreenplumClusterSegmentSubclusterArgs']):
        pulumi.set(self, "segment_subcluster", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the subnet, to which the hosts belongs. The subnet must be a part of the network to which the cluster belongs.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[_builtins.str]:
        """
        Greenplum cluster admin user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> pulumi.Input[_builtins.str]:
        """
        Greenplum cluster admin password name.
        """
        return pulumi.get(self, "user_password")

    @user_password.setter
    def user_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_password", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        Version of the Greenplum cluster. (`6.25`)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Input[_builtins.str]:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input['MdbGreenplumClusterAccessArgs']]:
        """
        Access policy to the Greenplum cluster.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input['MdbGreenplumClusterAccessArgs']]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter(name="backgroundActivities")
    def background_activities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterBackgroundActivityArgs']]]]:
        """
        Background activities settings.
        """
        return pulumi.get(self, "background_activities")

    @background_activities.setter
    def background_activities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterBackgroundActivityArgs']]]]):
        pulumi.set(self, "background_activities", value)

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> Optional[pulumi.Input['MdbGreenplumClusterBackupWindowStartArgs']]:
        """
        Time to start the daily backup, in the UTC timezone.
        """
        return pulumi.get(self, "backup_window_start")

    @backup_window_start.setter
    def backup_window_start(self, value: Optional[pulumi.Input['MdbGreenplumClusterBackupWindowStartArgs']]):
        pulumi.set(self, "backup_window_start", value)

    @_builtins.property
    @pulumi.getter(name="cloudStorage")
    def cloud_storage(self) -> Optional[pulumi.Input['MdbGreenplumClusterCloudStorageArgs']]:
        """
        Cloud Storage settings of the Greenplum cluster.
        """
        return pulumi.get(self, "cloud_storage")

    @cloud_storage.setter
    def cloud_storage(self, value: Optional[pulumi.Input['MdbGreenplumClusterCloudStorageArgs']]):
        pulumi.set(self, "cloud_storage", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="greenplumConfig")
    def greenplum_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Greenplum cluster config. Detail info in `Greenplum cluster settings` block.
        """
        return pulumi.get(self, "greenplum_config")

    @greenplum_config.setter
    def greenplum_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "greenplum_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['MdbGreenplumClusterLoggingArgs']]:
        """
        Cloud Logging settings.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['MdbGreenplumClusterLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbGreenplumClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the Greenplum cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbGreenplumClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="masterHostGroupIds")
    def master_host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IDs of the host groups to place master subclusters' VMs of the cluster on.
        """
        return pulumi.get(self, "master_host_group_ids")

    @master_host_group_ids.setter
    def master_host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "master_host_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="poolerConfig")
    def pooler_config(self) -> Optional[pulumi.Input['MdbGreenplumClusterPoolerConfigArgs']]:
        """
        Configuration of the connection pooler.
        """
        return pulumi.get(self, "pooler_config")

    @pooler_config.setter
    def pooler_config(self, value: Optional[pulumi.Input['MdbGreenplumClusterPoolerConfigArgs']]):
        pulumi.set(self, "pooler_config", value)

    @_builtins.property
    @pulumi.getter(name="pxfConfig")
    def pxf_config(self) -> Optional[pulumi.Input['MdbGreenplumClusterPxfConfigArgs']]:
        """
        Configuration of the PXF daemon.
        """
        return pulumi.get(self, "pxf_config")

    @pxf_config.setter
    def pxf_config(self, value: Optional[pulumi.Input['MdbGreenplumClusterPxfConfigArgs']]):
        pulumi.set(self, "pxf_config", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="segmentHostGroupIds")
    def segment_host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IDs of the host groups to place segment subclusters' VMs of the cluster on.
        """
        return pulumi.get(self, "segment_host_group_ids")

    @segment_host_group_ids.setter
    def segment_host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "segment_host_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of service account to use with Yandex Cloud resources (e.g. S3, Cloud Logging).
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)


@pulumi.input_type
class _MdbGreenplumClusterState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input['MdbGreenplumClusterAccessArgs']] = None,
                 assign_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 background_activities: Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterBackgroundActivityArgs']]]] = None,
                 backup_window_start: Optional[pulumi.Input['MdbGreenplumClusterBackupWindowStartArgs']] = None,
                 cloud_storage: Optional[pulumi.Input['MdbGreenplumClusterCloudStorageArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 greenplum_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 health: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging: Optional[pulumi.Input['MdbGreenplumClusterLoggingArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['MdbGreenplumClusterMaintenanceWindowArgs']] = None,
                 master_host_count: Optional[pulumi.Input[_builtins.int]] = None,
                 master_host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 master_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterMasterHostArgs']]]] = None,
                 master_subcluster: Optional[pulumi.Input['MdbGreenplumClusterMasterSubclusterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pooler_config: Optional[pulumi.Input['MdbGreenplumClusterPoolerConfigArgs']] = None,
                 pxf_config: Optional[pulumi.Input['MdbGreenplumClusterPxfConfigArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 segment_host_count: Optional[pulumi.Input[_builtins.int]] = None,
                 segment_host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 segment_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterSegmentHostArgs']]]] = None,
                 segment_in_host: Optional[pulumi.Input[_builtins.int]] = None,
                 segment_subcluster: Optional[pulumi.Input['MdbGreenplumClusterSegmentSubclusterArgs']] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_password: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MdbGreenplumCluster resources.
        :param pulumi.Input['MdbGreenplumClusterAccessArgs'] access: Access policy to the Greenplum cluster.
        :param pulumi.Input[_builtins.bool] assign_public_ip: Sets whether the master hosts should get a public IP address on creation. Changing this parameter for an existing host is not supported at the moment.
        :param pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterBackgroundActivityArgs']]] background_activities: Background activities settings.
        :param pulumi.Input['MdbGreenplumClusterBackupWindowStartArgs'] backup_window_start: Time to start the daily backup, in the UTC timezone.
        :param pulumi.Input['MdbGreenplumClusterCloudStorageArgs'] cloud_storage: Cloud Storage settings of the Greenplum cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the Greenplum cluster. (PRODUCTION, PRESTABLE)
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] greenplum_config: Greenplum cluster config. Detail info in `Greenplum cluster settings` block.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['MdbGreenplumClusterLoggingArgs'] logging: Cloud Logging settings.
        :param pulumi.Input['MdbGreenplumClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the Greenplum cluster.
        :param pulumi.Input[_builtins.int] master_host_count: Number of hosts in master subcluster (1 or 2).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] master_host_group_ids: A list of IDs of the host groups to place master subclusters' VMs of the cluster on.
        :param pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterMasterHostArgs']]] master_hosts: Info about hosts in master subcluster.
        :param pulumi.Input['MdbGreenplumClusterMasterSubclusterArgs'] master_subcluster: Settings for master subcluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input['MdbGreenplumClusterPoolerConfigArgs'] pooler_config: Configuration of the connection pooler.
        :param pulumi.Input['MdbGreenplumClusterPxfConfigArgs'] pxf_config: Configuration of the PXF daemon.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.int] segment_host_count: Number of hosts in segment subcluster (from 1 to 32).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] segment_host_group_ids: A list of IDs of the host groups to place segment subclusters' VMs of the cluster on.
        :param pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterSegmentHostArgs']]] segment_hosts: Info about hosts in segment subcluster.
        :param pulumi.Input[_builtins.int] segment_in_host: Number of segments on segment host (not more then 1 + RAM/8).
        :param pulumi.Input['MdbGreenplumClusterSegmentSubclusterArgs'] segment_subcluster: Settings for segment subcluster.
        :param pulumi.Input[_builtins.str] service_account_id: ID of service account to use with Yandex Cloud resources (e.g. S3, Cloud Logging).
        :param pulumi.Input[_builtins.str] status: Status of the cluster.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet, to which the hosts belongs. The subnet must be a part of the network to which the cluster belongs.
        :param pulumi.Input[_builtins.str] user_name: Greenplum cluster admin user name.
        :param pulumi.Input[_builtins.str] user_password: Greenplum cluster admin password name.
        :param pulumi.Input[_builtins.str] version: Version of the Greenplum cluster. (`6.25`)
        :param pulumi.Input[_builtins.str] zone: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if background_activities is not None:
            pulumi.set(__self__, "background_activities", background_activities)
        if backup_window_start is not None:
            pulumi.set(__self__, "backup_window_start", backup_window_start)
        if cloud_storage is not None:
            pulumi.set(__self__, "cloud_storage", cloud_storage)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if greenplum_config is not None:
            pulumi.set(__self__, "greenplum_config", greenplum_config)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if master_host_count is not None:
            pulumi.set(__self__, "master_host_count", master_host_count)
        if master_host_group_ids is not None:
            pulumi.set(__self__, "master_host_group_ids", master_host_group_ids)
        if master_hosts is not None:
            pulumi.set(__self__, "master_hosts", master_hosts)
        if master_subcluster is not None:
            pulumi.set(__self__, "master_subcluster", master_subcluster)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if pooler_config is not None:
            pulumi.set(__self__, "pooler_config", pooler_config)
        if pxf_config is not None:
            pulumi.set(__self__, "pxf_config", pxf_config)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if segment_host_count is not None:
            pulumi.set(__self__, "segment_host_count", segment_host_count)
        if segment_host_group_ids is not None:
            pulumi.set(__self__, "segment_host_group_ids", segment_host_group_ids)
        if segment_hosts is not None:
            pulumi.set(__self__, "segment_hosts", segment_hosts)
        if segment_in_host is not None:
            pulumi.set(__self__, "segment_in_host", segment_in_host)
        if segment_subcluster is not None:
            pulumi.set(__self__, "segment_subcluster", segment_subcluster)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if user_password is not None:
            pulumi.set(__self__, "user_password", user_password)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input['MdbGreenplumClusterAccessArgs']]:
        """
        Access policy to the Greenplum cluster.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input['MdbGreenplumClusterAccessArgs']]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Sets whether the master hosts should get a public IP address on creation. Changing this parameter for an existing host is not supported at the moment.
        """
        return pulumi.get(self, "assign_public_ip")

    @assign_public_ip.setter
    def assign_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assign_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="backgroundActivities")
    def background_activities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterBackgroundActivityArgs']]]]:
        """
        Background activities settings.
        """
        return pulumi.get(self, "background_activities")

    @background_activities.setter
    def background_activities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterBackgroundActivityArgs']]]]):
        pulumi.set(self, "background_activities", value)

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> Optional[pulumi.Input['MdbGreenplumClusterBackupWindowStartArgs']]:
        """
        Time to start the daily backup, in the UTC timezone.
        """
        return pulumi.get(self, "backup_window_start")

    @backup_window_start.setter
    def backup_window_start(self, value: Optional[pulumi.Input['MdbGreenplumClusterBackupWindowStartArgs']]):
        pulumi.set(self, "backup_window_start", value)

    @_builtins.property
    @pulumi.getter(name="cloudStorage")
    def cloud_storage(self) -> Optional[pulumi.Input['MdbGreenplumClusterCloudStorageArgs']]:
        """
        Cloud Storage settings of the Greenplum cluster.
        """
        return pulumi.get(self, "cloud_storage")

    @cloud_storage.setter
    def cloud_storage(self, value: Optional[pulumi.Input['MdbGreenplumClusterCloudStorageArgs']]):
        pulumi.set(self, "cloud_storage", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment environment of the Greenplum cluster. (PRODUCTION, PRESTABLE)
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="greenplumConfig")
    def greenplum_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Greenplum cluster config. Detail info in `Greenplum cluster settings` block.
        """
        return pulumi.get(self, "greenplum_config")

    @greenplum_config.setter
    def greenplum_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "greenplum_config", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['MdbGreenplumClusterLoggingArgs']]:
        """
        Cloud Logging settings.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['MdbGreenplumClusterLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbGreenplumClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the Greenplum cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbGreenplumClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="masterHostCount")
    def master_host_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of hosts in master subcluster (1 or 2).
        """
        return pulumi.get(self, "master_host_count")

    @master_host_count.setter
    def master_host_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "master_host_count", value)

    @_builtins.property
    @pulumi.getter(name="masterHostGroupIds")
    def master_host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IDs of the host groups to place master subclusters' VMs of the cluster on.
        """
        return pulumi.get(self, "master_host_group_ids")

    @master_host_group_ids.setter
    def master_host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "master_host_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="masterHosts")
    def master_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterMasterHostArgs']]]]:
        """
        Info about hosts in master subcluster.
        """
        return pulumi.get(self, "master_hosts")

    @master_hosts.setter
    def master_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterMasterHostArgs']]]]):
        pulumi.set(self, "master_hosts", value)

    @_builtins.property
    @pulumi.getter(name="masterSubcluster")
    def master_subcluster(self) -> Optional[pulumi.Input['MdbGreenplumClusterMasterSubclusterArgs']]:
        """
        Settings for master subcluster.
        """
        return pulumi.get(self, "master_subcluster")

    @master_subcluster.setter
    def master_subcluster(self, value: Optional[pulumi.Input['MdbGreenplumClusterMasterSubclusterArgs']]):
        pulumi.set(self, "master_subcluster", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="poolerConfig")
    def pooler_config(self) -> Optional[pulumi.Input['MdbGreenplumClusterPoolerConfigArgs']]:
        """
        Configuration of the connection pooler.
        """
        return pulumi.get(self, "pooler_config")

    @pooler_config.setter
    def pooler_config(self, value: Optional[pulumi.Input['MdbGreenplumClusterPoolerConfigArgs']]):
        pulumi.set(self, "pooler_config", value)

    @_builtins.property
    @pulumi.getter(name="pxfConfig")
    def pxf_config(self) -> Optional[pulumi.Input['MdbGreenplumClusterPxfConfigArgs']]:
        """
        Configuration of the PXF daemon.
        """
        return pulumi.get(self, "pxf_config")

    @pxf_config.setter
    def pxf_config(self, value: Optional[pulumi.Input['MdbGreenplumClusterPxfConfigArgs']]):
        pulumi.set(self, "pxf_config", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="segmentHostCount")
    def segment_host_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of hosts in segment subcluster (from 1 to 32).
        """
        return pulumi.get(self, "segment_host_count")

    @segment_host_count.setter
    def segment_host_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "segment_host_count", value)

    @_builtins.property
    @pulumi.getter(name="segmentHostGroupIds")
    def segment_host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IDs of the host groups to place segment subclusters' VMs of the cluster on.
        """
        return pulumi.get(self, "segment_host_group_ids")

    @segment_host_group_ids.setter
    def segment_host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "segment_host_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="segmentHosts")
    def segment_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterSegmentHostArgs']]]]:
        """
        Info about hosts in segment subcluster.
        """
        return pulumi.get(self, "segment_hosts")

    @segment_hosts.setter
    def segment_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbGreenplumClusterSegmentHostArgs']]]]):
        pulumi.set(self, "segment_hosts", value)

    @_builtins.property
    @pulumi.getter(name="segmentInHost")
    def segment_in_host(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of segments on segment host (not more then 1 + RAM/8).
        """
        return pulumi.get(self, "segment_in_host")

    @segment_in_host.setter
    def segment_in_host(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "segment_in_host", value)

    @_builtins.property
    @pulumi.getter(name="segmentSubcluster")
    def segment_subcluster(self) -> Optional[pulumi.Input['MdbGreenplumClusterSegmentSubclusterArgs']]:
        """
        Settings for segment subcluster.
        """
        return pulumi.get(self, "segment_subcluster")

    @segment_subcluster.setter
    def segment_subcluster(self, value: Optional[pulumi.Input['MdbGreenplumClusterSegmentSubclusterArgs']]):
        pulumi.set(self, "segment_subcluster", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of service account to use with Yandex Cloud resources (e.g. S3, Cloud Logging).
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the subnet, to which the hosts belongs. The subnet must be a part of the network to which the cluster belongs.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Greenplum cluster admin user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Greenplum cluster admin password name.
        """
        return pulumi.get(self, "user_password")

    @user_password.setter
    def user_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_password", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the Greenplum cluster. (`6.25`)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("yandex:index/mdbGreenplumCluster:MdbGreenplumCluster")
class MdbGreenplumCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[Union['MdbGreenplumClusterAccessArgs', 'MdbGreenplumClusterAccessArgsDict']]] = None,
                 assign_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 background_activities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbGreenplumClusterBackgroundActivityArgs', 'MdbGreenplumClusterBackgroundActivityArgsDict']]]]] = None,
                 backup_window_start: Optional[pulumi.Input[Union['MdbGreenplumClusterBackupWindowStartArgs', 'MdbGreenplumClusterBackupWindowStartArgsDict']]] = None,
                 cloud_storage: Optional[pulumi.Input[Union['MdbGreenplumClusterCloudStorageArgs', 'MdbGreenplumClusterCloudStorageArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 greenplum_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging: Optional[pulumi.Input[Union['MdbGreenplumClusterLoggingArgs', 'MdbGreenplumClusterLoggingArgsDict']]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbGreenplumClusterMaintenanceWindowArgs', 'MdbGreenplumClusterMaintenanceWindowArgsDict']]] = None,
                 master_host_count: Optional[pulumi.Input[_builtins.int]] = None,
                 master_host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 master_subcluster: Optional[pulumi.Input[Union['MdbGreenplumClusterMasterSubclusterArgs', 'MdbGreenplumClusterMasterSubclusterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pooler_config: Optional[pulumi.Input[Union['MdbGreenplumClusterPoolerConfigArgs', 'MdbGreenplumClusterPoolerConfigArgsDict']]] = None,
                 pxf_config: Optional[pulumi.Input[Union['MdbGreenplumClusterPxfConfigArgs', 'MdbGreenplumClusterPxfConfigArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 segment_host_count: Optional[pulumi.Input[_builtins.int]] = None,
                 segment_host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 segment_in_host: Optional[pulumi.Input[_builtins.int]] = None,
                 segment_subcluster: Optional[pulumi.Input[Union['MdbGreenplumClusterSegmentSubclusterArgs', 'MdbGreenplumClusterSegmentSubclusterArgsDict']]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_password: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Greenplum cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-greenplum/).

        Please read [Pricing for Managed Service for Greenplum](https://yandex.cloud/docs/managed-greenplum/) before using Greenplum cluster.

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbGreenplumCluster:MdbGreenplumCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbGreenplumCluster:MdbGreenplumCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbGreenplumClusterAccessArgs', 'MdbGreenplumClusterAccessArgsDict']] access: Access policy to the Greenplum cluster.
        :param pulumi.Input[_builtins.bool] assign_public_ip: Sets whether the master hosts should get a public IP address on creation. Changing this parameter for an existing host is not supported at the moment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbGreenplumClusterBackgroundActivityArgs', 'MdbGreenplumClusterBackgroundActivityArgsDict']]]] background_activities: Background activities settings.
        :param pulumi.Input[Union['MdbGreenplumClusterBackupWindowStartArgs', 'MdbGreenplumClusterBackupWindowStartArgsDict']] backup_window_start: Time to start the daily backup, in the UTC timezone.
        :param pulumi.Input[Union['MdbGreenplumClusterCloudStorageArgs', 'MdbGreenplumClusterCloudStorageArgsDict']] cloud_storage: Cloud Storage settings of the Greenplum cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the Greenplum cluster. (PRODUCTION, PRESTABLE)
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] greenplum_config: Greenplum cluster config. Detail info in `Greenplum cluster settings` block.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['MdbGreenplumClusterLoggingArgs', 'MdbGreenplumClusterLoggingArgsDict']] logging: Cloud Logging settings.
        :param pulumi.Input[Union['MdbGreenplumClusterMaintenanceWindowArgs', 'MdbGreenplumClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the Greenplum cluster.
        :param pulumi.Input[_builtins.int] master_host_count: Number of hosts in master subcluster (1 or 2).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] master_host_group_ids: A list of IDs of the host groups to place master subclusters' VMs of the cluster on.
        :param pulumi.Input[Union['MdbGreenplumClusterMasterSubclusterArgs', 'MdbGreenplumClusterMasterSubclusterArgsDict']] master_subcluster: Settings for master subcluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Union['MdbGreenplumClusterPoolerConfigArgs', 'MdbGreenplumClusterPoolerConfigArgsDict']] pooler_config: Configuration of the connection pooler.
        :param pulumi.Input[Union['MdbGreenplumClusterPxfConfigArgs', 'MdbGreenplumClusterPxfConfigArgsDict']] pxf_config: Configuration of the PXF daemon.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.int] segment_host_count: Number of hosts in segment subcluster (from 1 to 32).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] segment_host_group_ids: A list of IDs of the host groups to place segment subclusters' VMs of the cluster on.
        :param pulumi.Input[_builtins.int] segment_in_host: Number of segments on segment host (not more then 1 + RAM/8).
        :param pulumi.Input[Union['MdbGreenplumClusterSegmentSubclusterArgs', 'MdbGreenplumClusterSegmentSubclusterArgsDict']] segment_subcluster: Settings for segment subcluster.
        :param pulumi.Input[_builtins.str] service_account_id: ID of service account to use with Yandex Cloud resources (e.g. S3, Cloud Logging).
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet, to which the hosts belongs. The subnet must be a part of the network to which the cluster belongs.
        :param pulumi.Input[_builtins.str] user_name: Greenplum cluster admin user name.
        :param pulumi.Input[_builtins.str] user_password: Greenplum cluster admin password name.
        :param pulumi.Input[_builtins.str] version: Version of the Greenplum cluster. (`6.25`)
        :param pulumi.Input[_builtins.str] zone: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbGreenplumClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Greenplum cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-greenplum/).

        Please read [Pricing for Managed Service for Greenplum](https://yandex.cloud/docs/managed-greenplum/) before using Greenplum cluster.

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbGreenplumCluster:MdbGreenplumCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbGreenplumCluster:MdbGreenplumCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbGreenplumClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbGreenplumClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[Union['MdbGreenplumClusterAccessArgs', 'MdbGreenplumClusterAccessArgsDict']]] = None,
                 assign_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 background_activities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbGreenplumClusterBackgroundActivityArgs', 'MdbGreenplumClusterBackgroundActivityArgsDict']]]]] = None,
                 backup_window_start: Optional[pulumi.Input[Union['MdbGreenplumClusterBackupWindowStartArgs', 'MdbGreenplumClusterBackupWindowStartArgsDict']]] = None,
                 cloud_storage: Optional[pulumi.Input[Union['MdbGreenplumClusterCloudStorageArgs', 'MdbGreenplumClusterCloudStorageArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 greenplum_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging: Optional[pulumi.Input[Union['MdbGreenplumClusterLoggingArgs', 'MdbGreenplumClusterLoggingArgsDict']]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbGreenplumClusterMaintenanceWindowArgs', 'MdbGreenplumClusterMaintenanceWindowArgsDict']]] = None,
                 master_host_count: Optional[pulumi.Input[_builtins.int]] = None,
                 master_host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 master_subcluster: Optional[pulumi.Input[Union['MdbGreenplumClusterMasterSubclusterArgs', 'MdbGreenplumClusterMasterSubclusterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pooler_config: Optional[pulumi.Input[Union['MdbGreenplumClusterPoolerConfigArgs', 'MdbGreenplumClusterPoolerConfigArgsDict']]] = None,
                 pxf_config: Optional[pulumi.Input[Union['MdbGreenplumClusterPxfConfigArgs', 'MdbGreenplumClusterPxfConfigArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 segment_host_count: Optional[pulumi.Input[_builtins.int]] = None,
                 segment_host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 segment_in_host: Optional[pulumi.Input[_builtins.int]] = None,
                 segment_subcluster: Optional[pulumi.Input[Union['MdbGreenplumClusterSegmentSubclusterArgs', 'MdbGreenplumClusterSegmentSubclusterArgsDict']]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_password: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbGreenplumClusterArgs.__new__(MdbGreenplumClusterArgs)

            __props__.__dict__["access"] = access
            if assign_public_ip is None and not opts.urn:
                raise TypeError("Missing required property 'assign_public_ip'")
            __props__.__dict__["assign_public_ip"] = assign_public_ip
            __props__.__dict__["background_activities"] = background_activities
            __props__.__dict__["backup_window_start"] = backup_window_start
            __props__.__dict__["cloud_storage"] = cloud_storage
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["greenplum_config"] = greenplum_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["logging"] = logging
            __props__.__dict__["maintenance_window"] = maintenance_window
            if master_host_count is None and not opts.urn:
                raise TypeError("Missing required property 'master_host_count'")
            __props__.__dict__["master_host_count"] = master_host_count
            __props__.__dict__["master_host_group_ids"] = master_host_group_ids
            if master_subcluster is None and not opts.urn:
                raise TypeError("Missing required property 'master_subcluster'")
            __props__.__dict__["master_subcluster"] = master_subcluster
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["pooler_config"] = pooler_config
            __props__.__dict__["pxf_config"] = pxf_config
            __props__.__dict__["security_group_ids"] = security_group_ids
            if segment_host_count is None and not opts.urn:
                raise TypeError("Missing required property 'segment_host_count'")
            __props__.__dict__["segment_host_count"] = segment_host_count
            __props__.__dict__["segment_host_group_ids"] = segment_host_group_ids
            if segment_in_host is None and not opts.urn:
                raise TypeError("Missing required property 'segment_in_host'")
            __props__.__dict__["segment_in_host"] = segment_in_host
            if segment_subcluster is None and not opts.urn:
                raise TypeError("Missing required property 'segment_subcluster'")
            __props__.__dict__["segment_subcluster"] = segment_subcluster
            __props__.__dict__["service_account_id"] = service_account_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            if user_password is None and not opts.urn:
                raise TypeError("Missing required property 'user_password'")
            __props__.__dict__["user_password"] = None if user_password is None else pulumi.Output.secret(user_password)
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["master_hosts"] = None
            __props__.__dict__["segment_hosts"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["userPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MdbGreenplumCluster, __self__).__init__(
            'yandex:index/mdbGreenplumCluster:MdbGreenplumCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[Union['MdbGreenplumClusterAccessArgs', 'MdbGreenplumClusterAccessArgsDict']]] = None,
            assign_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            background_activities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbGreenplumClusterBackgroundActivityArgs', 'MdbGreenplumClusterBackgroundActivityArgsDict']]]]] = None,
            backup_window_start: Optional[pulumi.Input[Union['MdbGreenplumClusterBackupWindowStartArgs', 'MdbGreenplumClusterBackupWindowStartArgsDict']]] = None,
            cloud_storage: Optional[pulumi.Input[Union['MdbGreenplumClusterCloudStorageArgs', 'MdbGreenplumClusterCloudStorageArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            greenplum_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            health: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            logging: Optional[pulumi.Input[Union['MdbGreenplumClusterLoggingArgs', 'MdbGreenplumClusterLoggingArgsDict']]] = None,
            maintenance_window: Optional[pulumi.Input[Union['MdbGreenplumClusterMaintenanceWindowArgs', 'MdbGreenplumClusterMaintenanceWindowArgsDict']]] = None,
            master_host_count: Optional[pulumi.Input[_builtins.int]] = None,
            master_host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            master_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbGreenplumClusterMasterHostArgs', 'MdbGreenplumClusterMasterHostArgsDict']]]]] = None,
            master_subcluster: Optional[pulumi.Input[Union['MdbGreenplumClusterMasterSubclusterArgs', 'MdbGreenplumClusterMasterSubclusterArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            pooler_config: Optional[pulumi.Input[Union['MdbGreenplumClusterPoolerConfigArgs', 'MdbGreenplumClusterPoolerConfigArgsDict']]] = None,
            pxf_config: Optional[pulumi.Input[Union['MdbGreenplumClusterPxfConfigArgs', 'MdbGreenplumClusterPxfConfigArgsDict']]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            segment_host_count: Optional[pulumi.Input[_builtins.int]] = None,
            segment_host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            segment_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbGreenplumClusterSegmentHostArgs', 'MdbGreenplumClusterSegmentHostArgsDict']]]]] = None,
            segment_in_host: Optional[pulumi.Input[_builtins.int]] = None,
            segment_subcluster: Optional[pulumi.Input[Union['MdbGreenplumClusterSegmentSubclusterArgs', 'MdbGreenplumClusterSegmentSubclusterArgsDict']]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None,
            user_password: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'MdbGreenplumCluster':
        """
        Get an existing MdbGreenplumCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbGreenplumClusterAccessArgs', 'MdbGreenplumClusterAccessArgsDict']] access: Access policy to the Greenplum cluster.
        :param pulumi.Input[_builtins.bool] assign_public_ip: Sets whether the master hosts should get a public IP address on creation. Changing this parameter for an existing host is not supported at the moment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbGreenplumClusterBackgroundActivityArgs', 'MdbGreenplumClusterBackgroundActivityArgsDict']]]] background_activities: Background activities settings.
        :param pulumi.Input[Union['MdbGreenplumClusterBackupWindowStartArgs', 'MdbGreenplumClusterBackupWindowStartArgsDict']] backup_window_start: Time to start the daily backup, in the UTC timezone.
        :param pulumi.Input[Union['MdbGreenplumClusterCloudStorageArgs', 'MdbGreenplumClusterCloudStorageArgsDict']] cloud_storage: Cloud Storage settings of the Greenplum cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the Greenplum cluster. (PRODUCTION, PRESTABLE)
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] greenplum_config: Greenplum cluster config. Detail info in `Greenplum cluster settings` block.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['MdbGreenplumClusterLoggingArgs', 'MdbGreenplumClusterLoggingArgsDict']] logging: Cloud Logging settings.
        :param pulumi.Input[Union['MdbGreenplumClusterMaintenanceWindowArgs', 'MdbGreenplumClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the Greenplum cluster.
        :param pulumi.Input[_builtins.int] master_host_count: Number of hosts in master subcluster (1 or 2).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] master_host_group_ids: A list of IDs of the host groups to place master subclusters' VMs of the cluster on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbGreenplumClusterMasterHostArgs', 'MdbGreenplumClusterMasterHostArgsDict']]]] master_hosts: Info about hosts in master subcluster.
        :param pulumi.Input[Union['MdbGreenplumClusterMasterSubclusterArgs', 'MdbGreenplumClusterMasterSubclusterArgsDict']] master_subcluster: Settings for master subcluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Union['MdbGreenplumClusterPoolerConfigArgs', 'MdbGreenplumClusterPoolerConfigArgsDict']] pooler_config: Configuration of the connection pooler.
        :param pulumi.Input[Union['MdbGreenplumClusterPxfConfigArgs', 'MdbGreenplumClusterPxfConfigArgsDict']] pxf_config: Configuration of the PXF daemon.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.int] segment_host_count: Number of hosts in segment subcluster (from 1 to 32).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] segment_host_group_ids: A list of IDs of the host groups to place segment subclusters' VMs of the cluster on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbGreenplumClusterSegmentHostArgs', 'MdbGreenplumClusterSegmentHostArgsDict']]]] segment_hosts: Info about hosts in segment subcluster.
        :param pulumi.Input[_builtins.int] segment_in_host: Number of segments on segment host (not more then 1 + RAM/8).
        :param pulumi.Input[Union['MdbGreenplumClusterSegmentSubclusterArgs', 'MdbGreenplumClusterSegmentSubclusterArgsDict']] segment_subcluster: Settings for segment subcluster.
        :param pulumi.Input[_builtins.str] service_account_id: ID of service account to use with Yandex Cloud resources (e.g. S3, Cloud Logging).
        :param pulumi.Input[_builtins.str] status: Status of the cluster.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet, to which the hosts belongs. The subnet must be a part of the network to which the cluster belongs.
        :param pulumi.Input[_builtins.str] user_name: Greenplum cluster admin user name.
        :param pulumi.Input[_builtins.str] user_password: Greenplum cluster admin password name.
        :param pulumi.Input[_builtins.str] version: Version of the Greenplum cluster. (`6.25`)
        :param pulumi.Input[_builtins.str] zone: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbGreenplumClusterState.__new__(_MdbGreenplumClusterState)

        __props__.__dict__["access"] = access
        __props__.__dict__["assign_public_ip"] = assign_public_ip
        __props__.__dict__["background_activities"] = background_activities
        __props__.__dict__["backup_window_start"] = backup_window_start
        __props__.__dict__["cloud_storage"] = cloud_storage
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["greenplum_config"] = greenplum_config
        __props__.__dict__["health"] = health
        __props__.__dict__["labels"] = labels
        __props__.__dict__["logging"] = logging
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["master_host_count"] = master_host_count
        __props__.__dict__["master_host_group_ids"] = master_host_group_ids
        __props__.__dict__["master_hosts"] = master_hosts
        __props__.__dict__["master_subcluster"] = master_subcluster
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["pooler_config"] = pooler_config
        __props__.__dict__["pxf_config"] = pxf_config
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["segment_host_count"] = segment_host_count
        __props__.__dict__["segment_host_group_ids"] = segment_host_group_ids
        __props__.__dict__["segment_hosts"] = segment_hosts
        __props__.__dict__["segment_in_host"] = segment_in_host
        __props__.__dict__["segment_subcluster"] = segment_subcluster
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["user_password"] = user_password
        __props__.__dict__["version"] = version
        __props__.__dict__["zone"] = zone
        return MdbGreenplumCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def access(self) -> pulumi.Output['outputs.MdbGreenplumClusterAccess']:
        """
        Access policy to the Greenplum cluster.
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> pulumi.Output[_builtins.bool]:
        """
        Sets whether the master hosts should get a public IP address on creation. Changing this parameter for an existing host is not supported at the moment.
        """
        return pulumi.get(self, "assign_public_ip")

    @_builtins.property
    @pulumi.getter(name="backgroundActivities")
    def background_activities(self) -> pulumi.Output[Optional[Sequence['outputs.MdbGreenplumClusterBackgroundActivity']]]:
        """
        Background activities settings.
        """
        return pulumi.get(self, "background_activities")

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> pulumi.Output['outputs.MdbGreenplumClusterBackupWindowStart']:
        """
        Time to start the daily backup, in the UTC timezone.
        """
        return pulumi.get(self, "backup_window_start")

    @_builtins.property
    @pulumi.getter(name="cloudStorage")
    def cloud_storage(self) -> pulumi.Output['outputs.MdbGreenplumClusterCloudStorage']:
        """
        Cloud Storage settings of the Greenplum cluster.
        """
        return pulumi.get(self, "cloud_storage")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment environment of the Greenplum cluster. (PRODUCTION, PRESTABLE)
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="greenplumConfig")
    def greenplum_config(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Greenplum cluster config. Detail info in `Greenplum cluster settings` block.
        """
        return pulumi.get(self, "greenplum_config")

    @_builtins.property
    @pulumi.getter
    def health(self) -> pulumi.Output[_builtins.str]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> pulumi.Output['outputs.MdbGreenplumClusterLogging']:
        """
        Cloud Logging settings.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.MdbGreenplumClusterMaintenanceWindow']:
        """
        Maintenance policy of the Greenplum cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="masterHostCount")
    def master_host_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of hosts in master subcluster (1 or 2).
        """
        return pulumi.get(self, "master_host_count")

    @_builtins.property
    @pulumi.getter(name="masterHostGroupIds")
    def master_host_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of IDs of the host groups to place master subclusters' VMs of the cluster on.
        """
        return pulumi.get(self, "master_host_group_ids")

    @_builtins.property
    @pulumi.getter(name="masterHosts")
    def master_hosts(self) -> pulumi.Output[Sequence['outputs.MdbGreenplumClusterMasterHost']]:
        """
        Info about hosts in master subcluster.
        """
        return pulumi.get(self, "master_hosts")

    @_builtins.property
    @pulumi.getter(name="masterSubcluster")
    def master_subcluster(self) -> pulumi.Output['outputs.MdbGreenplumClusterMasterSubcluster']:
        """
        Settings for master subcluster.
        """
        return pulumi.get(self, "master_subcluster")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="poolerConfig")
    def pooler_config(self) -> pulumi.Output['outputs.MdbGreenplumClusterPoolerConfig']:
        """
        Configuration of the connection pooler.
        """
        return pulumi.get(self, "pooler_config")

    @_builtins.property
    @pulumi.getter(name="pxfConfig")
    def pxf_config(self) -> pulumi.Output['outputs.MdbGreenplumClusterPxfConfig']:
        """
        Configuration of the PXF daemon.
        """
        return pulumi.get(self, "pxf_config")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="segmentHostCount")
    def segment_host_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of hosts in segment subcluster (from 1 to 32).
        """
        return pulumi.get(self, "segment_host_count")

    @_builtins.property
    @pulumi.getter(name="segmentHostGroupIds")
    def segment_host_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of IDs of the host groups to place segment subclusters' VMs of the cluster on.
        """
        return pulumi.get(self, "segment_host_group_ids")

    @_builtins.property
    @pulumi.getter(name="segmentHosts")
    def segment_hosts(self) -> pulumi.Output[Sequence['outputs.MdbGreenplumClusterSegmentHost']]:
        """
        Info about hosts in segment subcluster.
        """
        return pulumi.get(self, "segment_hosts")

    @_builtins.property
    @pulumi.getter(name="segmentInHost")
    def segment_in_host(self) -> pulumi.Output[_builtins.int]:
        """
        Number of segments on segment host (not more then 1 + RAM/8).
        """
        return pulumi.get(self, "segment_in_host")

    @_builtins.property
    @pulumi.getter(name="segmentSubcluster")
    def segment_subcluster(self) -> pulumi.Output['outputs.MdbGreenplumClusterSegmentSubcluster']:
        """
        Settings for segment subcluster.
        """
        return pulumi.get(self, "segment_subcluster")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of service account to use with Yandex Cloud resources (e.g. S3, Cloud Logging).
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the subnet, to which the hosts belongs. The subnet must be a part of the network to which the cluster belongs.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        Greenplum cluster admin user name.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> pulumi.Output[_builtins.str]:
        """
        Greenplum cluster admin password name.
        """
        return pulumi.get(self, "user_password")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the Greenplum cluster. (`6.25`)
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone")

