# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbMysqlClusterArgs', 'MdbMysqlCluster']

@pulumi.input_type
class MdbMysqlClusterArgs:
    def __init__(__self__, *,
                 environment: pulumi.Input[_builtins.str],
                 hosts: pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]],
                 network_id: pulumi.Input[_builtins.str],
                 resources: pulumi.Input['MdbMysqlClusterResourcesArgs'],
                 version: pulumi.Input[_builtins.str],
                 access: Optional[pulumi.Input['MdbMysqlClusterAccessArgs']] = None,
                 allow_regeneration_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_window_start: Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling: Optional[pulumi.Input['MdbMysqlClusterDiskSizeAutoscalingArgs']] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']] = None,
                 mysql_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_diagnostics: Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']] = None,
                 restore: Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]] = None):
        """
        The set of arguments for constructing a MdbMysqlCluster resource.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the MySQL cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]] hosts: A host of the MySQL cluster.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input['MdbMysqlClusterResourcesArgs'] resources: Resources allocated to hosts of the MySQL cluster.
        :param pulumi.Input[_builtins.str] version: Version of the MySQL cluster. (allowed versions are: 5.7, 8.0).
        :param pulumi.Input['MdbMysqlClusterAccessArgs'] access: Access policy to the MySQL cluster.
        :param pulumi.Input[_builtins.bool] allow_regeneration_host: Deprecated field. You can safely remove this option. There is no need to recreate host if assign*public*ip is changed.
               Regenerate hosts after changing the assign*public*ip parameter.
        :param pulumi.Input[_builtins.int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input['MdbMysqlClusterBackupWindowStartArgs'] backup_window_start: Time to start the daily backup, in the UTC.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]] databases: To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        :param pulumi.Input['MdbMysqlClusterDiskSizeAutoscalingArgs'] disk_size_autoscaling: Cluster disk size autoscaling settings.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of host group IDs to place VMs of the cluster on.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the MySQL cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] mysql_config: MySQL cluster config block.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs'] performance_diagnostics: Cluster performance diagnostics settings. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics).
        :param pulumi.Input['MdbMysqlClusterRestoreArgs'] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]] users: To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "version", version)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if allow_regeneration_host is not None:
            warnings.warn("""You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""", DeprecationWarning)
            pulumi.log.warn("""allow_regeneration_host is deprecated: You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""")
        if allow_regeneration_host is not None:
            pulumi.set(__self__, "allow_regeneration_host", allow_regeneration_host)
        if backup_retain_period_days is not None:
            pulumi.set(__self__, "backup_retain_period_days", backup_retain_period_days)
        if backup_window_start is not None:
            pulumi.set(__self__, "backup_window_start", backup_window_start)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_id is not None:
            pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if disk_size_autoscaling is not None:
            pulumi.set(__self__, "disk_size_autoscaling", disk_size_autoscaling)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if mysql_config is not None:
            pulumi.set(__self__, "mysql_config", mysql_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_diagnostics is not None:
            pulumi.set(__self__, "performance_diagnostics", performance_diagnostics)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        Deployment environment of the MySQL cluster.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]]:
        """
        A host of the MySQL cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Input['MdbMysqlClusterResourcesArgs']:
        """
        Resources allocated to hosts of the MySQL cluster.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input['MdbMysqlClusterResourcesArgs']):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        Version of the MySQL cluster. (allowed versions are: 5.7, 8.0).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input['MdbMysqlClusterAccessArgs']]:
        """
        Access policy to the MySQL cluster.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input['MdbMysqlClusterAccessArgs']]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter(name="allowRegenerationHost")
    @_utilities.deprecated("""You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""")
    def allow_regeneration_host(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deprecated field. You can safely remove this option. There is no need to recreate host if assign*public*ip is changed.
        Regenerate hosts after changing the assign*public*ip parameter.
        """
        return pulumi.get(self, "allow_regeneration_host")

    @allow_regeneration_host.setter
    def allow_regeneration_host(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_regeneration_host", value)

    @_builtins.property
    @pulumi.getter(name="backupRetainPeriodDays")
    def backup_retain_period_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period in days during which backups are stored.
        """
        return pulumi.get(self, "backup_retain_period_days")

    @backup_retain_period_days.setter
    def backup_retain_period_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retain_period_days", value)

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']]:
        """
        Time to start the daily backup, in the UTC.
        """
        return pulumi.get(self, "backup_window_start")

    @backup_window_start.setter
    def backup_window_start(self, value: Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']]):
        pulumi.set(self, "backup_window_start", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]]:
        """
        To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @disk_encryption_key_id.setter
    def disk_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscaling")
    def disk_size_autoscaling(self) -> Optional[pulumi.Input['MdbMysqlClusterDiskSizeAutoscalingArgs']]:
        """
        Cluster disk size autoscaling settings.
        """
        return pulumi.get(self, "disk_size_autoscaling")

    @disk_size_autoscaling.setter
    def disk_size_autoscaling(self, value: Optional[pulumi.Input['MdbMysqlClusterDiskSizeAutoscalingArgs']]):
        pulumi.set(self, "disk_size_autoscaling", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of host group IDs to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the MySQL cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="mysqlConfig")
    def mysql_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        MySQL cluster config block.
        """
        return pulumi.get(self, "mysql_config")

    @mysql_config.setter
    def mysql_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mysql_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="performanceDiagnostics")
    def performance_diagnostics(self) -> Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']]:
        """
        Cluster performance diagnostics settings. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics).
        """
        return pulumi.get(self, "performance_diagnostics")

    @performance_diagnostics.setter
    def performance_diagnostics(self, value: Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']]):
        pulumi.set(self, "performance_diagnostics", value)

    @_builtins.property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']]:
        """
        The cluster will be created from the specified backup.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]]:
        """
        To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _MdbMysqlClusterState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input['MdbMysqlClusterAccessArgs']] = None,
                 allow_regeneration_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_window_start: Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling: Optional[pulumi.Input['MdbMysqlClusterDiskSizeAutoscalingArgs']] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']] = None,
                 mysql_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_diagnostics: Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']] = None,
                 resources: Optional[pulumi.Input['MdbMysqlClusterResourcesArgs']] = None,
                 restore: Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MdbMysqlCluster resources.
        :param pulumi.Input['MdbMysqlClusterAccessArgs'] access: Access policy to the MySQL cluster.
        :param pulumi.Input[_builtins.bool] allow_regeneration_host: Deprecated field. You can safely remove this option. There is no need to recreate host if assign*public*ip is changed.
               Regenerate hosts after changing the assign*public*ip parameter.
        :param pulumi.Input[_builtins.int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input['MdbMysqlClusterBackupWindowStartArgs'] backup_window_start: Time to start the daily backup, in the UTC.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]] databases: To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        :param pulumi.Input['MdbMysqlClusterDiskSizeAutoscalingArgs'] disk_size_autoscaling: Cluster disk size autoscaling settings.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the MySQL cluster.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of host group IDs to place VMs of the cluster on.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]] hosts: A host of the MySQL cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the MySQL cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] mysql_config: MySQL cluster config block.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs'] performance_diagnostics: Cluster performance diagnostics settings. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics).
        :param pulumi.Input['MdbMysqlClusterResourcesArgs'] resources: Resources allocated to hosts of the MySQL cluster.
        :param pulumi.Input['MdbMysqlClusterRestoreArgs'] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] status: Status of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]] users: To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        :param pulumi.Input[_builtins.str] version: Version of the MySQL cluster. (allowed versions are: 5.7, 8.0).
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if allow_regeneration_host is not None:
            warnings.warn("""You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""", DeprecationWarning)
            pulumi.log.warn("""allow_regeneration_host is deprecated: You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""")
        if allow_regeneration_host is not None:
            pulumi.set(__self__, "allow_regeneration_host", allow_regeneration_host)
        if backup_retain_period_days is not None:
            pulumi.set(__self__, "backup_retain_period_days", backup_retain_period_days)
        if backup_window_start is not None:
            pulumi.set(__self__, "backup_window_start", backup_window_start)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_id is not None:
            pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if disk_size_autoscaling is not None:
            pulumi.set(__self__, "disk_size_autoscaling", disk_size_autoscaling)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if mysql_config is not None:
            pulumi.set(__self__, "mysql_config", mysql_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if performance_diagnostics is not None:
            pulumi.set(__self__, "performance_diagnostics", performance_diagnostics)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input['MdbMysqlClusterAccessArgs']]:
        """
        Access policy to the MySQL cluster.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input['MdbMysqlClusterAccessArgs']]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter(name="allowRegenerationHost")
    @_utilities.deprecated("""You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""")
    def allow_regeneration_host(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deprecated field. You can safely remove this option. There is no need to recreate host if assign*public*ip is changed.
        Regenerate hosts after changing the assign*public*ip parameter.
        """
        return pulumi.get(self, "allow_regeneration_host")

    @allow_regeneration_host.setter
    def allow_regeneration_host(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_regeneration_host", value)

    @_builtins.property
    @pulumi.getter(name="backupRetainPeriodDays")
    def backup_retain_period_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period in days during which backups are stored.
        """
        return pulumi.get(self, "backup_retain_period_days")

    @backup_retain_period_days.setter
    def backup_retain_period_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retain_period_days", value)

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']]:
        """
        Time to start the daily backup, in the UTC.
        """
        return pulumi.get(self, "backup_window_start")

    @backup_window_start.setter
    def backup_window_start(self, value: Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']]):
        pulumi.set(self, "backup_window_start", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]]:
        """
        To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @disk_encryption_key_id.setter
    def disk_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscaling")
    def disk_size_autoscaling(self) -> Optional[pulumi.Input['MdbMysqlClusterDiskSizeAutoscalingArgs']]:
        """
        Cluster disk size autoscaling settings.
        """
        return pulumi.get(self, "disk_size_autoscaling")

    @disk_size_autoscaling.setter
    def disk_size_autoscaling(self, value: Optional[pulumi.Input['MdbMysqlClusterDiskSizeAutoscalingArgs']]):
        pulumi.set(self, "disk_size_autoscaling", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment environment of the MySQL cluster.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of host group IDs to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]]]:
        """
        A host of the MySQL cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the MySQL cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="mysqlConfig")
    def mysql_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        MySQL cluster config block.
        """
        return pulumi.get(self, "mysql_config")

    @mysql_config.setter
    def mysql_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mysql_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="performanceDiagnostics")
    def performance_diagnostics(self) -> Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']]:
        """
        Cluster performance diagnostics settings. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics).
        """
        return pulumi.get(self, "performance_diagnostics")

    @performance_diagnostics.setter
    def performance_diagnostics(self, value: Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']]):
        pulumi.set(self, "performance_diagnostics", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['MdbMysqlClusterResourcesArgs']]:
        """
        Resources allocated to hosts of the MySQL cluster.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['MdbMysqlClusterResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']]:
        """
        The cluster will be created from the specified backup.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]]:
        """
        To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]]):
        pulumi.set(self, "users", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the MySQL cluster. (allowed versions are: 5.7, 8.0).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("yandex:index/mdbMysqlCluster:MdbMysqlCluster")
class MdbMysqlCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[Union['MdbMysqlClusterAccessArgs', 'MdbMysqlClusterAccessArgsDict']]] = None,
                 allow_regeneration_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_window_start: Optional[pulumi.Input[Union['MdbMysqlClusterBackupWindowStartArgs', 'MdbMysqlClusterBackupWindowStartArgsDict']]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterDatabaseArgs', 'MdbMysqlClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling: Optional[pulumi.Input[Union['MdbMysqlClusterDiskSizeAutoscalingArgs', 'MdbMysqlClusterDiskSizeAutoscalingArgsDict']]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterHostArgs', 'MdbMysqlClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbMysqlClusterMaintenanceWindowArgs', 'MdbMysqlClusterMaintenanceWindowArgsDict']]] = None,
                 mysql_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_diagnostics: Optional[pulumi.Input[Union['MdbMysqlClusterPerformanceDiagnosticsArgs', 'MdbMysqlClusterPerformanceDiagnosticsArgsDict']]] = None,
                 resources: Optional[pulumi.Input[Union['MdbMysqlClusterResourcesArgs', 'MdbMysqlClusterResourcesArgsDict']]] = None,
                 restore: Optional[pulumi.Input[Union['MdbMysqlClusterRestoreArgs', 'MdbMysqlClusterRestoreArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterUserArgs', 'MdbMysqlClusterUserArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a MySQL cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-mysql/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB MySQL Cluster.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            mysql_config={
                "sql_mode": "ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION",
                "max_connections": "100",
                "default_authentication_plugin": "MYSQL_NATIVE_PASSWORD",
                "innodb_print_all_deadlocks": "true",
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        #
        # Create a new MDB High Availability MySQL Cluster.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            maintenance_window={
                "type": "WEEKLY",
                "day": "SAT",
                "hour": 12,
            },
            hosts=[
                {
                    "zone": "ru-central1-b",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-d",
                    "subnet_id": bar.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        #
        # Create a new MDB HA MySQL Cluster with cascade replicas.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            maintenance_window={
                "type": "WEEKLY",
                "day": "SAT",
                "hour": 12,
            },
            hosts=[
                {
                    "zone": "ru-central1-b",
                    "name": "na-1",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "na-2",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-b",
                    "name": "nb-1",
                    "replication_source_name": "na-1",
                    "subnet_id": bar.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "nb-2",
                    "replication_source_name": "nb-1",
                    "subnet_id": bar.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        #
        # Create a new MDB MySQL Cluster with different backup priorities.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            maintenance_window={
                "type": "WEEKLY",
                "day": "SAT",
                "hour": 12,
            },
            hosts=[
                {
                    "zone": "ru-central1-b",
                    "name": "na-1",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "nb-1",
                    "backup_priority": 5,
                    "subnet_id": bar.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "nb-2",
                    "backup_priority": 10,
                    "subnet_id": bar.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        #
        # Create a new MDB MySQL Cluster with different host priorities.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            maintenance_window={
                "type": "WEEKLY",
                "day": "SAT",
                "hour": 12,
            },
            hosts=[
                {
                    "zone": "ru-central1-b",
                    "name": "na-1",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "nb-1",
                    "priority": 5,
                    "subnet_id": bar.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "nb-2",
                    "priority": 10,
                    "subnet_id": bar.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB MySQL Cluster with user's params.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            maintenance_window={
                "type": "ANYTIME",
            },
            hosts=[{
                "zone": "ru-central1-b",
                "subnet_id": foo_vpc_subnet.id,
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbMysqlCluster:MdbMysqlCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbMysqlCluster:MdbMysqlCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbMysqlClusterAccessArgs', 'MdbMysqlClusterAccessArgsDict']] access: Access policy to the MySQL cluster.
        :param pulumi.Input[_builtins.bool] allow_regeneration_host: Deprecated field. You can safely remove this option. There is no need to recreate host if assign*public*ip is changed.
               Regenerate hosts after changing the assign*public*ip parameter.
        :param pulumi.Input[_builtins.int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input[Union['MdbMysqlClusterBackupWindowStartArgs', 'MdbMysqlClusterBackupWindowStartArgsDict']] backup_window_start: Time to start the daily backup, in the UTC.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterDatabaseArgs', 'MdbMysqlClusterDatabaseArgsDict']]]] databases: To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        :param pulumi.Input[Union['MdbMysqlClusterDiskSizeAutoscalingArgs', 'MdbMysqlClusterDiskSizeAutoscalingArgsDict']] disk_size_autoscaling: Cluster disk size autoscaling settings.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the MySQL cluster.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of host group IDs to place VMs of the cluster on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterHostArgs', 'MdbMysqlClusterHostArgsDict']]]] hosts: A host of the MySQL cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['MdbMysqlClusterMaintenanceWindowArgs', 'MdbMysqlClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the MySQL cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] mysql_config: MySQL cluster config block.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Union['MdbMysqlClusterPerformanceDiagnosticsArgs', 'MdbMysqlClusterPerformanceDiagnosticsArgsDict']] performance_diagnostics: Cluster performance diagnostics settings. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics).
        :param pulumi.Input[Union['MdbMysqlClusterResourcesArgs', 'MdbMysqlClusterResourcesArgsDict']] resources: Resources allocated to hosts of the MySQL cluster.
        :param pulumi.Input[Union['MdbMysqlClusterRestoreArgs', 'MdbMysqlClusterRestoreArgsDict']] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterUserArgs', 'MdbMysqlClusterUserArgsDict']]]] users: To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        :param pulumi.Input[_builtins.str] version: Version of the MySQL cluster. (allowed versions are: 5.7, 8.0).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbMysqlClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a MySQL cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-mysql/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB MySQL Cluster.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            mysql_config={
                "sql_mode": "ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION",
                "max_connections": "100",
                "default_authentication_plugin": "MYSQL_NATIVE_PASSWORD",
                "innodb_print_all_deadlocks": "true",
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        #
        # Create a new MDB High Availability MySQL Cluster.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            maintenance_window={
                "type": "WEEKLY",
                "day": "SAT",
                "hour": 12,
            },
            hosts=[
                {
                    "zone": "ru-central1-b",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-d",
                    "subnet_id": bar.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        #
        # Create a new MDB HA MySQL Cluster with cascade replicas.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            maintenance_window={
                "type": "WEEKLY",
                "day": "SAT",
                "hour": 12,
            },
            hosts=[
                {
                    "zone": "ru-central1-b",
                    "name": "na-1",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "na-2",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-b",
                    "name": "nb-1",
                    "replication_source_name": "na-1",
                    "subnet_id": bar.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "nb-2",
                    "replication_source_name": "nb-1",
                    "subnet_id": bar.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        #
        # Create a new MDB MySQL Cluster with different backup priorities.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            maintenance_window={
                "type": "WEEKLY",
                "day": "SAT",
                "hour": 12,
            },
            hosts=[
                {
                    "zone": "ru-central1-b",
                    "name": "na-1",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "nb-1",
                    "backup_priority": 5,
                    "subnet_id": bar.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "nb-2",
                    "backup_priority": 10,
                    "subnet_id": bar.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        #
        # Create a new MDB MySQL Cluster with different host priorities.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            maintenance_window={
                "type": "WEEKLY",
                "day": "SAT",
                "hour": 12,
            },
            hosts=[
                {
                    "zone": "ru-central1-b",
                    "name": "na-1",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "nb-1",
                    "priority": 5,
                    "subnet_id": bar.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "nb-2",
                    "priority": 10,
                    "subnet_id": bar.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB MySQL Cluster with user's params.
        #
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            maintenance_window={
                "type": "ANYTIME",
            },
            hosts=[{
                "zone": "ru-central1-b",
                "subnet_id": foo_vpc_subnet.id,
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbMysqlCluster:MdbMysqlCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbMysqlCluster:MdbMysqlCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbMysqlClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbMysqlClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[Union['MdbMysqlClusterAccessArgs', 'MdbMysqlClusterAccessArgsDict']]] = None,
                 allow_regeneration_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_window_start: Optional[pulumi.Input[Union['MdbMysqlClusterBackupWindowStartArgs', 'MdbMysqlClusterBackupWindowStartArgsDict']]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterDatabaseArgs', 'MdbMysqlClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling: Optional[pulumi.Input[Union['MdbMysqlClusterDiskSizeAutoscalingArgs', 'MdbMysqlClusterDiskSizeAutoscalingArgsDict']]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterHostArgs', 'MdbMysqlClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbMysqlClusterMaintenanceWindowArgs', 'MdbMysqlClusterMaintenanceWindowArgsDict']]] = None,
                 mysql_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_diagnostics: Optional[pulumi.Input[Union['MdbMysqlClusterPerformanceDiagnosticsArgs', 'MdbMysqlClusterPerformanceDiagnosticsArgsDict']]] = None,
                 resources: Optional[pulumi.Input[Union['MdbMysqlClusterResourcesArgs', 'MdbMysqlClusterResourcesArgsDict']]] = None,
                 restore: Optional[pulumi.Input[Union['MdbMysqlClusterRestoreArgs', 'MdbMysqlClusterRestoreArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterUserArgs', 'MdbMysqlClusterUserArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbMysqlClusterArgs.__new__(MdbMysqlClusterArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["allow_regeneration_host"] = allow_regeneration_host
            __props__.__dict__["backup_retain_period_days"] = backup_retain_period_days
            __props__.__dict__["backup_window_start"] = backup_window_start
            __props__.__dict__["databases"] = databases
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_encryption_key_id"] = disk_encryption_key_id
            __props__.__dict__["disk_size_autoscaling"] = disk_size_autoscaling
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["host_group_ids"] = host_group_ids
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["mysql_config"] = mysql_config
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["performance_diagnostics"] = performance_diagnostics
            if resources is None and not opts.urn:
                raise TypeError("Missing required property 'resources'")
            __props__.__dict__["resources"] = resources
            __props__.__dict__["restore"] = restore
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["users"] = users
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["status"] = None
        super(MdbMysqlCluster, __self__).__init__(
            'yandex:index/mdbMysqlCluster:MdbMysqlCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[Union['MdbMysqlClusterAccessArgs', 'MdbMysqlClusterAccessArgsDict']]] = None,
            allow_regeneration_host: Optional[pulumi.Input[_builtins.bool]] = None,
            backup_retain_period_days: Optional[pulumi.Input[_builtins.int]] = None,
            backup_window_start: Optional[pulumi.Input[Union['MdbMysqlClusterBackupWindowStartArgs', 'MdbMysqlClusterBackupWindowStartArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterDatabaseArgs', 'MdbMysqlClusterDatabaseArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_size_autoscaling: Optional[pulumi.Input[Union['MdbMysqlClusterDiskSizeAutoscalingArgs', 'MdbMysqlClusterDiskSizeAutoscalingArgsDict']]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            health: Optional[pulumi.Input[_builtins.str]] = None,
            host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterHostArgs', 'MdbMysqlClusterHostArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            maintenance_window: Optional[pulumi.Input[Union['MdbMysqlClusterMaintenanceWindowArgs', 'MdbMysqlClusterMaintenanceWindowArgsDict']]] = None,
            mysql_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            performance_diagnostics: Optional[pulumi.Input[Union['MdbMysqlClusterPerformanceDiagnosticsArgs', 'MdbMysqlClusterPerformanceDiagnosticsArgsDict']]] = None,
            resources: Optional[pulumi.Input[Union['MdbMysqlClusterResourcesArgs', 'MdbMysqlClusterResourcesArgsDict']]] = None,
            restore: Optional[pulumi.Input[Union['MdbMysqlClusterRestoreArgs', 'MdbMysqlClusterRestoreArgsDict']]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterUserArgs', 'MdbMysqlClusterUserArgsDict']]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'MdbMysqlCluster':
        """
        Get an existing MdbMysqlCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbMysqlClusterAccessArgs', 'MdbMysqlClusterAccessArgsDict']] access: Access policy to the MySQL cluster.
        :param pulumi.Input[_builtins.bool] allow_regeneration_host: Deprecated field. You can safely remove this option. There is no need to recreate host if assign*public*ip is changed.
               Regenerate hosts after changing the assign*public*ip parameter.
        :param pulumi.Input[_builtins.int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input[Union['MdbMysqlClusterBackupWindowStartArgs', 'MdbMysqlClusterBackupWindowStartArgsDict']] backup_window_start: Time to start the daily backup, in the UTC.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterDatabaseArgs', 'MdbMysqlClusterDatabaseArgsDict']]]] databases: To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        :param pulumi.Input[Union['MdbMysqlClusterDiskSizeAutoscalingArgs', 'MdbMysqlClusterDiskSizeAutoscalingArgsDict']] disk_size_autoscaling: Cluster disk size autoscaling settings.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the MySQL cluster.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of host group IDs to place VMs of the cluster on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterHostArgs', 'MdbMysqlClusterHostArgsDict']]]] hosts: A host of the MySQL cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['MdbMysqlClusterMaintenanceWindowArgs', 'MdbMysqlClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the MySQL cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] mysql_config: MySQL cluster config block.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Union['MdbMysqlClusterPerformanceDiagnosticsArgs', 'MdbMysqlClusterPerformanceDiagnosticsArgsDict']] performance_diagnostics: Cluster performance diagnostics settings. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics).
        :param pulumi.Input[Union['MdbMysqlClusterResourcesArgs', 'MdbMysqlClusterResourcesArgsDict']] resources: Resources allocated to hosts of the MySQL cluster.
        :param pulumi.Input[Union['MdbMysqlClusterRestoreArgs', 'MdbMysqlClusterRestoreArgsDict']] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] status: Status of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterUserArgs', 'MdbMysqlClusterUserArgsDict']]]] users: To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        :param pulumi.Input[_builtins.str] version: Version of the MySQL cluster. (allowed versions are: 5.7, 8.0).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbMysqlClusterState.__new__(_MdbMysqlClusterState)

        __props__.__dict__["access"] = access
        __props__.__dict__["allow_regeneration_host"] = allow_regeneration_host
        __props__.__dict__["backup_retain_period_days"] = backup_retain_period_days
        __props__.__dict__["backup_window_start"] = backup_window_start
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["databases"] = databases
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_encryption_key_id"] = disk_encryption_key_id
        __props__.__dict__["disk_size_autoscaling"] = disk_size_autoscaling
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["health"] = health
        __props__.__dict__["host_group_ids"] = host_group_ids
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["mysql_config"] = mysql_config
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["performance_diagnostics"] = performance_diagnostics
        __props__.__dict__["resources"] = resources
        __props__.__dict__["restore"] = restore
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["users"] = users
        __props__.__dict__["version"] = version
        return MdbMysqlCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def access(self) -> pulumi.Output['outputs.MdbMysqlClusterAccess']:
        """
        Access policy to the MySQL cluster.
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter(name="allowRegenerationHost")
    @_utilities.deprecated("""You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""")
    def allow_regeneration_host(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Deprecated field. You can safely remove this option. There is no need to recreate host if assign*public*ip is changed.
        Regenerate hosts after changing the assign*public*ip parameter.
        """
        return pulumi.get(self, "allow_regeneration_host")

    @_builtins.property
    @pulumi.getter(name="backupRetainPeriodDays")
    def backup_retain_period_days(self) -> pulumi.Output[_builtins.int]:
        """
        The period in days during which backups are stored.
        """
        return pulumi.get(self, "backup_retain_period_days")

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> pulumi.Output['outputs.MdbMysqlClusterBackupWindowStart']:
        """
        Time to start the daily backup, in the UTC.
        """
        return pulumi.get(self, "backup_window_start")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""")
    def databases(self) -> pulumi.Output[Optional[Sequence['outputs.MdbMysqlClusterDatabase']]]:
        """
        To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscaling")
    def disk_size_autoscaling(self) -> pulumi.Output['outputs.MdbMysqlClusterDiskSizeAutoscaling']:
        """
        Cluster disk size autoscaling settings.
        """
        return pulumi.get(self, "disk_size_autoscaling")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment environment of the MySQL cluster.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> pulumi.Output[_builtins.str]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of host group IDs to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.MdbMysqlClusterHost']]:
        """
        A host of the MySQL cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.MdbMysqlClusterMaintenanceWindow']:
        """
        Maintenance policy of the MySQL cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="mysqlConfig")
    def mysql_config(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        MySQL cluster config block.
        """
        return pulumi.get(self, "mysql_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="performanceDiagnostics")
    def performance_diagnostics(self) -> pulumi.Output['outputs.MdbMysqlClusterPerformanceDiagnostics']:
        """
        Cluster performance diagnostics settings. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics).
        """
        return pulumi.get(self, "performance_diagnostics")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output['outputs.MdbMysqlClusterResources']:
        """
        Resources allocated to hosts of the MySQL cluster.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def restore(self) -> pulumi.Output[Optional['outputs.MdbMysqlClusterRestore']]:
        """
        The cluster will be created from the specified backup.
        """
        return pulumi.get(self, "restore")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""")
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.MdbMysqlClusterUser']]]:
        """
        To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        """
        return pulumi.get(self, "users")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the MySQL cluster. (allowed versions are: 5.7, 8.0).
        """
        return pulumi.get(self, "version")

