# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbPostgresqlClusterArgs', 'MdbPostgresqlCluster']

@pulumi.input_type
class MdbPostgresqlClusterArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['MdbPostgresqlClusterConfigArgs'],
                 environment: pulumi.Input[_builtins.str],
                 hosts: pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]],
                 network_id: pulumi.Input[_builtins.str],
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_master_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]] = None):
        """
        The set of arguments for constructing a MdbPostgresqlCluster resource.
        :param pulumi.Input['MdbPostgresqlClusterConfigArgs'] config: Configuration of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the PostgreSQL cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]] hosts: A host of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]] databases: > Deprecated! To manage databases, please switch to using a separate resource type `MdbPostgresqlDatabase`.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: Host Group IDs.
        :param pulumi.Input[_builtins.str] host_master_name: Deprecated field. Will be removed in future versions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['MdbPostgresqlClusterRestoreArgs'] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]] users: > Deprecated! To manage users, please switch to using a separate resource type `MdbPostgresqlUser`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "network_id", network_id)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_id is not None:
            pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if host_master_name is not None:
            warnings.warn("""It sets name of master host. It works only when `host.name` is set. This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""", DeprecationWarning)
            pulumi.log.warn("""host_master_name is deprecated: It sets name of master host. It works only when `host.name` is set. This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""")
        if host_master_name is not None:
            pulumi.set(__self__, "host_master_name", host_master_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Input['MdbPostgresqlClusterConfigArgs']:
        """
        Configuration of the PostgreSQL cluster.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['MdbPostgresqlClusterConfigArgs']):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        Deployment environment of the PostgreSQL cluster.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]]:
        """
        A host of the PostgreSQL cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]]:
        """
        > Deprecated! To manage databases, please switch to using a separate resource type `MdbPostgresqlDatabase`.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @disk_encryption_key_id.setter
    def disk_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Host Group IDs.
        """
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="hostMasterName")
    @_utilities.deprecated("""It sets name of master host. It works only when `host.name` is set. This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""")
    def host_master_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deprecated field. Will be removed in future versions.
        """
        return pulumi.get(self, "host_master_name")

    @host_master_name.setter
    def host_master_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_master_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the PostgreSQL cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']]:
        """
        The cluster will be created from the specified backup.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]]:
        """
        > Deprecated! To manage users, please switch to using a separate resource type `MdbPostgresqlUser`.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _MdbPostgresqlClusterState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['MdbPostgresqlClusterConfigArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_master_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering MdbPostgresqlCluster resources.
        :param pulumi.Input['MdbPostgresqlClusterConfigArgs'] config: Configuration of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]] databases: > Deprecated! To manage databases, please switch to using a separate resource type `MdbPostgresqlDatabase`.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: Host Group IDs.
        :param pulumi.Input[_builtins.str] host_master_name: Deprecated field. Will be removed in future versions.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]] hosts: A host of the PostgreSQL cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input['MdbPostgresqlClusterRestoreArgs'] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] status: Status of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]] users: > Deprecated! To manage users, please switch to using a separate resource type `MdbPostgresqlUser`.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_id is not None:
            pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if host_master_name is not None:
            warnings.warn("""It sets name of master host. It works only when `host.name` is set. This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""", DeprecationWarning)
            pulumi.log.warn("""host_master_name is deprecated: It sets name of master host. It works only when `host.name` is set. This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""")
        if host_master_name is not None:
            pulumi.set(__self__, "host_master_name", host_master_name)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['MdbPostgresqlClusterConfigArgs']]:
        """
        Configuration of the PostgreSQL cluster.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['MdbPostgresqlClusterConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]]:
        """
        > Deprecated! To manage databases, please switch to using a separate resource type `MdbPostgresqlDatabase`.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @disk_encryption_key_id.setter
    def disk_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment environment of the PostgreSQL cluster.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Host Group IDs.
        """
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="hostMasterName")
    @_utilities.deprecated("""It sets name of master host. It works only when `host.name` is set. This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""")
    def host_master_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deprecated field. Will be removed in future versions.
        """
        return pulumi.get(self, "host_master_name")

    @host_master_name.setter
    def host_master_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_master_name", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]]]:
        """
        A host of the PostgreSQL cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the PostgreSQL cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']]:
        """
        The cluster will be created from the specified backup.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]]:
        """
        > Deprecated! To manage users, please switch to using a separate resource type `MdbPostgresqlUser`.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("yandex:index/mdbPostgresqlCluster:MdbPostgresqlCluster")
class MdbPostgresqlCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['MdbPostgresqlClusterConfigArgs', 'MdbPostgresqlClusterConfigArgsDict']]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterDatabaseArgs', 'MdbPostgresqlClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_master_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterHostArgs', 'MdbPostgresqlClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbPostgresqlClusterMaintenanceWindowArgs', 'MdbPostgresqlClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input[Union['MdbPostgresqlClusterRestoreArgs', 'MdbPostgresqlClusterRestoreArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterUserArgs', 'MdbPostgresqlClusterUserArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB PostgreSQL Cluster.
        #
        my_cluster = yandex.MdbPostgresqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            config={
                "version": "15",
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
                "postgresql_config": {
                    "max_connections": "395",
                    "enable_parallel_hash": "true",
                    "autovacuum_vacuum_scale_factor": "0.34",
                    "default_transaction_isolation": "TRANSACTION_ISOLATION_READ_COMMITTED",
                    "shared_preload_libraries": "SHARED_PRELOAD_LIBRARIES_AUTO_EXPLAIN,SHARED_PRELOAD_LIBRARIES_PG_HINT_PLAN",
                },
            },
            maintenance_window={
                "type": "WEEKLY",
                "day": "SAT",
                "hour": 12,
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        #
        # Create a new MDB High Availability PostgreSQL Cluster.
        #
        my_cluster = yandex.MdbPostgresqlCluster("my_cluster",
            name="ha",
            environment="PRESTABLE",
            network_id=foo.id,
            config={
                "version": "15",
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
            },
            maintenance_window={
                "type": "ANYTIME",
            },
            hosts=[
                {
                    "zone": "ru-central1-b",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-d",
                    "subnet_id": bar.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        a = yandex.VpcSubnet("a",
            zone="ru-central1-a",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        b = yandex.VpcSubnet("b",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        d = yandex.VpcSubnet("d",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.3.0.0/24"])
        #
        # Create a new MDB High Availability PostgreSQL Cluster.
        #
        my_cluster = yandex.MdbPostgresqlCluster("my_cluster",
            name="test_ha",
            description="test High-Availability (HA) PostgreSQL Cluster",
            environment="PRESTABLE",
            network_id=foo.id,
            config={
                "version": "15",
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_size": 10,
                    "disk_type_id": "network-ssd",
                },
            },
            hosts=[
                {
                    "zone": "ru-central1-a",
                    "name": "host_name_a",
                    "subnet_id": a.id,
                },
                {
                    "zone": "ru-central1-b",
                    "name": "host_name_b",
                    "replication_source_name": "host_name_d",
                    "subnet_id": b.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "host_name_d",
                    "subnet_id": d.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "host_name_d_2",
                    "subnet_id": d.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB PostgreSQL Single Node Cluster from backup.
        #
        my_cluster = yandex.MdbPostgresqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            restore={
                "backup_id": "c9q99999999999999994cm:base_000000010000005F000000B4",
                "time": "2021-02-11T15:04:05",
            },
            config={
                "version": "15",
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
                "postgresql_config": {
                    "max_connections": "395",
                    "enable_parallel_hash": "true",
                    "autovacuum_vacuum_scale_factor": "0.34",
                    "default_transaction_isolation": "TRANSACTION_ISOLATION_READ_COMMITTED",
                    "shared_preload_libraries": "SHARED_PRELOAD_LIBRARIES_AUTO_EXPLAIN,SHARED_PRELOAD_LIBRARIES_PG_HINT_PLAN",
                },
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlCluster:MdbPostgresqlCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlCluster:MdbPostgresqlCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbPostgresqlClusterConfigArgs', 'MdbPostgresqlClusterConfigArgsDict']] config: Configuration of the PostgreSQL cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterDatabaseArgs', 'MdbPostgresqlClusterDatabaseArgsDict']]]] databases: > Deprecated! To manage databases, please switch to using a separate resource type `MdbPostgresqlDatabase`.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: Host Group IDs.
        :param pulumi.Input[_builtins.str] host_master_name: Deprecated field. Will be removed in future versions.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterHostArgs', 'MdbPostgresqlClusterHostArgsDict']]]] hosts: A host of the PostgreSQL cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['MdbPostgresqlClusterMaintenanceWindowArgs', 'MdbPostgresqlClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Union['MdbPostgresqlClusterRestoreArgs', 'MdbPostgresqlClusterRestoreArgsDict']] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterUserArgs', 'MdbPostgresqlClusterUserArgsDict']]]] users: > Deprecated! To manage users, please switch to using a separate resource type `MdbPostgresqlUser`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbPostgresqlClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB PostgreSQL Cluster.
        #
        my_cluster = yandex.MdbPostgresqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            config={
                "version": "15",
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
                "postgresql_config": {
                    "max_connections": "395",
                    "enable_parallel_hash": "true",
                    "autovacuum_vacuum_scale_factor": "0.34",
                    "default_transaction_isolation": "TRANSACTION_ISOLATION_READ_COMMITTED",
                    "shared_preload_libraries": "SHARED_PRELOAD_LIBRARIES_AUTO_EXPLAIN,SHARED_PRELOAD_LIBRARIES_PG_HINT_PLAN",
                },
            },
            maintenance_window={
                "type": "WEEKLY",
                "day": "SAT",
                "hour": 12,
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        #
        # Create a new MDB High Availability PostgreSQL Cluster.
        #
        my_cluster = yandex.MdbPostgresqlCluster("my_cluster",
            name="ha",
            environment="PRESTABLE",
            network_id=foo.id,
            config={
                "version": "15",
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
            },
            maintenance_window={
                "type": "ANYTIME",
            },
            hosts=[
                {
                    "zone": "ru-central1-b",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "zone": "ru-central1-d",
                    "subnet_id": bar.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        a = yandex.VpcSubnet("a",
            zone="ru-central1-a",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        b = yandex.VpcSubnet("b",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        d = yandex.VpcSubnet("d",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.3.0.0/24"])
        #
        # Create a new MDB High Availability PostgreSQL Cluster.
        #
        my_cluster = yandex.MdbPostgresqlCluster("my_cluster",
            name="test_ha",
            description="test High-Availability (HA) PostgreSQL Cluster",
            environment="PRESTABLE",
            network_id=foo.id,
            config={
                "version": "15",
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_size": 10,
                    "disk_type_id": "network-ssd",
                },
            },
            hosts=[
                {
                    "zone": "ru-central1-a",
                    "name": "host_name_a",
                    "subnet_id": a.id,
                },
                {
                    "zone": "ru-central1-b",
                    "name": "host_name_b",
                    "replication_source_name": "host_name_d",
                    "subnet_id": b.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "host_name_d",
                    "subnet_id": d.id,
                },
                {
                    "zone": "ru-central1-d",
                    "name": "host_name_d_2",
                    "subnet_id": d.id,
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB PostgreSQL Single Node Cluster from backup.
        #
        my_cluster = yandex.MdbPostgresqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            restore={
                "backup_id": "c9q99999999999999994cm:base_000000010000005F000000B4",
                "time": "2021-02-11T15:04:05",
            },
            config={
                "version": "15",
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
                "postgresql_config": {
                    "max_connections": "395",
                    "enable_parallel_hash": "true",
                    "autovacuum_vacuum_scale_factor": "0.34",
                    "default_transaction_isolation": "TRANSACTION_ISOLATION_READ_COMMITTED",
                    "shared_preload_libraries": "SHARED_PRELOAD_LIBRARIES_AUTO_EXPLAIN,SHARED_PRELOAD_LIBRARIES_PG_HINT_PLAN",
                },
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlCluster:MdbPostgresqlCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlCluster:MdbPostgresqlCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbPostgresqlClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbPostgresqlClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['MdbPostgresqlClusterConfigArgs', 'MdbPostgresqlClusterConfigArgsDict']]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterDatabaseArgs', 'MdbPostgresqlClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_master_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterHostArgs', 'MdbPostgresqlClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbPostgresqlClusterMaintenanceWindowArgs', 'MdbPostgresqlClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input[Union['MdbPostgresqlClusterRestoreArgs', 'MdbPostgresqlClusterRestoreArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterUserArgs', 'MdbPostgresqlClusterUserArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbPostgresqlClusterArgs.__new__(MdbPostgresqlClusterArgs)

            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["databases"] = databases
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_encryption_key_id"] = disk_encryption_key_id
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["host_group_ids"] = host_group_ids
            __props__.__dict__["host_master_name"] = host_master_name
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["restore"] = restore
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["users"] = users
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["status"] = None
        super(MdbPostgresqlCluster, __self__).__init__(
            'yandex:index/mdbPostgresqlCluster:MdbPostgresqlCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['MdbPostgresqlClusterConfigArgs', 'MdbPostgresqlClusterConfigArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterDatabaseArgs', 'MdbPostgresqlClusterDatabaseArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            health: Optional[pulumi.Input[_builtins.str]] = None,
            host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            host_master_name: Optional[pulumi.Input[_builtins.str]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterHostArgs', 'MdbPostgresqlClusterHostArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            maintenance_window: Optional[pulumi.Input[Union['MdbPostgresqlClusterMaintenanceWindowArgs', 'MdbPostgresqlClusterMaintenanceWindowArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore: Optional[pulumi.Input[Union['MdbPostgresqlClusterRestoreArgs', 'MdbPostgresqlClusterRestoreArgsDict']]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterUserArgs', 'MdbPostgresqlClusterUserArgsDict']]]]] = None) -> 'MdbPostgresqlCluster':
        """
        Get an existing MdbPostgresqlCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbPostgresqlClusterConfigArgs', 'MdbPostgresqlClusterConfigArgsDict']] config: Configuration of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterDatabaseArgs', 'MdbPostgresqlClusterDatabaseArgsDict']]]] databases: > Deprecated! To manage databases, please switch to using a separate resource type `MdbPostgresqlDatabase`.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: Host Group IDs.
        :param pulumi.Input[_builtins.str] host_master_name: Deprecated field. Will be removed in future versions.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterHostArgs', 'MdbPostgresqlClusterHostArgsDict']]]] hosts: A host of the PostgreSQL cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['MdbPostgresqlClusterMaintenanceWindowArgs', 'MdbPostgresqlClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Union['MdbPostgresqlClusterRestoreArgs', 'MdbPostgresqlClusterRestoreArgsDict']] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] status: Status of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterUserArgs', 'MdbPostgresqlClusterUserArgsDict']]]] users: > Deprecated! To manage users, please switch to using a separate resource type `MdbPostgresqlUser`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbPostgresqlClusterState.__new__(_MdbPostgresqlClusterState)

        __props__.__dict__["config"] = config
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["databases"] = databases
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_encryption_key_id"] = disk_encryption_key_id
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["health"] = health
        __props__.__dict__["host_group_ids"] = host_group_ids
        __props__.__dict__["host_master_name"] = host_master_name
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["restore"] = restore
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["users"] = users
        return MdbPostgresqlCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.MdbPostgresqlClusterConfig']:
        """
        Configuration of the PostgreSQL cluster.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""")
    def databases(self) -> pulumi.Output[Optional[Sequence['outputs.MdbPostgresqlClusterDatabase']]]:
        """
        > Deprecated! To manage databases, please switch to using a separate resource type `MdbPostgresqlDatabase`.
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the KMS key for cluster disk encryption. Restoring without an encryption key will disable encryption if any exists.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment environment of the PostgreSQL cluster.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> pulumi.Output[_builtins.str]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Host Group IDs.
        """
        return pulumi.get(self, "host_group_ids")

    @_builtins.property
    @pulumi.getter(name="hostMasterName")
    @_utilities.deprecated("""It sets name of master host. It works only when `host.name` is set. This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""")
    def host_master_name(self) -> pulumi.Output[_builtins.str]:
        """
        Deprecated field. Will be removed in future versions.
        """
        return pulumi.get(self, "host_master_name")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.MdbPostgresqlClusterHost']]:
        """
        A host of the PostgreSQL cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.MdbPostgresqlClusterMaintenanceWindow']:
        """
        Maintenance policy of the PostgreSQL cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def restore(self) -> pulumi.Output[Optional['outputs.MdbPostgresqlClusterRestore']]:
        """
        The cluster will be created from the specified backup.
        """
        return pulumi.get(self, "restore")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""")
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.MdbPostgresqlClusterUser']]]:
        """
        > Deprecated! To manage users, please switch to using a separate resource type `MdbPostgresqlUser`.
        """
        return pulumi.get(self, "users")

