# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbSqlserverClusterArgs', 'MdbSqlserverCluster']

@pulumi.input_type
class MdbSqlserverClusterArgs:
    def __init__(__self__, *,
                 databases: pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterDatabaseArgs']]],
                 environment: pulumi.Input[_builtins.str],
                 hosts: pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterHostArgs']]],
                 network_id: pulumi.Input[_builtins.str],
                 resources: pulumi.Input['MdbSqlserverClusterResourcesArgs'],
                 users: pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterUserArgs']]],
                 version: pulumi.Input[_builtins.str],
                 backup_window_start: Optional[pulumi.Input['MdbSqlserverClusterBackupWindowStartArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sqlcollation: Optional[pulumi.Input[_builtins.str]] = None,
                 sqlserver_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a MdbSqlserverCluster resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterDatabaseArgs']]] databases: A database of the SQLServer cluster.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the SQLServer cluster. (PRODUCTION, PRESTABLE).
        :param pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterHostArgs']]] hosts: A host of the SQLServer cluster.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input['MdbSqlserverClusterResourcesArgs'] resources: Resources allocated to hosts of the SQLServer cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterUserArgs']]] users: A user of the SQLServer cluster.
        :param pulumi.Input[_builtins.str] version: Version of the SQLServer cluster. (2016sp2std, 2016sp2ent).
        :param pulumi.Input['MdbSqlserverClusterBackupWindowStartArgs'] backup_window_start: Time to start the daily backup, in the UTC.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of IDs of the host groups hosting VMs of the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] sqlcollation: SQL Collation cluster will be created with. This attribute cannot be changed when cluster is created!
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] sqlserver_config: SQLServer cluster config. Detail info in `SQLServer config` section.
        """
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "users", users)
        pulumi.set(__self__, "version", version)
        if backup_window_start is not None:
            pulumi.set(__self__, "backup_window_start", backup_window_start)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sqlcollation is not None:
            pulumi.set(__self__, "sqlcollation", sqlcollation)
        if sqlserver_config is not None:
            pulumi.set(__self__, "sqlserver_config", sqlserver_config)

    @_builtins.property
    @pulumi.getter
    def databases(self) -> pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterDatabaseArgs']]]:
        """
        A database of the SQLServer cluster.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterDatabaseArgs']]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        Deployment environment of the SQLServer cluster. (PRODUCTION, PRESTABLE).
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterHostArgs']]]:
        """
        A host of the SQLServer cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterHostArgs']]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Input['MdbSqlserverClusterResourcesArgs']:
        """
        Resources allocated to hosts of the SQLServer cluster.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input['MdbSqlserverClusterResourcesArgs']):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterUserArgs']]]:
        """
        A user of the SQLServer cluster.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterUserArgs']]]):
        pulumi.set(self, "users", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        Version of the SQLServer cluster. (2016sp2std, 2016sp2ent).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> Optional[pulumi.Input['MdbSqlserverClusterBackupWindowStartArgs']]:
        """
        Time to start the daily backup, in the UTC.
        """
        return pulumi.get(self, "backup_window_start")

    @backup_window_start.setter
    def backup_window_start(self, value: Optional[pulumi.Input['MdbSqlserverClusterBackupWindowStartArgs']]):
        pulumi.set(self, "backup_window_start", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IDs of the host groups hosting VMs of the cluster.
        """
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def sqlcollation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SQL Collation cluster will be created with. This attribute cannot be changed when cluster is created!
        """
        return pulumi.get(self, "sqlcollation")

    @sqlcollation.setter
    def sqlcollation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sqlcollation", value)

    @_builtins.property
    @pulumi.getter(name="sqlserverConfig")
    def sqlserver_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        SQLServer cluster config. Detail info in `SQLServer config` section.
        """
        return pulumi.get(self, "sqlserver_config")

    @sqlserver_config.setter
    def sqlserver_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sqlserver_config", value)


@pulumi.input_type
class _MdbSqlserverClusterState:
    def __init__(__self__, *,
                 backup_window_start: Optional[pulumi.Input['MdbSqlserverClusterBackupWindowStartArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterHostArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input['MdbSqlserverClusterResourcesArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sqlcollation: Optional[pulumi.Input[_builtins.str]] = None,
                 sqlserver_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterUserArgs']]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MdbSqlserverCluster resources.
        :param pulumi.Input['MdbSqlserverClusterBackupWindowStartArgs'] backup_window_start: Time to start the daily backup, in the UTC.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterDatabaseArgs']]] databases: A database of the SQLServer cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the SQLServer cluster. (PRODUCTION, PRESTABLE).
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of IDs of the host groups hosting VMs of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterHostArgs']]] hosts: A host of the SQLServer cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input['MdbSqlserverClusterResourcesArgs'] resources: Resources allocated to hosts of the SQLServer cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] sqlcollation: SQL Collation cluster will be created with. This attribute cannot be changed when cluster is created!
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] sqlserver_config: SQLServer cluster config. Detail info in `SQLServer config` section.
        :param pulumi.Input[_builtins.str] status: Status of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterUserArgs']]] users: A user of the SQLServer cluster.
        :param pulumi.Input[_builtins.str] version: Version of the SQLServer cluster. (2016sp2std, 2016sp2ent).
        """
        if backup_window_start is not None:
            pulumi.set(__self__, "backup_window_start", backup_window_start)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sqlcollation is not None:
            pulumi.set(__self__, "sqlcollation", sqlcollation)
        if sqlserver_config is not None:
            pulumi.set(__self__, "sqlserver_config", sqlserver_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> Optional[pulumi.Input['MdbSqlserverClusterBackupWindowStartArgs']]:
        """
        Time to start the daily backup, in the UTC.
        """
        return pulumi.get(self, "backup_window_start")

    @backup_window_start.setter
    def backup_window_start(self, value: Optional[pulumi.Input['MdbSqlserverClusterBackupWindowStartArgs']]):
        pulumi.set(self, "backup_window_start", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterDatabaseArgs']]]]:
        """
        A database of the SQLServer cluster.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment environment of the SQLServer cluster. (PRODUCTION, PRESTABLE).
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IDs of the host groups hosting VMs of the cluster.
        """
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterHostArgs']]]]:
        """
        A host of the SQLServer cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['MdbSqlserverClusterResourcesArgs']]:
        """
        Resources allocated to hosts of the SQLServer cluster.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['MdbSqlserverClusterResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def sqlcollation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SQL Collation cluster will be created with. This attribute cannot be changed when cluster is created!
        """
        return pulumi.get(self, "sqlcollation")

    @sqlcollation.setter
    def sqlcollation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sqlcollation", value)

    @_builtins.property
    @pulumi.getter(name="sqlserverConfig")
    def sqlserver_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        SQLServer cluster config. Detail info in `SQLServer config` section.
        """
        return pulumi.get(self, "sqlserver_config")

    @sqlserver_config.setter
    def sqlserver_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sqlserver_config", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterUserArgs']]]]:
        """
        A user of the SQLServer cluster.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbSqlserverClusterUserArgs']]]]):
        pulumi.set(self, "users", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the SQLServer cluster. (2016sp2std, 2016sp2ent).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("yandex:index/mdbSqlserverCluster:MdbSqlserverCluster")
class MdbSqlserverCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_window_start: Optional[pulumi.Input[Union['MdbSqlserverClusterBackupWindowStartArgs', 'MdbSqlserverClusterBackupWindowStartArgsDict']]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterDatabaseArgs', 'MdbSqlserverClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterHostArgs', 'MdbSqlserverClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Union['MdbSqlserverClusterResourcesArgs', 'MdbSqlserverClusterResourcesArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sqlcollation: Optional[pulumi.Input[_builtins.str]] = None,
                 sqlserver_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterUserArgs', 'MdbSqlserverClusterUserArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a SQLServer cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-sqlserver/).

        Please read [Pricing for Managed Service for SQL Server](https://yandex.cloud/docs/managed-sqlserver/pricing#prices) before using SQLServer cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-a",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        test_sg_x = yandex.VpcSecurityGroup("test-sg-x",
            network_id=foo.id,
            ingresses=[{
                "protocol": "ANY",
                "description": "Allow incoming traffic from members of the same security group",
                "from_port": 0,
                "to_port": 65535,
                "v4_cidr_blocks": ["0.0.0.0/0"],
            }],
            egresses=[{
                "protocol": "ANY",
                "description": "Allow outgoing traffic to members of the same security group",
                "from_port": 0,
                "to_port": 65535,
                "v4_cidr_blocks": ["0.0.0.0/0"],
            }])
        #
        # Create a new MDB SQL Server Cluster.
        #
        my_cluster = yandex.MdbSqlserverCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="2016sp2std",
            resources={
                "resource_preset_id": "s2.small",
                "disk_type_id": "network-ssd",
                "disk_size": 20,
            },
            labels={
                "test_key": "test_value",
            },
            backup_window_start={
                "hours": 20,
                "minutes": 30,
            },
            sqlserver_config={
                "fill_factor_percent": "49",
                "optimize_for_ad_hoc_workloads": "true",
            },
            databases=[
                {
                    "name": "db_name_a",
                },
                {
                    "name": "db_name",
                },
                {
                    "name": "db_name_b",
                },
            ],
            users=[
                {
                    "name": "bob",
                    "password": "mysecurepassword",
                },
                {
                    "name": "alice",
                    "password": "mysecurepassword",
                    "permissions": [{
                        "database_name": "db_name",
                        "roles": ["DDLADMIN"],
                    }],
                },
                {
                    "name": "chuck",
                    "password": "mysecurepassword",
                    "permissions": [
                        {
                            "database_name": "db_name_a",
                            "roles": ["OWNER"],
                        },
                        {
                            "database_name": "db_name",
                            "roles": [
                                "OWNER",
                                "DDLADMIN",
                            ],
                        },
                        {
                            "database_name": "db_name_b",
                            "roles": [
                                "OWNER",
                                "DDLADMIN",
                            ],
                        },
                    ],
                },
            ],
            hosts=[{
                "zone": "ru-central1-a",
                "subnet_id": foo_vpc_subnet.id,
            }],
            security_group_ids=[test_sg_x.id],
            host_group_ids=[
                "host_group_1",
                "host_group_2",
            ])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbSqlserverCluster:MdbSqlserverCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbSqlserverCluster:MdbSqlserverCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbSqlserverClusterBackupWindowStartArgs', 'MdbSqlserverClusterBackupWindowStartArgsDict']] backup_window_start: Time to start the daily backup, in the UTC.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterDatabaseArgs', 'MdbSqlserverClusterDatabaseArgsDict']]]] databases: A database of the SQLServer cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the SQLServer cluster. (PRODUCTION, PRESTABLE).
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of IDs of the host groups hosting VMs of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterHostArgs', 'MdbSqlserverClusterHostArgsDict']]]] hosts: A host of the SQLServer cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Union['MdbSqlserverClusterResourcesArgs', 'MdbSqlserverClusterResourcesArgsDict']] resources: Resources allocated to hosts of the SQLServer cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] sqlcollation: SQL Collation cluster will be created with. This attribute cannot be changed when cluster is created!
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] sqlserver_config: SQLServer cluster config. Detail info in `SQLServer config` section.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterUserArgs', 'MdbSqlserverClusterUserArgsDict']]]] users: A user of the SQLServer cluster.
        :param pulumi.Input[_builtins.str] version: Version of the SQLServer cluster. (2016sp2std, 2016sp2ent).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbSqlserverClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SQLServer cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-sqlserver/).

        Please read [Pricing for Managed Service for SQL Server](https://yandex.cloud/docs/managed-sqlserver/pricing#prices) before using SQLServer cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-a",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        test_sg_x = yandex.VpcSecurityGroup("test-sg-x",
            network_id=foo.id,
            ingresses=[{
                "protocol": "ANY",
                "description": "Allow incoming traffic from members of the same security group",
                "from_port": 0,
                "to_port": 65535,
                "v4_cidr_blocks": ["0.0.0.0/0"],
            }],
            egresses=[{
                "protocol": "ANY",
                "description": "Allow outgoing traffic to members of the same security group",
                "from_port": 0,
                "to_port": 65535,
                "v4_cidr_blocks": ["0.0.0.0/0"],
            }])
        #
        # Create a new MDB SQL Server Cluster.
        #
        my_cluster = yandex.MdbSqlserverCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="2016sp2std",
            resources={
                "resource_preset_id": "s2.small",
                "disk_type_id": "network-ssd",
                "disk_size": 20,
            },
            labels={
                "test_key": "test_value",
            },
            backup_window_start={
                "hours": 20,
                "minutes": 30,
            },
            sqlserver_config={
                "fill_factor_percent": "49",
                "optimize_for_ad_hoc_workloads": "true",
            },
            databases=[
                {
                    "name": "db_name_a",
                },
                {
                    "name": "db_name",
                },
                {
                    "name": "db_name_b",
                },
            ],
            users=[
                {
                    "name": "bob",
                    "password": "mysecurepassword",
                },
                {
                    "name": "alice",
                    "password": "mysecurepassword",
                    "permissions": [{
                        "database_name": "db_name",
                        "roles": ["DDLADMIN"],
                    }],
                },
                {
                    "name": "chuck",
                    "password": "mysecurepassword",
                    "permissions": [
                        {
                            "database_name": "db_name_a",
                            "roles": ["OWNER"],
                        },
                        {
                            "database_name": "db_name",
                            "roles": [
                                "OWNER",
                                "DDLADMIN",
                            ],
                        },
                        {
                            "database_name": "db_name_b",
                            "roles": [
                                "OWNER",
                                "DDLADMIN",
                            ],
                        },
                    ],
                },
            ],
            hosts=[{
                "zone": "ru-central1-a",
                "subnet_id": foo_vpc_subnet.id,
            }],
            security_group_ids=[test_sg_x.id],
            host_group_ids=[
                "host_group_1",
                "host_group_2",
            ])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbSqlserverCluster:MdbSqlserverCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbSqlserverCluster:MdbSqlserverCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbSqlserverClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbSqlserverClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_window_start: Optional[pulumi.Input[Union['MdbSqlserverClusterBackupWindowStartArgs', 'MdbSqlserverClusterBackupWindowStartArgsDict']]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterDatabaseArgs', 'MdbSqlserverClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterHostArgs', 'MdbSqlserverClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Union['MdbSqlserverClusterResourcesArgs', 'MdbSqlserverClusterResourcesArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sqlcollation: Optional[pulumi.Input[_builtins.str]] = None,
                 sqlserver_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterUserArgs', 'MdbSqlserverClusterUserArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbSqlserverClusterArgs.__new__(MdbSqlserverClusterArgs)

            __props__.__dict__["backup_window_start"] = backup_window_start
            if databases is None and not opts.urn:
                raise TypeError("Missing required property 'databases'")
            __props__.__dict__["databases"] = databases
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["host_group_ids"] = host_group_ids
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if resources is None and not opts.urn:
                raise TypeError("Missing required property 'resources'")
            __props__.__dict__["resources"] = resources
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["sqlcollation"] = sqlcollation
            __props__.__dict__["sqlserver_config"] = sqlserver_config
            if users is None and not opts.urn:
                raise TypeError("Missing required property 'users'")
            __props__.__dict__["users"] = users
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["status"] = None
        super(MdbSqlserverCluster, __self__).__init__(
            'yandex:index/mdbSqlserverCluster:MdbSqlserverCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_window_start: Optional[pulumi.Input[Union['MdbSqlserverClusterBackupWindowStartArgs', 'MdbSqlserverClusterBackupWindowStartArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterDatabaseArgs', 'MdbSqlserverClusterDatabaseArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            health: Optional[pulumi.Input[_builtins.str]] = None,
            host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterHostArgs', 'MdbSqlserverClusterHostArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            resources: Optional[pulumi.Input[Union['MdbSqlserverClusterResourcesArgs', 'MdbSqlserverClusterResourcesArgsDict']]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sqlcollation: Optional[pulumi.Input[_builtins.str]] = None,
            sqlserver_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterUserArgs', 'MdbSqlserverClusterUserArgsDict']]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'MdbSqlserverCluster':
        """
        Get an existing MdbSqlserverCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbSqlserverClusterBackupWindowStartArgs', 'MdbSqlserverClusterBackupWindowStartArgsDict']] backup_window_start: Time to start the daily backup, in the UTC.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterDatabaseArgs', 'MdbSqlserverClusterDatabaseArgsDict']]]] databases: A database of the SQLServer cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the SQLServer cluster. (PRODUCTION, PRESTABLE).
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of IDs of the host groups hosting VMs of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterHostArgs', 'MdbSqlserverClusterHostArgsDict']]]] hosts: A host of the SQLServer cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Union['MdbSqlserverClusterResourcesArgs', 'MdbSqlserverClusterResourcesArgsDict']] resources: Resources allocated to hosts of the SQLServer cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] sqlcollation: SQL Collation cluster will be created with. This attribute cannot be changed when cluster is created!
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] sqlserver_config: SQLServer cluster config. Detail info in `SQLServer config` section.
        :param pulumi.Input[_builtins.str] status: Status of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbSqlserverClusterUserArgs', 'MdbSqlserverClusterUserArgsDict']]]] users: A user of the SQLServer cluster.
        :param pulumi.Input[_builtins.str] version: Version of the SQLServer cluster. (2016sp2std, 2016sp2ent).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbSqlserverClusterState.__new__(_MdbSqlserverClusterState)

        __props__.__dict__["backup_window_start"] = backup_window_start
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["databases"] = databases
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["health"] = health
        __props__.__dict__["host_group_ids"] = host_group_ids
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["resources"] = resources
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["sqlcollation"] = sqlcollation
        __props__.__dict__["sqlserver_config"] = sqlserver_config
        __props__.__dict__["status"] = status
        __props__.__dict__["users"] = users
        __props__.__dict__["version"] = version
        return MdbSqlserverCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> pulumi.Output['outputs.MdbSqlserverClusterBackupWindowStart']:
        """
        Time to start the daily backup, in the UTC.
        """
        return pulumi.get(self, "backup_window_start")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def databases(self) -> pulumi.Output[Sequence['outputs.MdbSqlserverClusterDatabase']]:
        """
        A database of the SQLServer cluster.
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment environment of the SQLServer cluster. (PRODUCTION, PRESTABLE).
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> pulumi.Output[_builtins.str]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of IDs of the host groups hosting VMs of the cluster.
        """
        return pulumi.get(self, "host_group_ids")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.MdbSqlserverClusterHost']]:
        """
        A host of the SQLServer cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output['outputs.MdbSqlserverClusterResources']:
        """
        Resources allocated to hosts of the SQLServer cluster.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def sqlcollation(self) -> pulumi.Output[_builtins.str]:
        """
        SQL Collation cluster will be created with. This attribute cannot be changed when cluster is created!
        """
        return pulumi.get(self, "sqlcollation")

    @_builtins.property
    @pulumi.getter(name="sqlserverConfig")
    def sqlserver_config(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        SQLServer cluster config. Detail info in `SQLServer config` section.
        """
        return pulumi.get(self, "sqlserver_config")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence['outputs.MdbSqlserverClusterUser']]:
        """
        A user of the SQLServer cluster.
        """
        return pulumi.get(self, "users")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the SQLServer cluster. (2016sp2std, 2016sp2ent).
        """
        return pulumi.get(self, "version")

