# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MessageQueueArgs', 'MessageQueue']

@pulumi.input_type
class MessageQueueArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 fifo_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_retention_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_wait_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a MessageQueue resource.
        :param pulumi.Input[_builtins.str] access_key: The [access key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_access_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        :param pulumi.Input[_builtins.bool] content_based_deduplication: Enables [content-based deduplication](https://yandex.cloud/docs/message-queue/concepts/deduplication#content-based-deduplication). Can be used only if queue is [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues).
        :param pulumi.Input[_builtins.int] delay_seconds: Number of seconds to [delay the message from being available for processing](https://yandex.cloud/docs/message-queue/concepts/delay-queues#delay-queues). Valid values: from 0 to 900 seconds (15 minutes). Default: 0.
        :param pulumi.Input[_builtins.bool] fifo_queue: Is this queue [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues). If this parameter is not used, a standard queue is created. You cannot change the parameter value for a created queue.
        :param pulumi.Input[_builtins.int] max_message_size: Maximum message size in bytes. Valid values: from 1024 bytes (1 KB) to 262144 bytes (256 KB). Default: 262144 (256 KB). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.int] message_retention_seconds: The length of time in seconds to retain a message. Valid values: from 60 seconds (1 minute) to 1209600 seconds (14 days). Default: 345600 (4 days). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.str] name: Queue name. The maximum length is 80 characters. You can use numbers, letters, underscores, and hyphens in the name. The name of a FIFO queue must end with the `.fifo` suffix. If not specified, random name will be generated. Conflicts with `name_prefix`. For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.str] name_prefix: Generates random name with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.int] receive_wait_time_seconds: Wait time for the [ReceiveMessage](https://yandex.cloud/docs/message-queue/api-ref/message/ReceiveMessage) method (for long polling), in seconds. Valid values: from 0 to 20 seconds. Default: 0. For more information about long polling see [documentation](https://yandex.cloud/docs/message-queue/concepts/long-polling).
        :param pulumi.Input[_builtins.str] redrive_policy: Message redrive policy in [Dead Letter Queue](https://yandex.cloud/docs/message-queue/concepts/dlq). The source queue and DLQ must be the same type: for FIFO queues, the DLQ must also be a FIFO queue. For more information about redrive policy see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue). Also you can use example in this page.
        :param pulumi.Input[_builtins.str] region_id: ID of the region where the message queue is located at. The default is 'ru-central1'.
        :param pulumi.Input[_builtins.str] secret_key: The [secret key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_secret_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: SQS tags
        :param pulumi.Input[_builtins.int] visibility_timeout_seconds: [Visibility timeout](https://yandex.cloud/docs/message-queue/concepts/visibility-timeout) for messages in a queue, specified in seconds. Valid values: from 0 to 43200 seconds (12 hours). Default: 30.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if delay_seconds is not None:
            pulumi.set(__self__, "delay_seconds", delay_seconds)
        if fifo_queue is not None:
            pulumi.set(__self__, "fifo_queue", fifo_queue)
        if max_message_size is not None:
            pulumi.set(__self__, "max_message_size", max_message_size)
        if message_retention_seconds is not None:
            pulumi.set(__self__, "message_retention_seconds", message_retention_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if receive_wait_time_seconds is not None:
            pulumi.set(__self__, "receive_wait_time_seconds", receive_wait_time_seconds)
        if redrive_policy is not None:
            pulumi.set(__self__, "redrive_policy", redrive_policy)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility_timeout_seconds is not None:
            pulumi.set(__self__, "visibility_timeout_seconds", visibility_timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [access key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_access_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables [content-based deduplication](https://yandex.cloud/docs/message-queue/concepts/deduplication#content-based-deduplication). Can be used only if queue is [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues).
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @_builtins.property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds to [delay the message from being available for processing](https://yandex.cloud/docs/message-queue/concepts/delay-queues#delay-queues). Valid values: from 0 to 900 seconds (15 minutes). Default: 0.
        """
        return pulumi.get(self, "delay_seconds")

    @delay_seconds.setter
    def delay_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "delay_seconds", value)

    @_builtins.property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is this queue [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues). If this parameter is not used, a standard queue is created. You cannot change the parameter value for a created queue.
        """
        return pulumi.get(self, "fifo_queue")

    @fifo_queue.setter
    def fifo_queue(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fifo_queue", value)

    @_builtins.property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum message size in bytes. Valid values: from 1024 bytes (1 KB) to 262144 bytes (256 KB). Default: 262144 (256 KB). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        """
        return pulumi.get(self, "max_message_size")

    @max_message_size.setter
    def max_message_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_message_size", value)

    @_builtins.property
    @pulumi.getter(name="messageRetentionSeconds")
    def message_retention_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The length of time in seconds to retain a message. Valid values: from 60 seconds (1 minute) to 1209600 seconds (14 days). Default: 345600 (4 days). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        """
        return pulumi.get(self, "message_retention_seconds")

    @message_retention_seconds.setter
    def message_retention_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "message_retention_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Queue name. The maximum length is 80 characters. You can use numbers, letters, underscores, and hyphens in the name. The name of a FIFO queue must end with the `.fifo` suffix. If not specified, random name will be generated. Conflicts with `name_prefix`. For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generates random name with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="receiveWaitTimeSeconds")
    def receive_wait_time_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Wait time for the [ReceiveMessage](https://yandex.cloud/docs/message-queue/api-ref/message/ReceiveMessage) method (for long polling), in seconds. Valid values: from 0 to 20 seconds. Default: 0. For more information about long polling see [documentation](https://yandex.cloud/docs/message-queue/concepts/long-polling).
        """
        return pulumi.get(self, "receive_wait_time_seconds")

    @receive_wait_time_seconds.setter
    def receive_wait_time_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "receive_wait_time_seconds", value)

    @_builtins.property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message redrive policy in [Dead Letter Queue](https://yandex.cloud/docs/message-queue/concepts/dlq). The source queue and DLQ must be the same type: for FIFO queues, the DLQ must also be a FIFO queue. For more information about redrive policy see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue). Also you can use example in this page.
        """
        return pulumi.get(self, "redrive_policy")

    @redrive_policy.setter
    def redrive_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redrive_policy", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the region where the message queue is located at. The default is 'ru-central1'.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [secret key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_secret_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        SQS tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="visibilityTimeoutSeconds")
    def visibility_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        [Visibility timeout](https://yandex.cloud/docs/message-queue/concepts/visibility-timeout) for messages in a queue, specified in seconds. Valid values: from 0 to 43200 seconds (12 hours). Default: 30.
        """
        return pulumi.get(self, "visibility_timeout_seconds")

    @visibility_timeout_seconds.setter
    def visibility_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "visibility_timeout_seconds", value)


@pulumi.input_type
class _MessageQueueState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 fifo_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_retention_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_wait_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering MessageQueue resources.
        :param pulumi.Input[_builtins.str] access_key: The [access key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_access_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        :param pulumi.Input[_builtins.str] arn: ARN of the Yandex Message Queue. It is used for setting up a [redrive policy](https://yandex.cloud/docs/message-queue/concepts/dlq). See [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/SetQueueAttributes).
        :param pulumi.Input[_builtins.bool] content_based_deduplication: Enables [content-based deduplication](https://yandex.cloud/docs/message-queue/concepts/deduplication#content-based-deduplication). Can be used only if queue is [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues).
        :param pulumi.Input[_builtins.int] delay_seconds: Number of seconds to [delay the message from being available for processing](https://yandex.cloud/docs/message-queue/concepts/delay-queues#delay-queues). Valid values: from 0 to 900 seconds (15 minutes). Default: 0.
        :param pulumi.Input[_builtins.bool] fifo_queue: Is this queue [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues). If this parameter is not used, a standard queue is created. You cannot change the parameter value for a created queue.
        :param pulumi.Input[_builtins.int] max_message_size: Maximum message size in bytes. Valid values: from 1024 bytes (1 KB) to 262144 bytes (256 KB). Default: 262144 (256 KB). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.int] message_retention_seconds: The length of time in seconds to retain a message. Valid values: from 60 seconds (1 minute) to 1209600 seconds (14 days). Default: 345600 (4 days). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.str] name: Queue name. The maximum length is 80 characters. You can use numbers, letters, underscores, and hyphens in the name. The name of a FIFO queue must end with the `.fifo` suffix. If not specified, random name will be generated. Conflicts with `name_prefix`. For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.str] name_prefix: Generates random name with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.int] receive_wait_time_seconds: Wait time for the [ReceiveMessage](https://yandex.cloud/docs/message-queue/api-ref/message/ReceiveMessage) method (for long polling), in seconds. Valid values: from 0 to 20 seconds. Default: 0. For more information about long polling see [documentation](https://yandex.cloud/docs/message-queue/concepts/long-polling).
        :param pulumi.Input[_builtins.str] redrive_policy: Message redrive policy in [Dead Letter Queue](https://yandex.cloud/docs/message-queue/concepts/dlq). The source queue and DLQ must be the same type: for FIFO queues, the DLQ must also be a FIFO queue. For more information about redrive policy see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue). Also you can use example in this page.
        :param pulumi.Input[_builtins.str] region_id: ID of the region where the message queue is located at. The default is 'ru-central1'.
        :param pulumi.Input[_builtins.str] secret_key: The [secret key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_secret_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: SQS tags
        :param pulumi.Input[_builtins.int] visibility_timeout_seconds: [Visibility timeout](https://yandex.cloud/docs/message-queue/concepts/visibility-timeout) for messages in a queue, specified in seconds. Valid values: from 0 to 43200 seconds (12 hours). Default: 30.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if delay_seconds is not None:
            pulumi.set(__self__, "delay_seconds", delay_seconds)
        if fifo_queue is not None:
            pulumi.set(__self__, "fifo_queue", fifo_queue)
        if max_message_size is not None:
            pulumi.set(__self__, "max_message_size", max_message_size)
        if message_retention_seconds is not None:
            pulumi.set(__self__, "message_retention_seconds", message_retention_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if receive_wait_time_seconds is not None:
            pulumi.set(__self__, "receive_wait_time_seconds", receive_wait_time_seconds)
        if redrive_policy is not None:
            pulumi.set(__self__, "redrive_policy", redrive_policy)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility_timeout_seconds is not None:
            pulumi.set(__self__, "visibility_timeout_seconds", visibility_timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [access key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_access_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Yandex Message Queue. It is used for setting up a [redrive policy](https://yandex.cloud/docs/message-queue/concepts/dlq). See [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/SetQueueAttributes).
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables [content-based deduplication](https://yandex.cloud/docs/message-queue/concepts/deduplication#content-based-deduplication). Can be used only if queue is [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues).
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @_builtins.property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds to [delay the message from being available for processing](https://yandex.cloud/docs/message-queue/concepts/delay-queues#delay-queues). Valid values: from 0 to 900 seconds (15 minutes). Default: 0.
        """
        return pulumi.get(self, "delay_seconds")

    @delay_seconds.setter
    def delay_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "delay_seconds", value)

    @_builtins.property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is this queue [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues). If this parameter is not used, a standard queue is created. You cannot change the parameter value for a created queue.
        """
        return pulumi.get(self, "fifo_queue")

    @fifo_queue.setter
    def fifo_queue(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fifo_queue", value)

    @_builtins.property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum message size in bytes. Valid values: from 1024 bytes (1 KB) to 262144 bytes (256 KB). Default: 262144 (256 KB). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        """
        return pulumi.get(self, "max_message_size")

    @max_message_size.setter
    def max_message_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_message_size", value)

    @_builtins.property
    @pulumi.getter(name="messageRetentionSeconds")
    def message_retention_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The length of time in seconds to retain a message. Valid values: from 60 seconds (1 minute) to 1209600 seconds (14 days). Default: 345600 (4 days). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        """
        return pulumi.get(self, "message_retention_seconds")

    @message_retention_seconds.setter
    def message_retention_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "message_retention_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Queue name. The maximum length is 80 characters. You can use numbers, letters, underscores, and hyphens in the name. The name of a FIFO queue must end with the `.fifo` suffix. If not specified, random name will be generated. Conflicts with `name_prefix`. For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generates random name with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="receiveWaitTimeSeconds")
    def receive_wait_time_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Wait time for the [ReceiveMessage](https://yandex.cloud/docs/message-queue/api-ref/message/ReceiveMessage) method (for long polling), in seconds. Valid values: from 0 to 20 seconds. Default: 0. For more information about long polling see [documentation](https://yandex.cloud/docs/message-queue/concepts/long-polling).
        """
        return pulumi.get(self, "receive_wait_time_seconds")

    @receive_wait_time_seconds.setter
    def receive_wait_time_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "receive_wait_time_seconds", value)

    @_builtins.property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message redrive policy in [Dead Letter Queue](https://yandex.cloud/docs/message-queue/concepts/dlq). The source queue and DLQ must be the same type: for FIFO queues, the DLQ must also be a FIFO queue. For more information about redrive policy see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue). Also you can use example in this page.
        """
        return pulumi.get(self, "redrive_policy")

    @redrive_policy.setter
    def redrive_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redrive_policy", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the region where the message queue is located at. The default is 'ru-central1'.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [secret key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_secret_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        SQS tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="visibilityTimeoutSeconds")
    def visibility_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        [Visibility timeout](https://yandex.cloud/docs/message-queue/concepts/visibility-timeout) for messages in a queue, specified in seconds. Valid values: from 0 to 43200 seconds (12 hours). Default: 30.
        """
        return pulumi.get(self, "visibility_timeout_seconds")

    @visibility_timeout_seconds.setter
    def visibility_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "visibility_timeout_seconds", value)


@pulumi.type_token("yandex:index/messageQueue:MessageQueue")
class MessageQueue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 fifo_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_retention_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_wait_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Message Queue](https://yandex.cloud/docs/message-queue).

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Message Queue.
        #
        my_queue = yandex.MessageQueue("my_queue",
            name="ymq_terraform_example",
            visibility_timeout_seconds=600,
            receive_wait_time_seconds=20,
            message_retention_seconds=1209600,
            redrive_policy=json.dumps({
                "deadLetterTargetArn": example_deadletter_queue["arn"],
                "maxReceiveCount": 3,
            }))
        my_deadletter_queue = yandex.MessageQueue("my_deadletter_queue", name="ymq_terraform_deadletter_example")
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Message Queue with FIFO.
        #
        example_fifo_queue = yandex.MessageQueue("example_fifo_queue",
            name="ymq_terraform_fifo_example.fifo",
            fifo_queue=True,
            content_based_deduplication=True)
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/messageQueue:MessageQueue <resource Name> <queue URL>
        ```

        ```sh
        $ pulumi import yandex:index/messageQueue:MessageQueue my_queue https://message-queue.api.cloud.yandex.net/abcdefghijklmn123456/opqrstuvwxyz87654321/ymq_terraform_import_example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The [access key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_access_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        :param pulumi.Input[_builtins.bool] content_based_deduplication: Enables [content-based deduplication](https://yandex.cloud/docs/message-queue/concepts/deduplication#content-based-deduplication). Can be used only if queue is [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues).
        :param pulumi.Input[_builtins.int] delay_seconds: Number of seconds to [delay the message from being available for processing](https://yandex.cloud/docs/message-queue/concepts/delay-queues#delay-queues). Valid values: from 0 to 900 seconds (15 minutes). Default: 0.
        :param pulumi.Input[_builtins.bool] fifo_queue: Is this queue [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues). If this parameter is not used, a standard queue is created. You cannot change the parameter value for a created queue.
        :param pulumi.Input[_builtins.int] max_message_size: Maximum message size in bytes. Valid values: from 1024 bytes (1 KB) to 262144 bytes (256 KB). Default: 262144 (256 KB). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.int] message_retention_seconds: The length of time in seconds to retain a message. Valid values: from 60 seconds (1 minute) to 1209600 seconds (14 days). Default: 345600 (4 days). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.str] name: Queue name. The maximum length is 80 characters. You can use numbers, letters, underscores, and hyphens in the name. The name of a FIFO queue must end with the `.fifo` suffix. If not specified, random name will be generated. Conflicts with `name_prefix`. For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.str] name_prefix: Generates random name with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.int] receive_wait_time_seconds: Wait time for the [ReceiveMessage](https://yandex.cloud/docs/message-queue/api-ref/message/ReceiveMessage) method (for long polling), in seconds. Valid values: from 0 to 20 seconds. Default: 0. For more information about long polling see [documentation](https://yandex.cloud/docs/message-queue/concepts/long-polling).
        :param pulumi.Input[_builtins.str] redrive_policy: Message redrive policy in [Dead Letter Queue](https://yandex.cloud/docs/message-queue/concepts/dlq). The source queue and DLQ must be the same type: for FIFO queues, the DLQ must also be a FIFO queue. For more information about redrive policy see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue). Also you can use example in this page.
        :param pulumi.Input[_builtins.str] region_id: ID of the region where the message queue is located at. The default is 'ru-central1'.
        :param pulumi.Input[_builtins.str] secret_key: The [secret key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_secret_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: SQS tags
        :param pulumi.Input[_builtins.int] visibility_timeout_seconds: [Visibility timeout](https://yandex.cloud/docs/message-queue/concepts/visibility-timeout) for messages in a queue, specified in seconds. Valid values: from 0 to 43200 seconds (12 hours). Default: 30.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MessageQueueArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Message Queue](https://yandex.cloud/docs/message-queue).

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Message Queue.
        #
        my_queue = yandex.MessageQueue("my_queue",
            name="ymq_terraform_example",
            visibility_timeout_seconds=600,
            receive_wait_time_seconds=20,
            message_retention_seconds=1209600,
            redrive_policy=json.dumps({
                "deadLetterTargetArn": example_deadletter_queue["arn"],
                "maxReceiveCount": 3,
            }))
        my_deadletter_queue = yandex.MessageQueue("my_deadletter_queue", name="ymq_terraform_deadletter_example")
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Message Queue with FIFO.
        #
        example_fifo_queue = yandex.MessageQueue("example_fifo_queue",
            name="ymq_terraform_fifo_example.fifo",
            fifo_queue=True,
            content_based_deduplication=True)
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/messageQueue:MessageQueue <resource Name> <queue URL>
        ```

        ```sh
        $ pulumi import yandex:index/messageQueue:MessageQueue my_queue https://message-queue.api.cloud.yandex.net/abcdefghijklmn123456/opqrstuvwxyz87654321/ymq_terraform_import_example
        ```

        :param str resource_name: The name of the resource.
        :param MessageQueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MessageQueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 fifo_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_retention_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_wait_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MessageQueueArgs.__new__(MessageQueueArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["content_based_deduplication"] = content_based_deduplication
            __props__.__dict__["delay_seconds"] = delay_seconds
            __props__.__dict__["fifo_queue"] = fifo_queue
            __props__.__dict__["max_message_size"] = max_message_size
            __props__.__dict__["message_retention_seconds"] = message_retention_seconds
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["receive_wait_time_seconds"] = receive_wait_time_seconds
            __props__.__dict__["redrive_policy"] = redrive_policy
            __props__.__dict__["region_id"] = region_id
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["visibility_timeout_seconds"] = visibility_timeout_seconds
            __props__.__dict__["arn"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MessageQueue, __self__).__init__(
            'yandex:index/messageQueue:MessageQueue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            content_based_deduplication: Optional[pulumi.Input[_builtins.bool]] = None,
            delay_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            fifo_queue: Optional[pulumi.Input[_builtins.bool]] = None,
            max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
            message_retention_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            receive_wait_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            redrive_policy: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            visibility_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None) -> 'MessageQueue':
        """
        Get an existing MessageQueue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The [access key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_access_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        :param pulumi.Input[_builtins.str] arn: ARN of the Yandex Message Queue. It is used for setting up a [redrive policy](https://yandex.cloud/docs/message-queue/concepts/dlq). See [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/SetQueueAttributes).
        :param pulumi.Input[_builtins.bool] content_based_deduplication: Enables [content-based deduplication](https://yandex.cloud/docs/message-queue/concepts/deduplication#content-based-deduplication). Can be used only if queue is [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues).
        :param pulumi.Input[_builtins.int] delay_seconds: Number of seconds to [delay the message from being available for processing](https://yandex.cloud/docs/message-queue/concepts/delay-queues#delay-queues). Valid values: from 0 to 900 seconds (15 minutes). Default: 0.
        :param pulumi.Input[_builtins.bool] fifo_queue: Is this queue [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues). If this parameter is not used, a standard queue is created. You cannot change the parameter value for a created queue.
        :param pulumi.Input[_builtins.int] max_message_size: Maximum message size in bytes. Valid values: from 1024 bytes (1 KB) to 262144 bytes (256 KB). Default: 262144 (256 KB). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.int] message_retention_seconds: The length of time in seconds to retain a message. Valid values: from 60 seconds (1 minute) to 1209600 seconds (14 days). Default: 345600 (4 days). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.str] name: Queue name. The maximum length is 80 characters. You can use numbers, letters, underscores, and hyphens in the name. The name of a FIFO queue must end with the `.fifo` suffix. If not specified, random name will be generated. Conflicts with `name_prefix`. For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        :param pulumi.Input[_builtins.str] name_prefix: Generates random name with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.int] receive_wait_time_seconds: Wait time for the [ReceiveMessage](https://yandex.cloud/docs/message-queue/api-ref/message/ReceiveMessage) method (for long polling), in seconds. Valid values: from 0 to 20 seconds. Default: 0. For more information about long polling see [documentation](https://yandex.cloud/docs/message-queue/concepts/long-polling).
        :param pulumi.Input[_builtins.str] redrive_policy: Message redrive policy in [Dead Letter Queue](https://yandex.cloud/docs/message-queue/concepts/dlq). The source queue and DLQ must be the same type: for FIFO queues, the DLQ must also be a FIFO queue. For more information about redrive policy see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue). Also you can use example in this page.
        :param pulumi.Input[_builtins.str] region_id: ID of the region where the message queue is located at. The default is 'ru-central1'.
        :param pulumi.Input[_builtins.str] secret_key: The [secret key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_secret_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: SQS tags
        :param pulumi.Input[_builtins.int] visibility_timeout_seconds: [Visibility timeout](https://yandex.cloud/docs/message-queue/concepts/visibility-timeout) for messages in a queue, specified in seconds. Valid values: from 0 to 43200 seconds (12 hours). Default: 30.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MessageQueueState.__new__(_MessageQueueState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["arn"] = arn
        __props__.__dict__["content_based_deduplication"] = content_based_deduplication
        __props__.__dict__["delay_seconds"] = delay_seconds
        __props__.__dict__["fifo_queue"] = fifo_queue
        __props__.__dict__["max_message_size"] = max_message_size
        __props__.__dict__["message_retention_seconds"] = message_retention_seconds
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["receive_wait_time_seconds"] = receive_wait_time_seconds
        __props__.__dict__["redrive_policy"] = redrive_policy
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["tags"] = tags
        __props__.__dict__["visibility_timeout_seconds"] = visibility_timeout_seconds
        return MessageQueue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [access key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_access_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Yandex Message Queue. It is used for setting up a [redrive policy](https://yandex.cloud/docs/message-queue/concepts/dlq). See [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/SetQueueAttributes).
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables [content-based deduplication](https://yandex.cloud/docs/message-queue/concepts/deduplication#content-based-deduplication). Can be used only if queue is [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues).
        """
        return pulumi.get(self, "content_based_deduplication")

    @_builtins.property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of seconds to [delay the message from being available for processing](https://yandex.cloud/docs/message-queue/concepts/delay-queues#delay-queues). Valid values: from 0 to 900 seconds (15 minutes). Default: 0.
        """
        return pulumi.get(self, "delay_seconds")

    @_builtins.property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is this queue [FIFO](https://yandex.cloud/docs/message-queue/concepts/queue#fifo-queues). If this parameter is not used, a standard queue is created. You cannot change the parameter value for a created queue.
        """
        return pulumi.get(self, "fifo_queue")

    @_builtins.property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum message size in bytes. Valid values: from 1024 bytes (1 KB) to 262144 bytes (256 KB). Default: 262144 (256 KB). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        """
        return pulumi.get(self, "max_message_size")

    @_builtins.property
    @pulumi.getter(name="messageRetentionSeconds")
    def message_retention_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The length of time in seconds to retain a message. Valid values: from 60 seconds (1 minute) to 1209600 seconds (14 days). Default: 345600 (4 days). For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        """
        return pulumi.get(self, "message_retention_seconds")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Queue name. The maximum length is 80 characters. You can use numbers, letters, underscores, and hyphens in the name. The name of a FIFO queue must end with the `.fifo` suffix. If not specified, random name will be generated. Conflicts with `name_prefix`. For more information see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Generates random name with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="receiveWaitTimeSeconds")
    def receive_wait_time_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Wait time for the [ReceiveMessage](https://yandex.cloud/docs/message-queue/api-ref/message/ReceiveMessage) method (for long polling), in seconds. Valid values: from 0 to 20 seconds. Default: 0. For more information about long polling see [documentation](https://yandex.cloud/docs/message-queue/concepts/long-polling).
        """
        return pulumi.get(self, "receive_wait_time_seconds")

    @_builtins.property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Message redrive policy in [Dead Letter Queue](https://yandex.cloud/docs/message-queue/concepts/dlq). The source queue and DLQ must be the same type: for FIFO queues, the DLQ must also be a FIFO queue. For more information about redrive policy see [documentation](https://yandex.cloud/docs/message-queue/api-ref/queue/CreateQueue). Also you can use example in this page.
        """
        return pulumi.get(self, "redrive_policy")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the region where the message queue is located at. The default is 'ru-central1'.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [secret key](https://yandex.cloud/docs/iam/operations/sa/create-access-key) to use when applying changes. If omitted, `ymq_secret_key` specified in provider config is used. For more information see [documentation](https://yandex.cloud/docs/message-queue/quickstart).
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        SQS tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="visibilityTimeoutSeconds")
    def visibility_timeout_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        [Visibility timeout](https://yandex.cloud/docs/message-queue/concepts/visibility-timeout) for messages in a queue, specified in seconds. Valid values: from 0 to 43200 seconds (12 hours). Default: 30.
        """
        return pulumi.get(self, "visibility_timeout_seconds")

