# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationmanagerGroupMappingArgs', 'OrganizationmanagerGroupMapping']

@pulumi.input_type
class OrganizationmanagerGroupMappingArgs:
    def __init__(__self__, *,
                 federation_id: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a OrganizationmanagerGroupMapping resource.
        :param pulumi.Input[_builtins.str] federation_id: ID of the SAML Federation.
        :param pulumi.Input[_builtins.bool] enabled: Set "true" to enable organization manager group mapping.
        """
        pulumi.set(__self__, "federation_id", federation_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the SAML Federation.
        """
        return pulumi.get(self, "federation_id")

    @federation_id.setter
    def federation_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "federation_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set "true" to enable organization manager group mapping.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class _OrganizationmanagerGroupMappingState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationmanagerGroupMapping resources.
        :param pulumi.Input[_builtins.bool] enabled: Set "true" to enable organization manager group mapping.
        :param pulumi.Input[_builtins.str] federation_id: ID of the SAML Federation.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if federation_id is not None:
            pulumi.set(__self__, "federation_id", federation_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set "true" to enable organization manager group mapping.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the SAML Federation.
        """
        return pulumi.get(self, "federation_id")

    @federation_id.setter
    def federation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "federation_id", value)


@pulumi.type_token("yandex:index/organizationmanagerGroupMapping:OrganizationmanagerGroupMapping")
class OrganizationmanagerGroupMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Organization Manager Group Mapping](https://yandex.cloud/docs/organization/concepts/add-federation#group-mapping). It supports the creation, updating(enabling/disabling), and deletion of group mapping.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new OrganizationManager Group Mapping.
        #
        my_group_map = yandex.OrganizationmanagerGroupMapping("my_group_map",
            federation_id="my-federation-id",
            enabled=True)
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/organizationmanagerGroupMapping:OrganizationmanagerGroupMapping <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/organizationmanagerGroupMapping:OrganizationmanagerGroupMapping my_group_map ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Set "true" to enable organization manager group mapping.
        :param pulumi.Input[_builtins.str] federation_id: ID of the SAML Federation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationmanagerGroupMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Organization Manager Group Mapping](https://yandex.cloud/docs/organization/concepts/add-federation#group-mapping). It supports the creation, updating(enabling/disabling), and deletion of group mapping.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new OrganizationManager Group Mapping.
        #
        my_group_map = yandex.OrganizationmanagerGroupMapping("my_group_map",
            federation_id="my-federation-id",
            enabled=True)
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/organizationmanagerGroupMapping:OrganizationmanagerGroupMapping <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/organizationmanagerGroupMapping:OrganizationmanagerGroupMapping my_group_map ...
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationmanagerGroupMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationmanagerGroupMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationmanagerGroupMappingArgs.__new__(OrganizationmanagerGroupMappingArgs)

            __props__.__dict__["enabled"] = enabled
            if federation_id is None and not opts.urn:
                raise TypeError("Missing required property 'federation_id'")
            __props__.__dict__["federation_id"] = federation_id
        super(OrganizationmanagerGroupMapping, __self__).__init__(
            'yandex:index/organizationmanagerGroupMapping:OrganizationmanagerGroupMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            federation_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationmanagerGroupMapping':
        """
        Get an existing OrganizationmanagerGroupMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Set "true" to enable organization manager group mapping.
        :param pulumi.Input[_builtins.str] federation_id: ID of the SAML Federation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationmanagerGroupMappingState.__new__(_OrganizationmanagerGroupMappingState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["federation_id"] = federation_id
        return OrganizationmanagerGroupMapping(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set "true" to enable organization manager group mapping.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the SAML Federation.
        """
        return pulumi.get(self, "federation_id")

