# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationmanagerGroupMappingItemArgs', 'OrganizationmanagerGroupMappingItem']

@pulumi.input_type
class OrganizationmanagerGroupMappingItemArgs:
    def __init__(__self__, *,
                 external_group_id: pulumi.Input[_builtins.str],
                 federation_id: pulumi.Input[_builtins.str],
                 internal_group_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a OrganizationmanagerGroupMappingItem resource.
        :param pulumi.Input[_builtins.str] external_group_id: ID of the external group
        :param pulumi.Input[_builtins.str] federation_id: ID of the SAML Federation
        :param pulumi.Input[_builtins.str] internal_group_id: ID of the internal group
        """
        pulumi.set(__self__, "external_group_id", external_group_id)
        pulumi.set(__self__, "federation_id", federation_id)
        pulumi.set(__self__, "internal_group_id", internal_group_id)

    @_builtins.property
    @pulumi.getter(name="externalGroupId")
    def external_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the external group
        """
        return pulumi.get(self, "external_group_id")

    @external_group_id.setter
    def external_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_group_id", value)

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the SAML Federation
        """
        return pulumi.get(self, "federation_id")

    @federation_id.setter
    def federation_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "federation_id", value)

    @_builtins.property
    @pulumi.getter(name="internalGroupId")
    def internal_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the internal group
        """
        return pulumi.get(self, "internal_group_id")

    @internal_group_id.setter
    def internal_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "internal_group_id", value)


@pulumi.input_type
class _OrganizationmanagerGroupMappingItemState:
    def __init__(__self__, *,
                 external_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationmanagerGroupMappingItem resources.
        :param pulumi.Input[_builtins.str] external_group_id: ID of the external group
        :param pulumi.Input[_builtins.str] federation_id: ID of the SAML Federation
        :param pulumi.Input[_builtins.str] internal_group_id: ID of the internal group
        """
        if external_group_id is not None:
            pulumi.set(__self__, "external_group_id", external_group_id)
        if federation_id is not None:
            pulumi.set(__self__, "federation_id", federation_id)
        if internal_group_id is not None:
            pulumi.set(__self__, "internal_group_id", internal_group_id)

    @_builtins.property
    @pulumi.getter(name="externalGroupId")
    def external_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the external group
        """
        return pulumi.get(self, "external_group_id")

    @external_group_id.setter
    def external_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_group_id", value)

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the SAML Federation
        """
        return pulumi.get(self, "federation_id")

    @federation_id.setter
    def federation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "federation_id", value)

    @_builtins.property
    @pulumi.getter(name="internalGroupId")
    def internal_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the internal group
        """
        return pulumi.get(self, "internal_group_id")

    @internal_group_id.setter
    def internal_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_group_id", value)


@pulumi.type_token("yandex:index/organizationmanagerGroupMappingItem:OrganizationmanagerGroupMappingItem")
class OrganizationmanagerGroupMappingItem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new OrganizationManager Group Mapping Item.
        #
        group_mapping_item = yandex.OrganizationmanagerGroupMappingItem("group_mapping_item",
            federation_id="my-federation_id",
            internal_group_id="my_internal_group_id",
            external_group_id="my_external_group_id",
            opts = pulumi.ResourceOptions(depends_on=[group_mapping]))
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/organizationmanagerGroupMappingItem:OrganizationmanagerGroupMappingItem <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/organizationmanagerGroupMappingItem:OrganizationmanagerGroupMappingItem group_mapping_item .../.../...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_group_id: ID of the external group
        :param pulumi.Input[_builtins.str] federation_id: ID of the SAML Federation
        :param pulumi.Input[_builtins.str] internal_group_id: ID of the internal group
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationmanagerGroupMappingItemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new OrganizationManager Group Mapping Item.
        #
        group_mapping_item = yandex.OrganizationmanagerGroupMappingItem("group_mapping_item",
            federation_id="my-federation_id",
            internal_group_id="my_internal_group_id",
            external_group_id="my_external_group_id",
            opts = pulumi.ResourceOptions(depends_on=[group_mapping]))
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/organizationmanagerGroupMappingItem:OrganizationmanagerGroupMappingItem <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/organizationmanagerGroupMappingItem:OrganizationmanagerGroupMappingItem group_mapping_item .../.../...
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationmanagerGroupMappingItemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationmanagerGroupMappingItemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationmanagerGroupMappingItemArgs.__new__(OrganizationmanagerGroupMappingItemArgs)

            if external_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_group_id'")
            __props__.__dict__["external_group_id"] = external_group_id
            if federation_id is None and not opts.urn:
                raise TypeError("Missing required property 'federation_id'")
            __props__.__dict__["federation_id"] = federation_id
            if internal_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'internal_group_id'")
            __props__.__dict__["internal_group_id"] = internal_group_id
        super(OrganizationmanagerGroupMappingItem, __self__).__init__(
            'yandex:index/organizationmanagerGroupMappingItem:OrganizationmanagerGroupMappingItem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            external_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            federation_id: Optional[pulumi.Input[_builtins.str]] = None,
            internal_group_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationmanagerGroupMappingItem':
        """
        Get an existing OrganizationmanagerGroupMappingItem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_group_id: ID of the external group
        :param pulumi.Input[_builtins.str] federation_id: ID of the SAML Federation
        :param pulumi.Input[_builtins.str] internal_group_id: ID of the internal group
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationmanagerGroupMappingItemState.__new__(_OrganizationmanagerGroupMappingItemState)

        __props__.__dict__["external_group_id"] = external_group_id
        __props__.__dict__["federation_id"] = federation_id
        __props__.__dict__["internal_group_id"] = internal_group_id
        return OrganizationmanagerGroupMappingItem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="externalGroupId")
    def external_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the external group
        """
        return pulumi.get(self, "external_group_id")

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the SAML Federation
        """
        return pulumi.get(self, "federation_id")

    @_builtins.property
    @pulumi.getter(name="internalGroupId")
    def internal_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the internal group
        """
        return pulumi.get(self, "internal_group_id")

