# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationmanagerUserSshKeyArgs', 'OrganizationmanagerUserSshKey']

@pulumi.input_type
class OrganizationmanagerUserSshKeyArgs:
    def __init__(__self__, *,
                 data: pulumi.Input[_builtins.str],
                 organization_id: pulumi.Input[_builtins.str],
                 subject_id: pulumi.Input[_builtins.str],
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationmanagerUserSshKey resource.
        :param pulumi.Input[_builtins.str] data: Data of the user ssh key.
        :param pulumi.Input[_builtins.str] organization_id: Organization that the user ssh key belongs to.
        :param pulumi.Input[_builtins.str] subject_id: Subject that the user ssh key belongs to.
        :param pulumi.Input[_builtins.str] expires_at: User ssh key will be no longer valid after expiration timestamp.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "subject_id", subject_id)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Input[_builtins.str]:
        """
        Data of the user ssh key.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        Organization that the user ssh key belongs to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="subjectId")
    def subject_id(self) -> pulumi.Input[_builtins.str]:
        """
        Subject that the user ssh key belongs to.
        """
        return pulumi.get(self, "subject_id")

    @subject_id.setter
    def subject_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subject_id", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User ssh key will be no longer valid after expiration timestamp.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _OrganizationmanagerUserSshKeyState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationmanagerUserSshKey resources.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] data: Data of the user ssh key.
        :param pulumi.Input[_builtins.str] expires_at: User ssh key will be no longer valid after expiration timestamp.
        :param pulumi.Input[_builtins.str] fingerprint: SSH Key Fingerprint.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] organization_id: Organization that the user ssh key belongs to.
        :param pulumi.Input[_builtins.str] subject_id: Subject that the user ssh key belongs to.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if subject_id is not None:
            pulumi.set(__self__, "subject_id", subject_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data of the user ssh key.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User ssh key will be no longer valid after expiration timestamp.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SSH Key Fingerprint.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization that the user ssh key belongs to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="subjectId")
    def subject_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subject that the user ssh key belongs to.
        """
        return pulumi.get(self, "subject_id")

    @subject_id.setter
    def subject_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_id", value)


@pulumi.type_token("yandex:index/organizationmanagerUserSshKey:OrganizationmanagerUserSshKey")
class OrganizationmanagerUserSshKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows management of User SSH Keys within an existing Yandex Cloud Organization and Subject.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new OrganizationManager User SSH Key.
        #
        my_user_ssh_key = yandex.OrganizationmanagerUserSshKey("my_user_ssh_key",
            organization_id="some_organization_id",
            subject_id="some_subject_id",
            data="ssh_key_data")
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/organizationmanagerUserSshKey:OrganizationmanagerUserSshKey <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/organizationmanagerUserSshKey:OrganizationmanagerUserSshKey my_user_ssh_key ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data: Data of the user ssh key.
        :param pulumi.Input[_builtins.str] expires_at: User ssh key will be no longer valid after expiration timestamp.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] organization_id: Organization that the user ssh key belongs to.
        :param pulumi.Input[_builtins.str] subject_id: Subject that the user ssh key belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationmanagerUserSshKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of User SSH Keys within an existing Yandex Cloud Organization and Subject.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new OrganizationManager User SSH Key.
        #
        my_user_ssh_key = yandex.OrganizationmanagerUserSshKey("my_user_ssh_key",
            organization_id="some_organization_id",
            subject_id="some_subject_id",
            data="ssh_key_data")
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/organizationmanagerUserSshKey:OrganizationmanagerUserSshKey <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/organizationmanagerUserSshKey:OrganizationmanagerUserSshKey my_user_ssh_key ...
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationmanagerUserSshKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationmanagerUserSshKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationmanagerUserSshKeyArgs.__new__(OrganizationmanagerUserSshKeyArgs)

            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = data
            __props__.__dict__["expires_at"] = expires_at
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if subject_id is None and not opts.urn:
                raise TypeError("Missing required property 'subject_id'")
            __props__.__dict__["subject_id"] = subject_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["fingerprint"] = None
        super(OrganizationmanagerUserSshKey, __self__).__init__(
            'yandex:index/organizationmanagerUserSshKey:OrganizationmanagerUserSshKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            data: Optional[pulumi.Input[_builtins.str]] = None,
            expires_at: Optional[pulumi.Input[_builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            subject_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationmanagerUserSshKey':
        """
        Get an existing OrganizationmanagerUserSshKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] data: Data of the user ssh key.
        :param pulumi.Input[_builtins.str] expires_at: User ssh key will be no longer valid after expiration timestamp.
        :param pulumi.Input[_builtins.str] fingerprint: SSH Key Fingerprint.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] organization_id: Organization that the user ssh key belongs to.
        :param pulumi.Input[_builtins.str] subject_id: Subject that the user ssh key belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationmanagerUserSshKeyState.__new__(_OrganizationmanagerUserSshKeyState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["data"] = data
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["subject_id"] = subject_id
        return OrganizationmanagerUserSshKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Output[_builtins.str]:
        """
        Data of the user ssh key.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User ssh key will be no longer valid after expiration timestamp.
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        SSH Key Fingerprint.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        Organization that the user ssh key belongs to.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="subjectId")
    def subject_id(self) -> pulumi.Output[_builtins.str]:
        """
        Subject that the user ssh key belongs to.
        """
        return pulumi.get(self, "subject_id")

