# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerlessEventrouterConnectorArgs', 'ServerlessEventrouterConnector']

@pulumi.input_type
class ServerlessEventrouterConnectorArgs:
    def __init__(__self__, *,
                 bus_id: pulumi.Input[_builtins.str],
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timers: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorTimerArgs']]]] = None,
                 yds: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYdArgs']]]] = None,
                 ymqs: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYmqArgs']]]] = None):
        """
        The set of arguments for constructing a ServerlessEventrouterConnector resource.
        :param pulumi.Input[_builtins.str] bus_id: ID of the bus that the connector belongs to
        :param pulumi.Input[_builtins.bool] deletion_protection: Deletion protection
        :param pulumi.Input[_builtins.str] description: Description of the connector
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Connector labels
        :param pulumi.Input[_builtins.str] name: Name of the connector
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorTimerArgs']]] timers: Timer source of the connector
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYdArgs']]] yds: Data Stream source of the connector
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYmqArgs']]] ymqs: Message Queue source of the connector
        """
        pulumi.set(__self__, "bus_id", bus_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if timers is not None:
            pulumi.set(__self__, "timers", timers)
        if yds is not None:
            pulumi.set(__self__, "yds", yds)
        if ymqs is not None:
            pulumi.set(__self__, "ymqs", ymqs)

    @_builtins.property
    @pulumi.getter(name="busId")
    def bus_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the bus that the connector belongs to
        """
        return pulumi.get(self, "bus_id")

    @bus_id.setter
    def bus_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bus_id", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deletion protection
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the connector
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Connector labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the connector
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def timers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorTimerArgs']]]]:
        """
        Timer source of the connector
        """
        return pulumi.get(self, "timers")

    @timers.setter
    def timers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorTimerArgs']]]]):
        pulumi.set(self, "timers", value)

    @_builtins.property
    @pulumi.getter
    def yds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYdArgs']]]]:
        """
        Data Stream source of the connector
        """
        return pulumi.get(self, "yds")

    @yds.setter
    def yds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYdArgs']]]]):
        pulumi.set(self, "yds", value)

    @_builtins.property
    @pulumi.getter
    def ymqs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYmqArgs']]]]:
        """
        Message Queue source of the connector
        """
        return pulumi.get(self, "ymqs")

    @ymqs.setter
    def ymqs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYmqArgs']]]]):
        pulumi.set(self, "ymqs", value)


@pulumi.input_type
class _ServerlessEventrouterConnectorState:
    def __init__(__self__, *,
                 bus_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timers: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorTimerArgs']]]] = None,
                 yds: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYdArgs']]]] = None,
                 ymqs: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYmqArgs']]]] = None):
        """
        Input properties used for looking up and filtering ServerlessEventrouterConnector resources.
        :param pulumi.Input[_builtins.str] bus_id: ID of the bus that the connector belongs to
        :param pulumi.Input[_builtins.str] cloud_id: ID of the cloud that the connector resides in
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp
        :param pulumi.Input[_builtins.bool] deletion_protection: Deletion protection
        :param pulumi.Input[_builtins.str] description: Description of the connector
        :param pulumi.Input[_builtins.str] folder_id: ID of the folder that the connector resides in
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Connector labels
        :param pulumi.Input[_builtins.str] name: Name of the connector
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorTimerArgs']]] timers: Timer source of the connector
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYdArgs']]] yds: Data Stream source of the connector
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYmqArgs']]] ymqs: Message Queue source of the connector
        """
        if bus_id is not None:
            pulumi.set(__self__, "bus_id", bus_id)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if timers is not None:
            pulumi.set(__self__, "timers", timers)
        if yds is not None:
            pulumi.set(__self__, "yds", yds)
        if ymqs is not None:
            pulumi.set(__self__, "ymqs", ymqs)

    @_builtins.property
    @pulumi.getter(name="busId")
    def bus_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the bus that the connector belongs to
        """
        return pulumi.get(self, "bus_id")

    @bus_id.setter
    def bus_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bus_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the cloud that the connector resides in
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deletion protection
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the connector
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the folder that the connector resides in
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Connector labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the connector
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def timers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorTimerArgs']]]]:
        """
        Timer source of the connector
        """
        return pulumi.get(self, "timers")

    @timers.setter
    def timers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorTimerArgs']]]]):
        pulumi.set(self, "timers", value)

    @_builtins.property
    @pulumi.getter
    def yds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYdArgs']]]]:
        """
        Data Stream source of the connector
        """
        return pulumi.get(self, "yds")

    @yds.setter
    def yds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYdArgs']]]]):
        pulumi.set(self, "yds", value)

    @_builtins.property
    @pulumi.getter
    def ymqs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYmqArgs']]]]:
        """
        Message Queue source of the connector
        """
        return pulumi.get(self, "ymqs")

    @ymqs.setter
    def ymqs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterConnectorYmqArgs']]]]):
        pulumi.set(self, "ymqs", value)


@pulumi.type_token("yandex:index/serverlessEventrouterConnector:ServerlessEventrouterConnector")
class ServerlessEventrouterConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bus_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorTimerArgs', 'ServerlessEventrouterConnectorTimerArgsDict']]]]] = None,
                 yds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorYdArgs', 'ServerlessEventrouterConnectorYdArgsDict']]]]] = None,
                 ymqs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorYmqArgs', 'ServerlessEventrouterConnectorYmqArgsDict']]]]] = None,
                 __props__=None):
        """
        Allows management of a Yandex Cloud Serverless Event Router Connector.

        ## Example Usage

        ```python
        import pulumi
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/serverlessEventrouterConnector:ServerlessEventrouterConnector <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/serverlessEventrouterConnector:ServerlessEventrouterConnector evr_con ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bus_id: ID of the bus that the connector belongs to
        :param pulumi.Input[_builtins.bool] deletion_protection: Deletion protection
        :param pulumi.Input[_builtins.str] description: Description of the connector
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Connector labels
        :param pulumi.Input[_builtins.str] name: Name of the connector
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorTimerArgs', 'ServerlessEventrouterConnectorTimerArgsDict']]]] timers: Timer source of the connector
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorYdArgs', 'ServerlessEventrouterConnectorYdArgsDict']]]] yds: Data Stream source of the connector
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorYmqArgs', 'ServerlessEventrouterConnectorYmqArgsDict']]]] ymqs: Message Queue source of the connector
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerlessEventrouterConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of a Yandex Cloud Serverless Event Router Connector.

        ## Example Usage

        ```python
        import pulumi
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/serverlessEventrouterConnector:ServerlessEventrouterConnector <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/serverlessEventrouterConnector:ServerlessEventrouterConnector evr_con ...
        ```

        :param str resource_name: The name of the resource.
        :param ServerlessEventrouterConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerlessEventrouterConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bus_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorTimerArgs', 'ServerlessEventrouterConnectorTimerArgsDict']]]]] = None,
                 yds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorYdArgs', 'ServerlessEventrouterConnectorYdArgsDict']]]]] = None,
                 ymqs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorYmqArgs', 'ServerlessEventrouterConnectorYmqArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerlessEventrouterConnectorArgs.__new__(ServerlessEventrouterConnectorArgs)

            if bus_id is None and not opts.urn:
                raise TypeError("Missing required property 'bus_id'")
            __props__.__dict__["bus_id"] = bus_id
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["timers"] = timers
            __props__.__dict__["yds"] = yds
            __props__.__dict__["ymqs"] = ymqs
            __props__.__dict__["cloud_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["folder_id"] = None
        super(ServerlessEventrouterConnector, __self__).__init__(
            'yandex:index/serverlessEventrouterConnector:ServerlessEventrouterConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bus_id: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            timers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorTimerArgs', 'ServerlessEventrouterConnectorTimerArgsDict']]]]] = None,
            yds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorYdArgs', 'ServerlessEventrouterConnectorYdArgsDict']]]]] = None,
            ymqs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorYmqArgs', 'ServerlessEventrouterConnectorYmqArgsDict']]]]] = None) -> 'ServerlessEventrouterConnector':
        """
        Get an existing ServerlessEventrouterConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bus_id: ID of the bus that the connector belongs to
        :param pulumi.Input[_builtins.str] cloud_id: ID of the cloud that the connector resides in
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp
        :param pulumi.Input[_builtins.bool] deletion_protection: Deletion protection
        :param pulumi.Input[_builtins.str] description: Description of the connector
        :param pulumi.Input[_builtins.str] folder_id: ID of the folder that the connector resides in
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Connector labels
        :param pulumi.Input[_builtins.str] name: Name of the connector
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorTimerArgs', 'ServerlessEventrouterConnectorTimerArgsDict']]]] timers: Timer source of the connector
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorYdArgs', 'ServerlessEventrouterConnectorYdArgsDict']]]] yds: Data Stream source of the connector
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterConnectorYmqArgs', 'ServerlessEventrouterConnectorYmqArgsDict']]]] ymqs: Message Queue source of the connector
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerlessEventrouterConnectorState.__new__(_ServerlessEventrouterConnectorState)

        __props__.__dict__["bus_id"] = bus_id
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["timers"] = timers
        __props__.__dict__["yds"] = yds
        __props__.__dict__["ymqs"] = ymqs
        return ServerlessEventrouterConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="busId")
    def bus_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the bus that the connector belongs to
        """
        return pulumi.get(self, "bus_id")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the cloud that the connector resides in
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Deletion protection
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the connector
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the folder that the connector resides in
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Connector labels
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the connector
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def timers(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessEventrouterConnectorTimer']]]:
        """
        Timer source of the connector
        """
        return pulumi.get(self, "timers")

    @_builtins.property
    @pulumi.getter
    def yds(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessEventrouterConnectorYd']]]:
        """
        Data Stream source of the connector
        """
        return pulumi.get(self, "yds")

    @_builtins.property
    @pulumi.getter
    def ymqs(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessEventrouterConnectorYmq']]]:
        """
        Message Queue source of the connector
        """
        return pulumi.get(self, "ymqs")

