# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerlessEventrouterRuleArgs', 'ServerlessEventrouterRule']

@pulumi.input_type
class ServerlessEventrouterRuleArgs:
    def __init__(__self__, *,
                 bus_id: pulumi.Input[_builtins.str],
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleContainerArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleFunctionArgs']]]] = None,
                 gateway_websocket_broadcasts: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs']]]] = None,
                 jq_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleLoggingArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 workflows: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleWorkflowArgs']]]] = None,
                 yds: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYdArgs']]]] = None,
                 ymqs: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYmqArgs']]]] = None):
        """
        The set of arguments for constructing a ServerlessEventrouterRule resource.
        :param pulumi.Input[_builtins.str] bus_id: ID of the bus that the rule belongs to
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleContainerArgs']]] containers: ContainerTarget
        :param pulumi.Input[_builtins.str] description: Description of the rule
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleFunctionArgs']]] functions: FunctionTarget
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs']]] gateway_websocket_broadcasts: GatewayWebsocketBroadcastTarget
        :param pulumi.Input[_builtins.str] jq_filter: JQ filter for matching events
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Rule labels
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleLoggingArgs']]] loggings: LoggingTarget. Includes either log*group*id or folder_id
        :param pulumi.Input[_builtins.str] name: Name of the rule
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleWorkflowArgs']]] workflows: WorkflowTarget
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYdArgs']]] yds: YdsTarget
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYmqArgs']]] ymqs: YmqTarget
        """
        pulumi.set(__self__, "bus_id", bus_id)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if functions is not None:
            pulumi.set(__self__, "functions", functions)
        if gateway_websocket_broadcasts is not None:
            pulumi.set(__self__, "gateway_websocket_broadcasts", gateway_websocket_broadcasts)
        if jq_filter is not None:
            pulumi.set(__self__, "jq_filter", jq_filter)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workflows is not None:
            pulumi.set(__self__, "workflows", workflows)
        if yds is not None:
            pulumi.set(__self__, "yds", yds)
        if ymqs is not None:
            pulumi.set(__self__, "ymqs", ymqs)

    @_builtins.property
    @pulumi.getter(name="busId")
    def bus_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the bus that the rule belongs to
        """
        return pulumi.get(self, "bus_id")

    @bus_id.setter
    def bus_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bus_id", value)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleContainerArgs']]]]:
        """
        ContainerTarget
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleFunctionArgs']]]]:
        """
        FunctionTarget
        """
        return pulumi.get(self, "functions")

    @functions.setter
    def functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleFunctionArgs']]]]):
        pulumi.set(self, "functions", value)

    @_builtins.property
    @pulumi.getter(name="gatewayWebsocketBroadcasts")
    def gateway_websocket_broadcasts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs']]]]:
        """
        GatewayWebsocketBroadcastTarget
        """
        return pulumi.get(self, "gateway_websocket_broadcasts")

    @gateway_websocket_broadcasts.setter
    def gateway_websocket_broadcasts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs']]]]):
        pulumi.set(self, "gateway_websocket_broadcasts", value)

    @_builtins.property
    @pulumi.getter(name="jqFilter")
    def jq_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JQ filter for matching events
        """
        return pulumi.get(self, "jq_filter")

    @jq_filter.setter
    def jq_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jq_filter", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Rule labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleLoggingArgs']]]]:
        """
        LoggingTarget. Includes either log*group*id or folder_id
        """
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleLoggingArgs']]]]):
        pulumi.set(self, "loggings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def workflows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleWorkflowArgs']]]]:
        """
        WorkflowTarget
        """
        return pulumi.get(self, "workflows")

    @workflows.setter
    def workflows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleWorkflowArgs']]]]):
        pulumi.set(self, "workflows", value)

    @_builtins.property
    @pulumi.getter
    def yds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYdArgs']]]]:
        """
        YdsTarget
        """
        return pulumi.get(self, "yds")

    @yds.setter
    def yds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYdArgs']]]]):
        pulumi.set(self, "yds", value)

    @_builtins.property
    @pulumi.getter
    def ymqs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYmqArgs']]]]:
        """
        YmqTarget
        """
        return pulumi.get(self, "ymqs")

    @ymqs.setter
    def ymqs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYmqArgs']]]]):
        pulumi.set(self, "ymqs", value)


@pulumi.input_type
class _ServerlessEventrouterRuleState:
    def __init__(__self__, *,
                 bus_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleContainerArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleFunctionArgs']]]] = None,
                 gateway_websocket_broadcasts: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs']]]] = None,
                 jq_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleLoggingArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 workflows: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleWorkflowArgs']]]] = None,
                 yds: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYdArgs']]]] = None,
                 ymqs: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYmqArgs']]]] = None):
        """
        Input properties used for looking up and filtering ServerlessEventrouterRule resources.
        :param pulumi.Input[_builtins.str] bus_id: ID of the bus that the rule belongs to
        :param pulumi.Input[_builtins.str] cloud_id: ID of the cloud that the rule resides in
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleContainerArgs']]] containers: ContainerTarget
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp
        :param pulumi.Input[_builtins.bool] deletion_protection: Deletion protection
        :param pulumi.Input[_builtins.str] description: Description of the rule
        :param pulumi.Input[_builtins.str] folder_id: ID of the folder that the rule resides in
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleFunctionArgs']]] functions: FunctionTarget
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs']]] gateway_websocket_broadcasts: GatewayWebsocketBroadcastTarget
        :param pulumi.Input[_builtins.str] jq_filter: JQ filter for matching events
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Rule labels
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleLoggingArgs']]] loggings: LoggingTarget. Includes either log*group*id or folder_id
        :param pulumi.Input[_builtins.str] name: Name of the rule
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleWorkflowArgs']]] workflows: WorkflowTarget
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYdArgs']]] yds: YdsTarget
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYmqArgs']]] ymqs: YmqTarget
        """
        if bus_id is not None:
            pulumi.set(__self__, "bus_id", bus_id)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if functions is not None:
            pulumi.set(__self__, "functions", functions)
        if gateway_websocket_broadcasts is not None:
            pulumi.set(__self__, "gateway_websocket_broadcasts", gateway_websocket_broadcasts)
        if jq_filter is not None:
            pulumi.set(__self__, "jq_filter", jq_filter)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workflows is not None:
            pulumi.set(__self__, "workflows", workflows)
        if yds is not None:
            pulumi.set(__self__, "yds", yds)
        if ymqs is not None:
            pulumi.set(__self__, "ymqs", ymqs)

    @_builtins.property
    @pulumi.getter(name="busId")
    def bus_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the bus that the rule belongs to
        """
        return pulumi.get(self, "bus_id")

    @bus_id.setter
    def bus_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bus_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the cloud that the rule resides in
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleContainerArgs']]]]:
        """
        ContainerTarget
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deletion protection
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the folder that the rule resides in
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleFunctionArgs']]]]:
        """
        FunctionTarget
        """
        return pulumi.get(self, "functions")

    @functions.setter
    def functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleFunctionArgs']]]]):
        pulumi.set(self, "functions", value)

    @_builtins.property
    @pulumi.getter(name="gatewayWebsocketBroadcasts")
    def gateway_websocket_broadcasts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs']]]]:
        """
        GatewayWebsocketBroadcastTarget
        """
        return pulumi.get(self, "gateway_websocket_broadcasts")

    @gateway_websocket_broadcasts.setter
    def gateway_websocket_broadcasts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs']]]]):
        pulumi.set(self, "gateway_websocket_broadcasts", value)

    @_builtins.property
    @pulumi.getter(name="jqFilter")
    def jq_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JQ filter for matching events
        """
        return pulumi.get(self, "jq_filter")

    @jq_filter.setter
    def jq_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jq_filter", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Rule labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleLoggingArgs']]]]:
        """
        LoggingTarget. Includes either log*group*id or folder_id
        """
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleLoggingArgs']]]]):
        pulumi.set(self, "loggings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def workflows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleWorkflowArgs']]]]:
        """
        WorkflowTarget
        """
        return pulumi.get(self, "workflows")

    @workflows.setter
    def workflows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleWorkflowArgs']]]]):
        pulumi.set(self, "workflows", value)

    @_builtins.property
    @pulumi.getter
    def yds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYdArgs']]]]:
        """
        YdsTarget
        """
        return pulumi.get(self, "yds")

    @yds.setter
    def yds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYdArgs']]]]):
        pulumi.set(self, "yds", value)

    @_builtins.property
    @pulumi.getter
    def ymqs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYmqArgs']]]]:
        """
        YmqTarget
        """
        return pulumi.get(self, "ymqs")

    @ymqs.setter
    def ymqs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessEventrouterRuleYmqArgs']]]]):
        pulumi.set(self, "ymqs", value)


@pulumi.type_token("yandex:index/serverlessEventrouterRule:ServerlessEventrouterRule")
class ServerlessEventrouterRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bus_id: Optional[pulumi.Input[_builtins.str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleContainerArgs', 'ServerlessEventrouterRuleContainerArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleFunctionArgs', 'ServerlessEventrouterRuleFunctionArgsDict']]]]] = None,
                 gateway_websocket_broadcasts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs', 'ServerlessEventrouterRuleGatewayWebsocketBroadcastArgsDict']]]]] = None,
                 jq_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleLoggingArgs', 'ServerlessEventrouterRuleLoggingArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 workflows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleWorkflowArgs', 'ServerlessEventrouterRuleWorkflowArgsDict']]]]] = None,
                 yds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleYdArgs', 'ServerlessEventrouterRuleYdArgsDict']]]]] = None,
                 ymqs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleYmqArgs', 'ServerlessEventrouterRuleYmqArgsDict']]]]] = None,
                 __props__=None):
        """
        Allows management of a Yandex Cloud Serverless Event Router Rule.

        ## Example Usage

        ```python
        import pulumi
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/serverlessEventrouterRule:ServerlessEventrouterRule <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/serverlessEventrouterRule:ServerlessEventrouterRule evr_rule ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bus_id: ID of the bus that the rule belongs to
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleContainerArgs', 'ServerlessEventrouterRuleContainerArgsDict']]]] containers: ContainerTarget
        :param pulumi.Input[_builtins.str] description: Description of the rule
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleFunctionArgs', 'ServerlessEventrouterRuleFunctionArgsDict']]]] functions: FunctionTarget
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs', 'ServerlessEventrouterRuleGatewayWebsocketBroadcastArgsDict']]]] gateway_websocket_broadcasts: GatewayWebsocketBroadcastTarget
        :param pulumi.Input[_builtins.str] jq_filter: JQ filter for matching events
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Rule labels
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleLoggingArgs', 'ServerlessEventrouterRuleLoggingArgsDict']]]] loggings: LoggingTarget. Includes either log*group*id or folder_id
        :param pulumi.Input[_builtins.str] name: Name of the rule
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleWorkflowArgs', 'ServerlessEventrouterRuleWorkflowArgsDict']]]] workflows: WorkflowTarget
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleYdArgs', 'ServerlessEventrouterRuleYdArgsDict']]]] yds: YdsTarget
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleYmqArgs', 'ServerlessEventrouterRuleYmqArgsDict']]]] ymqs: YmqTarget
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerlessEventrouterRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of a Yandex Cloud Serverless Event Router Rule.

        ## Example Usage

        ```python
        import pulumi
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/serverlessEventrouterRule:ServerlessEventrouterRule <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/serverlessEventrouterRule:ServerlessEventrouterRule evr_rule ...
        ```

        :param str resource_name: The name of the resource.
        :param ServerlessEventrouterRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerlessEventrouterRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bus_id: Optional[pulumi.Input[_builtins.str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleContainerArgs', 'ServerlessEventrouterRuleContainerArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleFunctionArgs', 'ServerlessEventrouterRuleFunctionArgsDict']]]]] = None,
                 gateway_websocket_broadcasts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs', 'ServerlessEventrouterRuleGatewayWebsocketBroadcastArgsDict']]]]] = None,
                 jq_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleLoggingArgs', 'ServerlessEventrouterRuleLoggingArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 workflows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleWorkflowArgs', 'ServerlessEventrouterRuleWorkflowArgsDict']]]]] = None,
                 yds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleYdArgs', 'ServerlessEventrouterRuleYdArgsDict']]]]] = None,
                 ymqs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleYmqArgs', 'ServerlessEventrouterRuleYmqArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerlessEventrouterRuleArgs.__new__(ServerlessEventrouterRuleArgs)

            if bus_id is None and not opts.urn:
                raise TypeError("Missing required property 'bus_id'")
            __props__.__dict__["bus_id"] = bus_id
            __props__.__dict__["containers"] = containers
            __props__.__dict__["description"] = description
            __props__.__dict__["functions"] = functions
            __props__.__dict__["gateway_websocket_broadcasts"] = gateway_websocket_broadcasts
            __props__.__dict__["jq_filter"] = jq_filter
            __props__.__dict__["labels"] = labels
            __props__.__dict__["loggings"] = loggings
            __props__.__dict__["name"] = name
            __props__.__dict__["workflows"] = workflows
            __props__.__dict__["yds"] = yds
            __props__.__dict__["ymqs"] = ymqs
            __props__.__dict__["cloud_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["deletion_protection"] = None
            __props__.__dict__["folder_id"] = None
        super(ServerlessEventrouterRule, __self__).__init__(
            'yandex:index/serverlessEventrouterRule:ServerlessEventrouterRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bus_id: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
            containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleContainerArgs', 'ServerlessEventrouterRuleContainerArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            functions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleFunctionArgs', 'ServerlessEventrouterRuleFunctionArgsDict']]]]] = None,
            gateway_websocket_broadcasts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs', 'ServerlessEventrouterRuleGatewayWebsocketBroadcastArgsDict']]]]] = None,
            jq_filter: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleLoggingArgs', 'ServerlessEventrouterRuleLoggingArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            workflows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleWorkflowArgs', 'ServerlessEventrouterRuleWorkflowArgsDict']]]]] = None,
            yds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleYdArgs', 'ServerlessEventrouterRuleYdArgsDict']]]]] = None,
            ymqs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleYmqArgs', 'ServerlessEventrouterRuleYmqArgsDict']]]]] = None) -> 'ServerlessEventrouterRule':
        """
        Get an existing ServerlessEventrouterRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bus_id: ID of the bus that the rule belongs to
        :param pulumi.Input[_builtins.str] cloud_id: ID of the cloud that the rule resides in
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleContainerArgs', 'ServerlessEventrouterRuleContainerArgsDict']]]] containers: ContainerTarget
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp
        :param pulumi.Input[_builtins.bool] deletion_protection: Deletion protection
        :param pulumi.Input[_builtins.str] description: Description of the rule
        :param pulumi.Input[_builtins.str] folder_id: ID of the folder that the rule resides in
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleFunctionArgs', 'ServerlessEventrouterRuleFunctionArgsDict']]]] functions: FunctionTarget
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleGatewayWebsocketBroadcastArgs', 'ServerlessEventrouterRuleGatewayWebsocketBroadcastArgsDict']]]] gateway_websocket_broadcasts: GatewayWebsocketBroadcastTarget
        :param pulumi.Input[_builtins.str] jq_filter: JQ filter for matching events
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Rule labels
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleLoggingArgs', 'ServerlessEventrouterRuleLoggingArgsDict']]]] loggings: LoggingTarget. Includes either log*group*id or folder_id
        :param pulumi.Input[_builtins.str] name: Name of the rule
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleWorkflowArgs', 'ServerlessEventrouterRuleWorkflowArgsDict']]]] workflows: WorkflowTarget
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleYdArgs', 'ServerlessEventrouterRuleYdArgsDict']]]] yds: YdsTarget
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessEventrouterRuleYmqArgs', 'ServerlessEventrouterRuleYmqArgsDict']]]] ymqs: YmqTarget
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerlessEventrouterRuleState.__new__(_ServerlessEventrouterRuleState)

        __props__.__dict__["bus_id"] = bus_id
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["containers"] = containers
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["functions"] = functions
        __props__.__dict__["gateway_websocket_broadcasts"] = gateway_websocket_broadcasts
        __props__.__dict__["jq_filter"] = jq_filter
        __props__.__dict__["labels"] = labels
        __props__.__dict__["loggings"] = loggings
        __props__.__dict__["name"] = name
        __props__.__dict__["workflows"] = workflows
        __props__.__dict__["yds"] = yds
        __props__.__dict__["ymqs"] = ymqs
        return ServerlessEventrouterRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="busId")
    def bus_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the bus that the rule belongs to
        """
        return pulumi.get(self, "bus_id")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the cloud that the rule resides in
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessEventrouterRuleContainer']]]:
        """
        ContainerTarget
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        Deletion protection
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the folder that the rule resides in
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def functions(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessEventrouterRuleFunction']]]:
        """
        FunctionTarget
        """
        return pulumi.get(self, "functions")

    @_builtins.property
    @pulumi.getter(name="gatewayWebsocketBroadcasts")
    def gateway_websocket_broadcasts(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessEventrouterRuleGatewayWebsocketBroadcast']]]:
        """
        GatewayWebsocketBroadcastTarget
        """
        return pulumi.get(self, "gateway_websocket_broadcasts")

    @_builtins.property
    @pulumi.getter(name="jqFilter")
    def jq_filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JQ filter for matching events
        """
        return pulumi.get(self, "jq_filter")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Rule labels
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def loggings(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessEventrouterRuleLogging']]]:
        """
        LoggingTarget. Includes either log*group*id or folder_id
        """
        return pulumi.get(self, "loggings")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def workflows(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessEventrouterRuleWorkflow']]]:
        """
        WorkflowTarget
        """
        return pulumi.get(self, "workflows")

    @_builtins.property
    @pulumi.getter
    def yds(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessEventrouterRuleYd']]]:
        """
        YdsTarget
        """
        return pulumi.get(self, "yds")

    @_builtins.property
    @pulumi.getter
    def ymqs(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessEventrouterRuleYmq']]]:
        """
        YmqTarget
        """
        return pulumi.get(self, "ymqs")

