# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SmartcaptchaCaptchaArgs', 'SmartcaptchaCaptcha']

@pulumi.input_type
class SmartcaptchaCaptchaArgs:
    def __init__(__self__, *,
                 allowed_sites: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 challenge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 complexity: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 override_variants: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]] = None,
                 pre_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]] = None,
                 style_json: Optional[pulumi.Input[_builtins.str]] = None,
                 turn_off_hostname_check: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SmartcaptchaCaptcha resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_sites: List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        :param pulumi.Input[_builtins.str] challenge_type: Additional task type of the captcha. Possible values:
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] complexity: Complexity of the captcha. Possible values:
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]] override_variants: List of variants to use in security*rules.
        :param pulumi.Input[_builtins.str] pre_check_type: Basic check type of the captcha.Possible values:
        :param pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]] security_rules: List of security rules.
        :param pulumi.Input[_builtins.str] style_json: JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        :param pulumi.Input[_builtins.bool] turn_off_hostname_check: Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        if allowed_sites is not None:
            pulumi.set(__self__, "allowed_sites", allowed_sites)
        if challenge_type is not None:
            pulumi.set(__self__, "challenge_type", challenge_type)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if override_variants is not None:
            pulumi.set(__self__, "override_variants", override_variants)
        if pre_check_type is not None:
            pulumi.set(__self__, "pre_check_type", pre_check_type)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)
        if style_json is not None:
            pulumi.set(__self__, "style_json", style_json)
        if turn_off_hostname_check is not None:
            pulumi.set(__self__, "turn_off_hostname_check", turn_off_hostname_check)

    @_builtins.property
    @pulumi.getter(name="allowedSites")
    def allowed_sites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "allowed_sites")

    @allowed_sites.setter
    def allowed_sites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_sites", value)

    @_builtins.property
    @pulumi.getter(name="challengeType")
    def challenge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional task type of the captcha. Possible values:
        """
        return pulumi.get(self, "challenge_type")

    @challenge_type.setter
    def challenge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "challenge_type", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Complexity of the captcha. Possible values:
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "complexity", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="overrideVariants")
    def override_variants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]]:
        """
        List of variants to use in security*rules.
        """
        return pulumi.get(self, "override_variants")

    @override_variants.setter
    def override_variants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]]):
        pulumi.set(self, "override_variants", value)

    @_builtins.property
    @pulumi.getter(name="preCheckType")
    def pre_check_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Basic check type of the captcha.Possible values:
        """
        return pulumi.get(self, "pre_check_type")

    @pre_check_type.setter
    def pre_check_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_check_type", value)

    @_builtins.property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]]:
        """
        List of security rules.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)

    @_builtins.property
    @pulumi.getter(name="styleJson")
    def style_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        """
        return pulumi.get(self, "style_json")

    @style_json.setter
    def style_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "style_json", value)

    @_builtins.property
    @pulumi.getter(name="turnOffHostnameCheck")
    def turn_off_hostname_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "turn_off_hostname_check")

    @turn_off_hostname_check.setter
    def turn_off_hostname_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "turn_off_hostname_check", value)


@pulumi.input_type
class _SmartcaptchaCaptchaState:
    def __init__(__self__, *,
                 allowed_sites: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 challenge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 complexity: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 override_variants: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]] = None,
                 pre_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]] = None,
                 style_json: Optional[pulumi.Input[_builtins.str]] = None,
                 suspend: Optional[pulumi.Input[_builtins.bool]] = None,
                 turn_off_hostname_check: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SmartcaptchaCaptcha resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_sites: List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        :param pulumi.Input[_builtins.str] challenge_type: Additional task type of the captcha. Possible values:
        :param pulumi.Input[_builtins.str] client_key: Client key of the captcha, see [CAPTCHA keys](https://yandex.cloud/docs/smartcaptcha/concepts/keys).
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] complexity: Complexity of the captcha. Possible values:
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]] override_variants: List of variants to use in security*rules.
        :param pulumi.Input[_builtins.str] pre_check_type: Basic check type of the captcha.Possible values:
        :param pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]] security_rules: List of security rules.
        :param pulumi.Input[_builtins.str] style_json: JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        :param pulumi.Input[_builtins.bool] turn_off_hostname_check: Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        if allowed_sites is not None:
            pulumi.set(__self__, "allowed_sites", allowed_sites)
        if challenge_type is not None:
            pulumi.set(__self__, "challenge_type", challenge_type)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if override_variants is not None:
            pulumi.set(__self__, "override_variants", override_variants)
        if pre_check_type is not None:
            pulumi.set(__self__, "pre_check_type", pre_check_type)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)
        if style_json is not None:
            pulumi.set(__self__, "style_json", style_json)
        if suspend is not None:
            pulumi.set(__self__, "suspend", suspend)
        if turn_off_hostname_check is not None:
            pulumi.set(__self__, "turn_off_hostname_check", turn_off_hostname_check)

    @_builtins.property
    @pulumi.getter(name="allowedSites")
    def allowed_sites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "allowed_sites")

    @allowed_sites.setter
    def allowed_sites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_sites", value)

    @_builtins.property
    @pulumi.getter(name="challengeType")
    def challenge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional task type of the captcha. Possible values:
        """
        return pulumi.get(self, "challenge_type")

    @challenge_type.setter
    def challenge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "challenge_type", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client key of the captcha, see [CAPTCHA keys](https://yandex.cloud/docs/smartcaptcha/concepts/keys).
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Complexity of the captcha. Possible values:
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "complexity", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="overrideVariants")
    def override_variants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]]:
        """
        List of variants to use in security*rules.
        """
        return pulumi.get(self, "override_variants")

    @override_variants.setter
    def override_variants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]]):
        pulumi.set(self, "override_variants", value)

    @_builtins.property
    @pulumi.getter(name="preCheckType")
    def pre_check_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Basic check type of the captcha.Possible values:
        """
        return pulumi.get(self, "pre_check_type")

    @pre_check_type.setter
    def pre_check_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_check_type", value)

    @_builtins.property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]]:
        """
        List of security rules.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)

    @_builtins.property
    @pulumi.getter(name="styleJson")
    def style_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        """
        return pulumi.get(self, "style_json")

    @style_json.setter
    def style_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "style_json", value)

    @_builtins.property
    @pulumi.getter
    def suspend(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "suspend")

    @suspend.setter
    def suspend(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspend", value)

    @_builtins.property
    @pulumi.getter(name="turnOffHostnameCheck")
    def turn_off_hostname_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "turn_off_hostname_check")

    @turn_off_hostname_check.setter
    def turn_off_hostname_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "turn_off_hostname_check", value)


@pulumi.type_token("yandex:index/smartcaptchaCaptcha:SmartcaptchaCaptcha")
class SmartcaptchaCaptcha(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_sites: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 challenge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 complexity: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 override_variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaOverrideVariantArgs', 'SmartcaptchaCaptchaOverrideVariantArgsDict']]]]] = None,
                 pre_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaSecurityRuleArgs', 'SmartcaptchaCaptchaSecurityRuleArgsDict']]]]] = None,
                 style_json: Optional[pulumi.Input[_builtins.str]] = None,
                 turn_off_hostname_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Creates a Captcha in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartcaptcha/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # 
        # Simple SmartCaptcha example.
        #
        demo_captcha_simple = yandex.SmartcaptchaCaptcha("demo-captcha-simple",
            deletion_protection=True,
            name="demo-captcha-simple",
            complexity="HARD",
            pre_check_type="SLIDER",
            challenge_type="IMAGE_TEXT",
            allowed_sites=[
                "example.com",
                "example.ru",
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Advanced SmartCaptcha example.
        #
        demo_captcha_advanced = yandex.SmartcaptchaCaptcha("demo-captcha-advanced",
            deletion_protection=True,
            name="demo-captcha-advanced",
            complexity="HARD",
            pre_check_type="SLIDER",
            challenge_type="IMAGE_TEXT",
            allowed_sites=[
                "example.com",
                "example.ru",
            ],
            override_variants=[
                {
                    "uuid": "xxx",
                    "description": "override variant 1",
                    "complexity": "EASY",
                    "pre_check_type": "CHECKBOX",
                    "challenge_type": "SILHOUETTES",
                },
                {
                    "uuid": "yyy",
                    "description": "override variant 2",
                    "complexity": "HARD",
                    "pre_check_type": "CHECKBOX",
                    "challenge_type": "KALEIDOSCOPE",
                },
            ],
            security_rules=[
                {
                    "name": "rule1",
                    "priority": 11,
                    "description": "My first security rule. This rule it's just example to show possibilities of configuration.",
                    "override_variant_uuid": "xxx",
                    "condition": {
                        "host": {
                            "hosts": [
                                {
                                    "exact_match": "example.com",
                                },
                                {
                                    "exact_match": "example.net",
                                },
                            ],
                        },
                        "uri": {
                            "path": {
                                "prefix_match": "/form",
                            },
                            "queries": [
                                {
                                    "key": "firstname",
                                    "value": {
                                        "pire_regex_match": ".*ivan.*",
                                    },
                                },
                                {
                                    "key": "lastname",
                                    "value": {
                                        "pire_regex_match": ".*petr.*",
                                    },
                                },
                            ],
                        },
                        "headers": [
                            {
                                "name": "User-Agent",
                                "value": {
                                    "pire_regex_match": ".*curl.*",
                                },
                            },
                            {
                                "name": "Referer",
                                "value": {
                                    "pire_regex_not_match": ".*bot.*",
                                },
                            },
                        ],
                        "source_ip": {
                            "ip_ranges_match": {
                                "ip_ranges": [
                                    "1.2.33.44",
                                    "2.3.4.56",
                                ],
                            },
                            "ip_ranges_not_match": {
                                "ip_ranges": [
                                    "8.8.0.0/16",
                                    "10::1234:1abc:1/64",
                                ],
                            },
                            "geo_ip_match": {
                                "locations": [
                                    "ru",
                                    "es",
                                ],
                            },
                            "geo_ip_not_match": {
                                "locations": [
                                    "us",
                                    "fm",
                                    "gb",
                                ],
                            },
                        },
                    },
                },
                {
                    "name": "rule2",
                    "priority": 555,
                    "description": "Second rule",
                    "override_variant_uuid": "yyy",
                    "condition": {
                        "uri": {
                            "path": {
                                "prefix_match": "/form",
                            },
                        },
                    },
                },
                {
                    "name": "rule3",
                    "priority": 99999,
                    "description": "Empty condition rule",
                    "override_variant_uuid": "yyy",
                },
            ])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/smartcaptchaCaptcha:SmartcaptchaCaptcha <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/smartcaptchaCaptcha:SmartcaptchaCaptcha demo-captcha-simple ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_sites: List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        :param pulumi.Input[_builtins.str] challenge_type: Additional task type of the captcha. Possible values:
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] complexity: Complexity of the captcha. Possible values:
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaOverrideVariantArgs', 'SmartcaptchaCaptchaOverrideVariantArgsDict']]]] override_variants: List of variants to use in security*rules.
        :param pulumi.Input[_builtins.str] pre_check_type: Basic check type of the captcha.Possible values:
        :param pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaSecurityRuleArgs', 'SmartcaptchaCaptchaSecurityRuleArgsDict']]]] security_rules: List of security rules.
        :param pulumi.Input[_builtins.str] style_json: JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        :param pulumi.Input[_builtins.bool] turn_off_hostname_check: Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SmartcaptchaCaptchaArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Captcha in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartcaptcha/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # 
        # Simple SmartCaptcha example.
        #
        demo_captcha_simple = yandex.SmartcaptchaCaptcha("demo-captcha-simple",
            deletion_protection=True,
            name="demo-captcha-simple",
            complexity="HARD",
            pre_check_type="SLIDER",
            challenge_type="IMAGE_TEXT",
            allowed_sites=[
                "example.com",
                "example.ru",
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Advanced SmartCaptcha example.
        #
        demo_captcha_advanced = yandex.SmartcaptchaCaptcha("demo-captcha-advanced",
            deletion_protection=True,
            name="demo-captcha-advanced",
            complexity="HARD",
            pre_check_type="SLIDER",
            challenge_type="IMAGE_TEXT",
            allowed_sites=[
                "example.com",
                "example.ru",
            ],
            override_variants=[
                {
                    "uuid": "xxx",
                    "description": "override variant 1",
                    "complexity": "EASY",
                    "pre_check_type": "CHECKBOX",
                    "challenge_type": "SILHOUETTES",
                },
                {
                    "uuid": "yyy",
                    "description": "override variant 2",
                    "complexity": "HARD",
                    "pre_check_type": "CHECKBOX",
                    "challenge_type": "KALEIDOSCOPE",
                },
            ],
            security_rules=[
                {
                    "name": "rule1",
                    "priority": 11,
                    "description": "My first security rule. This rule it's just example to show possibilities of configuration.",
                    "override_variant_uuid": "xxx",
                    "condition": {
                        "host": {
                            "hosts": [
                                {
                                    "exact_match": "example.com",
                                },
                                {
                                    "exact_match": "example.net",
                                },
                            ],
                        },
                        "uri": {
                            "path": {
                                "prefix_match": "/form",
                            },
                            "queries": [
                                {
                                    "key": "firstname",
                                    "value": {
                                        "pire_regex_match": ".*ivan.*",
                                    },
                                },
                                {
                                    "key": "lastname",
                                    "value": {
                                        "pire_regex_match": ".*petr.*",
                                    },
                                },
                            ],
                        },
                        "headers": [
                            {
                                "name": "User-Agent",
                                "value": {
                                    "pire_regex_match": ".*curl.*",
                                },
                            },
                            {
                                "name": "Referer",
                                "value": {
                                    "pire_regex_not_match": ".*bot.*",
                                },
                            },
                        ],
                        "source_ip": {
                            "ip_ranges_match": {
                                "ip_ranges": [
                                    "1.2.33.44",
                                    "2.3.4.56",
                                ],
                            },
                            "ip_ranges_not_match": {
                                "ip_ranges": [
                                    "8.8.0.0/16",
                                    "10::1234:1abc:1/64",
                                ],
                            },
                            "geo_ip_match": {
                                "locations": [
                                    "ru",
                                    "es",
                                ],
                            },
                            "geo_ip_not_match": {
                                "locations": [
                                    "us",
                                    "fm",
                                    "gb",
                                ],
                            },
                        },
                    },
                },
                {
                    "name": "rule2",
                    "priority": 555,
                    "description": "Second rule",
                    "override_variant_uuid": "yyy",
                    "condition": {
                        "uri": {
                            "path": {
                                "prefix_match": "/form",
                            },
                        },
                    },
                },
                {
                    "name": "rule3",
                    "priority": 99999,
                    "description": "Empty condition rule",
                    "override_variant_uuid": "yyy",
                },
            ])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/smartcaptchaCaptcha:SmartcaptchaCaptcha <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/smartcaptchaCaptcha:SmartcaptchaCaptcha demo-captcha-simple ...
        ```

        :param str resource_name: The name of the resource.
        :param SmartcaptchaCaptchaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SmartcaptchaCaptchaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_sites: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 challenge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 complexity: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 override_variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaOverrideVariantArgs', 'SmartcaptchaCaptchaOverrideVariantArgsDict']]]]] = None,
                 pre_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaSecurityRuleArgs', 'SmartcaptchaCaptchaSecurityRuleArgsDict']]]]] = None,
                 style_json: Optional[pulumi.Input[_builtins.str]] = None,
                 turn_off_hostname_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SmartcaptchaCaptchaArgs.__new__(SmartcaptchaCaptchaArgs)

            __props__.__dict__["allowed_sites"] = allowed_sites
            __props__.__dict__["challenge_type"] = challenge_type
            __props__.__dict__["cloud_id"] = cloud_id
            __props__.__dict__["complexity"] = complexity
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["name"] = name
            __props__.__dict__["override_variants"] = override_variants
            __props__.__dict__["pre_check_type"] = pre_check_type
            __props__.__dict__["security_rules"] = security_rules
            __props__.__dict__["style_json"] = style_json
            __props__.__dict__["turn_off_hostname_check"] = turn_off_hostname_check
            __props__.__dict__["client_key"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["suspend"] = None
        super(SmartcaptchaCaptcha, __self__).__init__(
            'yandex:index/smartcaptchaCaptcha:SmartcaptchaCaptcha',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_sites: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            challenge_type: Optional[pulumi.Input[_builtins.str]] = None,
            client_key: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
            complexity: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            override_variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaOverrideVariantArgs', 'SmartcaptchaCaptchaOverrideVariantArgsDict']]]]] = None,
            pre_check_type: Optional[pulumi.Input[_builtins.str]] = None,
            security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaSecurityRuleArgs', 'SmartcaptchaCaptchaSecurityRuleArgsDict']]]]] = None,
            style_json: Optional[pulumi.Input[_builtins.str]] = None,
            suspend: Optional[pulumi.Input[_builtins.bool]] = None,
            turn_off_hostname_check: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SmartcaptchaCaptcha':
        """
        Get an existing SmartcaptchaCaptcha resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_sites: List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        :param pulumi.Input[_builtins.str] challenge_type: Additional task type of the captcha. Possible values:
        :param pulumi.Input[_builtins.str] client_key: Client key of the captcha, see [CAPTCHA keys](https://yandex.cloud/docs/smartcaptcha/concepts/keys).
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] complexity: Complexity of the captcha. Possible values:
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaOverrideVariantArgs', 'SmartcaptchaCaptchaOverrideVariantArgsDict']]]] override_variants: List of variants to use in security*rules.
        :param pulumi.Input[_builtins.str] pre_check_type: Basic check type of the captcha.Possible values:
        :param pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaSecurityRuleArgs', 'SmartcaptchaCaptchaSecurityRuleArgsDict']]]] security_rules: List of security rules.
        :param pulumi.Input[_builtins.str] style_json: JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        :param pulumi.Input[_builtins.bool] turn_off_hostname_check: Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SmartcaptchaCaptchaState.__new__(_SmartcaptchaCaptchaState)

        __props__.__dict__["allowed_sites"] = allowed_sites
        __props__.__dict__["challenge_type"] = challenge_type
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["complexity"] = complexity
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["name"] = name
        __props__.__dict__["override_variants"] = override_variants
        __props__.__dict__["pre_check_type"] = pre_check_type
        __props__.__dict__["security_rules"] = security_rules
        __props__.__dict__["style_json"] = style_json
        __props__.__dict__["suspend"] = suspend
        __props__.__dict__["turn_off_hostname_check"] = turn_off_hostname_check
        return SmartcaptchaCaptcha(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedSites")
    def allowed_sites(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "allowed_sites")

    @_builtins.property
    @pulumi.getter(name="challengeType")
    def challenge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Additional task type of the captcha. Possible values:
        """
        return pulumi.get(self, "challenge_type")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> pulumi.Output[_builtins.str]:
        """
        Client key of the captcha, see [CAPTCHA keys](https://yandex.cloud/docs/smartcaptcha/concepts/keys).
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter
    def complexity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Complexity of the captcha. Possible values:
        """
        return pulumi.get(self, "complexity")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="overrideVariants")
    def override_variants(self) -> pulumi.Output[Optional[Sequence['outputs.SmartcaptchaCaptchaOverrideVariant']]]:
        """
        List of variants to use in security*rules.
        """
        return pulumi.get(self, "override_variants")

    @_builtins.property
    @pulumi.getter(name="preCheckType")
    def pre_check_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Basic check type of the captcha.Possible values:
        """
        return pulumi.get(self, "pre_check_type")

    @_builtins.property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SmartcaptchaCaptchaSecurityRule']]]:
        """
        List of security rules.
        """
        return pulumi.get(self, "security_rules")

    @_builtins.property
    @pulumi.getter(name="styleJson")
    def style_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        """
        return pulumi.get(self, "style_json")

    @_builtins.property
    @pulumi.getter
    def suspend(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "suspend")

    @_builtins.property
    @pulumi.getter(name="turnOffHostnameCheck")
    def turn_off_hostname_check(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "turn_off_hostname_check")

