# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StorageBucketArgs', 'StorageBucket']

@pulumi.input_type
class StorageBucketArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 anonymous_access_flags: Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]] = None,
                 default_storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]] = None,
                 https: Optional[pulumi.Input['StorageBucketHttpsArgs']] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 object_lock_configuration: Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input['StorageBucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['StorageBucketWebsiteArgs']] = None,
                 website_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 website_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StorageBucket resource.
        :param pulumi.Input[_builtins.str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] acl: The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
        :param pulumi.Input['StorageBucketAnonymousAccessFlagsArgs'] anonymous_access_flags: Provides various access to objects. See [Bucket Availability](https://yandex.cloud/docs/storage/operations/buckets/bucket-availability) for more information.
        :param pulumi.Input[_builtins.str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]] cors_rules: A rule of [Cross-Origin Resource Sharing](https://yandex.cloud/docs/storage/concepts/cors) (CORS object).
        :param pulumi.Input[_builtins.str] default_storage_class: Storage class which is used for storing objects by default. Available values are: "STANDARD", "COLD", "ICE". Default is `"STANDARD"`. See [Storage Class](https://yandex.cloud/docs/storage/concepts/storage-class) for more information.
        :param pulumi.Input[_builtins.str] folder_id: Allow to create bucket in different folder. In case you are using IAM token from UserAccount, you are needed to explicitly specify folder_id in the resource, as it cannot be identified from such type of account. In case you are using IAM token from ServiceAccount or static access keys, folder_id does not need to be specified unless you want to create the resource in a different folder than the account folder.
               
               > It will try to create bucket using `IAM-token`, not using `access keys`.
        :param pulumi.Input[_builtins.bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]] grants: An [ACL policy grant](https://yandex.cloud/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
               
               > To manage `grant` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input['StorageBucketHttpsArgs'] https: Manages https certificates for bucket. See [https](https://yandex.cloud/docs/storage/operations/hosting/certificate) for more information.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]] lifecycle_rules: A configuration of [object lifecycle management](https://yandex.cloud/docs/storage/concepts/lifecycles).
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]] loggings: A settings of [bucket logging](https://yandex.cloud/docs/storage/concepts/server-logs).
        :param pulumi.Input[_builtins.int] max_size: The size of bucket, in bytes. See [Size Limiting](https://yandex.cloud/docs/storage/operations/buckets/limit-max-volume) for more information.
        :param pulumi.Input['StorageBucketObjectLockConfigurationArgs'] object_lock_configuration: A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock).
        :param pulumi.Input[_builtins.str] policy: The `policy` object should contain the only field with the text of the policy. See [policy documentation](https://yandex.cloud/docs/storage/concepts/policy) for more information on policy format.
        :param pulumi.Input[_builtins.str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs'] server_side_encryption_configuration: A configuration of server-side encryption for the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        :param pulumi.Input['StorageBucketVersioningArgs'] versioning: A state of [versioning](https://yandex.cloud/docs/storage/concepts/versioning).
               
               > To manage `versioning` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input['StorageBucketWebsiteArgs'] website: A [Website Object](https://yandex.cloud/docs/storage/concepts/hosting)
        :param pulumi.Input[_builtins.str] website_domain: The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        :param pulumi.Input[_builtins.str] website_endpoint: The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if acl is not None:
            warnings.warn("""Use `yandex_storage_bucket_grant` instead.""", DeprecationWarning)
            pulumi.log.warn("""acl is deprecated: Use `yandex_storage_bucket_grant` instead.""")
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if anonymous_access_flags is not None:
            pulumi.set(__self__, "anonymous_access_flags", anonymous_access_flags)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if default_storage_class is not None:
            pulumi.set(__self__, "default_storage_class", default_storage_class)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if grants is not None:
            warnings.warn("""Use `yandex_storage_bucket_grant` instead.""", DeprecationWarning)
            pulumi.log.warn("""grants is deprecated: Use `yandex_storage_bucket_grant` instead.""")
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if object_lock_configuration is not None:
            pulumi.set(__self__, "object_lock_configuration", object_lock_configuration)
        if policy is not None:
            warnings.warn("""Use `yandex_storage_bucket_policy` resource instead.""", DeprecationWarning)
            pulumi.log.warn("""policy is deprecated: Use `yandex_storage_bucket_policy` resource instead.""")
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if server_side_encryption_configuration is not None:
            pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)
        if website_domain is not None:
            pulumi.set(__self__, "website_domain", website_domain)
        if website_endpoint is not None:
            pulumi.set(__self__, "website_endpoint", website_endpoint)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `yandex_storage_bucket_grant` instead.""")
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="anonymousAccessFlags")
    def anonymous_access_flags(self) -> Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']]:
        """
        Provides various access to objects. See [Bucket Availability](https://yandex.cloud/docs/storage/operations/buckets/bucket-availability) for more information.
        """
        return pulumi.get(self, "anonymous_access_flags")

    @anonymous_access_flags.setter
    def anonymous_access_flags(self, value: Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']]):
        pulumi.set(self, "anonymous_access_flags", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_prefix", value)

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]]:
        """
        A rule of [Cross-Origin Resource Sharing](https://yandex.cloud/docs/storage/concepts/cors) (CORS object).
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @_builtins.property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage class which is used for storing objects by default. Available values are: "STANDARD", "COLD", "ICE". Default is `"STANDARD"`. See [Storage Class](https://yandex.cloud/docs/storage/concepts/storage-class) for more information.
        """
        return pulumi.get(self, "default_storage_class")

    @default_storage_class.setter
    def default_storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_storage_class", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allow to create bucket in different folder. In case you are using IAM token from UserAccount, you are needed to explicitly specify folder_id in the resource, as it cannot be identified from such type of account. In case you are using IAM token from ServiceAccount or static access keys, folder_id does not need to be specified unless you want to create the resource in a different folder than the account folder.

        > It will try to create bucket using `IAM-token`, not using `access keys`.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable. Default is `false`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `yandex_storage_bucket_grant` instead.""")
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]]:
        """
        An [ACL policy grant](https://yandex.cloud/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.

        > To manage `grant` argument, service account with `storage.admin` role should be used.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]]):
        pulumi.set(self, "grants", value)

    @_builtins.property
    @pulumi.getter
    def https(self) -> Optional[pulumi.Input['StorageBucketHttpsArgs']]:
        """
        Manages https certificates for bucket. See [https](https://yandex.cloud/docs/storage/operations/hosting/certificate) for more information.
        """
        return pulumi.get(self, "https")

    @https.setter
    def https(self, value: Optional[pulumi.Input['StorageBucketHttpsArgs']]):
        pulumi.set(self, "https", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]]:
        """
        A configuration of [object lifecycle management](https://yandex.cloud/docs/storage/concepts/lifecycles).
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @_builtins.property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]]:
        """
        A settings of [bucket logging](https://yandex.cloud/docs/storage/concepts/server-logs).
        """
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]]):
        pulumi.set(self, "loggings", value)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of bucket, in bytes. See [Size Limiting](https://yandex.cloud/docs/storage/operations/buckets/limit-max-volume) for more information.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size", value)

    @_builtins.property
    @pulumi.getter(name="objectLockConfiguration")
    def object_lock_configuration(self) -> Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']]:
        """
        A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock).
        """
        return pulumi.get(self, "object_lock_configuration")

    @object_lock_configuration.setter
    def object_lock_configuration(self, value: Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']]):
        pulumi.set(self, "object_lock_configuration", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `yandex_storage_bucket_policy` resource instead.""")
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `policy` object should contain the only field with the text of the policy. See [policy documentation](https://yandex.cloud/docs/storage/concepts/policy) for more information on policy format.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']]:
        """
        A configuration of server-side encryption for the bucket.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @server_side_encryption_configuration.setter
    def server_side_encryption_configuration(self, value: Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']]):
        pulumi.set(self, "server_side_encryption_configuration", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['StorageBucketVersioningArgs']]:
        """
        A state of [versioning](https://yandex.cloud/docs/storage/concepts/versioning).

        > To manage `versioning` argument, service account with `storage.admin` role should be used.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['StorageBucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @_builtins.property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['StorageBucketWebsiteArgs']]:
        """
        A [Website Object](https://yandex.cloud/docs/storage/concepts/hosting)
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['StorageBucketWebsiteArgs']]):
        pulumi.set(self, "website", value)

    @_builtins.property
    @pulumi.getter(name="websiteDomain")
    def website_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_domain")

    @website_domain.setter
    def website_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "website_domain", value)

    @_builtins.property
    @pulumi.getter(name="websiteEndpoint")
    def website_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_endpoint")

    @website_endpoint.setter
    def website_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "website_endpoint", value)


@pulumi.input_type
class _StorageBucketState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 anonymous_access_flags: Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]] = None,
                 default_storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]] = None,
                 https: Optional[pulumi.Input['StorageBucketHttpsArgs']] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 object_lock_configuration: Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input['StorageBucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['StorageBucketWebsiteArgs']] = None,
                 website_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 website_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StorageBucket resources.
        :param pulumi.Input[_builtins.str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] acl: The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
        :param pulumi.Input['StorageBucketAnonymousAccessFlagsArgs'] anonymous_access_flags: Provides various access to objects. See [Bucket Availability](https://yandex.cloud/docs/storage/operations/buckets/bucket-availability) for more information.
        :param pulumi.Input[_builtins.str] bucket_domain_name: The bucket domain name.
        :param pulumi.Input[_builtins.str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]] cors_rules: A rule of [Cross-Origin Resource Sharing](https://yandex.cloud/docs/storage/concepts/cors) (CORS object).
        :param pulumi.Input[_builtins.str] default_storage_class: Storage class which is used for storing objects by default. Available values are: "STANDARD", "COLD", "ICE". Default is `"STANDARD"`. See [Storage Class](https://yandex.cloud/docs/storage/concepts/storage-class) for more information.
        :param pulumi.Input[_builtins.str] folder_id: Allow to create bucket in different folder. In case you are using IAM token from UserAccount, you are needed to explicitly specify folder_id in the resource, as it cannot be identified from such type of account. In case you are using IAM token from ServiceAccount or static access keys, folder_id does not need to be specified unless you want to create the resource in a different folder than the account folder.
               
               > It will try to create bucket using `IAM-token`, not using `access keys`.
        :param pulumi.Input[_builtins.bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]] grants: An [ACL policy grant](https://yandex.cloud/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
               
               > To manage `grant` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input['StorageBucketHttpsArgs'] https: Manages https certificates for bucket. See [https](https://yandex.cloud/docs/storage/operations/hosting/certificate) for more information.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]] lifecycle_rules: A configuration of [object lifecycle management](https://yandex.cloud/docs/storage/concepts/lifecycles).
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]] loggings: A settings of [bucket logging](https://yandex.cloud/docs/storage/concepts/server-logs).
        :param pulumi.Input[_builtins.int] max_size: The size of bucket, in bytes. See [Size Limiting](https://yandex.cloud/docs/storage/operations/buckets/limit-max-volume) for more information.
        :param pulumi.Input['StorageBucketObjectLockConfigurationArgs'] object_lock_configuration: A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock).
        :param pulumi.Input[_builtins.str] policy: The `policy` object should contain the only field with the text of the policy. See [policy documentation](https://yandex.cloud/docs/storage/concepts/policy) for more information on policy format.
        :param pulumi.Input[_builtins.str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs'] server_side_encryption_configuration: A configuration of server-side encryption for the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        :param pulumi.Input['StorageBucketVersioningArgs'] versioning: A state of [versioning](https://yandex.cloud/docs/storage/concepts/versioning).
               
               > To manage `versioning` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input['StorageBucketWebsiteArgs'] website: A [Website Object](https://yandex.cloud/docs/storage/concepts/hosting)
        :param pulumi.Input[_builtins.str] website_domain: The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        :param pulumi.Input[_builtins.str] website_endpoint: The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if acl is not None:
            warnings.warn("""Use `yandex_storage_bucket_grant` instead.""", DeprecationWarning)
            pulumi.log.warn("""acl is deprecated: Use `yandex_storage_bucket_grant` instead.""")
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if anonymous_access_flags is not None:
            pulumi.set(__self__, "anonymous_access_flags", anonymous_access_flags)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if bucket_domain_name is not None:
            pulumi.set(__self__, "bucket_domain_name", bucket_domain_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if default_storage_class is not None:
            pulumi.set(__self__, "default_storage_class", default_storage_class)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if grants is not None:
            warnings.warn("""Use `yandex_storage_bucket_grant` instead.""", DeprecationWarning)
            pulumi.log.warn("""grants is deprecated: Use `yandex_storage_bucket_grant` instead.""")
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if object_lock_configuration is not None:
            pulumi.set(__self__, "object_lock_configuration", object_lock_configuration)
        if policy is not None:
            warnings.warn("""Use `yandex_storage_bucket_policy` resource instead.""", DeprecationWarning)
            pulumi.log.warn("""policy is deprecated: Use `yandex_storage_bucket_policy` resource instead.""")
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if server_side_encryption_configuration is not None:
            pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)
        if website_domain is not None:
            pulumi.set(__self__, "website_domain", website_domain)
        if website_endpoint is not None:
            pulumi.set(__self__, "website_endpoint", website_endpoint)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `yandex_storage_bucket_grant` instead.""")
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="anonymousAccessFlags")
    def anonymous_access_flags(self) -> Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']]:
        """
        Provides various access to objects. See [Bucket Availability](https://yandex.cloud/docs/storage/operations/buckets/bucket-availability) for more information.
        """
        return pulumi.get(self, "anonymous_access_flags")

    @anonymous_access_flags.setter
    def anonymous_access_flags(self, value: Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']]):
        pulumi.set(self, "anonymous_access_flags", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="bucketDomainName")
    def bucket_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bucket domain name.
        """
        return pulumi.get(self, "bucket_domain_name")

    @bucket_domain_name.setter
    def bucket_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_prefix", value)

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]]:
        """
        A rule of [Cross-Origin Resource Sharing](https://yandex.cloud/docs/storage/concepts/cors) (CORS object).
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @_builtins.property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage class which is used for storing objects by default. Available values are: "STANDARD", "COLD", "ICE". Default is `"STANDARD"`. See [Storage Class](https://yandex.cloud/docs/storage/concepts/storage-class) for more information.
        """
        return pulumi.get(self, "default_storage_class")

    @default_storage_class.setter
    def default_storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_storage_class", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allow to create bucket in different folder. In case you are using IAM token from UserAccount, you are needed to explicitly specify folder_id in the resource, as it cannot be identified from such type of account. In case you are using IAM token from ServiceAccount or static access keys, folder_id does not need to be specified unless you want to create the resource in a different folder than the account folder.

        > It will try to create bucket using `IAM-token`, not using `access keys`.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable. Default is `false`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `yandex_storage_bucket_grant` instead.""")
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]]:
        """
        An [ACL policy grant](https://yandex.cloud/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.

        > To manage `grant` argument, service account with `storage.admin` role should be used.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]]):
        pulumi.set(self, "grants", value)

    @_builtins.property
    @pulumi.getter
    def https(self) -> Optional[pulumi.Input['StorageBucketHttpsArgs']]:
        """
        Manages https certificates for bucket. See [https](https://yandex.cloud/docs/storage/operations/hosting/certificate) for more information.
        """
        return pulumi.get(self, "https")

    @https.setter
    def https(self, value: Optional[pulumi.Input['StorageBucketHttpsArgs']]):
        pulumi.set(self, "https", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]]:
        """
        A configuration of [object lifecycle management](https://yandex.cloud/docs/storage/concepts/lifecycles).
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @_builtins.property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]]:
        """
        A settings of [bucket logging](https://yandex.cloud/docs/storage/concepts/server-logs).
        """
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]]):
        pulumi.set(self, "loggings", value)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of bucket, in bytes. See [Size Limiting](https://yandex.cloud/docs/storage/operations/buckets/limit-max-volume) for more information.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size", value)

    @_builtins.property
    @pulumi.getter(name="objectLockConfiguration")
    def object_lock_configuration(self) -> Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']]:
        """
        A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock).
        """
        return pulumi.get(self, "object_lock_configuration")

    @object_lock_configuration.setter
    def object_lock_configuration(self, value: Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']]):
        pulumi.set(self, "object_lock_configuration", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `yandex_storage_bucket_policy` resource instead.""")
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `policy` object should contain the only field with the text of the policy. See [policy documentation](https://yandex.cloud/docs/storage/concepts/policy) for more information on policy format.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']]:
        """
        A configuration of server-side encryption for the bucket.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @server_side_encryption_configuration.setter
    def server_side_encryption_configuration(self, value: Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']]):
        pulumi.set(self, "server_side_encryption_configuration", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['StorageBucketVersioningArgs']]:
        """
        A state of [versioning](https://yandex.cloud/docs/storage/concepts/versioning).

        > To manage `versioning` argument, service account with `storage.admin` role should be used.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['StorageBucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @_builtins.property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['StorageBucketWebsiteArgs']]:
        """
        A [Website Object](https://yandex.cloud/docs/storage/concepts/hosting)
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['StorageBucketWebsiteArgs']]):
        pulumi.set(self, "website", value)

    @_builtins.property
    @pulumi.getter(name="websiteDomain")
    def website_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_domain")

    @website_domain.setter
    def website_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "website_domain", value)

    @_builtins.property
    @pulumi.getter(name="websiteEndpoint")
    def website_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_endpoint")

    @website_endpoint.setter
    def website_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "website_endpoint", value)


@pulumi.type_token("yandex:index/storageBucket:StorageBucket")
class StorageBucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 anonymous_access_flags: Optional[pulumi.Input[Union['StorageBucketAnonymousAccessFlagsArgs', 'StorageBucketAnonymousAccessFlagsArgsDict']]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketCorsRuleArgs', 'StorageBucketCorsRuleArgsDict']]]]] = None,
                 default_storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketGrantArgs', 'StorageBucketGrantArgsDict']]]]] = None,
                 https: Optional[pulumi.Input[Union['StorageBucketHttpsArgs', 'StorageBucketHttpsArgsDict']]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLifecycleRuleArgs', 'StorageBucketLifecycleRuleArgsDict']]]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLoggingArgs', 'StorageBucketLoggingArgsDict']]]]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 object_lock_configuration: Optional[pulumi.Input[Union['StorageBucketObjectLockConfigurationArgs', 'StorageBucketObjectLockConfigurationArgsDict']]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input[Union['StorageBucketServerSideEncryptionConfigurationArgs', 'StorageBucketServerSideEncryptionConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input[Union['StorageBucketVersioningArgs', 'StorageBucketVersioningArgsDict']]] = None,
                 website: Optional[pulumi.Input[Union['StorageBucketWebsiteArgs', 'StorageBucketWebsiteArgsDict']]] = None,
                 website_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 website_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        test_bucket = yandex.StorageBucket("test_bucket", bucket="tf-test-bucket")
        ```

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        folder_id = "<folder-id>"
        # Create SA
        sa = yandex.IamServiceAccount("sa",
            folder_id=folder_id,
            name="tf-test-sa")
        # Grant permissions
        sa_editor = yandex.index.ResourcemanagerFolderIamMember("sa-editor",
            folder_id=folder_id,
            role=storage.editor,
            member=fserviceAccount:{sa.id})
        # Create Static Access Keys
        sa_static_key = yandex.IamServiceAccountStaticAccessKey("sa-static-key",
            service_account_id=sa.id,
            description="static access key for object storage")
        # Use keys to create bucket
        test = yandex.StorageBucket("test",
            access_key=sa_static_key.access_key,
            secret_key=sa_static_key.secret_key,
            bucket="tf-test-bucket")
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Static Website Hosting.
        #
        test = yandex.StorageBucket("test",
            bucket="storage-website-test.hashicorp.com",
            acl="public-read",
            website={
                "index_document": "index.html",
                "error_document": "error.html",
                "routing_rules": \"\"\"[{
            "Condition": {
                "KeyPrefixEquals": "docs/"
            },
            "Redirect": {
                "ReplaceKeyPrefixWith": "documents/"
            }
        }]
        \"\"\",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using ACL policy grants.
        #
        test = yandex.StorageBucket("test",
            bucket="mybucket",
            grants=[
                {
                    "id": "myuser",
                    "type": "CanonicalUser",
                    "permissions": ["FULL_CONTROL"],
                },
                {
                    "type": "Group",
                    "permissions": [
                        "READ",
                        "WRITE",
                    ],
                    "uri": "http://acs.amazonaws.com/groups/global/AllUsers",
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using CORS.
        #
        b = yandex.StorageBucket("b",
            bucket="s3-website-test.hashicorp.com",
            acl="public-read",
            cors_rules=[{
                "allowed_headers": ["*"],
                "allowed_methods": [
                    "PUT",
                    "POST",
                ],
                "allowed_origins": ["https://s3-website-test.hashicorp.com"],
                "expose_headers": ["ETag"],
                "max_age_seconds": 3000,
            }])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using versioning.
        #
        b = yandex.StorageBucket("b",
            bucket="my-tf-test-bucket",
            acl="private",
            versioning={
                "enabled": True,
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using Policy Configuration
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            policy=\"\"\"{
          "Version": "2012-10-17",
          "Statement": [
            {
              "Effect": "Allow",
              "Principal": "*",
              "Action": "s3:*",
              "Resource": [
                "arn:aws:s3:::my-policy-bucket/*",
                "arn:aws:s3:::my-policy-bucket"
              ]
            },
            {
              "Effect": "Deny",
              "Principal": "*",
              "Action": "s3:PutObject",
              "Resource": [
                "arn:aws:s3:::my-policy-bucket/*",
                "arn:aws:s3:::my-policy-bucket"
              ]
            }
          ]
        }
        \"\"\")
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using Bucket Tagging
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            tags={
                "test_key": "test_value",
                "other_key": "other_value",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Set Bucket Max Size.
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            max_size=1048576)
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Set Bucket Folder Id.
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            folder_id="<folder_id>")
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using Bucket Anonymous Access Flags.
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            anonymous_access_flags={
                "read": True,
                "list": False,
                "config_read": True,
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Bucket HTTPS Certificate.
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            https={
                "certificate_id": "<certificate_id_from_certificate_manager>",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Set Bucket Default Storage Class.
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            default_storage_class="COLD")
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/storageBucket:StorageBucket <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/storageBucket:StorageBucket test_bucket ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] acl: The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
        :param pulumi.Input[Union['StorageBucketAnonymousAccessFlagsArgs', 'StorageBucketAnonymousAccessFlagsArgsDict']] anonymous_access_flags: Provides various access to objects. See [Bucket Availability](https://yandex.cloud/docs/storage/operations/buckets/bucket-availability) for more information.
        :param pulumi.Input[_builtins.str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketCorsRuleArgs', 'StorageBucketCorsRuleArgsDict']]]] cors_rules: A rule of [Cross-Origin Resource Sharing](https://yandex.cloud/docs/storage/concepts/cors) (CORS object).
        :param pulumi.Input[_builtins.str] default_storage_class: Storage class which is used for storing objects by default. Available values are: "STANDARD", "COLD", "ICE". Default is `"STANDARD"`. See [Storage Class](https://yandex.cloud/docs/storage/concepts/storage-class) for more information.
        :param pulumi.Input[_builtins.str] folder_id: Allow to create bucket in different folder. In case you are using IAM token from UserAccount, you are needed to explicitly specify folder_id in the resource, as it cannot be identified from such type of account. In case you are using IAM token from ServiceAccount or static access keys, folder_id does not need to be specified unless you want to create the resource in a different folder than the account folder.
               
               > It will try to create bucket using `IAM-token`, not using `access keys`.
        :param pulumi.Input[_builtins.bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketGrantArgs', 'StorageBucketGrantArgsDict']]]] grants: An [ACL policy grant](https://yandex.cloud/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
               
               > To manage `grant` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input[Union['StorageBucketHttpsArgs', 'StorageBucketHttpsArgsDict']] https: Manages https certificates for bucket. See [https](https://yandex.cloud/docs/storage/operations/hosting/certificate) for more information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLifecycleRuleArgs', 'StorageBucketLifecycleRuleArgsDict']]]] lifecycle_rules: A configuration of [object lifecycle management](https://yandex.cloud/docs/storage/concepts/lifecycles).
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLoggingArgs', 'StorageBucketLoggingArgsDict']]]] loggings: A settings of [bucket logging](https://yandex.cloud/docs/storage/concepts/server-logs).
        :param pulumi.Input[_builtins.int] max_size: The size of bucket, in bytes. See [Size Limiting](https://yandex.cloud/docs/storage/operations/buckets/limit-max-volume) for more information.
        :param pulumi.Input[Union['StorageBucketObjectLockConfigurationArgs', 'StorageBucketObjectLockConfigurationArgsDict']] object_lock_configuration: A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock).
        :param pulumi.Input[_builtins.str] policy: The `policy` object should contain the only field with the text of the policy. See [policy documentation](https://yandex.cloud/docs/storage/concepts/policy) for more information on policy format.
        :param pulumi.Input[_builtins.str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[Union['StorageBucketServerSideEncryptionConfigurationArgs', 'StorageBucketServerSideEncryptionConfigurationArgsDict']] server_side_encryption_configuration: A configuration of server-side encryption for the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        :param pulumi.Input[Union['StorageBucketVersioningArgs', 'StorageBucketVersioningArgsDict']] versioning: A state of [versioning](https://yandex.cloud/docs/storage/concepts/versioning).
               
               > To manage `versioning` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input[Union['StorageBucketWebsiteArgs', 'StorageBucketWebsiteArgsDict']] website: A [Website Object](https://yandex.cloud/docs/storage/concepts/hosting)
        :param pulumi.Input[_builtins.str] website_domain: The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        :param pulumi.Input[_builtins.str] website_endpoint: The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[StorageBucketArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        test_bucket = yandex.StorageBucket("test_bucket", bucket="tf-test-bucket")
        ```

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        folder_id = "<folder-id>"
        # Create SA
        sa = yandex.IamServiceAccount("sa",
            folder_id=folder_id,
            name="tf-test-sa")
        # Grant permissions
        sa_editor = yandex.index.ResourcemanagerFolderIamMember("sa-editor",
            folder_id=folder_id,
            role=storage.editor,
            member=fserviceAccount:{sa.id})
        # Create Static Access Keys
        sa_static_key = yandex.IamServiceAccountStaticAccessKey("sa-static-key",
            service_account_id=sa.id,
            description="static access key for object storage")
        # Use keys to create bucket
        test = yandex.StorageBucket("test",
            access_key=sa_static_key.access_key,
            secret_key=sa_static_key.secret_key,
            bucket="tf-test-bucket")
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Static Website Hosting.
        #
        test = yandex.StorageBucket("test",
            bucket="storage-website-test.hashicorp.com",
            acl="public-read",
            website={
                "index_document": "index.html",
                "error_document": "error.html",
                "routing_rules": \"\"\"[{
            "Condition": {
                "KeyPrefixEquals": "docs/"
            },
            "Redirect": {
                "ReplaceKeyPrefixWith": "documents/"
            }
        }]
        \"\"\",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using ACL policy grants.
        #
        test = yandex.StorageBucket("test",
            bucket="mybucket",
            grants=[
                {
                    "id": "myuser",
                    "type": "CanonicalUser",
                    "permissions": ["FULL_CONTROL"],
                },
                {
                    "type": "Group",
                    "permissions": [
                        "READ",
                        "WRITE",
                    ],
                    "uri": "http://acs.amazonaws.com/groups/global/AllUsers",
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using CORS.
        #
        b = yandex.StorageBucket("b",
            bucket="s3-website-test.hashicorp.com",
            acl="public-read",
            cors_rules=[{
                "allowed_headers": ["*"],
                "allowed_methods": [
                    "PUT",
                    "POST",
                ],
                "allowed_origins": ["https://s3-website-test.hashicorp.com"],
                "expose_headers": ["ETag"],
                "max_age_seconds": 3000,
            }])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using versioning.
        #
        b = yandex.StorageBucket("b",
            bucket="my-tf-test-bucket",
            acl="private",
            versioning={
                "enabled": True,
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using Policy Configuration
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            policy=\"\"\"{
          "Version": "2012-10-17",
          "Statement": [
            {
              "Effect": "Allow",
              "Principal": "*",
              "Action": "s3:*",
              "Resource": [
                "arn:aws:s3:::my-policy-bucket/*",
                "arn:aws:s3:::my-policy-bucket"
              ]
            },
            {
              "Effect": "Deny",
              "Principal": "*",
              "Action": "s3:PutObject",
              "Resource": [
                "arn:aws:s3:::my-policy-bucket/*",
                "arn:aws:s3:::my-policy-bucket"
              ]
            }
          ]
        }
        \"\"\")
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using Bucket Tagging
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            tags={
                "test_key": "test_value",
                "other_key": "other_value",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Set Bucket Max Size.
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            max_size=1048576)
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Set Bucket Folder Id.
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            folder_id="<folder_id>")
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Using Bucket Anonymous Access Flags.
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            anonymous_access_flags={
                "read": True,
                "list": False,
                "config_read": True,
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Bucket HTTPS Certificate.
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            https={
                "certificate_id": "<certificate_id_from_certificate_manager>",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Set Bucket Default Storage Class.
        #
        b = yandex.StorageBucket("b",
            bucket="my-policy-bucket",
            default_storage_class="COLD")
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/storageBucket:StorageBucket <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/storageBucket:StorageBucket test_bucket ...
        ```

        :param str resource_name: The name of the resource.
        :param StorageBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 anonymous_access_flags: Optional[pulumi.Input[Union['StorageBucketAnonymousAccessFlagsArgs', 'StorageBucketAnonymousAccessFlagsArgsDict']]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketCorsRuleArgs', 'StorageBucketCorsRuleArgsDict']]]]] = None,
                 default_storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketGrantArgs', 'StorageBucketGrantArgsDict']]]]] = None,
                 https: Optional[pulumi.Input[Union['StorageBucketHttpsArgs', 'StorageBucketHttpsArgsDict']]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLifecycleRuleArgs', 'StorageBucketLifecycleRuleArgsDict']]]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLoggingArgs', 'StorageBucketLoggingArgsDict']]]]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 object_lock_configuration: Optional[pulumi.Input[Union['StorageBucketObjectLockConfigurationArgs', 'StorageBucketObjectLockConfigurationArgsDict']]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input[Union['StorageBucketServerSideEncryptionConfigurationArgs', 'StorageBucketServerSideEncryptionConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input[Union['StorageBucketVersioningArgs', 'StorageBucketVersioningArgsDict']]] = None,
                 website: Optional[pulumi.Input[Union['StorageBucketWebsiteArgs', 'StorageBucketWebsiteArgsDict']]] = None,
                 website_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 website_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageBucketArgs.__new__(StorageBucketArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["acl"] = acl
            __props__.__dict__["anonymous_access_flags"] = anonymous_access_flags
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["bucket_prefix"] = bucket_prefix
            __props__.__dict__["cors_rules"] = cors_rules
            __props__.__dict__["default_storage_class"] = default_storage_class
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["grants"] = grants
            __props__.__dict__["https"] = https
            __props__.__dict__["lifecycle_rules"] = lifecycle_rules
            __props__.__dict__["loggings"] = loggings
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["object_lock_configuration"] = object_lock_configuration
            __props__.__dict__["policy"] = policy
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["server_side_encryption_configuration"] = server_side_encryption_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["versioning"] = versioning
            __props__.__dict__["website"] = website
            __props__.__dict__["website_domain"] = website_domain
            __props__.__dict__["website_endpoint"] = website_endpoint
            __props__.__dict__["bucket_domain_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(StorageBucket, __self__).__init__(
            'yandex:index/storageBucket:StorageBucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            anonymous_access_flags: Optional[pulumi.Input[Union['StorageBucketAnonymousAccessFlagsArgs', 'StorageBucketAnonymousAccessFlagsArgsDict']]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketCorsRuleArgs', 'StorageBucketCorsRuleArgsDict']]]]] = None,
            default_storage_class: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketGrantArgs', 'StorageBucketGrantArgsDict']]]]] = None,
            https: Optional[pulumi.Input[Union['StorageBucketHttpsArgs', 'StorageBucketHttpsArgsDict']]] = None,
            lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLifecycleRuleArgs', 'StorageBucketLifecycleRuleArgsDict']]]]] = None,
            loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLoggingArgs', 'StorageBucketLoggingArgsDict']]]]] = None,
            max_size: Optional[pulumi.Input[_builtins.int]] = None,
            object_lock_configuration: Optional[pulumi.Input[Union['StorageBucketObjectLockConfigurationArgs', 'StorageBucketObjectLockConfigurationArgsDict']]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            server_side_encryption_configuration: Optional[pulumi.Input[Union['StorageBucketServerSideEncryptionConfigurationArgs', 'StorageBucketServerSideEncryptionConfigurationArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            versioning: Optional[pulumi.Input[Union['StorageBucketVersioningArgs', 'StorageBucketVersioningArgsDict']]] = None,
            website: Optional[pulumi.Input[Union['StorageBucketWebsiteArgs', 'StorageBucketWebsiteArgsDict']]] = None,
            website_domain: Optional[pulumi.Input[_builtins.str]] = None,
            website_endpoint: Optional[pulumi.Input[_builtins.str]] = None) -> 'StorageBucket':
        """
        Get an existing StorageBucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] acl: The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
        :param pulumi.Input[Union['StorageBucketAnonymousAccessFlagsArgs', 'StorageBucketAnonymousAccessFlagsArgsDict']] anonymous_access_flags: Provides various access to objects. See [Bucket Availability](https://yandex.cloud/docs/storage/operations/buckets/bucket-availability) for more information.
        :param pulumi.Input[_builtins.str] bucket_domain_name: The bucket domain name.
        :param pulumi.Input[_builtins.str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketCorsRuleArgs', 'StorageBucketCorsRuleArgsDict']]]] cors_rules: A rule of [Cross-Origin Resource Sharing](https://yandex.cloud/docs/storage/concepts/cors) (CORS object).
        :param pulumi.Input[_builtins.str] default_storage_class: Storage class which is used for storing objects by default. Available values are: "STANDARD", "COLD", "ICE". Default is `"STANDARD"`. See [Storage Class](https://yandex.cloud/docs/storage/concepts/storage-class) for more information.
        :param pulumi.Input[_builtins.str] folder_id: Allow to create bucket in different folder. In case you are using IAM token from UserAccount, you are needed to explicitly specify folder_id in the resource, as it cannot be identified from such type of account. In case you are using IAM token from ServiceAccount or static access keys, folder_id does not need to be specified unless you want to create the resource in a different folder than the account folder.
               
               > It will try to create bucket using `IAM-token`, not using `access keys`.
        :param pulumi.Input[_builtins.bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketGrantArgs', 'StorageBucketGrantArgsDict']]]] grants: An [ACL policy grant](https://yandex.cloud/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
               
               > To manage `grant` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input[Union['StorageBucketHttpsArgs', 'StorageBucketHttpsArgsDict']] https: Manages https certificates for bucket. See [https](https://yandex.cloud/docs/storage/operations/hosting/certificate) for more information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLifecycleRuleArgs', 'StorageBucketLifecycleRuleArgsDict']]]] lifecycle_rules: A configuration of [object lifecycle management](https://yandex.cloud/docs/storage/concepts/lifecycles).
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLoggingArgs', 'StorageBucketLoggingArgsDict']]]] loggings: A settings of [bucket logging](https://yandex.cloud/docs/storage/concepts/server-logs).
        :param pulumi.Input[_builtins.int] max_size: The size of bucket, in bytes. See [Size Limiting](https://yandex.cloud/docs/storage/operations/buckets/limit-max-volume) for more information.
        :param pulumi.Input[Union['StorageBucketObjectLockConfigurationArgs', 'StorageBucketObjectLockConfigurationArgsDict']] object_lock_configuration: A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock).
        :param pulumi.Input[_builtins.str] policy: The `policy` object should contain the only field with the text of the policy. See [policy documentation](https://yandex.cloud/docs/storage/concepts/policy) for more information on policy format.
        :param pulumi.Input[_builtins.str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[Union['StorageBucketServerSideEncryptionConfigurationArgs', 'StorageBucketServerSideEncryptionConfigurationArgsDict']] server_side_encryption_configuration: A configuration of server-side encryption for the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        :param pulumi.Input[Union['StorageBucketVersioningArgs', 'StorageBucketVersioningArgsDict']] versioning: A state of [versioning](https://yandex.cloud/docs/storage/concepts/versioning).
               
               > To manage `versioning` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input[Union['StorageBucketWebsiteArgs', 'StorageBucketWebsiteArgsDict']] website: A [Website Object](https://yandex.cloud/docs/storage/concepts/hosting)
        :param pulumi.Input[_builtins.str] website_domain: The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        :param pulumi.Input[_builtins.str] website_endpoint: The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StorageBucketState.__new__(_StorageBucketState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["acl"] = acl
        __props__.__dict__["anonymous_access_flags"] = anonymous_access_flags
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["bucket_domain_name"] = bucket_domain_name
        __props__.__dict__["bucket_prefix"] = bucket_prefix
        __props__.__dict__["cors_rules"] = cors_rules
        __props__.__dict__["default_storage_class"] = default_storage_class
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["grants"] = grants
        __props__.__dict__["https"] = https
        __props__.__dict__["lifecycle_rules"] = lifecycle_rules
        __props__.__dict__["loggings"] = loggings
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["object_lock_configuration"] = object_lock_configuration
        __props__.__dict__["policy"] = policy
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["server_side_encryption_configuration"] = server_side_encryption_configuration
        __props__.__dict__["tags"] = tags
        __props__.__dict__["versioning"] = versioning
        __props__.__dict__["website"] = website
        __props__.__dict__["website_domain"] = website_domain
        __props__.__dict__["website_endpoint"] = website_endpoint
        return StorageBucket(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `yandex_storage_bucket_grant` instead.""")
    def acl(self) -> pulumi.Output[_builtins.str]:
        """
        The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter(name="anonymousAccessFlags")
    def anonymous_access_flags(self) -> pulumi.Output['outputs.StorageBucketAnonymousAccessFlags']:
        """
        Provides various access to objects. See [Bucket Availability](https://yandex.cloud/docs/storage/operations/buckets/bucket-availability) for more information.
        """
        return pulumi.get(self, "anonymous_access_flags")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="bucketDomainName")
    def bucket_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The bucket domain name.
        """
        return pulumi.get(self, "bucket_domain_name")

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        """
        return pulumi.get(self, "bucket_prefix")

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> pulumi.Output[Optional[Sequence['outputs.StorageBucketCorsRule']]]:
        """
        A rule of [Cross-Origin Resource Sharing](https://yandex.cloud/docs/storage/concepts/cors) (CORS object).
        """
        return pulumi.get(self, "cors_rules")

    @_builtins.property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> pulumi.Output[_builtins.str]:
        """
        Storage class which is used for storing objects by default. Available values are: "STANDARD", "COLD", "ICE". Default is `"STANDARD"`. See [Storage Class](https://yandex.cloud/docs/storage/concepts/storage-class) for more information.
        """
        return pulumi.get(self, "default_storage_class")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        Allow to create bucket in different folder. In case you are using IAM token from UserAccount, you are needed to explicitly specify folder_id in the resource, as it cannot be identified from such type of account. In case you are using IAM token from ServiceAccount or static access keys, folder_id does not need to be specified unless you want to create the resource in a different folder than the account folder.

        > It will try to create bucket using `IAM-token`, not using `access keys`.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable. Default is `false`.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `yandex_storage_bucket_grant` instead.""")
    def grants(self) -> pulumi.Output[Sequence['outputs.StorageBucketGrant']]:
        """
        An [ACL policy grant](https://yandex.cloud/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.

        > To manage `grant` argument, service account with `storage.admin` role should be used.
        """
        return pulumi.get(self, "grants")

    @_builtins.property
    @pulumi.getter
    def https(self) -> pulumi.Output[Optional['outputs.StorageBucketHttps']]:
        """
        Manages https certificates for bucket. See [https](https://yandex.cloud/docs/storage/operations/hosting/certificate) for more information.
        """
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> pulumi.Output[Optional[Sequence['outputs.StorageBucketLifecycleRule']]]:
        """
        A configuration of [object lifecycle management](https://yandex.cloud/docs/storage/concepts/lifecycles).
        """
        return pulumi.get(self, "lifecycle_rules")

    @_builtins.property
    @pulumi.getter
    def loggings(self) -> pulumi.Output[Optional[Sequence['outputs.StorageBucketLogging']]]:
        """
        A settings of [bucket logging](https://yandex.cloud/docs/storage/concepts/server-logs).
        """
        return pulumi.get(self, "loggings")

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The size of bucket, in bytes. See [Size Limiting](https://yandex.cloud/docs/storage/operations/buckets/limit-max-volume) for more information.
        """
        return pulumi.get(self, "max_size")

    @_builtins.property
    @pulumi.getter(name="objectLockConfiguration")
    def object_lock_configuration(self) -> pulumi.Output[Optional['outputs.StorageBucketObjectLockConfiguration']]:
        """
        A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock).
        """
        return pulumi.get(self, "object_lock_configuration")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `yandex_storage_bucket_policy` resource instead.""")
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        The `policy` object should contain the only field with the text of the policy. See [policy documentation](https://yandex.cloud/docs/storage/concepts/policy) for more information on policy format.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> pulumi.Output[Optional['outputs.StorageBucketServerSideEncryptionConfiguration']]:
        """
        A configuration of server-side encryption for the bucket.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> pulumi.Output['outputs.StorageBucketVersioning']:
        """
        A state of [versioning](https://yandex.cloud/docs/storage/concepts/versioning).

        > To manage `versioning` argument, service account with `storage.admin` role should be used.
        """
        return pulumi.get(self, "versioning")

    @_builtins.property
    @pulumi.getter
    def website(self) -> pulumi.Output[Optional['outputs.StorageBucketWebsite']]:
        """
        A [Website Object](https://yandex.cloud/docs/storage/concepts/hosting)
        """
        return pulumi.get(self, "website")

    @_builtins.property
    @pulumi.getter(name="websiteDomain")
    def website_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_domain")

    @_builtins.property
    @pulumi.getter(name="websiteEndpoint")
    def website_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_endpoint")

