# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwsSecurityProfileArgs', 'SwsSecurityProfile']

@pulumi.input_type
class SwsSecurityProfileArgs:
    def __init__(__self__, *,
                 advanced_rate_limiter_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 analyze_request_body: Optional[pulumi.Input['SwsSecurityProfileAnalyzeRequestBodyArgs']] = None,
                 captcha_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]] = None):
        """
        The set of arguments for constructing a SwsSecurityProfile resource.
        :param pulumi.Input[_builtins.str] advanced_rate_limiter_profile_id: Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        :param pulumi.Input['SwsSecurityProfileAnalyzeRequestBodyArgs'] analyze_request_body: Analyze request body.
        :param pulumi.Input[_builtins.str] captcha_id: Captcha ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] default_action: Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]] security_rules: List of security rules.
        """
        if advanced_rate_limiter_profile_id is not None:
            pulumi.set(__self__, "advanced_rate_limiter_profile_id", advanced_rate_limiter_profile_id)
        if analyze_request_body is not None:
            pulumi.set(__self__, "analyze_request_body", analyze_request_body)
        if captcha_id is not None:
            pulumi.set(__self__, "captcha_id", captcha_id)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)

    @_builtins.property
    @pulumi.getter(name="advancedRateLimiterProfileId")
    def advanced_rate_limiter_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "advanced_rate_limiter_profile_id")

    @advanced_rate_limiter_profile_id.setter
    def advanced_rate_limiter_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "advanced_rate_limiter_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="analyzeRequestBody")
    def analyze_request_body(self) -> Optional[pulumi.Input['SwsSecurityProfileAnalyzeRequestBodyArgs']]:
        """
        Analyze request body.
        """
        return pulumi.get(self, "analyze_request_body")

    @analyze_request_body.setter
    def analyze_request_body(self, value: Optional[pulumi.Input['SwsSecurityProfileAnalyzeRequestBodyArgs']]):
        pulumi.set(self, "analyze_request_body", value)

    @_builtins.property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Captcha ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "captcha_id")

    @captcha_id.setter
    def captcha_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "captcha_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]]:
        """
        List of security rules.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)


@pulumi.input_type
class _SwsSecurityProfileState:
    def __init__(__self__, *,
                 advanced_rate_limiter_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 analyze_request_body: Optional[pulumi.Input['SwsSecurityProfileAnalyzeRequestBodyArgs']] = None,
                 captcha_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering SwsSecurityProfile resources.
        :param pulumi.Input[_builtins.str] advanced_rate_limiter_profile_id: Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        :param pulumi.Input['SwsSecurityProfileAnalyzeRequestBodyArgs'] analyze_request_body: Analyze request body.
        :param pulumi.Input[_builtins.str] captcha_id: Captcha ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] default_action: Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]] security_rules: List of security rules.
        """
        if advanced_rate_limiter_profile_id is not None:
            pulumi.set(__self__, "advanced_rate_limiter_profile_id", advanced_rate_limiter_profile_id)
        if analyze_request_body is not None:
            pulumi.set(__self__, "analyze_request_body", analyze_request_body)
        if captcha_id is not None:
            pulumi.set(__self__, "captcha_id", captcha_id)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)

    @_builtins.property
    @pulumi.getter(name="advancedRateLimiterProfileId")
    def advanced_rate_limiter_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "advanced_rate_limiter_profile_id")

    @advanced_rate_limiter_profile_id.setter
    def advanced_rate_limiter_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "advanced_rate_limiter_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="analyzeRequestBody")
    def analyze_request_body(self) -> Optional[pulumi.Input['SwsSecurityProfileAnalyzeRequestBodyArgs']]:
        """
        Analyze request body.
        """
        return pulumi.get(self, "analyze_request_body")

    @analyze_request_body.setter
    def analyze_request_body(self, value: Optional[pulumi.Input['SwsSecurityProfileAnalyzeRequestBodyArgs']]):
        pulumi.set(self, "analyze_request_body", value)

    @_builtins.property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Captcha ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "captcha_id")

    @captcha_id.setter
    def captcha_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "captcha_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]]:
        """
        List of security rules.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)


@pulumi.type_token("yandex:index/swsSecurityProfile:SwsSecurityProfile")
class SwsSecurityProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_rate_limiter_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 analyze_request_body: Optional[pulumi.Input[Union['SwsSecurityProfileAnalyzeRequestBodyArgs', 'SwsSecurityProfileAnalyzeRequestBodyArgsDict']]] = None,
                 captcha_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsSecurityProfileSecurityRuleArgs', 'SwsSecurityProfileSecurityRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        With security profiles you can protect your infrastructure from DDoS attacks at the application level (L7).

        Creates a Security Profile in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/concepts/profiles).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new SWS Security Profile (Simple).
        #
        demo_profile_simple = yandex.SwsSecurityProfile("demo-profile-simple",
            name="demo-profile-simple",
            default_action="ALLOW",
            security_rules=[{
                "name": "smart-protection",
                "priority": 99999,
                "smart_protection": {
                    "mode": "API",
                },
            }])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new SWS Security Profile (Advanced).
        #
        demo_profile_advanced = yandex.SwsSecurityProfile("demo-profile-advanced",
            name="demo-profile-advanced",
            default_action="ALLOW",
            captcha_id="<captcha_id>",
            advanced_rate_limiter_profile_id="<arl_id>",
            security_rules=[
                {
                    "name": "smart-protection",
                    "priority": 99999,
                    "smart_protection": {
                        "mode": "API",
                    },
                },
                {
                    "name": "waf",
                    "priority": 88888,
                    "waf": {
                        "mode": "API",
                        "waf_profile_id": "<waf_id>",
                    },
                },
                {
                    "name": "rule-condition-1",
                    "priority": 1,
                    "rule_condition": {
                        "action": "ALLOW",
                        "condition": {
                            "authority": {
                                "authorities": [
                                    {
                                        "exact_match": "example.com",
                                    },
                                    {
                                        "exact_match": "example.net",
                                    },
                                ],
                            },
                        },
                    },
                },
                {
                    "name": "rule-condition-2",
                    "priority": 2,
                    "rule_condition": {
                        "action": "DENY",
                        "condition": {
                            "http_method": {
                                "http_methods": [
                                    {
                                        "exact_match": "DELETE",
                                    },
                                    {
                                        "exact_match": "PUT",
                                    },
                                ],
                            },
                        },
                    },
                },
                {
                    "name": "rule-condition-3",
                    "priority": 3,
                    "rule_condition": {
                        "action": "DENY",
                        "condition": {
                            "request_uri": {
                                "path": {
                                    "prefix_match": "/form",
                                },
                                "queries": [
                                    {
                                        "key": "firstname",
                                        "value": {
                                            "pire_regex_match": ".*ivan.*",
                                        },
                                    },
                                    {
                                        "key": "lastname",
                                        "value": {
                                            "pire_regex_match": ".*petr.*",
                                        },
                                    },
                                ],
                            },
                            "headers": [
                                {
                                    "name": "User-Agent",
                                    "value": {
                                        "pire_regex_match": ".*curl.*",
                                    },
                                },
                                {
                                    "name": "Referer",
                                    "value": {
                                        "pire_regex_not_match": ".*bot.*",
                                    },
                                },
                            ],
                            "source_ip": {
                                "ip_ranges_match": {
                                    "ip_ranges": [
                                        "1.2.33.44",
                                        "2.3.4.56",
                                    ],
                                },
                                "ip_ranges_not_match": {
                                    "ip_ranges": [
                                        "8.8.0.0/16",
                                        "10::1234:1abc:1/64",
                                    ],
                                },
                                "geo_ip_match": {
                                    "locations": [
                                        "ru",
                                        "es",
                                    ],
                                },
                                "geo_ip_not_match": {
                                    "locations": [
                                        "us",
                                        "fm",
                                        "gb",
                                    ],
                                },
                            },
                        },
                    },
                },
            ])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/swsSecurityProfile:SwsSecurityProfile <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/swsSecurityProfile:SwsSecurityProfile demo-profile-simple ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] advanced_rate_limiter_profile_id: Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[Union['SwsSecurityProfileAnalyzeRequestBodyArgs', 'SwsSecurityProfileAnalyzeRequestBodyArgsDict']] analyze_request_body: Analyze request body.
        :param pulumi.Input[_builtins.str] captcha_id: Captcha ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] default_action: Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsSecurityProfileSecurityRuleArgs', 'SwsSecurityProfileSecurityRuleArgsDict']]]] security_rules: List of security rules.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SwsSecurityProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With security profiles you can protect your infrastructure from DDoS attacks at the application level (L7).

        Creates a Security Profile in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/concepts/profiles).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new SWS Security Profile (Simple).
        #
        demo_profile_simple = yandex.SwsSecurityProfile("demo-profile-simple",
            name="demo-profile-simple",
            default_action="ALLOW",
            security_rules=[{
                "name": "smart-protection",
                "priority": 99999,
                "smart_protection": {
                    "mode": "API",
                },
            }])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new SWS Security Profile (Advanced).
        #
        demo_profile_advanced = yandex.SwsSecurityProfile("demo-profile-advanced",
            name="demo-profile-advanced",
            default_action="ALLOW",
            captcha_id="<captcha_id>",
            advanced_rate_limiter_profile_id="<arl_id>",
            security_rules=[
                {
                    "name": "smart-protection",
                    "priority": 99999,
                    "smart_protection": {
                        "mode": "API",
                    },
                },
                {
                    "name": "waf",
                    "priority": 88888,
                    "waf": {
                        "mode": "API",
                        "waf_profile_id": "<waf_id>",
                    },
                },
                {
                    "name": "rule-condition-1",
                    "priority": 1,
                    "rule_condition": {
                        "action": "ALLOW",
                        "condition": {
                            "authority": {
                                "authorities": [
                                    {
                                        "exact_match": "example.com",
                                    },
                                    {
                                        "exact_match": "example.net",
                                    },
                                ],
                            },
                        },
                    },
                },
                {
                    "name": "rule-condition-2",
                    "priority": 2,
                    "rule_condition": {
                        "action": "DENY",
                        "condition": {
                            "http_method": {
                                "http_methods": [
                                    {
                                        "exact_match": "DELETE",
                                    },
                                    {
                                        "exact_match": "PUT",
                                    },
                                ],
                            },
                        },
                    },
                },
                {
                    "name": "rule-condition-3",
                    "priority": 3,
                    "rule_condition": {
                        "action": "DENY",
                        "condition": {
                            "request_uri": {
                                "path": {
                                    "prefix_match": "/form",
                                },
                                "queries": [
                                    {
                                        "key": "firstname",
                                        "value": {
                                            "pire_regex_match": ".*ivan.*",
                                        },
                                    },
                                    {
                                        "key": "lastname",
                                        "value": {
                                            "pire_regex_match": ".*petr.*",
                                        },
                                    },
                                ],
                            },
                            "headers": [
                                {
                                    "name": "User-Agent",
                                    "value": {
                                        "pire_regex_match": ".*curl.*",
                                    },
                                },
                                {
                                    "name": "Referer",
                                    "value": {
                                        "pire_regex_not_match": ".*bot.*",
                                    },
                                },
                            ],
                            "source_ip": {
                                "ip_ranges_match": {
                                    "ip_ranges": [
                                        "1.2.33.44",
                                        "2.3.4.56",
                                    ],
                                },
                                "ip_ranges_not_match": {
                                    "ip_ranges": [
                                        "8.8.0.0/16",
                                        "10::1234:1abc:1/64",
                                    ],
                                },
                                "geo_ip_match": {
                                    "locations": [
                                        "ru",
                                        "es",
                                    ],
                                },
                                "geo_ip_not_match": {
                                    "locations": [
                                        "us",
                                        "fm",
                                        "gb",
                                    ],
                                },
                            },
                        },
                    },
                },
            ])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/swsSecurityProfile:SwsSecurityProfile <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/swsSecurityProfile:SwsSecurityProfile demo-profile-simple ...
        ```

        :param str resource_name: The name of the resource.
        :param SwsSecurityProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwsSecurityProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_rate_limiter_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 analyze_request_body: Optional[pulumi.Input[Union['SwsSecurityProfileAnalyzeRequestBodyArgs', 'SwsSecurityProfileAnalyzeRequestBodyArgsDict']]] = None,
                 captcha_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsSecurityProfileSecurityRuleArgs', 'SwsSecurityProfileSecurityRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwsSecurityProfileArgs.__new__(SwsSecurityProfileArgs)

            __props__.__dict__["advanced_rate_limiter_profile_id"] = advanced_rate_limiter_profile_id
            __props__.__dict__["analyze_request_body"] = analyze_request_body
            __props__.__dict__["captcha_id"] = captcha_id
            __props__.__dict__["cloud_id"] = cloud_id
            __props__.__dict__["default_action"] = default_action
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["security_rules"] = security_rules
            __props__.__dict__["created_at"] = None
        super(SwsSecurityProfile, __self__).__init__(
            'yandex:index/swsSecurityProfile:SwsSecurityProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_rate_limiter_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            analyze_request_body: Optional[pulumi.Input[Union['SwsSecurityProfileAnalyzeRequestBodyArgs', 'SwsSecurityProfileAnalyzeRequestBodyArgsDict']]] = None,
            captcha_id: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            default_action: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsSecurityProfileSecurityRuleArgs', 'SwsSecurityProfileSecurityRuleArgsDict']]]]] = None) -> 'SwsSecurityProfile':
        """
        Get an existing SwsSecurityProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] advanced_rate_limiter_profile_id: Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[Union['SwsSecurityProfileAnalyzeRequestBodyArgs', 'SwsSecurityProfileAnalyzeRequestBodyArgsDict']] analyze_request_body: Analyze request body.
        :param pulumi.Input[_builtins.str] captcha_id: Captcha ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] default_action: Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsSecurityProfileSecurityRuleArgs', 'SwsSecurityProfileSecurityRuleArgsDict']]]] security_rules: List of security rules.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwsSecurityProfileState.__new__(_SwsSecurityProfileState)

        __props__.__dict__["advanced_rate_limiter_profile_id"] = advanced_rate_limiter_profile_id
        __props__.__dict__["analyze_request_body"] = analyze_request_body
        __props__.__dict__["captcha_id"] = captcha_id
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["default_action"] = default_action
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["security_rules"] = security_rules
        return SwsSecurityProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedRateLimiterProfileId")
    def advanced_rate_limiter_profile_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "advanced_rate_limiter_profile_id")

    @_builtins.property
    @pulumi.getter(name="analyzeRequestBody")
    def analyze_request_body(self) -> pulumi.Output[Optional['outputs.SwsSecurityProfileAnalyzeRequestBody']]:
        """
        Analyze request body.
        """
        return pulumi.get(self, "analyze_request_body")

    @_builtins.property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Captcha ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "captcha_id")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SwsSecurityProfileSecurityRule']]]:
        """
        List of security rules.
        """
        return pulumi.get(self, "security_rules")

