# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwsWafProfileArgs', 'SwsWafProfile']

@pulumi.input_type
class SwsWafProfileArgs:
    def __init__(__self__, *,
                 analyze_request_body: Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 core_rule_set: Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusion_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 match_all_rule_sets: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleSetArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]] = None):
        """
        The set of arguments for constructing a SwsWafProfile resource.
        :param pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs'] analyze_request_body: Parameters for request body analyzer.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input['SwsWafProfileCoreRuleSetArgs'] core_rule_set: Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]] exclusion_rules: List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules).
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleSetArgs']]] rule_sets: Rule set.
        :param pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]] rules: Settings for each rule in rule set.
        """
        if analyze_request_body is not None:
            pulumi.set(__self__, "analyze_request_body", analyze_request_body)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if core_rule_set is not None:
            pulumi.set(__self__, "core_rule_set", core_rule_set)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclusion_rules is not None:
            pulumi.set(__self__, "exclusion_rules", exclusion_rules)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if match_all_rule_sets is not None:
            pulumi.set(__self__, "match_all_rule_sets", match_all_rule_sets)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_sets is not None:
            pulumi.set(__self__, "rule_sets", rule_sets)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="analyzeRequestBody")
    def analyze_request_body(self) -> Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']]:
        """
        Parameters for request body analyzer.
        """
        return pulumi.get(self, "analyze_request_body")

    @analyze_request_body.setter
    def analyze_request_body(self, value: Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']]):
        pulumi.set(self, "analyze_request_body", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter(name="coreRuleSet")
    def core_rule_set(self) -> Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']]:
        """
        Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details.
        """
        return pulumi.get(self, "core_rule_set")

    @core_rule_set.setter
    def core_rule_set(self, value: Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']]):
        pulumi.set(self, "core_rule_set", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="exclusionRules")
    def exclusion_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]]:
        """
        List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules).
        """
        return pulumi.get(self, "exclusion_rules")

    @exclusion_rules.setter
    def exclusion_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]]):
        pulumi.set(self, "exclusion_rules", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="matchAllRuleSets")
    def match_all_rule_sets(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "match_all_rule_sets")

    @match_all_rule_sets.setter
    def match_all_rule_sets(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "match_all_rule_sets", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ruleSets")
    def rule_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleSetArgs']]]]:
        """
        Rule set.
        """
        return pulumi.get(self, "rule_sets")

    @rule_sets.setter
    def rule_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleSetArgs']]]]):
        pulumi.set(self, "rule_sets", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]]:
        """
        Settings for each rule in rule set.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _SwsWafProfileState:
    def __init__(__self__, *,
                 analyze_request_body: Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 core_rule_set: Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusion_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 match_all_rule_sets: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleSetArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering SwsWafProfile resources.
        :param pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs'] analyze_request_body: Parameters for request body analyzer.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input['SwsWafProfileCoreRuleSetArgs'] core_rule_set: Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]] exclusion_rules: List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules).
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleSetArgs']]] rule_sets: Rule set.
        :param pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]] rules: Settings for each rule in rule set.
        """
        if analyze_request_body is not None:
            pulumi.set(__self__, "analyze_request_body", analyze_request_body)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if core_rule_set is not None:
            pulumi.set(__self__, "core_rule_set", core_rule_set)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclusion_rules is not None:
            pulumi.set(__self__, "exclusion_rules", exclusion_rules)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if match_all_rule_sets is not None:
            pulumi.set(__self__, "match_all_rule_sets", match_all_rule_sets)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_sets is not None:
            pulumi.set(__self__, "rule_sets", rule_sets)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="analyzeRequestBody")
    def analyze_request_body(self) -> Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']]:
        """
        Parameters for request body analyzer.
        """
        return pulumi.get(self, "analyze_request_body")

    @analyze_request_body.setter
    def analyze_request_body(self, value: Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']]):
        pulumi.set(self, "analyze_request_body", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter(name="coreRuleSet")
    def core_rule_set(self) -> Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']]:
        """
        Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details.
        """
        return pulumi.get(self, "core_rule_set")

    @core_rule_set.setter
    def core_rule_set(self, value: Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']]):
        pulumi.set(self, "core_rule_set", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="exclusionRules")
    def exclusion_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]]:
        """
        List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules).
        """
        return pulumi.get(self, "exclusion_rules")

    @exclusion_rules.setter
    def exclusion_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]]):
        pulumi.set(self, "exclusion_rules", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="matchAllRuleSets")
    def match_all_rule_sets(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "match_all_rule_sets")

    @match_all_rule_sets.setter
    def match_all_rule_sets(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "match_all_rule_sets", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ruleSets")
    def rule_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleSetArgs']]]]:
        """
        Rule set.
        """
        return pulumi.get(self, "rule_sets")

    @rule_sets.setter
    def rule_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleSetArgs']]]]):
        pulumi.set(self, "rule_sets", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]]:
        """
        Settings for each rule in rule set.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.type_token("yandex:index/swsWafProfile:SwsWafProfile")
class SwsWafProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analyze_request_body: Optional[pulumi.Input[Union['SwsWafProfileAnalyzeRequestBodyArgs', 'SwsWafProfileAnalyzeRequestBodyArgsDict']]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 core_rule_set: Optional[pulumi.Input[Union['SwsWafProfileCoreRuleSetArgs', 'SwsWafProfileCoreRuleSetArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusion_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileExclusionRuleArgs', 'SwsWafProfileExclusionRuleArgsDict']]]]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 match_all_rule_sets: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleSetArgs', 'SwsWafProfileRuleSetArgsDict']]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleArgs', 'SwsWafProfileRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        Creates a WAF Profile in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#waf).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new SWS WAF Profile (Empty).
        #
        empty = yandex.SwsWafProfile("empty",
            name="waf-profile-dummy",
            core_rule_set={
                "inbound_anomaly_score": 2,
                "paranoia_level": 1,
                "rule_set": {
                    "name": "OWASP Core Ruleset",
                    "version": "4.0.0",
                },
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        waf_paranoia_level = 1
        owasp4 = yandex.get_sws_waf_rule_set_descriptor(name="OWASP Core Ruleset",
            version="4.0.0")
        default = yandex.SwsWafProfile("default",
            rules=[{"key": k, "value": v} for k, v in [rule for rule in owasp4.rules if rule.paranoia_level >= waf_paranoia_level]].apply(lambda entries: [{
                "ruleId": entry["value"].id,
                "isEnabled": True,
                "isBlocking": False,
            } for entry in entries]),
            name="waf-profile-default",
            core_rule_set={
                "inbound_anomaly_score": 2,
                "paranoia_level": waf_paranoia_level,
                "rule_set": {
                    "name": "OWASP Core Ruleset",
                    "version": "4.0.0",
                },
            },
            analyze_request_body={
                "is_enabled": True,
                "size_limit": 8,
                "size_limit_action": "IGNORE",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/swsWafProfile:SwsWafProfile <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/swsWafProfile:SwsWafProfile default ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SwsWafProfileAnalyzeRequestBodyArgs', 'SwsWafProfileAnalyzeRequestBodyArgsDict']] analyze_request_body: Parameters for request body analyzer.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[Union['SwsWafProfileCoreRuleSetArgs', 'SwsWafProfileCoreRuleSetArgsDict']] core_rule_set: Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileExclusionRuleArgs', 'SwsWafProfileExclusionRuleArgsDict']]]] exclusion_rules: List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules).
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleSetArgs', 'SwsWafProfileRuleSetArgsDict']]]] rule_sets: Rule set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleArgs', 'SwsWafProfileRuleArgsDict']]]] rules: Settings for each rule in rule set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SwsWafProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a WAF Profile in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#waf).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new SWS WAF Profile (Empty).
        #
        empty = yandex.SwsWafProfile("empty",
            name="waf-profile-dummy",
            core_rule_set={
                "inbound_anomaly_score": 2,
                "paranoia_level": 1,
                "rule_set": {
                    "name": "OWASP Core Ruleset",
                    "version": "4.0.0",
                },
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        waf_paranoia_level = 1
        owasp4 = yandex.get_sws_waf_rule_set_descriptor(name="OWASP Core Ruleset",
            version="4.0.0")
        default = yandex.SwsWafProfile("default",
            rules=[{"key": k, "value": v} for k, v in [rule for rule in owasp4.rules if rule.paranoia_level >= waf_paranoia_level]].apply(lambda entries: [{
                "ruleId": entry["value"].id,
                "isEnabled": True,
                "isBlocking": False,
            } for entry in entries]),
            name="waf-profile-default",
            core_rule_set={
                "inbound_anomaly_score": 2,
                "paranoia_level": waf_paranoia_level,
                "rule_set": {
                    "name": "OWASP Core Ruleset",
                    "version": "4.0.0",
                },
            },
            analyze_request_body={
                "is_enabled": True,
                "size_limit": 8,
                "size_limit_action": "IGNORE",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/swsWafProfile:SwsWafProfile <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/swsWafProfile:SwsWafProfile default ...
        ```

        :param str resource_name: The name of the resource.
        :param SwsWafProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwsWafProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analyze_request_body: Optional[pulumi.Input[Union['SwsWafProfileAnalyzeRequestBodyArgs', 'SwsWafProfileAnalyzeRequestBodyArgsDict']]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 core_rule_set: Optional[pulumi.Input[Union['SwsWafProfileCoreRuleSetArgs', 'SwsWafProfileCoreRuleSetArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusion_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileExclusionRuleArgs', 'SwsWafProfileExclusionRuleArgsDict']]]]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 match_all_rule_sets: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleSetArgs', 'SwsWafProfileRuleSetArgsDict']]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleArgs', 'SwsWafProfileRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwsWafProfileArgs.__new__(SwsWafProfileArgs)

            __props__.__dict__["analyze_request_body"] = analyze_request_body
            __props__.__dict__["cloud_id"] = cloud_id
            __props__.__dict__["core_rule_set"] = core_rule_set
            __props__.__dict__["description"] = description
            __props__.__dict__["exclusion_rules"] = exclusion_rules
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["match_all_rule_sets"] = match_all_rule_sets
            __props__.__dict__["name"] = name
            __props__.__dict__["rule_sets"] = rule_sets
            __props__.__dict__["rules"] = rules
            __props__.__dict__["created_at"] = None
        super(SwsWafProfile, __self__).__init__(
            'yandex:index/swsWafProfile:SwsWafProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analyze_request_body: Optional[pulumi.Input[Union['SwsWafProfileAnalyzeRequestBodyArgs', 'SwsWafProfileAnalyzeRequestBodyArgsDict']]] = None,
            cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
            core_rule_set: Optional[pulumi.Input[Union['SwsWafProfileCoreRuleSetArgs', 'SwsWafProfileCoreRuleSetArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            exclusion_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileExclusionRuleArgs', 'SwsWafProfileExclusionRuleArgsDict']]]]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            match_all_rule_sets: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleSetArgs', 'SwsWafProfileRuleSetArgsDict']]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleArgs', 'SwsWafProfileRuleArgsDict']]]]] = None) -> 'SwsWafProfile':
        """
        Get an existing SwsWafProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SwsWafProfileAnalyzeRequestBodyArgs', 'SwsWafProfileAnalyzeRequestBodyArgsDict']] analyze_request_body: Parameters for request body analyzer.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[Union['SwsWafProfileCoreRuleSetArgs', 'SwsWafProfileCoreRuleSetArgsDict']] core_rule_set: Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileExclusionRuleArgs', 'SwsWafProfileExclusionRuleArgsDict']]]] exclusion_rules: List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules).
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleSetArgs', 'SwsWafProfileRuleSetArgsDict']]]] rule_sets: Rule set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleArgs', 'SwsWafProfileRuleArgsDict']]]] rules: Settings for each rule in rule set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwsWafProfileState.__new__(_SwsWafProfileState)

        __props__.__dict__["analyze_request_body"] = analyze_request_body
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["core_rule_set"] = core_rule_set
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["exclusion_rules"] = exclusion_rules
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["match_all_rule_sets"] = match_all_rule_sets
        __props__.__dict__["name"] = name
        __props__.__dict__["rule_sets"] = rule_sets
        __props__.__dict__["rules"] = rules
        return SwsWafProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="analyzeRequestBody")
    def analyze_request_body(self) -> pulumi.Output[Optional['outputs.SwsWafProfileAnalyzeRequestBody']]:
        """
        Parameters for request body analyzer.
        """
        return pulumi.get(self, "analyze_request_body")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter(name="coreRuleSet")
    def core_rule_set(self) -> pulumi.Output[Optional['outputs.SwsWafProfileCoreRuleSet']]:
        """
        Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details.
        """
        return pulumi.get(self, "core_rule_set")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="exclusionRules")
    def exclusion_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SwsWafProfileExclusionRule']]]:
        """
        List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules).
        """
        return pulumi.get(self, "exclusion_rules")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="matchAllRuleSets")
    def match_all_rule_sets(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "match_all_rule_sets")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ruleSets")
    def rule_sets(self) -> pulumi.Output[Optional[Sequence['outputs.SwsWafProfileRuleSet']]]:
        """
        Rule set.
        """
        return pulumi.get(self, "rule_sets")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.SwsWafProfileRule']]]:
        """
        Settings for each rule in rule set.
        """
        return pulumi.get(self, "rules")

