# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcAddressArgs', 'VpcAddress']

@pulumi.input_type
class VpcAddressArgs:
    def __init__(__self__, *,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_records: Optional[pulumi.Input[Sequence[pulumi.Input['VpcAddressDnsRecordArgs']]]] = None,
                 external_ipv4_address: Optional[pulumi.Input['VpcAddressExternalIpv4AddressArgs']] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpcAddress resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input['VpcAddressDnsRecordArgs']]] dns_records: DNS record specification of address.
        :param pulumi.Input['VpcAddressExternalIpv4AddressArgs'] external_ipv4_address: Specification of IPv4 address.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_records is not None:
            pulumi.set(__self__, "dns_records", dns_records)
        if external_ipv4_address is not None:
            pulumi.set(__self__, "external_ipv4_address", external_ipv4_address)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcAddressDnsRecordArgs']]]]:
        """
        DNS record specification of address.
        """
        return pulumi.get(self, "dns_records")

    @dns_records.setter
    def dns_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcAddressDnsRecordArgs']]]]):
        pulumi.set(self, "dns_records", value)

    @_builtins.property
    @pulumi.getter(name="externalIpv4Address")
    def external_ipv4_address(self) -> Optional[pulumi.Input['VpcAddressExternalIpv4AddressArgs']]:
        """
        Specification of IPv4 address.
        """
        return pulumi.get(self, "external_ipv4_address")

    @external_ipv4_address.setter
    def external_ipv4_address(self, value: Optional[pulumi.Input['VpcAddressExternalIpv4AddressArgs']]):
        pulumi.set(self, "external_ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VpcAddressState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_records: Optional[pulumi.Input[Sequence[pulumi.Input['VpcAddressDnsRecordArgs']]]] = None,
                 external_ipv4_address: Optional[pulumi.Input['VpcAddressExternalIpv4AddressArgs']] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved: Optional[pulumi.Input[_builtins.bool]] = None,
                 used: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering VpcAddress resources.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input['VpcAddressDnsRecordArgs']]] dns_records: DNS record specification of address.
        :param pulumi.Input['VpcAddressExternalIpv4AddressArgs'] external_ipv4_address: Specification of IPv4 address.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.bool] reserved: `false` means that address is ephemeral.
        :param pulumi.Input[_builtins.bool] used: `true` if address is used.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_records is not None:
            pulumi.set(__self__, "dns_records", dns_records)
        if external_ipv4_address is not None:
            pulumi.set(__self__, "external_ipv4_address", external_ipv4_address)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reserved is not None:
            pulumi.set(__self__, "reserved", reserved)
        if used is not None:
            pulumi.set(__self__, "used", used)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcAddressDnsRecordArgs']]]]:
        """
        DNS record specification of address.
        """
        return pulumi.get(self, "dns_records")

    @dns_records.setter
    def dns_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcAddressDnsRecordArgs']]]]):
        pulumi.set(self, "dns_records", value)

    @_builtins.property
    @pulumi.getter(name="externalIpv4Address")
    def external_ipv4_address(self) -> Optional[pulumi.Input['VpcAddressExternalIpv4AddressArgs']]:
        """
        Specification of IPv4 address.
        """
        return pulumi.get(self, "external_ipv4_address")

    @external_ipv4_address.setter
    def external_ipv4_address(self, value: Optional[pulumi.Input['VpcAddressExternalIpv4AddressArgs']]):
        pulumi.set(self, "external_ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def reserved(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `false` means that address is ephemeral.
        """
        return pulumi.get(self, "reserved")

    @reserved.setter
    def reserved(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reserved", value)

    @_builtins.property
    @pulumi.getter
    def used(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `true` if address is used.
        """
        return pulumi.get(self, "used")

    @used.setter
    def used(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "used", value)


@pulumi.type_token("yandex:index/vpcAddress:VpcAddress")
class VpcAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcAddressDnsRecordArgs', 'VpcAddressDnsRecordArgsDict']]]]] = None,
                 external_ipv4_address: Optional[pulumi.Input[Union['VpcAddressExternalIpv4AddressArgs', 'VpcAddressExternalIpv4AddressArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a address within the Yandex Cloud. You can only create a reserved (static) address via this resource. An ephemeral address could be obtained via implicit creation at a compute instance creation only. For more information, see [the official documentation](https://yandex.cloud/docs/vpc/concepts/address).

        * How-to Guides
          * [Cloud Networking](https://yandex.cloud/docs/vpc/)
          * [VPC Addressing](https://yandex.cloud/docs/vpc/concepts/address)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new VPC regular IPv4 Address.
        #
        addr = yandex.VpcAddress("addr",
            name="exampleAddress",
            external_ipv4_address={
                "zone_id": "ru-central1-a",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new VPC IPv4 Address with DDoS Protection.
        #
        vpnaddr = yandex.VpcAddress("vpnaddr",
            name="vpnaddr",
            external_ipv4_address={
                "zone_id": "ru-central1-a",
                "ddos_protection_provider": "qrator",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/vpcAddress:VpcAddress <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/vpcAddress:VpcAddress addr ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcAddressDnsRecordArgs', 'VpcAddressDnsRecordArgsDict']]]] dns_records: DNS record specification of address.
        :param pulumi.Input[Union['VpcAddressExternalIpv4AddressArgs', 'VpcAddressExternalIpv4AddressArgsDict']] external_ipv4_address: Specification of IPv4 address.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpcAddressArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a address within the Yandex Cloud. You can only create a reserved (static) address via this resource. An ephemeral address could be obtained via implicit creation at a compute instance creation only. For more information, see [the official documentation](https://yandex.cloud/docs/vpc/concepts/address).

        * How-to Guides
          * [Cloud Networking](https://yandex.cloud/docs/vpc/)
          * [VPC Addressing](https://yandex.cloud/docs/vpc/concepts/address)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new VPC regular IPv4 Address.
        #
        addr = yandex.VpcAddress("addr",
            name="exampleAddress",
            external_ipv4_address={
                "zone_id": "ru-central1-a",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new VPC IPv4 Address with DDoS Protection.
        #
        vpnaddr = yandex.VpcAddress("vpnaddr",
            name="vpnaddr",
            external_ipv4_address={
                "zone_id": "ru-central1-a",
                "ddos_protection_provider": "qrator",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/vpcAddress:VpcAddress <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/vpcAddress:VpcAddress addr ...
        ```

        :param str resource_name: The name of the resource.
        :param VpcAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcAddressDnsRecordArgs', 'VpcAddressDnsRecordArgsDict']]]]] = None,
                 external_ipv4_address: Optional[pulumi.Input[Union['VpcAddressExternalIpv4AddressArgs', 'VpcAddressExternalIpv4AddressArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcAddressArgs.__new__(VpcAddressArgs)

            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["dns_records"] = dns_records
            __props__.__dict__["external_ipv4_address"] = external_ipv4_address
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["reserved"] = None
            __props__.__dict__["used"] = None
        super(VpcAddress, __self__).__init__(
            'yandex:index/vpcAddress:VpcAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dns_records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcAddressDnsRecordArgs', 'VpcAddressDnsRecordArgsDict']]]]] = None,
            external_ipv4_address: Optional[pulumi.Input[Union['VpcAddressExternalIpv4AddressArgs', 'VpcAddressExternalIpv4AddressArgsDict']]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            reserved: Optional[pulumi.Input[_builtins.bool]] = None,
            used: Optional[pulumi.Input[_builtins.bool]] = None) -> 'VpcAddress':
        """
        Get an existing VpcAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcAddressDnsRecordArgs', 'VpcAddressDnsRecordArgsDict']]]] dns_records: DNS record specification of address.
        :param pulumi.Input[Union['VpcAddressExternalIpv4AddressArgs', 'VpcAddressExternalIpv4AddressArgsDict']] external_ipv4_address: Specification of IPv4 address.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.bool] reserved: `false` means that address is ephemeral.
        :param pulumi.Input[_builtins.bool] used: `true` if address is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcAddressState.__new__(_VpcAddressState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_records"] = dns_records
        __props__.__dict__["external_ipv4_address"] = external_ipv4_address
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["reserved"] = reserved
        __props__.__dict__["used"] = used
        return VpcAddress(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> pulumi.Output[Optional[Sequence['outputs.VpcAddressDnsRecord']]]:
        """
        DNS record specification of address.
        """
        return pulumi.get(self, "dns_records")

    @_builtins.property
    @pulumi.getter(name="externalIpv4Address")
    def external_ipv4_address(self) -> pulumi.Output[Optional['outputs.VpcAddressExternalIpv4Address']]:
        """
        Specification of IPv4 address.
        """
        return pulumi.get(self, "external_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def reserved(self) -> pulumi.Output[_builtins.bool]:
        """
        `false` means that address is ephemeral.
        """
        return pulumi.get(self, "reserved")

    @_builtins.property
    @pulumi.getter
    def used(self) -> pulumi.Output[_builtins.bool]:
        """
        `true` if address is used.
        """
        return pulumi.get(self, "used")

