# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['YdbDatabaseDedicatedArgs', 'YdbDatabaseDedicated']

@pulumi.input_type
class YdbDatabaseDedicatedArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 resource_preset_id: pulumi.Input[_builtins.str],
                 scale_policy: pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs'],
                 storage_config: pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs'],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 assign_public_ips: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']] = None,
                 location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sleep_after: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a YdbDatabaseDedicated resource.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] resource_preset_id: The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        :param pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs'] scale_policy: Scaling policy for the Yandex Database cluster.
        :param pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs'] storage_config: A list of storage configuration options for the Yandex Database cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: The list of VPC subnets identifiers which resource is attached.
        :param pulumi.Input[_builtins.bool] assign_public_ips: Whether public IP addresses should be assigned to the Yandex Database cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['YdbDatabaseDedicatedLocationArgs'] location: Location for the Yandex Database cluster.
        :param pulumi.Input[_builtins.str] location_id: Location ID for the Yandex Database cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "resource_preset_id", resource_preset_id)
        pulumi.set(__self__, "scale_policy", scale_policy)
        pulumi.set(__self__, "storage_config", storage_config)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if assign_public_ips is not None:
            pulumi.set(__self__, "assign_public_ips", assign_public_ips)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sleep_after is not None:
            pulumi.set(__self__, "sleep_after", sleep_after)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="resourcePresetId")
    def resource_preset_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        """
        return pulumi.get(self, "resource_preset_id")

    @resource_preset_id.setter
    def resource_preset_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_preset_id", value)

    @_builtins.property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs']:
        """
        Scaling policy for the Yandex Database cluster.
        """
        return pulumi.get(self, "scale_policy")

    @scale_policy.setter
    def scale_policy(self, value: pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs']):
        pulumi.set(self, "scale_policy", value)

    @_builtins.property
    @pulumi.getter(name="storageConfig")
    def storage_config(self) -> pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs']:
        """
        A list of storage configuration options for the Yandex Database cluster.
        """
        return pulumi.get(self, "storage_config")

    @storage_config.setter
    def storage_config(self, value: pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs']):
        pulumi.set(self, "storage_config", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of VPC subnets identifiers which resource is attached.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter(name="assignPublicIps")
    def assign_public_ips(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public IP addresses should be assigned to the Yandex Database cluster.
        """
        return pulumi.get(self, "assign_public_ips")

    @assign_public_ips.setter
    def assign_public_ips(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assign_public_ips", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']]:
        """
        Location for the Yandex Database cluster.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location ID for the Yandex Database cluster.
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="sleepAfter")
    def sleep_after(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "sleep_after")

    @sleep_after.setter
    def sleep_after(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep_after", value)


@pulumi.input_type
class _YdbDatabaseDedicatedState:
    def __init__(__self__, *,
                 assign_public_ips: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 database_path: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']] = None,
                 location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_preset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_policy: Optional[pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sleep_after: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_config: Optional[pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs']] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ydb_api_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ydb_full_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering YdbDatabaseDedicated resources.
        :param pulumi.Input[_builtins.bool] assign_public_ips: Whether public IP addresses should be assigned to the Yandex Database cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] database_path: Full database path of the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['YdbDatabaseDedicatedLocationArgs'] location: Location for the Yandex Database cluster.
        :param pulumi.Input[_builtins.str] location_id: Location ID for the Yandex Database cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] resource_preset_id: The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        :param pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs'] scale_policy: Scaling policy for the Yandex Database cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] status: Status of the Yandex Database cluster.
        :param pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs'] storage_config: A list of storage configuration options for the Yandex Database cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: The list of VPC subnets identifiers which resource is attached.
        :param pulumi.Input[_builtins.bool] tls_enabled: Whether TLS is enabled for the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[_builtins.str] ydb_api_endpoint: API endpoint of the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[_builtins.str] ydb_full_endpoint: Full endpoint of the Yandex Database cluster.
        """
        if assign_public_ips is not None:
            pulumi.set(__self__, "assign_public_ips", assign_public_ips)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if database_path is not None:
            pulumi.set(__self__, "database_path", database_path)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if resource_preset_id is not None:
            pulumi.set(__self__, "resource_preset_id", resource_preset_id)
        if scale_policy is not None:
            pulumi.set(__self__, "scale_policy", scale_policy)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sleep_after is not None:
            pulumi.set(__self__, "sleep_after", sleep_after)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_config is not None:
            pulumi.set(__self__, "storage_config", storage_config)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)
        if ydb_api_endpoint is not None:
            pulumi.set(__self__, "ydb_api_endpoint", ydb_api_endpoint)
        if ydb_full_endpoint is not None:
            pulumi.set(__self__, "ydb_full_endpoint", ydb_full_endpoint)

    @_builtins.property
    @pulumi.getter(name="assignPublicIps")
    def assign_public_ips(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public IP addresses should be assigned to the Yandex Database cluster.
        """
        return pulumi.get(self, "assign_public_ips")

    @assign_public_ips.setter
    def assign_public_ips(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assign_public_ips", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="databasePath")
    def database_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full database path of the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "database_path")

    @database_path.setter
    def database_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_path", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']]:
        """
        Location for the Yandex Database cluster.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location ID for the Yandex Database cluster.
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="resourcePresetId")
    def resource_preset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        """
        return pulumi.get(self, "resource_preset_id")

    @resource_preset_id.setter
    def resource_preset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_preset_id", value)

    @_builtins.property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> Optional[pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs']]:
        """
        Scaling policy for the Yandex Database cluster.
        """
        return pulumi.get(self, "scale_policy")

    @scale_policy.setter
    def scale_policy(self, value: Optional[pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs']]):
        pulumi.set(self, "scale_policy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="sleepAfter")
    def sleep_after(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "sleep_after")

    @sleep_after.setter
    def sleep_after(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep_after", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the Yandex Database cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageConfig")
    def storage_config(self) -> Optional[pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs']]:
        """
        A list of storage configuration options for the Yandex Database cluster.
        """
        return pulumi.get(self, "storage_config")

    @storage_config.setter
    def storage_config(self, value: Optional[pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs']]):
        pulumi.set(self, "storage_config", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of VPC subnets identifiers which resource is attached.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether TLS is enabled for the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls_enabled", value)

    @_builtins.property
    @pulumi.getter(name="ydbApiEndpoint")
    def ydb_api_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API endpoint of the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "ydb_api_endpoint")

    @ydb_api_endpoint.setter
    def ydb_api_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ydb_api_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="ydbFullEndpoint")
    def ydb_full_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full endpoint of the Yandex Database cluster.
        """
        return pulumi.get(self, "ydb_full_endpoint")

    @ydb_full_endpoint.setter
    def ydb_full_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ydb_full_endpoint", value)


@pulumi.type_token("yandex:index/ydbDatabaseDedicated:YdbDatabaseDedicated")
class YdbDatabaseDedicated(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_public_ips: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[Union['YdbDatabaseDedicatedLocationArgs', 'YdbDatabaseDedicatedLocationArgsDict']]] = None,
                 location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_preset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_policy: Optional[pulumi.Input[Union['YdbDatabaseDedicatedScalePolicyArgs', 'YdbDatabaseDedicatedScalePolicyArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sleep_after: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_config: Optional[pulumi.Input[Union['YdbDatabaseDedicatedStorageConfigArgs', 'YdbDatabaseDedicatedStorageConfigArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Yandex Database (dedicated) resource. For more information, see [the official documentation](https://yandex.cloud/docs/ydb/concepts/serverless_and_dedicated).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new YDB Dedicated Database.
        #
        database1 = yandex.YdbDatabaseDedicated("database1",
            name="test-ydb-dedicated",
            folder_id=test_folder["id"],
            network_id=my_inst_group_network["id"],
            subnet_ids=[my_inst_group_subnet["id"]],
            resource_preset_id="medium",
            deletion_protection=True,
            scale_policy={
                "fixed_scale": {
                    "size": 1,
                },
            },
            storage_config={
                "group_count": 1,
                "storage_type_id": "ssd",
            },
            location={
                "region": {
                    "id": "ru-central1",
                },
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new YDB Dedicated Database with auto-scale policy.
        #
        database1 = yandex.YdbDatabaseDedicated("database1",
            name="test-ydb-dedicated",
            folder_id=test_folder["id"],
            network_id=my_inst_group_network["id"],
            subnet_ids=[my_inst_group_subnet["id"]],
            resource_preset_id="medium",
            deletion_protection=True,
            scale_policy={
                "auto_scale": {
                    "min_size": 2,
                    "max_size": 8,
                    "target_tracking": {
                        "cpu_utilization_percent": 70,
                    },
                },
            },
            labels={
                "enable_autoscaling": "1",
            },
            storage_config={
                "group_count": 1,
                "storage_type_id": "ssd",
            },
            location={
                "region": {
                    "id": "ru-central1",
                },
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/ydbDatabaseDedicated:YdbDatabaseDedicated <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/ydbDatabaseDedicated:YdbDatabaseDedicated my_ydb ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] assign_public_ips: Whether public IP addresses should be assigned to the Yandex Database cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['YdbDatabaseDedicatedLocationArgs', 'YdbDatabaseDedicatedLocationArgsDict']] location: Location for the Yandex Database cluster.
        :param pulumi.Input[_builtins.str] location_id: Location ID for the Yandex Database cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] resource_preset_id: The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        :param pulumi.Input[Union['YdbDatabaseDedicatedScalePolicyArgs', 'YdbDatabaseDedicatedScalePolicyArgsDict']] scale_policy: Scaling policy for the Yandex Database cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[Union['YdbDatabaseDedicatedStorageConfigArgs', 'YdbDatabaseDedicatedStorageConfigArgsDict']] storage_config: A list of storage configuration options for the Yandex Database cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: The list of VPC subnets identifiers which resource is attached.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: YdbDatabaseDedicatedArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Yandex Database (dedicated) resource. For more information, see [the official documentation](https://yandex.cloud/docs/ydb/concepts/serverless_and_dedicated).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new YDB Dedicated Database.
        #
        database1 = yandex.YdbDatabaseDedicated("database1",
            name="test-ydb-dedicated",
            folder_id=test_folder["id"],
            network_id=my_inst_group_network["id"],
            subnet_ids=[my_inst_group_subnet["id"]],
            resource_preset_id="medium",
            deletion_protection=True,
            scale_policy={
                "fixed_scale": {
                    "size": 1,
                },
            },
            storage_config={
                "group_count": 1,
                "storage_type_id": "ssd",
            },
            location={
                "region": {
                    "id": "ru-central1",
                },
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new YDB Dedicated Database with auto-scale policy.
        #
        database1 = yandex.YdbDatabaseDedicated("database1",
            name="test-ydb-dedicated",
            folder_id=test_folder["id"],
            network_id=my_inst_group_network["id"],
            subnet_ids=[my_inst_group_subnet["id"]],
            resource_preset_id="medium",
            deletion_protection=True,
            scale_policy={
                "auto_scale": {
                    "min_size": 2,
                    "max_size": 8,
                    "target_tracking": {
                        "cpu_utilization_percent": 70,
                    },
                },
            },
            labels={
                "enable_autoscaling": "1",
            },
            storage_config={
                "group_count": 1,
                "storage_type_id": "ssd",
            },
            location={
                "region": {
                    "id": "ru-central1",
                },
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/ydbDatabaseDedicated:YdbDatabaseDedicated <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/ydbDatabaseDedicated:YdbDatabaseDedicated my_ydb ...
        ```

        :param str resource_name: The name of the resource.
        :param YdbDatabaseDedicatedArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(YdbDatabaseDedicatedArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_public_ips: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[Union['YdbDatabaseDedicatedLocationArgs', 'YdbDatabaseDedicatedLocationArgsDict']]] = None,
                 location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_preset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_policy: Optional[pulumi.Input[Union['YdbDatabaseDedicatedScalePolicyArgs', 'YdbDatabaseDedicatedScalePolicyArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sleep_after: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_config: Optional[pulumi.Input[Union['YdbDatabaseDedicatedStorageConfigArgs', 'YdbDatabaseDedicatedStorageConfigArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = YdbDatabaseDedicatedArgs.__new__(YdbDatabaseDedicatedArgs)

            __props__.__dict__["assign_public_ips"] = assign_public_ips
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["location_id"] = location_id
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if resource_preset_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_preset_id'")
            __props__.__dict__["resource_preset_id"] = resource_preset_id
            if scale_policy is None and not opts.urn:
                raise TypeError("Missing required property 'scale_policy'")
            __props__.__dict__["scale_policy"] = scale_policy
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["sleep_after"] = sleep_after
            if storage_config is None and not opts.urn:
                raise TypeError("Missing required property 'storage_config'")
            __props__.__dict__["storage_config"] = storage_config
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["created_at"] = None
            __props__.__dict__["database_path"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tls_enabled"] = None
            __props__.__dict__["ydb_api_endpoint"] = None
            __props__.__dict__["ydb_full_endpoint"] = None
        super(YdbDatabaseDedicated, __self__).__init__(
            'yandex:index/ydbDatabaseDedicated:YdbDatabaseDedicated',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assign_public_ips: Optional[pulumi.Input[_builtins.bool]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            database_path: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[Union['YdbDatabaseDedicatedLocationArgs', 'YdbDatabaseDedicatedLocationArgsDict']]] = None,
            location_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_preset_id: Optional[pulumi.Input[_builtins.str]] = None,
            scale_policy: Optional[pulumi.Input[Union['YdbDatabaseDedicatedScalePolicyArgs', 'YdbDatabaseDedicatedScalePolicyArgsDict']]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sleep_after: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_config: Optional[pulumi.Input[Union['YdbDatabaseDedicatedStorageConfigArgs', 'YdbDatabaseDedicatedStorageConfigArgsDict']]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ydb_api_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            ydb_full_endpoint: Optional[pulumi.Input[_builtins.str]] = None) -> 'YdbDatabaseDedicated':
        """
        Get an existing YdbDatabaseDedicated resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] assign_public_ips: Whether public IP addresses should be assigned to the Yandex Database cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] database_path: Full database path of the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['YdbDatabaseDedicatedLocationArgs', 'YdbDatabaseDedicatedLocationArgsDict']] location: Location for the Yandex Database cluster.
        :param pulumi.Input[_builtins.str] location_id: Location ID for the Yandex Database cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] resource_preset_id: The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        :param pulumi.Input[Union['YdbDatabaseDedicatedScalePolicyArgs', 'YdbDatabaseDedicatedScalePolicyArgsDict']] scale_policy: Scaling policy for the Yandex Database cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] status: Status of the Yandex Database cluster.
        :param pulumi.Input[Union['YdbDatabaseDedicatedStorageConfigArgs', 'YdbDatabaseDedicatedStorageConfigArgsDict']] storage_config: A list of storage configuration options for the Yandex Database cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: The list of VPC subnets identifiers which resource is attached.
        :param pulumi.Input[_builtins.bool] tls_enabled: Whether TLS is enabled for the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[_builtins.str] ydb_api_endpoint: API endpoint of the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[_builtins.str] ydb_full_endpoint: Full endpoint of the Yandex Database cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _YdbDatabaseDedicatedState.__new__(_YdbDatabaseDedicatedState)

        __props__.__dict__["assign_public_ips"] = assign_public_ips
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["database_path"] = database_path
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["location_id"] = location_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["resource_preset_id"] = resource_preset_id
        __props__.__dict__["scale_policy"] = scale_policy
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["sleep_after"] = sleep_after
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_config"] = storage_config
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tls_enabled"] = tls_enabled
        __props__.__dict__["ydb_api_endpoint"] = ydb_api_endpoint
        __props__.__dict__["ydb_full_endpoint"] = ydb_full_endpoint
        return YdbDatabaseDedicated(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assignPublicIps")
    def assign_public_ips(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether public IP addresses should be assigned to the Yandex Database cluster.
        """
        return pulumi.get(self, "assign_public_ips")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="databasePath")
    def database_path(self) -> pulumi.Output[_builtins.str]:
        """
        Full database path of the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "database_path")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional['outputs.YdbDatabaseDedicatedLocation']]:
        """
        Location for the Yandex Database cluster.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Output[_builtins.str]:
        """
        Location ID for the Yandex Database cluster.
        """
        return pulumi.get(self, "location_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="resourcePresetId")
    def resource_preset_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        """
        return pulumi.get(self, "resource_preset_id")

    @_builtins.property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> pulumi.Output['outputs.YdbDatabaseDedicatedScalePolicy']:
        """
        Scaling policy for the Yandex Database cluster.
        """
        return pulumi.get(self, "scale_policy")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="sleepAfter")
    def sleep_after(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "sleep_after")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the Yandex Database cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageConfig")
    def storage_config(self) -> pulumi.Output['outputs.YdbDatabaseDedicatedStorageConfig']:
        """
        A list of storage configuration options for the Yandex Database cluster.
        """
        return pulumi.get(self, "storage_config")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of VPC subnets identifiers which resource is attached.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether TLS is enabled for the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "tls_enabled")

    @_builtins.property
    @pulumi.getter(name="ydbApiEndpoint")
    def ydb_api_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        API endpoint of the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "ydb_api_endpoint")

    @_builtins.property
    @pulumi.getter(name="ydbFullEndpoint")
    def ydb_full_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Full endpoint of the Yandex Database cluster.
        """
        return pulumi.get(self, "ydb_full_endpoint")

