# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['YdbTableChangefeedArgs', 'YdbTableChangefeed']

@pulumi.input_type
class YdbTableChangefeedArgs:
    def __init__(__self__, *,
                 format: pulumi.Input[_builtins.str],
                 mode: pulumi.Input[_builtins.str],
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 consumers: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableChangefeedConsumerArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.str]] = None,
                 table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_path: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_timestamps: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a YdbTableChangefeed resource.
        :param pulumi.Input[_builtins.str] format: Changefeed format.
        :param pulumi.Input[_builtins.str] mode: [Changefeed mode](https://ydb.tech/en/docs/yql/reference/syntax/alter_table#changefeed-options).
        :param pulumi.Input[_builtins.str] connection_string: Connection string, conflicts with `table_id`.
        :param pulumi.Input[Sequence[pulumi.Input['YdbTableChangefeedConsumerArgs']]] consumers: Changefeed [consumers](https://ydb.tech/en/docs/concepts/topic#consumer) - named entities for reading data from the topic.
        :param pulumi.Input[_builtins.str] name: Changefeed name.
        :param pulumi.Input[_builtins.str] retention_period: Time of data retention in the topic, [ISO 8601](https://ru.wikipedia.org/wiki/ISO_8601) format.
        :param pulumi.Input[_builtins.str] table_path: Table path.
        :param pulumi.Input[_builtins.bool] virtual_timestamps: Use [virtual timestamps](https://ydb.tech/en/docs/concepts/cdc#virtual-timestamps).
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "mode", mode)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if consumers is not None:
            pulumi.set(__self__, "consumers", consumers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)
        if table_path is not None:
            pulumi.set(__self__, "table_path", table_path)
        if virtual_timestamps is not None:
            pulumi.set(__self__, "virtual_timestamps", virtual_timestamps)

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Input[_builtins.str]:
        """
        Changefeed format.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Input[_builtins.str]:
        """
        [Changefeed mode](https://ydb.tech/en/docs/yql/reference/syntax/alter_table#changefeed-options).
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Connection string, conflicts with `table_id`.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter
    def consumers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableChangefeedConsumerArgs']]]]:
        """
        Changefeed [consumers](https://ydb.tech/en/docs/concepts/topic#consumer) - named entities for reading data from the topic.
        """
        return pulumi.get(self, "consumers")

    @consumers.setter
    def consumers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableChangefeedConsumerArgs']]]]):
        pulumi.set(self, "consumers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Changefeed name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of data retention in the topic, [ISO 8601](https://ru.wikipedia.org/wiki/ISO_8601) format.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_period", value)

    @_builtins.property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_id", value)

    @_builtins.property
    @pulumi.getter(name="tablePath")
    def table_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Table path.
        """
        return pulumi.get(self, "table_path")

    @table_path.setter
    def table_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_path", value)

    @_builtins.property
    @pulumi.getter(name="virtualTimestamps")
    def virtual_timestamps(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use [virtual timestamps](https://ydb.tech/en/docs/concepts/cdc#virtual-timestamps).
        """
        return pulumi.get(self, "virtual_timestamps")

    @virtual_timestamps.setter
    def virtual_timestamps(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virtual_timestamps", value)


@pulumi.input_type
class _YdbTableChangefeedState:
    def __init__(__self__, *,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 consumers: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableChangefeedConsumerArgs']]]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.str]] = None,
                 table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_path: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_timestamps: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering YdbTableChangefeed resources.
        :param pulumi.Input[_builtins.str] connection_string: Connection string, conflicts with `table_id`.
        :param pulumi.Input[Sequence[pulumi.Input['YdbTableChangefeedConsumerArgs']]] consumers: Changefeed [consumers](https://ydb.tech/en/docs/concepts/topic#consumer) - named entities for reading data from the topic.
        :param pulumi.Input[_builtins.str] format: Changefeed format.
        :param pulumi.Input[_builtins.str] mode: [Changefeed mode](https://ydb.tech/en/docs/yql/reference/syntax/alter_table#changefeed-options).
        :param pulumi.Input[_builtins.str] name: Changefeed name.
        :param pulumi.Input[_builtins.str] retention_period: Time of data retention in the topic, [ISO 8601](https://ru.wikipedia.org/wiki/ISO_8601) format.
        :param pulumi.Input[_builtins.str] table_path: Table path.
        :param pulumi.Input[_builtins.bool] virtual_timestamps: Use [virtual timestamps](https://ydb.tech/en/docs/concepts/cdc#virtual-timestamps).
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if consumers is not None:
            pulumi.set(__self__, "consumers", consumers)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)
        if table_path is not None:
            pulumi.set(__self__, "table_path", table_path)
        if virtual_timestamps is not None:
            pulumi.set(__self__, "virtual_timestamps", virtual_timestamps)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Connection string, conflicts with `table_id`.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter
    def consumers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableChangefeedConsumerArgs']]]]:
        """
        Changefeed [consumers](https://ydb.tech/en/docs/concepts/topic#consumer) - named entities for reading data from the topic.
        """
        return pulumi.get(self, "consumers")

    @consumers.setter
    def consumers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableChangefeedConsumerArgs']]]]):
        pulumi.set(self, "consumers", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Changefeed format.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Changefeed mode](https://ydb.tech/en/docs/yql/reference/syntax/alter_table#changefeed-options).
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Changefeed name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of data retention in the topic, [ISO 8601](https://ru.wikipedia.org/wiki/ISO_8601) format.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_period", value)

    @_builtins.property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_id", value)

    @_builtins.property
    @pulumi.getter(name="tablePath")
    def table_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Table path.
        """
        return pulumi.get(self, "table_path")

    @table_path.setter
    def table_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_path", value)

    @_builtins.property
    @pulumi.getter(name="virtualTimestamps")
    def virtual_timestamps(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use [virtual timestamps](https://ydb.tech/en/docs/concepts/cdc#virtual-timestamps).
        """
        return pulumi.get(self, "virtual_timestamps")

    @virtual_timestamps.setter
    def virtual_timestamps(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virtual_timestamps", value)


@pulumi.type_token("yandex:index/ydbTableChangefeed:YdbTableChangefeed")
class YdbTableChangefeed(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTableChangefeedConsumerArgs', 'YdbTableChangefeedConsumerArgsDict']]]]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.str]] = None,
                 table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_path: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_timestamps: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Yandex Database [table changefeed](https://ydb.tech/en/docs/concepts/cdc), or Change Data Capture (CDC) resource, keeps you informed about changes in a given table. When you add, update, or delete a table row, the CDC mechanism generates a change record where it specifies the primary key of the row and writes it to the topic partition corresponding to this key. A [topic](https://ydb.tech/en/docs/concepts/topic) is an entity for storing unstructured messages and delivering them to multiple subscribers. Basically, a topic is a named set of messages.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new YDB Table Change feed.
        #
        ydb_changefeed = yandex.YdbTableChangefeed("ydb_changefeed",
            table_id=test_table2["id"],
            name="changefeed",
            mode="NEW_IMAGE",
            format="JSON",
            consumers=[{
                "name": "test_consumer",
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/ydbTableChangefeed:YdbTableChangefeed <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/ydbTableChangefeed:YdbTableChangefeed ydb_changefeed ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_string: Connection string, conflicts with `table_id`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['YdbTableChangefeedConsumerArgs', 'YdbTableChangefeedConsumerArgsDict']]]] consumers: Changefeed [consumers](https://ydb.tech/en/docs/concepts/topic#consumer) - named entities for reading data from the topic.
        :param pulumi.Input[_builtins.str] format: Changefeed format.
        :param pulumi.Input[_builtins.str] mode: [Changefeed mode](https://ydb.tech/en/docs/yql/reference/syntax/alter_table#changefeed-options).
        :param pulumi.Input[_builtins.str] name: Changefeed name.
        :param pulumi.Input[_builtins.str] retention_period: Time of data retention in the topic, [ISO 8601](https://ru.wikipedia.org/wiki/ISO_8601) format.
        :param pulumi.Input[_builtins.str] table_path: Table path.
        :param pulumi.Input[_builtins.bool] virtual_timestamps: Use [virtual timestamps](https://ydb.tech/en/docs/concepts/cdc#virtual-timestamps).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: YdbTableChangefeedArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Yandex Database [table changefeed](https://ydb.tech/en/docs/concepts/cdc), or Change Data Capture (CDC) resource, keeps you informed about changes in a given table. When you add, update, or delete a table row, the CDC mechanism generates a change record where it specifies the primary key of the row and writes it to the topic partition corresponding to this key. A [topic](https://ydb.tech/en/docs/concepts/topic) is an entity for storing unstructured messages and delivering them to multiple subscribers. Basically, a topic is a named set of messages.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new YDB Table Change feed.
        #
        ydb_changefeed = yandex.YdbTableChangefeed("ydb_changefeed",
            table_id=test_table2["id"],
            name="changefeed",
            mode="NEW_IMAGE",
            format="JSON",
            consumers=[{
                "name": "test_consumer",
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/ydbTableChangefeed:YdbTableChangefeed <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/ydbTableChangefeed:YdbTableChangefeed ydb_changefeed ...
        ```

        :param str resource_name: The name of the resource.
        :param YdbTableChangefeedArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(YdbTableChangefeedArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTableChangefeedConsumerArgs', 'YdbTableChangefeedConsumerArgsDict']]]]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.str]] = None,
                 table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_path: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_timestamps: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = YdbTableChangefeedArgs.__new__(YdbTableChangefeedArgs)

            __props__.__dict__["connection_string"] = connection_string
            __props__.__dict__["consumers"] = consumers
            if format is None and not opts.urn:
                raise TypeError("Missing required property 'format'")
            __props__.__dict__["format"] = format
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["retention_period"] = retention_period
            __props__.__dict__["table_id"] = table_id
            __props__.__dict__["table_path"] = table_path
            __props__.__dict__["virtual_timestamps"] = virtual_timestamps
        super(YdbTableChangefeed, __self__).__init__(
            'yandex:index/ydbTableChangefeed:YdbTableChangefeed',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTableChangefeedConsumerArgs', 'YdbTableChangefeedConsumerArgsDict']]]]] = None,
            format: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            retention_period: Optional[pulumi.Input[_builtins.str]] = None,
            table_id: Optional[pulumi.Input[_builtins.str]] = None,
            table_path: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_timestamps: Optional[pulumi.Input[_builtins.bool]] = None) -> 'YdbTableChangefeed':
        """
        Get an existing YdbTableChangefeed resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_string: Connection string, conflicts with `table_id`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['YdbTableChangefeedConsumerArgs', 'YdbTableChangefeedConsumerArgsDict']]]] consumers: Changefeed [consumers](https://ydb.tech/en/docs/concepts/topic#consumer) - named entities for reading data from the topic.
        :param pulumi.Input[_builtins.str] format: Changefeed format.
        :param pulumi.Input[_builtins.str] mode: [Changefeed mode](https://ydb.tech/en/docs/yql/reference/syntax/alter_table#changefeed-options).
        :param pulumi.Input[_builtins.str] name: Changefeed name.
        :param pulumi.Input[_builtins.str] retention_period: Time of data retention in the topic, [ISO 8601](https://ru.wikipedia.org/wiki/ISO_8601) format.
        :param pulumi.Input[_builtins.str] table_path: Table path.
        :param pulumi.Input[_builtins.bool] virtual_timestamps: Use [virtual timestamps](https://ydb.tech/en/docs/concepts/cdc#virtual-timestamps).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _YdbTableChangefeedState.__new__(_YdbTableChangefeedState)

        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["consumers"] = consumers
        __props__.__dict__["format"] = format
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["retention_period"] = retention_period
        __props__.__dict__["table_id"] = table_id
        __props__.__dict__["table_path"] = table_path
        __props__.__dict__["virtual_timestamps"] = virtual_timestamps
        return YdbTableChangefeed(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        Connection string, conflicts with `table_id`.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter
    def consumers(self) -> pulumi.Output[Sequence['outputs.YdbTableChangefeedConsumer']]:
        """
        Changefeed [consumers](https://ydb.tech/en/docs/concepts/topic#consumer) - named entities for reading data from the topic.
        """
        return pulumi.get(self, "consumers")

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Output[_builtins.str]:
        """
        Changefeed format.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        [Changefeed mode](https://ydb.tech/en/docs/yql/reference/syntax/alter_table#changefeed-options).
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Changefeed name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time of data retention in the topic, [ISO 8601](https://ru.wikipedia.org/wiki/ISO_8601) format.
        """
        return pulumi.get(self, "retention_period")

    @_builtins.property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "table_id")

    @_builtins.property
    @pulumi.getter(name="tablePath")
    def table_path(self) -> pulumi.Output[_builtins.str]:
        """
        Table path.
        """
        return pulumi.get(self, "table_path")

    @_builtins.property
    @pulumi.getter(name="virtualTimestamps")
    def virtual_timestamps(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Use [virtual timestamps](https://ydb.tech/en/docs/concepts/cdc#virtual-timestamps).
        """
        return pulumi.get(self, "virtual_timestamps")

